/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.aspectj.internal.lang.reflect;

import com.contrastsecurity.thirdparty.org.aspectj.internal.lang.reflect.PointcutExpressionImpl;
import com.contrastsecurity.thirdparty.org.aspectj.lang.annotation.AdviceName;
import com.contrastsecurity.thirdparty.org.aspectj.lang.reflect.Advice;
import com.contrastsecurity.thirdparty.org.aspectj.lang.reflect.AdviceKind;
import com.contrastsecurity.thirdparty.org.aspectj.lang.reflect.AjType;
import com.contrastsecurity.thirdparty.org.aspectj.lang.reflect.AjTypeSystem;
import com.contrastsecurity.thirdparty.org.aspectj.lang.reflect.PointcutExpression;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class AdviceImpl
implements Advice {
    private static final String AJC_INTERNAL = "com.contrastsecurity.thirdparty.org.aspectj.runtime.internal";
    private final AdviceKind kind;
    private final Method adviceMethod;
    private PointcutExpression pointcutExpression;
    private boolean hasExtraParam = false;
    private Type[] genericParameterTypes;
    private AjType[] parameterTypes;
    private AjType[] exceptionTypes;

    protected AdviceImpl(Method method, String string, AdviceKind adviceKind) {
        this.kind = adviceKind;
        this.adviceMethod = method;
        this.pointcutExpression = new PointcutExpressionImpl(string);
    }

    protected AdviceImpl(Method method, String string, AdviceKind adviceKind, String string2) {
        this(method, string, adviceKind);
        this.hasExtraParam = true;
    }

    @Override
    public AjType getDeclaringType() {
        return AjTypeSystem.getAjType(this.adviceMethod.getDeclaringClass());
    }

    @Override
    public Type[] getGenericParameterTypes() {
        if (this.genericParameterTypes == null) {
            Type[] typeArray = this.adviceMethod.getGenericParameterTypes();
            int n2 = 0;
            for (Type type : typeArray) {
                if (!(type instanceof Class) || !((Class)type).getPackage().getName().equals(AJC_INTERNAL)) continue;
                ++n2;
            }
            this.genericParameterTypes = new Type[typeArray.length - n2];
            for (int i2 = 0; i2 < this.genericParameterTypes.length; ++i2) {
                this.genericParameterTypes[i2] = typeArray[i2] instanceof Class ? AjTypeSystem.getAjType((Class)typeArray[i2]) : typeArray[i2];
            }
        }
        return this.genericParameterTypes;
    }

    @Override
    public AjType<?>[] getParameterTypes() {
        if (this.parameterTypes == null) {
            Class<?>[] classArray = this.adviceMethod.getParameterTypes();
            int n2 = 0;
            for (Class<?> clazz : classArray) {
                if (!clazz.getPackage().getName().equals(AJC_INTERNAL)) continue;
                ++n2;
            }
            this.parameterTypes = new AjType[classArray.length - n2];
            for (int i2 = 0; i2 < this.parameterTypes.length; ++i2) {
                this.parameterTypes[i2] = AjTypeSystem.getAjType(classArray[i2]);
            }
        }
        return this.parameterTypes;
    }

    @Override
    public AjType<?>[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            Class<?>[] classArray = this.adviceMethod.getExceptionTypes();
            this.exceptionTypes = new AjType[classArray.length];
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                this.exceptionTypes[i2] = AjTypeSystem.getAjType(classArray[i2]);
            }
        }
        return this.exceptionTypes;
    }

    @Override
    public AdviceKind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        String string = this.adviceMethod.getName();
        if (string.startsWith("ajc$")) {
            string = "";
            AdviceName adviceName = this.adviceMethod.getAnnotation(AdviceName.class);
            if (adviceName != null) {
                string = adviceName.value();
            }
        }
        return string;
    }

    @Override
    public PointcutExpression getPointcutExpression() {
        return this.pointcutExpression;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getName().length() > 0) {
            stringBuffer.append("@AdviceName(\"");
            stringBuffer.append(this.getName());
            stringBuffer.append("\") ");
        }
        if (this.getKind() == AdviceKind.AROUND) {
            stringBuffer.append(this.adviceMethod.getGenericReturnType().toString());
            stringBuffer.append(" ");
        }
        switch (this.getKind()) {
            case AFTER: {
                stringBuffer.append("after(");
                break;
            }
            case AFTER_RETURNING: {
                stringBuffer.append("after(");
                break;
            }
            case AFTER_THROWING: {
                stringBuffer.append("after(");
                break;
            }
            case AROUND: {
                stringBuffer.append("around(");
                break;
            }
            case BEFORE: {
                stringBuffer.append("before(");
            }
        }
        AjType<?>[] ajTypeArray = this.getParameterTypes();
        int n2 = ajTypeArray.length;
        if (this.hasExtraParam) {
            --n2;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(ajTypeArray[i2].getName());
            if (i2 + 1 >= n2) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(") ");
        switch (this.getKind()) {
            case AFTER_RETURNING: {
                stringBuffer.append("returning");
                if (this.hasExtraParam) {
                    stringBuffer.append("(");
                    stringBuffer.append(ajTypeArray[n2 - 1].getName());
                    stringBuffer.append(") ");
                }
            }
            case AFTER_THROWING: {
                stringBuffer.append("throwing");
                if (!this.hasExtraParam) break;
                stringBuffer.append("(");
                stringBuffer.append(ajTypeArray[n2 - 1].getName());
                stringBuffer.append(") ");
            }
        }
        AjType<?>[] ajTypeArray2 = this.getExceptionTypes();
        if (ajTypeArray2.length > 0) {
            stringBuffer.append("throws ");
            for (int i3 = 0; i3 < ajTypeArray2.length; ++i3) {
                stringBuffer.append(ajTypeArray2[i3].getName());
                if (i3 + 1 >= ajTypeArray2.length) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(" ");
        }
        stringBuffer.append(": ");
        stringBuffer.append(this.getPointcutExpression().asString());
        return stringBuffer.toString();
    }
}

