/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.aspectj.internal.lang.reflect;

import com.contrastsecurity.thirdparty.org.aspectj.internal.lang.reflect.PointcutExpressionImpl;
import com.contrastsecurity.thirdparty.org.aspectj.lang.reflect.AjType;
import com.contrastsecurity.thirdparty.org.aspectj.lang.reflect.AjTypeSystem;
import com.contrastsecurity.thirdparty.org.aspectj.lang.reflect.DeclareSoft;
import com.contrastsecurity.thirdparty.org.aspectj.lang.reflect.PointcutExpression;

public class DeclareSoftImpl
implements DeclareSoft {
    private AjType<?> declaringType;
    private PointcutExpression pointcut;
    private AjType<?> exceptionType;
    private String missingTypeName;

    public DeclareSoftImpl(AjType<?> ajType, String string, String string2) {
        this.declaringType = ajType;
        this.pointcut = new PointcutExpressionImpl(string);
        try {
            ClassLoader classLoader = ajType.getJavaClass().getClassLoader();
            this.exceptionType = AjTypeSystem.getAjType(Class.forName(string2, false, classLoader));
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.missingTypeName = string2;
        }
    }

    @Override
    public AjType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public AjType getSoftenedExceptionType() throws ClassNotFoundException {
        if (this.missingTypeName != null) {
            throw new ClassNotFoundException(this.missingTypeName);
        }
        return this.exceptionType;
    }

    @Override
    public PointcutExpression getPointcutExpression() {
        return this.pointcut;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("declare soft : ");
        if (this.missingTypeName != null) {
            stringBuffer.append(this.exceptionType.getName());
        } else {
            stringBuffer.append(this.missingTypeName);
        }
        stringBuffer.append(" : ");
        stringBuffer.append(this.getPointcutExpression().asString());
        return stringBuffer.toString();
    }
}

