/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.aspectj.internal.lang.reflect;

import com.contrastsecurity.thirdparty.org.aspectj.internal.lang.reflect.InterTypeDeclarationImpl;
import com.contrastsecurity.thirdparty.org.aspectj.lang.reflect.AjType;
import com.contrastsecurity.thirdparty.org.aspectj.lang.reflect.AjTypeSystem;
import com.contrastsecurity.thirdparty.org.aspectj.lang.reflect.InterTypeMethodDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class InterTypeMethodDeclarationImpl
extends InterTypeDeclarationImpl
implements InterTypeMethodDeclaration {
    private String name;
    private Method baseMethod;
    private int parameterAdjustmentFactor = 1;
    private AjType<?>[] parameterTypes;
    private Type[] genericParameterTypes;
    private AjType<?> returnType;
    private Type genericReturnType;
    private AjType<?>[] exceptionTypes;

    public InterTypeMethodDeclarationImpl(AjType<?> ajType, String string, int n2, String string2, Method method) {
        super(ajType, string, n2);
        this.name = string2;
        this.baseMethod = method;
    }

    public InterTypeMethodDeclarationImpl(AjType<?> ajType, AjType<?> ajType2, Method method, int n2) {
        super(ajType, ajType2, n2);
        this.parameterAdjustmentFactor = 0;
        this.name = method.getName();
        this.baseMethod = method;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AjType<?> getReturnType() {
        return AjTypeSystem.getAjType(this.baseMethod.getReturnType());
    }

    @Override
    public Type getGenericReturnType() {
        Type type = this.baseMethod.getGenericReturnType();
        if (type instanceof Class) {
            return AjTypeSystem.getAjType((Class)type);
        }
        return type;
    }

    @Override
    public AjType<?>[] getParameterTypes() {
        Class<?>[] classArray = this.baseMethod.getParameterTypes();
        AjType[] ajTypeArray = new AjType[classArray.length - this.parameterAdjustmentFactor];
        for (int i2 = this.parameterAdjustmentFactor; i2 < classArray.length; ++i2) {
            ajTypeArray[i2 - this.parameterAdjustmentFactor] = AjTypeSystem.getAjType(classArray[i2]);
        }
        return ajTypeArray;
    }

    @Override
    public Type[] getGenericParameterTypes() {
        Type[] typeArray = this.baseMethod.getGenericParameterTypes();
        Type[] typeArray2 = new AjType[typeArray.length - this.parameterAdjustmentFactor];
        for (int i2 = this.parameterAdjustmentFactor; i2 < typeArray.length; ++i2) {
            typeArray2[i2 - this.parameterAdjustmentFactor] = typeArray[i2] instanceof Class ? AjTypeSystem.getAjType((Class)typeArray[i2]) : typeArray[i2];
        }
        return typeArray2;
    }

    @Override
    public TypeVariable<Method>[] getTypeParameters() {
        return this.baseMethod.getTypeParameters();
    }

    @Override
    public AjType<?>[] getExceptionTypes() {
        Class<?>[] classArray = this.baseMethod.getExceptionTypes();
        AjType[] ajTypeArray = new AjType[classArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            ajTypeArray[i2] = AjTypeSystem.getAjType(classArray[i2]);
        }
        return ajTypeArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Modifier.toString(this.getModifiers()));
        stringBuffer.append(" ");
        stringBuffer.append(this.getReturnType().toString());
        stringBuffer.append(" ");
        stringBuffer.append(this.targetTypeName);
        stringBuffer.append(".");
        stringBuffer.append(this.getName());
        stringBuffer.append("(");
        AjType<?>[] ajTypeArray = this.getParameterTypes();
        for (int i2 = 0; i2 < ajTypeArray.length - 1; ++i2) {
            stringBuffer.append(ajTypeArray[i2].toString());
            stringBuffer.append(", ");
        }
        if (ajTypeArray.length > 0) {
            stringBuffer.append(ajTypeArray[ajTypeArray.length - 1].toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

