/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.aspectj.lang;

import com.contrastsecurity.thirdparty.org.aspectj.lang.NoAspectBoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Aspects {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Class[] PEROBJECT_CLASS_ARRAY = new Class[]{Object.class};
    private static final Class[] PERTYPEWITHIN_CLASS_ARRAY = new Class[]{Class.class};
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String ASPECTOF = "aspectOf";
    private static final String HASASPECT = "hasAspect";

    public static <T> T aspectOf(Class<T> clazz) throws NoAspectBoundException {
        try {
            return (T)Aspects.getSingletonOrThreadAspectOf(clazz).invoke(null, EMPTY_OBJECT_ARRAY);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoAspectBoundException(clazz.getName(), invocationTargetException);
        }
        catch (Exception exception) {
            throw new NoAspectBoundException(clazz.getName(), exception);
        }
    }

    public static <T> T aspectOf(Class<T> clazz, Object object) throws NoAspectBoundException {
        try {
            return (T)Aspects.getPerObjectAspectOf(clazz).invoke(null, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoAspectBoundException(clazz.getName(), invocationTargetException);
        }
        catch (Exception exception) {
            throw new NoAspectBoundException(clazz.getName(), exception);
        }
    }

    public static <T> T aspectOf(Class<T> clazz, Class<?> clazz2) throws NoAspectBoundException {
        try {
            return (T)Aspects.getPerTypeWithinAspectOf(clazz).invoke(null, clazz2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoAspectBoundException(clazz.getName(), invocationTargetException);
        }
        catch (Exception exception) {
            throw new NoAspectBoundException(clazz.getName(), exception);
        }
    }

    public static boolean hasAspect(Class<?> clazz) throws NoAspectBoundException {
        try {
            return (Boolean)Aspects.getSingletonOrThreadHasAspect(clazz).invoke(null, EMPTY_OBJECT_ARRAY);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean hasAspect(Class<?> clazz, Object object) throws NoAspectBoundException {
        try {
            return (Boolean)Aspects.getPerObjectHasAspect(clazz).invoke(null, object);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean hasAspect(Class<?> clazz, Class<?> clazz2) throws NoAspectBoundException {
        try {
            return (Boolean)Aspects.getPerTypeWithinHasAspect(clazz).invoke(null, clazz2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static Method getSingletonOrThreadAspectOf(Class<?> clazz) throws NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(ASPECTOF, EMPTY_CLASS_ARRAY);
        return Aspects.checkAspectOf(method, clazz);
    }

    private static Method getPerObjectAspectOf(Class<?> clazz) throws NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(ASPECTOF, PEROBJECT_CLASS_ARRAY);
        return Aspects.checkAspectOf(method, clazz);
    }

    private static Method getPerTypeWithinAspectOf(Class<?> clazz) throws NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(ASPECTOF, PERTYPEWITHIN_CLASS_ARRAY);
        return Aspects.checkAspectOf(method, clazz);
    }

    private static Method checkAspectOf(Method method, Class<?> clazz) throws NoSuchMethodException {
        method.setAccessible(true);
        if (!(method.isAccessible() && Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()))) {
            throw new NoSuchMethodException(clazz.getName() + ".aspectOf(..) is not accessible public static");
        }
        return method;
    }

    private static Method getSingletonOrThreadHasAspect(Class clazz) throws NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(HASASPECT, EMPTY_CLASS_ARRAY);
        return Aspects.checkHasAspect(method, clazz);
    }

    private static Method getPerObjectHasAspect(Class clazz) throws NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(HASASPECT, PEROBJECT_CLASS_ARRAY);
        return Aspects.checkHasAspect(method, clazz);
    }

    private static Method getPerTypeWithinHasAspect(Class clazz) throws NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(HASASPECT, PERTYPEWITHIN_CLASS_ARRAY);
        return Aspects.checkHasAspect(method, clazz);
    }

    private static Method checkHasAspect(Method method, Class clazz) throws NoSuchMethodException {
        method.setAccessible(true);
        if (!(method.isAccessible() && Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()))) {
            throw new NoSuchMethodException(clazz.getName() + ".hasAspect(..) is not accessible public static");
        }
        return method;
    }
}

