/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.aspectj.runtime.reflect;

import com.contrastsecurity.thirdparty.org.aspectj.lang.Signature;
import com.contrastsecurity.thirdparty.org.aspectj.runtime.reflect.Factory;
import com.contrastsecurity.thirdparty.org.aspectj.runtime.reflect.StringMaker;
import java.lang.ref.SoftReference;
import java.util.StringTokenizer;

abstract class SignatureImpl
implements Signature {
    private static boolean useCache = true;
    int modifiers = -1;
    String name;
    String declaringTypeName;
    Class declaringType;
    Cache stringCache;
    private String stringRep;
    ClassLoader lookupClassLoader = null;
    static final char SEP = '-';
    static String[] EMPTY_STRING_ARRAY = new String[0];
    static Class[] EMPTY_CLASS_ARRAY = new Class[0];
    static final String INNER_SEP = ":";

    SignatureImpl(int n2, String string, Class clazz) {
        this.modifiers = n2;
        this.name = string;
        this.declaringType = clazz;
    }

    protected abstract String createToString(StringMaker var1);

    String toString(StringMaker stringMaker) {
        String string = null;
        if (useCache) {
            if (this.stringCache == null) {
                try {
                    this.stringCache = new CacheImpl();
                }
                catch (Throwable throwable) {
                    useCache = false;
                }
            } else {
                string = this.stringCache.get(stringMaker.cacheOffset);
            }
        }
        if (string == null) {
            string = this.createToString(stringMaker);
        }
        if (useCache) {
            this.stringCache.set(stringMaker.cacheOffset, string);
        }
        return string;
    }

    public final String toString() {
        return this.toString(StringMaker.middleStringMaker);
    }

    public final String toShortString() {
        return this.toString(StringMaker.shortStringMaker);
    }

    public final String toLongString() {
        return this.toString(StringMaker.longStringMaker);
    }

    public int getModifiers() {
        if (this.modifiers == -1) {
            this.modifiers = this.extractInt(0);
        }
        return this.modifiers;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.extractString(1);
        }
        return this.name;
    }

    public Class getDeclaringType() {
        if (this.declaringType == null) {
            this.declaringType = this.extractType(2);
        }
        return this.declaringType;
    }

    public String getDeclaringTypeName() {
        if (this.declaringTypeName == null) {
            this.declaringTypeName = this.getDeclaringType().getName();
        }
        return this.declaringTypeName;
    }

    String fullTypeName(Class clazz) {
        if (clazz == null) {
            return "ANONYMOUS";
        }
        if (clazz.isArray()) {
            return this.fullTypeName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName().replace('$', '.');
    }

    String stripPackageName(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1);
    }

    String shortTypeName(Class clazz) {
        if (clazz == null) {
            return "ANONYMOUS";
        }
        if (clazz.isArray()) {
            return this.shortTypeName(clazz.getComponentType()) + "[]";
        }
        return this.stripPackageName(clazz.getName()).replace('$', '.');
    }

    void addFullTypeNames(StringBuffer stringBuffer, Class[] classArray) {
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.fullTypeName(classArray[i2]));
        }
    }

    void addShortTypeNames(StringBuffer stringBuffer, Class[] classArray) {
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.shortTypeName(classArray[i2]));
        }
    }

    void addTypeArray(StringBuffer stringBuffer, Class[] classArray) {
        this.addFullTypeNames(stringBuffer, classArray);
    }

    public void setLookupClassLoader(ClassLoader classLoader) {
        this.lookupClassLoader = classLoader;
    }

    private ClassLoader getLookupClassLoader() {
        if (this.lookupClassLoader == null) {
            this.lookupClassLoader = this.getClass().getClassLoader();
        }
        return this.lookupClassLoader;
    }

    public SignatureImpl(String string) {
        this.stringRep = string;
    }

    String extractString(int n2) {
        int n3 = 0;
        int n4 = this.stringRep.indexOf(45);
        while (n2-- > 0) {
            n3 = n4 + 1;
            n4 = this.stringRep.indexOf(45, n3);
        }
        if (n4 == -1) {
            n4 = this.stringRep.length();
        }
        return this.stringRep.substring(n3, n4);
    }

    int extractInt(int n2) {
        String string = this.extractString(n2);
        return Integer.parseInt(string, 16);
    }

    Class extractType(int n2) {
        String string = this.extractString(n2);
        return Factory.makeClass(string, this.getLookupClassLoader());
    }

    String[] extractStrings(int n2) {
        String string = this.extractString(n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, INNER_SEP);
        int n3 = stringTokenizer.countTokens();
        String[] stringArray = new String[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            stringArray[i2] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    Class[] extractTypes(int n2) {
        String string = this.extractString(n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, INNER_SEP);
        int n3 = stringTokenizer.countTokens();
        Class[] classArray = new Class[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            classArray[i2] = Factory.makeClass(stringTokenizer.nextToken(), this.getLookupClassLoader());
        }
        return classArray;
    }

    static void setUseCache(boolean bl) {
        useCache = bl;
    }

    static boolean getUseCache() {
        return useCache;
    }

    private static final class CacheImpl
    implements Cache {
        private SoftReference toStringCacheRef;

        public CacheImpl() {
            this.makeCache();
        }

        public String get(int n2) {
            String[] stringArray = this.array();
            if (stringArray == null) {
                return null;
            }
            return stringArray[n2];
        }

        public void set(int n2, String string) {
            String[] stringArray = this.array();
            if (stringArray == null) {
                stringArray = this.makeCache();
            }
            stringArray[n2] = string;
        }

        private String[] array() {
            return (String[])this.toStringCacheRef.get();
        }

        private String[] makeCache() {
            String[] stringArray = new String[3];
            this.toStringCacheRef = new SoftReference<String[]>(stringArray);
            return stringArray;
        }
    }

    private static interface Cache {
        public String get(int var1);

        public void set(int var1, String var2);
    }
}

