/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jsoup.examples;

import com.contrastsecurity.thirdparty.org.jsoup.Jsoup;
import com.contrastsecurity.thirdparty.org.jsoup.helper.Validate;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Document;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Element;
import com.contrastsecurity.thirdparty.org.jsoup.select.Elements;
import java.io.IOException;

public class ListLinks {
    public static void main(String[] stringArray) throws IOException {
        Validate.isTrue(stringArray.length == 1, "usage: supply url to fetch");
        String string = stringArray[0];
        ListLinks.print("Fetching %s...", string);
        Document document = Jsoup.connect(string).get();
        Elements elements = document.select("a[href]");
        Elements elements2 = document.select("[src]");
        Elements elements3 = document.select("link[href]");
        ListLinks.print("\nMedia: (%d)", elements2.size());
        for (Element element : elements2) {
            if (element.tagName().equals("img")) {
                ListLinks.print(" * %s: <%s> %sx%s (%s)", element.tagName(), element.attr("abs:src"), element.attr("width"), element.attr("height"), ListLinks.trim(element.attr("alt"), 20));
                continue;
            }
            ListLinks.print(" * %s: <%s>", element.tagName(), element.attr("abs:src"));
        }
        ListLinks.print("\nImports: (%d)", elements3.size());
        for (Element element : elements3) {
            ListLinks.print(" * %s <%s> (%s)", element.tagName(), element.attr("abs:href"), element.attr("rel"));
        }
        ListLinks.print("\nLinks: (%d)", elements.size());
        for (Element element : elements) {
            ListLinks.print(" * a: <%s>  (%s)", element.attr("abs:href"), ListLinks.trim(element.text(), 35));
        }
    }

    private static void print(String string, Object ... objectArray) {
        System.out.println(String.format(string, objectArray));
    }

    private static String trim(String string, int n2) {
        if (string.length() > n2) {
            return string.substring(0, n2 - 1) + ".";
        }
        return string;
    }
}

