/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jsoup.helper;

import com.contrastsecurity.thirdparty.org.jsoup.helper.Validate;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Document;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Element;
import com.contrastsecurity.thirdparty.org.jsoup.parser.Parser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataUtil {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");
    static final String defaultCharset = "UTF-8";
    private static final int bufferSize = 131072;

    private DataUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document load(File file, String string, String string2) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            ByteBuffer byteBuffer = DataUtil.readToByteBuffer(fileInputStream);
            Document document = DataUtil.parseByteData(byteBuffer, string, string2, Parser.htmlParser());
            return document;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static Document load(InputStream inputStream, String string, String string2) throws IOException {
        ByteBuffer byteBuffer = DataUtil.readToByteBuffer(inputStream);
        return DataUtil.parseByteData(byteBuffer, string, string2, Parser.htmlParser());
    }

    public static Document load(InputStream inputStream, String string, String string2, Parser parser) throws IOException {
        ByteBuffer byteBuffer = DataUtil.readToByteBuffer(inputStream);
        return DataUtil.parseByteData(byteBuffer, string, string2, parser);
    }

    static Document parseByteData(ByteBuffer byteBuffer, String string, String string2, Parser parser) {
        String string3;
        Document document = null;
        if (string == null) {
            string3 = Charset.forName(defaultCharset).decode(byteBuffer).toString();
            document = parser.parseInput(string3, string2);
            Element element = document.select("meta[http-equiv=content-type], meta[charset]").first();
            if (element != null) {
                String string4;
                String string5 = string4 = element.hasAttr("http-equiv") ? DataUtil.getCharsetFromContentType(element.attr("content")) : element.attr("charset");
                if (string4 != null && string4.length() != 0 && !string4.equals(defaultCharset)) {
                    string = string4;
                    byteBuffer.rewind();
                    string3 = Charset.forName(string4).decode(byteBuffer).toString();
                    document = null;
                }
            }
        } else {
            Validate.notEmpty(string, "Must set charset arg to character set of file to parse. Set to null to attempt to detect from HTML");
            string3 = Charset.forName(string).decode(byteBuffer).toString();
        }
        if (document == null) {
            if (string3.length() > 0 && string3.charAt(0) == '\ufeff') {
                string3 = string3.substring(1);
            }
            document = parser.parseInput(string3, string2);
            document.outputSettings().charset(string);
        }
        return document;
    }

    static ByteBuffer readToByteBuffer(InputStream inputStream, int n2) throws IOException {
        int n3;
        Validate.isTrue(n2 >= 0, "maxSize must be 0 (unlimited) or larger");
        boolean bl = n2 > 0;
        byte[] byArray = new byte[131072];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(131072);
        int n4 = n2;
        while ((n3 = inputStream.read(byArray)) != -1) {
            if (bl) {
                if (n3 > n4) {
                    byteArrayOutputStream.write(byArray, 0, n4);
                    break;
                }
                n4 -= n3;
            }
            byteArrayOutputStream.write(byArray, 0, n3);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        return byteBuffer;
    }

    static ByteBuffer readToByteBuffer(InputStream inputStream) throws IOException {
        return DataUtil.readToByteBuffer(inputStream, 0);
    }

    static String getCharsetFromContentType(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = charsetPattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1).trim();
            if (Charset.isSupported(string2)) {
                return string2;
            }
            if (Charset.isSupported(string2 = string2.toUpperCase(Locale.ENGLISH))) {
                return string2;
            }
        }
        return null;
    }
}

