/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jsoup.helper;

import com.contrastsecurity.thirdparty.org.jsoup.Connection;
import com.contrastsecurity.thirdparty.org.jsoup.HttpStatusException;
import com.contrastsecurity.thirdparty.org.jsoup.UnsupportedMimeTypeException;
import com.contrastsecurity.thirdparty.org.jsoup.helper.DataUtil;
import com.contrastsecurity.thirdparty.org.jsoup.helper.Validate;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Document;
import com.contrastsecurity.thirdparty.org.jsoup.parser.Parser;
import com.contrastsecurity.thirdparty.org.jsoup.parser.TokenQueue;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpConnection
implements Connection {
    private Connection.Request req = new Request();
    private Connection.Response res = new Response();

    public static Connection connect(String string) {
        HttpConnection httpConnection = new HttpConnection();
        httpConnection.url(string);
        return httpConnection;
    }

    public static Connection connect(URL uRL) {
        HttpConnection httpConnection = new HttpConnection();
        httpConnection.url(uRL);
        return httpConnection;
    }

    private HttpConnection() {
    }

    @Override
    public Connection url(URL uRL) {
        this.req.url(uRL);
        return this;
    }

    @Override
    public Connection url(String string) {
        Validate.notEmpty(string, "Must supply a valid URL");
        try {
            this.req.url(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Malformed URL: " + string, malformedURLException);
        }
        return this;
    }

    @Override
    public Connection userAgent(String string) {
        Validate.notNull(string, "User agent must not be null");
        this.req.header("User-Agent", string);
        return this;
    }

    @Override
    public Connection timeout(int n2) {
        this.req.timeout(n2);
        return this;
    }

    @Override
    public Connection maxBodySize(int n2) {
        this.req.maxBodySize(n2);
        return this;
    }

    @Override
    public Connection followRedirects(boolean bl) {
        this.req.followRedirects(bl);
        return this;
    }

    @Override
    public Connection referrer(String string) {
        Validate.notNull(string, "Referrer must not be null");
        this.req.header("Referer", string);
        return this;
    }

    @Override
    public Connection method(Connection.Method method) {
        this.req.method(method);
        return this;
    }

    @Override
    public Connection ignoreHttpErrors(boolean bl) {
        this.req.ignoreHttpErrors(bl);
        return this;
    }

    @Override
    public Connection ignoreContentType(boolean bl) {
        this.req.ignoreContentType(bl);
        return this;
    }

    @Override
    public Connection data(String string, String string2) {
        this.req.data(KeyVal.create(string, string2));
        return this;
    }

    @Override
    public Connection data(Map<String, String> map) {
        Validate.notNull(map, "Data map must not be null");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.req.data(KeyVal.create(entry.getKey(), entry.getValue()));
        }
        return this;
    }

    @Override
    public Connection data(String ... stringArray) {
        Validate.notNull(stringArray, "Data key value pairs must not be null");
        Validate.isTrue(stringArray.length % 2 == 0, "Must supply an even number of key value pairs");
        for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
            String string = stringArray[i2];
            String string2 = stringArray[i2 + 1];
            Validate.notEmpty(string, "Data key must not be empty");
            Validate.notNull(string2, "Data value must not be null");
            this.req.data(KeyVal.create(string, string2));
        }
        return this;
    }

    @Override
    public Connection header(String string, String string2) {
        this.req.header(string, string2);
        return this;
    }

    @Override
    public Connection cookie(String string, String string2) {
        this.req.cookie(string, string2);
        return this;
    }

    @Override
    public Connection cookies(Map<String, String> map) {
        Validate.notNull(map, "Cookie map must not be null");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.req.cookie(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public Connection parser(Parser parser) {
        this.req.parser(parser);
        return this;
    }

    @Override
    public Document get() throws IOException {
        this.req.method(Connection.Method.GET);
        this.execute();
        return this.res.parse();
    }

    @Override
    public Document post() throws IOException {
        this.req.method(Connection.Method.POST);
        this.execute();
        return this.res.parse();
    }

    @Override
    public Connection.Response execute() throws IOException {
        this.res = Response.execute(this.req);
        return this.res;
    }

    @Override
    public Connection.Request request() {
        return this.req;
    }

    @Override
    public Connection request(Connection.Request request) {
        this.req = request;
        return this;
    }

    @Override
    public Connection.Response response() {
        return this.res;
    }

    @Override
    public Connection response(Connection.Response response) {
        this.res = response;
        return this;
    }

    public static class KeyVal
    implements Connection.KeyVal {
        private String key;
        private String value;

        public static KeyVal create(String string, String string2) {
            Validate.notEmpty(string, "Data key must not be empty");
            Validate.notNull(string2, "Data value must not be null");
            return new KeyVal(string, string2);
        }

        private KeyVal(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        public KeyVal key(String string) {
            Validate.notEmpty(string, "Data key must not be empty");
            this.key = string;
            return this;
        }

        public String key() {
            return this.key;
        }

        public KeyVal value(String string) {
            Validate.notNull(string, "Data value must not be null");
            this.value = string;
            return this;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Response
    extends Base<Connection.Response>
    implements Connection.Response {
        private static final int MAX_REDIRECTS = 20;
        private int statusCode;
        private String statusMessage;
        private ByteBuffer byteData;
        private String charset;
        private String contentType;
        private boolean executed = false;
        private int numRedirects = 0;
        private Connection.Request req;

        Response() {
        }

        private Response(Response response) throws IOException {
            if (response != null) {
                this.numRedirects = response.numRedirects + 1;
                if (this.numRedirects >= 20) {
                    throw new IOException(String.format("Too many redirects occurred trying to load URL %s", response.url()));
                }
            }
        }

        static Response execute(Connection.Request request) throws IOException {
            return Response.execute(request, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Response execute(Connection.Request request, Response response) throws IOException {
            Response response2;
            Validate.notNull(request, "Request must not be null");
            String string = request.url().getProtocol();
            if (!string.equals("http") && !string.equals("https")) {
                throw new MalformedURLException("Only http & https protocols supported");
            }
            if (request.method() == Connection.Method.GET && request.data().size() > 0) {
                Response.serialiseRequestUrl(request);
            }
            HttpURLConnection httpURLConnection = Response.createConnection(request);
            try {
                httpURLConnection.connect();
                if (request.method() == Connection.Method.POST) {
                    Response.writePost(request.data(), httpURLConnection.getOutputStream());
                }
                int n2 = httpURLConnection.getResponseCode();
                boolean bl = false;
                if (n2 != 200) {
                    if (n2 == 302 || n2 == 301 || n2 == 303) {
                        bl = true;
                    } else if (!request.ignoreHttpErrors()) {
                        throw new HttpStatusException("HTTP error fetching URL", n2, request.url().toString());
                    }
                }
                response2 = new Response(response);
                response2.setupFromConnection(httpURLConnection, response);
                if (bl && request.followRedirects()) {
                    request.method(Connection.Method.GET);
                    request.data().clear();
                    request.url(new URL(request.url(), response2.header("Location")));
                    for (Map.Entry entry : response2.cookies.entrySet()) {
                        request.cookie((String)entry.getKey(), (String)entry.getValue());
                    }
                    Response response3 = Response.execute(request, response2);
                    return response3;
                }
                response2.req = request;
                String string2 = response2.contentType();
                if (!(string2 == null || request.ignoreContentType() || string2.startsWith("text/") || string2.startsWith("application/xml") || string2.startsWith("application/xhtml+xml"))) {
                    throw new UnsupportedMimeTypeException("Unhandled content type. Must be text/*, application/xml, or application/xhtml+xml", string2, request.url().toString());
                }
                InputStream inputStream = null;
                InputStream inputStream2 = null;
                try {
                    inputStream2 = httpURLConnection.getErrorStream() != null ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
                    inputStream = response2.hasHeader("Content-Encoding") && response2.header("Content-Encoding").equalsIgnoreCase("gzip") ? new BufferedInputStream(new GZIPInputStream(inputStream2)) : new BufferedInputStream(inputStream2);
                    response2.byteData = DataUtil.readToByteBuffer(inputStream, request.maxBodySize());
                    response2.charset = DataUtil.getCharsetFromContentType(response2.contentType);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
            }
            finally {
                httpURLConnection.disconnect();
            }
            response2.executed = true;
            return response2;
        }

        @Override
        public int statusCode() {
            return this.statusCode;
        }

        @Override
        public String statusMessage() {
            return this.statusMessage;
        }

        @Override
        public String charset() {
            return this.charset;
        }

        @Override
        public String contentType() {
            return this.contentType;
        }

        @Override
        public Document parse() throws IOException {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before parsing response");
            Document document = DataUtil.parseByteData(this.byteData, this.charset, this.url.toExternalForm(), this.req.parser());
            this.byteData.rewind();
            this.charset = document.outputSettings().charset().name();
            return document;
        }

        @Override
        public String body() {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
            String string = this.charset == null ? Charset.forName("UTF-8").decode(this.byteData).toString() : Charset.forName(this.charset).decode(this.byteData).toString();
            this.byteData.rewind();
            return string;
        }

        @Override
        public byte[] bodyAsBytes() {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
            return this.byteData.array();
        }

        private static HttpURLConnection createConnection(Connection.Request request) throws IOException {
            HttpURLConnection httpURLConnection = (HttpURLConnection)request.url().openConnection();
            httpURLConnection.setRequestMethod(request.method().name());
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.setConnectTimeout(request.timeout());
            httpURLConnection.setReadTimeout(request.timeout());
            if (request.method() == Connection.Method.POST) {
                httpURLConnection.setDoOutput(true);
            }
            if (request.cookies().size() > 0) {
                httpURLConnection.addRequestProperty("Cookie", Response.getRequestCookieString(request));
            }
            for (Map.Entry<String, String> entry : request.headers().entrySet()) {
                httpURLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            return httpURLConnection;
        }

        private void setupFromConnection(HttpURLConnection httpURLConnection, Connection.Response response) throws IOException {
            this.method = Connection.Method.valueOf(httpURLConnection.getRequestMethod());
            this.url = httpURLConnection.getURL();
            this.statusCode = httpURLConnection.getResponseCode();
            this.statusMessage = httpURLConnection.getResponseMessage();
            this.contentType = httpURLConnection.getContentType();
            Map<String, List<String>> map = httpURLConnection.getHeaderFields();
            this.processResponseHeaders(map);
            if (response != null) {
                for (Map.Entry<String, String> entry : response.cookies().entrySet()) {
                    if (this.hasCookie(entry.getKey())) continue;
                    this.cookie(entry.getKey(), entry.getValue());
                }
            }
        }

        void processResponseHeaders(Map<String, List<String>> map) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String string = entry.getKey();
                if (string == null) continue;
                List<String> list = entry.getValue();
                if (string.equalsIgnoreCase("Set-Cookie")) {
                    for (String string2 : list) {
                        if (string2 == null) continue;
                        TokenQueue tokenQueue = new TokenQueue(string2);
                        String string3 = tokenQueue.chompTo("=").trim();
                        String string4 = tokenQueue.consumeTo(";").trim();
                        if (string4 == null) {
                            string4 = "";
                        }
                        if (string3 == null || string3.length() <= 0) continue;
                        this.cookie(string3, string4);
                    }
                    continue;
                }
                if (list.isEmpty()) continue;
                this.header(string, list.get(0));
            }
        }

        private static void writePost(Collection<Connection.KeyVal> collection, OutputStream outputStream) throws IOException {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            boolean bl = true;
            for (Connection.KeyVal keyVal : collection) {
                if (!bl) {
                    outputStreamWriter.append('&');
                } else {
                    bl = false;
                }
                outputStreamWriter.write(URLEncoder.encode(keyVal.key(), "UTF-8"));
                outputStreamWriter.write(61);
                outputStreamWriter.write(URLEncoder.encode(keyVal.value(), "UTF-8"));
            }
            outputStreamWriter.close();
        }

        private static String getRequestCookieString(Connection.Request request) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (Map.Entry<String, String> entry : request.cookies().entrySet()) {
                if (!bl) {
                    stringBuilder.append("; ");
                } else {
                    bl = false;
                }
                stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
            }
            return stringBuilder.toString();
        }

        private static void serialiseRequestUrl(Connection.Request request) throws IOException {
            URL uRL = request.url();
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            stringBuilder.append(uRL.getProtocol()).append("://").append(uRL.getAuthority()).append(uRL.getPath()).append("?");
            if (uRL.getQuery() != null) {
                stringBuilder.append(uRL.getQuery());
                bl = false;
            }
            for (Connection.KeyVal keyVal : request.data()) {
                if (!bl) {
                    stringBuilder.append('&');
                } else {
                    bl = false;
                }
                stringBuilder.append(URLEncoder.encode(keyVal.key(), "UTF-8")).append('=').append(URLEncoder.encode(keyVal.value(), "UTF-8"));
            }
            request.url(new URL(stringBuilder.toString()));
            request.data().clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Request
    extends Base<Connection.Request>
    implements Connection.Request {
        private int timeoutMilliseconds = 3000;
        private int maxBodySizeBytes = 0x100000;
        private boolean followRedirects = true;
        private Collection<Connection.KeyVal> data = new ArrayList<Connection.KeyVal>();
        private boolean ignoreHttpErrors = false;
        private boolean ignoreContentType = false;
        private Parser parser;

        private Request() {
            this.method = Connection.Method.GET;
            this.headers.put("Accept-Encoding", "gzip");
            this.parser = Parser.htmlParser();
        }

        @Override
        public int timeout() {
            return this.timeoutMilliseconds;
        }

        @Override
        public Request timeout(int n2) {
            Validate.isTrue(n2 >= 0, "Timeout milliseconds must be 0 (infinite) or greater");
            this.timeoutMilliseconds = n2;
            return this;
        }

        @Override
        public int maxBodySize() {
            return this.maxBodySizeBytes;
        }

        @Override
        public Connection.Request maxBodySize(int n2) {
            Validate.isTrue(n2 >= 0, "maxSize must be 0 (unlimited) or larger");
            this.maxBodySizeBytes = n2;
            return this;
        }

        @Override
        public boolean followRedirects() {
            return this.followRedirects;
        }

        @Override
        public Connection.Request followRedirects(boolean bl) {
            this.followRedirects = bl;
            return this;
        }

        @Override
        public boolean ignoreHttpErrors() {
            return this.ignoreHttpErrors;
        }

        @Override
        public Connection.Request ignoreHttpErrors(boolean bl) {
            this.ignoreHttpErrors = bl;
            return this;
        }

        @Override
        public boolean ignoreContentType() {
            return this.ignoreContentType;
        }

        @Override
        public Connection.Request ignoreContentType(boolean bl) {
            this.ignoreContentType = bl;
            return this;
        }

        @Override
        public Request data(Connection.KeyVal keyVal) {
            Validate.notNull(keyVal, "Key val must not be null");
            this.data.add(keyVal);
            return this;
        }

        @Override
        public Collection<Connection.KeyVal> data() {
            return this.data;
        }

        @Override
        public Request parser(Parser parser) {
            this.parser = parser;
            return this;
        }

        @Override
        public Parser parser() {
            return this.parser;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Base<T extends Connection.Base>
    implements Connection.Base<T> {
        URL url;
        Connection.Method method;
        Map<String, String> headers = new LinkedHashMap<String, String>();
        Map<String, String> cookies = new LinkedHashMap<String, String>();

        private Base() {
        }

        @Override
        public URL url() {
            return this.url;
        }

        @Override
        public T url(URL uRL) {
            Validate.notNull(uRL, "URL must not be null");
            this.url = uRL;
            return (T)this;
        }

        @Override
        public Connection.Method method() {
            return this.method;
        }

        @Override
        public T method(Connection.Method method) {
            Validate.notNull((Object)method, "Method must not be null");
            this.method = method;
            return (T)this;
        }

        @Override
        public String header(String string) {
            Validate.notNull(string, "Header name must not be null");
            return this.getHeaderCaseInsensitive(string);
        }

        @Override
        public T header(String string, String string2) {
            Validate.notEmpty(string, "Header name must not be empty");
            Validate.notNull(string2, "Header value must not be null");
            this.removeHeader(string);
            this.headers.put(string, string2);
            return (T)this;
        }

        @Override
        public boolean hasHeader(String string) {
            Validate.notEmpty(string, "Header name must not be empty");
            return this.getHeaderCaseInsensitive(string) != null;
        }

        @Override
        public T removeHeader(String string) {
            Validate.notEmpty(string, "Header name must not be empty");
            Map.Entry<String, String> entry = this.scanHeaders(string);
            if (entry != null) {
                this.headers.remove(entry.getKey());
            }
            return (T)this;
        }

        @Override
        public Map<String, String> headers() {
            return this.headers;
        }

        private String getHeaderCaseInsensitive(String string) {
            Map.Entry<String, String> entry;
            Validate.notNull(string, "Header name must not be null");
            String string2 = this.headers.get(string);
            if (string2 == null) {
                string2 = this.headers.get(string.toLowerCase());
            }
            if (string2 == null && (entry = this.scanHeaders(string)) != null) {
                string2 = entry.getValue();
            }
            return string2;
        }

        private Map.Entry<String, String> scanHeaders(String string) {
            String string2 = string.toLowerCase();
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                if (!entry.getKey().toLowerCase().equals(string2)) continue;
                return entry;
            }
            return null;
        }

        @Override
        public String cookie(String string) {
            Validate.notNull(string, "Cookie name must not be null");
            return this.cookies.get(string);
        }

        @Override
        public T cookie(String string, String string2) {
            Validate.notEmpty(string, "Cookie name must not be empty");
            Validate.notNull(string2, "Cookie value must not be null");
            this.cookies.put(string, string2);
            return (T)this;
        }

        @Override
        public boolean hasCookie(String string) {
            Validate.notEmpty("Cookie name must not be empty");
            return this.cookies.containsKey(string);
        }

        @Override
        public T removeCookie(String string) {
            Validate.notEmpty("Cookie name must not be empty");
            this.cookies.remove(string);
            return (T)this;
        }

        @Override
        public Map<String, String> cookies() {
            return this.cookies;
        }
    }
}

