/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jsoup.nodes;

import com.contrastsecurity.thirdparty.org.jsoup.helper.Validate;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Document;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Entities;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute
implements Cloneable,
Map.Entry<String, String> {
    private String key;
    private String value;

    public Attribute(String string, String string2) {
        Validate.notEmpty(string);
        Validate.notNull(string2);
        this.key = string.trim().toLowerCase();
        this.value = string2;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        Validate.notEmpty(string);
        this.key = string.trim().toLowerCase();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String setValue(String string) {
        Validate.notNull(string);
        String string2 = this.value;
        this.value = string;
        return string2;
    }

    public String html() {
        return this.key + "=\"" + Entities.escape(this.value, new Document("").outputSettings()) + "\"";
    }

    protected void html(StringBuilder stringBuilder, Document.OutputSettings outputSettings) {
        stringBuilder.append(this.key).append("=\"").append(Entities.escape(this.value, outputSettings)).append("\"");
    }

    public String toString() {
        return this.html();
    }

    public static Attribute createFromEncoded(String string, String string2) {
        String string3 = Entities.unescape(string2, true);
        return new Attribute(string, string3);
    }

    protected boolean isDataAttribute() {
        return this.key.startsWith("data-") && this.key.length() > "data-".length();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        if (this.key != null ? !this.key.equals(attribute.key) : attribute.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(attribute.value) : attribute.value != null);
    }

    @Override
    public int hashCode() {
        int n2 = this.key != null ? this.key.hashCode() : 0;
        n2 = 31 * n2 + (this.value != null ? this.value.hashCode() : 0);
        return n2;
    }

    public Attribute clone() {
        try {
            return (Attribute)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }
}

