/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jsoup.nodes;

import com.contrastsecurity.thirdparty.org.jsoup.helper.Validate;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Attribute;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Document;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attributes
implements Cloneable,
Iterable<Attribute> {
    protected static final String dataPrefix = "data-";
    private LinkedHashMap<String, Attribute> attributes = null;

    public String get(String string) {
        Validate.notEmpty(string);
        if (this.attributes == null) {
            return "";
        }
        Attribute attribute = this.attributes.get(string.toLowerCase());
        return attribute != null ? attribute.getValue() : "";
    }

    public void put(String string, String string2) {
        Attribute attribute = new Attribute(string, string2);
        this.put(attribute);
    }

    public void put(Attribute attribute) {
        Validate.notNull(attribute);
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap(2);
        }
        this.attributes.put(attribute.getKey(), attribute);
    }

    public void remove(String string) {
        Validate.notEmpty(string);
        if (this.attributes == null) {
            return;
        }
        this.attributes.remove(string.toLowerCase());
    }

    public boolean hasKey(String string) {
        return this.attributes != null && this.attributes.containsKey(string.toLowerCase());
    }

    public int size() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public void addAll(Attributes attributes) {
        if (attributes.size() == 0) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap(attributes.size());
        }
        this.attributes.putAll(attributes.attributes);
    }

    @Override
    public Iterator<Attribute> iterator() {
        return this.asList().iterator();
    }

    public List<Attribute> asList() {
        if (this.attributes == null) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(this.attributes.size());
        for (Map.Entry<String, Attribute> entry : this.attributes.entrySet()) {
            arrayList.add(entry.getValue());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Map<String, String> dataset() {
        return new Dataset();
    }

    public String html() {
        StringBuilder stringBuilder = new StringBuilder();
        this.html(stringBuilder, new Document("").outputSettings());
        return stringBuilder.toString();
    }

    void html(StringBuilder stringBuilder, Document.OutputSettings outputSettings) {
        if (this.attributes == null) {
            return;
        }
        for (Map.Entry<String, Attribute> entry : this.attributes.entrySet()) {
            Attribute attribute = entry.getValue();
            stringBuilder.append(" ");
            attribute.html(stringBuilder, outputSettings);
        }
    }

    public String toString() {
        return this.html();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Attributes)) {
            return false;
        }
        Attributes attributes = (Attributes)object;
        return !(this.attributes != null ? !this.attributes.equals(attributes.attributes) : attributes.attributes != null);
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }

    public Attributes clone() {
        Attributes attributes;
        if (this.attributes == null) {
            return new Attributes();
        }
        try {
            attributes = (Attributes)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        attributes.attributes = new LinkedHashMap(this.attributes.size());
        for (Attribute attribute : this) {
            attributes.attributes.put(attribute.getKey(), attribute.clone());
        }
        return attributes;
    }

    private static String dataKey(String string) {
        return dataPrefix + string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Dataset
    extends AbstractMap<String, String> {
        private Dataset() {
            if (Attributes.this.attributes == null) {
                Attributes.this.attributes = new LinkedHashMap(2);
            }
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return new EntrySet();
        }

        @Override
        public String put(String string, String string2) {
            String string3 = Attributes.dataKey(string);
            String string4 = Attributes.this.hasKey(string3) ? ((Attribute)Attributes.this.attributes.get(string3)).getValue() : null;
            Attribute attribute = new Attribute(string3, string2);
            Attributes.this.attributes.put(string3, attribute);
            return string4;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class DatasetIterator
        implements Iterator<Map.Entry<String, String>> {
            private Iterator<Attribute> attrIter;
            private Attribute attr;

            private DatasetIterator() {
                this.attrIter = Attributes.this.attributes.values().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.attrIter.hasNext()) {
                    this.attr = this.attrIter.next();
                    if (!this.attr.isDataAttribute()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Map.Entry<String, String> next() {
                return new Attribute(this.attr.getKey().substring(Attributes.dataPrefix.length()), this.attr.getValue());
            }

            @Override
            public void remove() {
                Attributes.this.attributes.remove(this.attr.getKey());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntrySet
        extends AbstractSet<Map.Entry<String, String>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new DatasetIterator();
            }

            @Override
            public int size() {
                int n2 = 0;
                DatasetIterator datasetIterator = new DatasetIterator();
                while (datasetIterator.hasNext()) {
                    ++n2;
                }
                return n2;
            }
        }
    }
}

