/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jsoup.nodes;

import com.contrastsecurity.thirdparty.org.jsoup.nodes.Document;
import com.contrastsecurity.thirdparty.org.jsoup.parser.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entities {
    private static final Map<String, Character> full;
    private static final Map<Character, String> xhtmlByVal;
    private static final Map<String, Character> base;
    private static final Map<Character, String> baseByVal;
    private static final Map<Character, String> fullByVal;
    private static final Pattern unescapePattern;
    private static final Pattern strictUnescapePattern;
    private static final Object[][] xhtmlArray;

    private Entities() {
    }

    public static boolean isNamedEntity(String string) {
        return full.containsKey(string);
    }

    public static boolean isBaseNamedEntity(String string) {
        return base.containsKey(string);
    }

    public static Character getCharacterByName(String string) {
        return full.get(string);
    }

    static String escape(String string, Document.OutputSettings outputSettings) {
        return Entities.escape(string, outputSettings.encoder(), outputSettings.escapeMode());
    }

    static String escape(String string, CharsetEncoder charsetEncoder, EscapeMode escapeMode) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        Map<Character, String> map = escapeMode.getMap();
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (n2 < 65536) {
                char c2 = (char)n2;
                if (map.containsKey(Character.valueOf(c2))) {
                    stringBuilder.append('&').append(map.get(Character.valueOf(c2))).append(';');
                    continue;
                }
                if (charsetEncoder.canEncode(c2)) {
                    stringBuilder.append(c2);
                    continue;
                }
                stringBuilder.append("&#x").append(Integer.toHexString(n2)).append(';');
                continue;
            }
            String string2 = new String(Character.toChars(n2));
            if (charsetEncoder.canEncode(string2)) {
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append("&#x").append(Integer.toHexString(n2)).append(';');
        }
        return stringBuilder.toString();
    }

    static String unescape(String string) {
        return Entities.unescape(string, false);
    }

    static String unescape(String string, boolean bl) {
        return Parser.unescapeEntities(string, bl);
    }

    private static Map<String, Character> loadEntities(String string) {
        Properties properties = new Properties();
        HashMap<String, Character> hashMap = new HashMap<String, Character>();
        try {
            InputStream inputStream = Entities.class.getResourceAsStream(string);
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new MissingResourceException("Error loading entities resource: " + iOException.getMessage(), "Entities", string);
        }
        for (Map.Entry entry : properties.entrySet()) {
            Character c2 = Character.valueOf((char)Integer.parseInt((String)entry.getValue(), 16));
            String string2 = (String)entry.getKey();
            hashMap.put(string2, c2);
        }
        return hashMap;
    }

    private static Map<Character, String> toCharacterKey(Map<String, Character> map) {
        HashMap<Character, String> hashMap = new HashMap<Character, String>();
        for (Map.Entry<String, Character> entry : map.entrySet()) {
            Character c2 = entry.getValue();
            String string = entry.getKey();
            if (hashMap.containsKey(c2)) {
                if (!string.toLowerCase().equals(string)) continue;
                hashMap.put(c2, string);
                continue;
            }
            hashMap.put(c2, string);
        }
        return hashMap;
    }

    static /* synthetic */ Map access$000() {
        return xhtmlByVal;
    }

    static /* synthetic */ Map access$100() {
        return baseByVal;
    }

    static /* synthetic */ Map access$200() {
        return fullByVal;
    }

    static {
        unescapePattern = Pattern.compile("&(#(x|X)?([0-9a-fA-F]+)|[a-zA-Z]+\\d*);?");
        strictUnescapePattern = Pattern.compile("&(#(x|X)?([0-9a-fA-F]+)|[a-zA-Z]+\\d*);");
        xhtmlArray = new Object[][]{{"quot", 34}, {"amp", 38}, {"apos", 39}, {"lt", 60}, {"gt", 62}};
        xhtmlByVal = new HashMap<Character, String>();
        base = Entities.loadEntities("entities-base.properties");
        baseByVal = Entities.toCharacterKey(base);
        full = Entities.loadEntities("entities-full.properties");
        fullByVal = Entities.toCharacterKey(full);
        for (Object[] objectArray : xhtmlArray) {
            Character c2 = Character.valueOf((char)((Integer)objectArray[1]).intValue());
            xhtmlByVal.put(c2, (String)objectArray[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EscapeMode {
        xhtml(Entities.access$000()),
        base(Entities.access$100()),
        extended(Entities.access$200());

        private Map<Character, String> map;

        private EscapeMode(Map<Character, String> map) {
            this.map = map;
        }

        public Map<Character, String> getMap() {
            return this.map;
        }
    }
}

