/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jsoup.nodes;

import com.contrastsecurity.thirdparty.org.jsoup.helper.StringUtil;
import com.contrastsecurity.thirdparty.org.jsoup.helper.Validate;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Attributes;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Document;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Element;
import com.contrastsecurity.thirdparty.org.jsoup.parser.Parser;
import com.contrastsecurity.thirdparty.org.jsoup.select.Elements;
import com.contrastsecurity.thirdparty.org.jsoup.select.NodeTraversor;
import com.contrastsecurity.thirdparty.org.jsoup.select.NodeVisitor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements Cloneable {
    Node parentNode;
    List<Node> childNodes;
    Attributes attributes;
    String baseUri;
    int siblingIndex;

    protected Node(String string, Attributes attributes) {
        Validate.notNull(string);
        Validate.notNull(attributes);
        this.childNodes = new ArrayList<Node>(4);
        this.baseUri = string.trim();
        this.attributes = attributes;
    }

    protected Node(String string) {
        this(string, new Attributes());
    }

    protected Node() {
        this.childNodes = Collections.emptyList();
        this.attributes = null;
    }

    public abstract String nodeName();

    public String attr(String string) {
        Validate.notNull(string);
        if (this.attributes.hasKey(string)) {
            return this.attributes.get(string);
        }
        if (string.toLowerCase().startsWith("abs:")) {
            return this.absUrl(string.substring("abs:".length()));
        }
        return "";
    }

    public Attributes attributes() {
        return this.attributes;
    }

    public Node attr(String string, String string2) {
        this.attributes.put(string, string2);
        return this;
    }

    public boolean hasAttr(String string) {
        String string2;
        Validate.notNull(string);
        if (string.toLowerCase().startsWith("abs:") && this.attributes.hasKey(string2 = string.substring("abs:".length())) && !this.absUrl(string2).equals("")) {
            return true;
        }
        return this.attributes.hasKey(string);
    }

    public Node removeAttr(String string) {
        Validate.notNull(string);
        this.attributes.remove(string);
        return this;
    }

    public String baseUri() {
        return this.baseUri;
    }

    public void setBaseUri(final String string) {
        Validate.notNull(string);
        this.traverse(new NodeVisitor(){

            public void head(Node node, int n2) {
                node.baseUri = string;
            }

            public void tail(Node node, int n2) {
            }
        });
    }

    public String absUrl(String string) {
        Validate.notEmpty(string);
        String string2 = this.attr(string);
        if (!this.hasAttr(string)) {
            return "";
        }
        try {
            URL uRL;
            try {
                uRL = new URL(this.baseUri);
            }
            catch (MalformedURLException malformedURLException) {
                URL uRL2 = new URL(string2);
                return uRL2.toExternalForm();
            }
            if (string2.startsWith("?")) {
                string2 = uRL.getPath() + string2;
            }
            URL uRL3 = new URL(uRL, string2);
            return uRL3.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return "";
        }
    }

    public Node childNode(int n2) {
        return this.childNodes.get(n2);
    }

    public List<Node> childNodes() {
        return Collections.unmodifiableList(this.childNodes);
    }

    public List<Node> childNodesCopy() {
        ArrayList<Node> arrayList = new ArrayList<Node>(this.childNodes.size());
        for (Node node : this.childNodes) {
            arrayList.add(node.clone());
        }
        return arrayList;
    }

    public final int childNodeSize() {
        return this.childNodes.size();
    }

    protected Node[] childNodesAsArray() {
        return this.childNodes.toArray(new Node[this.childNodeSize()]);
    }

    public Node parent() {
        return this.parentNode;
    }

    public Document ownerDocument() {
        if (this instanceof Document) {
            return (Document)this;
        }
        if (this.parentNode == null) {
            return null;
        }
        return this.parentNode.ownerDocument();
    }

    public void remove() {
        Validate.notNull(this.parentNode);
        this.parentNode.removeChild(this);
    }

    public Node before(String string) {
        this.addSiblingHtml(this.siblingIndex(), string);
        return this;
    }

    public Node before(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.parentNode);
        this.parentNode.addChildren(this.siblingIndex(), node);
        return this;
    }

    public Node after(String string) {
        this.addSiblingHtml(this.siblingIndex() + 1, string);
        return this;
    }

    public Node after(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.parentNode);
        this.parentNode.addChildren(this.siblingIndex() + 1, node);
        return this;
    }

    private void addSiblingHtml(int n2, String string) {
        Validate.notNull(string);
        Validate.notNull(this.parentNode);
        Element element = this.parent() instanceof Element ? (Element)this.parent() : null;
        List<Node> list = Parser.parseFragment(string, element, this.baseUri());
        this.parentNode.addChildren(n2, list.toArray(new Node[list.size()]));
    }

    public Node wrap(String string) {
        Validate.notEmpty(string);
        Element element = this.parent() instanceof Element ? (Element)this.parent() : null;
        List<Node> list = Parser.parseFragment(string, element, this.baseUri());
        Node node = list.get(0);
        if (node == null || !(node instanceof Element)) {
            return null;
        }
        Element element2 = (Element)node;
        Element element3 = this.getDeepChild(element2);
        this.parentNode.replaceChild(this, element2);
        element3.addChildren(this);
        if (list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Node node2 = list.get(i2);
                node2.parentNode.removeChild(node2);
                element2.appendChild(node2);
            }
        }
        return this;
    }

    public Node unwrap() {
        Validate.notNull(this.parentNode);
        int n2 = this.siblingIndex;
        Node node = this.childNodes.size() > 0 ? this.childNodes.get(0) : null;
        this.parentNode.addChildren(n2, this.childNodesAsArray());
        this.remove();
        return node;
    }

    private Element getDeepChild(Element element) {
        Elements elements = element.children();
        if (elements.size() > 0) {
            return this.getDeepChild((Element)elements.get(0));
        }
        return element;
    }

    public void replaceWith(Node node) {
        Validate.notNull(node);
        Validate.notNull(this.parentNode);
        this.parentNode.replaceChild(this, node);
    }

    protected void setParentNode(Node node) {
        if (this.parentNode != null) {
            this.parentNode.removeChild(this);
        }
        this.parentNode = node;
    }

    protected void replaceChild(Node node, Node node2) {
        Validate.isTrue(node.parentNode == this);
        Validate.notNull(node2);
        if (node2.parentNode != null) {
            node2.parentNode.removeChild(node2);
        }
        Integer n2 = node.siblingIndex();
        this.childNodes.set(n2, node2);
        node2.parentNode = this;
        node2.setSiblingIndex(n2);
        node.parentNode = null;
    }

    protected void removeChild(Node node) {
        Validate.isTrue(node.parentNode == this);
        int n2 = node.siblingIndex();
        this.childNodes.remove(n2);
        this.reindexChildren();
        node.parentNode = null;
    }

    protected void addChildren(Node ... nodeArray) {
        for (Node node : nodeArray) {
            this.reparentChild(node);
            this.childNodes.add(node);
            node.setSiblingIndex(this.childNodes.size() - 1);
        }
    }

    protected void addChildren(int n2, Node ... nodeArray) {
        Validate.noNullElements(nodeArray);
        for (int i2 = nodeArray.length - 1; i2 >= 0; --i2) {
            Node node = nodeArray[i2];
            this.reparentChild(node);
            this.childNodes.add(n2, node);
        }
        this.reindexChildren();
    }

    private void reparentChild(Node node) {
        if (node.parentNode != null) {
            node.parentNode.removeChild(node);
        }
        node.setParentNode(this);
    }

    private void reindexChildren() {
        for (int i2 = 0; i2 < this.childNodes.size(); ++i2) {
            this.childNodes.get(i2).setSiblingIndex(i2);
        }
    }

    public List<Node> siblingNodes() {
        if (this.parentNode == null) {
            return Collections.emptyList();
        }
        List<Node> list = this.parentNode.childNodes;
        ArrayList<Node> arrayList = new ArrayList<Node>(list.size() - 1);
        for (Node node : list) {
            if (node == this) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public Node nextSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Node> list = this.parentNode.childNodes;
        Integer n2 = this.siblingIndex();
        Validate.notNull(n2);
        if (list.size() > n2 + 1) {
            return list.get(n2 + 1);
        }
        return null;
    }

    public Node previousSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Node> list = this.parentNode.childNodes;
        Integer n2 = this.siblingIndex();
        Validate.notNull(n2);
        if (n2 > 0) {
            return list.get(n2 - 1);
        }
        return null;
    }

    public int siblingIndex() {
        return this.siblingIndex;
    }

    protected void setSiblingIndex(int n2) {
        this.siblingIndex = n2;
    }

    public Node traverse(NodeVisitor nodeVisitor) {
        Validate.notNull(nodeVisitor);
        NodeTraversor nodeTraversor = new NodeTraversor(nodeVisitor);
        nodeTraversor.traverse(this);
        return this;
    }

    public String outerHtml() {
        StringBuilder stringBuilder = new StringBuilder(128);
        this.outerHtml(stringBuilder);
        return stringBuilder.toString();
    }

    protected void outerHtml(StringBuilder stringBuilder) {
        new NodeTraversor(new OuterHtmlVisitor(stringBuilder, this.getOutputSettings())).traverse(this);
    }

    private Document.OutputSettings getOutputSettings() {
        return this.ownerDocument() != null ? this.ownerDocument().outputSettings() : new Document("").outputSettings();
    }

    abstract void outerHtmlHead(StringBuilder var1, int var2, Document.OutputSettings var3);

    abstract void outerHtmlTail(StringBuilder var1, int var2, Document.OutputSettings var3);

    public String toString() {
        return this.outerHtml();
    }

    protected void indent(StringBuilder stringBuilder, int n2, Document.OutputSettings outputSettings) {
        stringBuilder.append("\n").append(StringUtil.padding(n2 * outputSettings.indentAmount()));
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        int n2 = this.parentNode != null ? this.parentNode.hashCode() : 0;
        n2 = 31 * n2 + (this.attributes != null ? this.attributes.hashCode() : 0);
        return n2;
    }

    public Node clone() {
        return this.doClone(null);
    }

    protected Node doClone(Node node) {
        Node node2;
        try {
            node2 = (Node)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        node2.parentNode = node;
        node2.siblingIndex = node == null ? 0 : this.siblingIndex;
        node2.attributes = this.attributes != null ? this.attributes.clone() : null;
        node2.baseUri = this.baseUri;
        node2.childNodes = new ArrayList<Node>(this.childNodes.size());
        for (Node node3 : this.childNodes) {
            node2.childNodes.add(node3.doClone(node2));
        }
        return node2;
    }

    private static class OuterHtmlVisitor
    implements NodeVisitor {
        private StringBuilder accum;
        private Document.OutputSettings out;

        OuterHtmlVisitor(StringBuilder stringBuilder, Document.OutputSettings outputSettings) {
            this.accum = stringBuilder;
            this.out = outputSettings;
        }

        public void head(Node node, int n2) {
            node.outerHtmlHead(this.accum, n2, this.out);
        }

        public void tail(Node node, int n2) {
            if (!node.nodeName().equals("#text")) {
                node.outerHtmlTail(this.accum, n2, this.out);
            }
        }
    }
}

