/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jsoup.parser;

import com.contrastsecurity.thirdparty.org.jsoup.helper.Validate;
import java.util.Locale;

class CharacterReader {
    static final char EOF = '\uffff';
    private final char[] input;
    private final int length;
    private int pos = 0;
    private int mark = 0;

    CharacterReader(String string) {
        Validate.notNull(string);
        this.input = string.toCharArray();
        this.length = this.input.length;
    }

    int pos() {
        return this.pos;
    }

    boolean isEmpty() {
        return this.pos >= this.length;
    }

    char current() {
        return this.isEmpty() ? (char)'\uffff' : this.input[this.pos];
    }

    char consume() {
        char c2 = this.isEmpty() ? (char)'\uffff' : this.input[this.pos];
        ++this.pos;
        return c2;
    }

    void unconsume() {
        --this.pos;
    }

    void advance() {
        ++this.pos;
    }

    void mark() {
        this.mark = this.pos;
    }

    void rewindToMark() {
        this.pos = this.mark;
    }

    String consumeAsString() {
        return new String(this.input, this.pos++, 1);
    }

    int nextIndexOf(char c2) {
        for (int i2 = this.pos; i2 < this.length; ++i2) {
            if (c2 != this.input[i2]) continue;
            return i2 - this.pos;
        }
        return -1;
    }

    int nextIndexOf(CharSequence charSequence) {
        char c2 = charSequence.charAt(0);
        for (int i2 = this.pos; i2 < this.length; ++i2) {
            if (c2 != this.input[i2]) {
                while (++i2 < this.length && c2 != this.input[i2]) {
                }
            }
            if (i2 >= this.length) continue;
            int n2 = i2 + 1;
            int n3 = n2 + charSequence.length() - 1;
            int n4 = 1;
            while (n2 < n3 && charSequence.charAt(n4) == this.input[n2]) {
                ++n2;
                ++n4;
            }
            if (n2 != n3) continue;
            return i2 - this.pos;
        }
        return -1;
    }

    String consumeTo(char c2) {
        int n2 = this.nextIndexOf(c2);
        if (n2 != -1) {
            String string = new String(this.input, this.pos, n2);
            this.pos += n2;
            return string;
        }
        return this.consumeToEnd();
    }

    String consumeTo(String string) {
        int n2 = this.nextIndexOf(string);
        if (n2 != -1) {
            String string2 = new String(this.input, this.pos, n2);
            this.pos += n2;
            return string2;
        }
        return this.consumeToEnd();
    }

    String consumeToAny(char ... cArray) {
        int n2 = this.pos;
        block0: while (this.pos < this.length) {
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                if (this.input[this.pos] == cArray[i2]) break block0;
            }
            ++this.pos;
        }
        return this.pos > n2 ? new String(this.input, n2, this.pos - n2) : "";
    }

    String consumeToEnd() {
        String string = new String(this.input, this.pos, this.length - this.pos);
        this.pos = this.length;
        return string;
    }

    String consumeLetterSequence() {
        char c2;
        int n2 = this.pos;
        while (this.pos < this.length && ((c2 = this.input[this.pos]) >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z')) {
            ++this.pos;
        }
        return new String(this.input, n2, this.pos - n2);
    }

    String consumeLetterThenDigitSequence() {
        char c2;
        int n2 = this.pos;
        while (this.pos < this.length && ((c2 = this.input[this.pos]) >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z')) {
            ++this.pos;
        }
        while (!this.isEmpty() && (c2 = this.input[this.pos]) >= '0' && c2 <= '9') {
            ++this.pos;
        }
        return new String(this.input, n2, this.pos - n2);
    }

    String consumeHexSequence() {
        char c2;
        int n2 = this.pos;
        while (this.pos < this.length && ((c2 = this.input[this.pos]) >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f')) {
            ++this.pos;
        }
        return new String(this.input, n2, this.pos - n2);
    }

    String consumeDigitSequence() {
        char c2;
        int n2 = this.pos;
        while (this.pos < this.length && (c2 = this.input[this.pos]) >= '0' && c2 <= '9') {
            ++this.pos;
        }
        return new String(this.input, n2, this.pos - n2);
    }

    boolean matches(char c2) {
        return !this.isEmpty() && this.input[this.pos] == c2;
    }

    boolean matches(String string) {
        int n2 = string.length();
        if (n2 > this.length - this.pos) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) == this.input[this.pos + i2]) continue;
            return false;
        }
        return true;
    }

    boolean matchesIgnoreCase(String string) {
        int n2 = string.length();
        if (n2 > this.length - this.pos) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2;
            char c3 = Character.toUpperCase(string.charAt(i2));
            if (c3 == (c2 = Character.toUpperCase(this.input[this.pos + i2]))) continue;
            return false;
        }
        return true;
    }

    boolean matchesAny(char ... cArray) {
        if (this.isEmpty()) {
            return false;
        }
        char c2 = this.input[this.pos];
        for (char c3 : cArray) {
            if (c3 != c2) continue;
            return true;
        }
        return false;
    }

    boolean matchesLetter() {
        if (this.isEmpty()) {
            return false;
        }
        char c2 = this.input[this.pos];
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z';
    }

    boolean matchesDigit() {
        if (this.isEmpty()) {
            return false;
        }
        char c2 = this.input[this.pos];
        return c2 >= '0' && c2 <= '9';
    }

    boolean matchConsume(String string) {
        if (this.matches(string)) {
            this.pos += string.length();
            return true;
        }
        return false;
    }

    boolean matchConsumeIgnoreCase(String string) {
        if (this.matchesIgnoreCase(string)) {
            this.pos += string.length();
            return true;
        }
        return false;
    }

    boolean containsIgnoreCase(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = string.toUpperCase(Locale.ENGLISH);
        return this.nextIndexOf(string2) > -1 || this.nextIndexOf(string3) > -1;
    }

    public String toString() {
        return new String(this.input, this.pos, this.length - this.pos);
    }
}

