/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jsoup.parser;

import com.contrastsecurity.thirdparty.org.jsoup.helper.Validate;
import java.util.HashMap;
import java.util.Map;

public class Tag {
    private static final Map<String, Tag> tags;
    private String tagName;
    private boolean isBlock = true;
    private boolean formatAsBlock = true;
    private boolean canContainBlock = true;
    private boolean canContainInline = true;
    private boolean empty = false;
    private boolean selfClosing = false;
    private boolean preserveWhitespace = false;
    private static final String[] blockTags;
    private static final String[] inlineTags;
    private static final String[] emptyTags;
    private static final String[] formatAsInlineTags;
    private static final String[] preserveWhitespaceTags;

    private Tag(String string) {
        this.tagName = string.toLowerCase();
    }

    public String getName() {
        return this.tagName;
    }

    public static Tag valueOf(String string) {
        Validate.notNull(string);
        Tag tag = tags.get(string);
        if (tag == null) {
            string = string.trim().toLowerCase();
            Validate.notEmpty(string);
            tag = tags.get(string);
            if (tag == null) {
                tag = new Tag(string);
                tag.isBlock = false;
                tag.canContainBlock = true;
            }
        }
        return tag;
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public boolean formatAsBlock() {
        return this.formatAsBlock;
    }

    public boolean canContainBlock() {
        return this.canContainBlock;
    }

    public boolean isInline() {
        return !this.isBlock;
    }

    public boolean isData() {
        return !this.canContainInline && !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isSelfClosing() {
        return this.empty || this.selfClosing;
    }

    public boolean isKnownTag() {
        return tags.containsKey(this.tagName);
    }

    public static boolean isKnownTag(String string) {
        return tags.containsKey(string);
    }

    public boolean preserveWhitespace() {
        return this.preserveWhitespace;
    }

    Tag setSelfClosing() {
        this.selfClosing = true;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)object;
        if (this.canContainBlock != tag.canContainBlock) {
            return false;
        }
        if (this.canContainInline != tag.canContainInline) {
            return false;
        }
        if (this.empty != tag.empty) {
            return false;
        }
        if (this.formatAsBlock != tag.formatAsBlock) {
            return false;
        }
        if (this.isBlock != tag.isBlock) {
            return false;
        }
        if (this.preserveWhitespace != tag.preserveWhitespace) {
            return false;
        }
        if (this.selfClosing != tag.selfClosing) {
            return false;
        }
        return this.tagName.equals(tag.tagName);
    }

    public int hashCode() {
        int n2 = this.tagName.hashCode();
        n2 = 31 * n2 + (this.isBlock ? 1 : 0);
        n2 = 31 * n2 + (this.formatAsBlock ? 1 : 0);
        n2 = 31 * n2 + (this.canContainBlock ? 1 : 0);
        n2 = 31 * n2 + (this.canContainInline ? 1 : 0);
        n2 = 31 * n2 + (this.empty ? 1 : 0);
        n2 = 31 * n2 + (this.selfClosing ? 1 : 0);
        n2 = 31 * n2 + (this.preserveWhitespace ? 1 : 0);
        return n2;
    }

    public String toString() {
        return this.tagName;
    }

    private static void register(Tag tag) {
        tags.put(tag.tagName, tag);
    }

    static {
        Tag tag;
        tags = new HashMap<String, Tag>();
        blockTags = new String[]{"html", "head", "body", "frameset", "script", "noscript", "style", "meta", "link", "title", "frame", "noframes", "section", "nav", "aside", "hgroup", "header", "footer", "p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "pre", "div", "blockquote", "hr", "address", "figure", "figcaption", "form", "fieldset", "ins", "del", "s", "dl", "dt", "dd", "li", "table", "caption", "thead", "tfoot", "tbody", "colgroup", "col", "tr", "th", "td", "video", "audio", "canvas", "details", "menu", "plaintext"};
        inlineTags = new String[]{"object", "base", "font", "tt", "i", "b", "u", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "time", "acronym", "mark", "ruby", "rt", "rp", "a", "img", "br", "wbr", "map", "q", "sub", "sup", "bdo", "iframe", "embed", "span", "input", "select", "textarea", "label", "button", "optgroup", "option", "legend", "datalist", "keygen", "output", "progress", "meter", "area", "param", "source", "track", "summary", "command", "device"};
        emptyTags = new String[]{"meta", "link", "base", "frame", "img", "br", "wbr", "embed", "hr", "input", "keygen", "col", "command", "device"};
        formatAsInlineTags = new String[]{"title", "a", "p", "h1", "h2", "h3", "h4", "h5", "h6", "pre", "address", "li", "th", "td", "script", "style", "ins", "del", "s"};
        preserveWhitespaceTags = new String[]{"pre", "plaintext", "title", "textarea"};
        for (String string : blockTags) {
            tag = new Tag(string);
            Tag.register(tag);
        }
        for (String string : inlineTags) {
            tag = new Tag(string);
            tag.isBlock = false;
            tag.canContainBlock = false;
            tag.formatAsBlock = false;
            Tag.register(tag);
        }
        for (String string : emptyTags) {
            tag = tags.get(string);
            Validate.notNull(tag);
            tag.canContainBlock = false;
            tag.canContainInline = false;
            tag.empty = true;
        }
        for (String string : formatAsInlineTags) {
            tag = tags.get(string);
            Validate.notNull(tag);
            tag.formatAsBlock = false;
        }
        for (String string : preserveWhitespaceTags) {
            tag = tags.get(string);
            Validate.notNull(tag);
            tag.preserveWhitespace = true;
        }
    }
}

