/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jsoup.select;

import com.contrastsecurity.thirdparty.org.jsoup.helper.Validate;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Element;
import com.contrastsecurity.thirdparty.org.jsoup.select.NodeTraversor;
import com.contrastsecurity.thirdparty.org.jsoup.select.NodeVisitor;
import com.contrastsecurity.thirdparty.org.jsoup.select.Selector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Elements
implements Cloneable,
List<Element> {
    private List<Element> contents;

    public Elements() {
        this.contents = new ArrayList<Element>();
    }

    public Elements(int n2) {
        this.contents = new ArrayList<Element>(n2);
    }

    public Elements(Collection<Element> collection) {
        this.contents = new ArrayList<Element>(collection);
    }

    public Elements(List<Element> list) {
        this.contents = list;
    }

    public Elements(Element ... elementArray) {
        this(Arrays.asList(elementArray));
    }

    public Elements clone() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element element : this.contents) {
            arrayList.add(element.clone());
        }
        return new Elements((List<Element>)arrayList);
    }

    public String attr(String string) {
        for (Element element : this.contents) {
            if (!element.hasAttr(string)) continue;
            return element.attr(string);
        }
        return "";
    }

    public boolean hasAttr(String string) {
        for (Element element : this.contents) {
            if (!element.hasAttr(string)) continue;
            return true;
        }
        return false;
    }

    public Elements attr(String string, String string2) {
        for (Element element : this.contents) {
            element.attr(string, string2);
        }
        return this;
    }

    public Elements removeAttr(String string) {
        for (Element element : this.contents) {
            element.removeAttr(string);
        }
        return this;
    }

    public Elements addClass(String string) {
        for (Element element : this.contents) {
            element.addClass(string);
        }
        return this;
    }

    public Elements removeClass(String string) {
        for (Element element : this.contents) {
            element.removeClass(string);
        }
        return this;
    }

    public Elements toggleClass(String string) {
        for (Element element : this.contents) {
            element.toggleClass(string);
        }
        return this;
    }

    public boolean hasClass(String string) {
        for (Element element : this.contents) {
            if (!element.hasClass(string)) continue;
            return true;
        }
        return false;
    }

    public String val() {
        if (this.size() > 0) {
            return this.first().val();
        }
        return "";
    }

    public Elements val(String string) {
        for (Element element : this.contents) {
            element.val(string);
        }
        return this;
    }

    public String text() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : this.contents) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(element.text());
        }
        return stringBuilder.toString();
    }

    public boolean hasText() {
        for (Element element : this.contents) {
            if (!element.hasText()) continue;
            return true;
        }
        return false;
    }

    public String html() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : this.contents) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(element.html());
        }
        return stringBuilder.toString();
    }

    public String outerHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element element : this.contents) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(element.outerHtml());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.outerHtml();
    }

    public Elements tagName(String string) {
        for (Element element : this.contents) {
            element.tagName(string);
        }
        return this;
    }

    public Elements html(String string) {
        for (Element element : this.contents) {
            element.html(string);
        }
        return this;
    }

    public Elements prepend(String string) {
        for (Element element : this.contents) {
            element.prepend(string);
        }
        return this;
    }

    public Elements append(String string) {
        for (Element element : this.contents) {
            element.append(string);
        }
        return this;
    }

    public Elements before(String string) {
        for (Element element : this.contents) {
            element.before(string);
        }
        return this;
    }

    public Elements after(String string) {
        for (Element element : this.contents) {
            element.after(string);
        }
        return this;
    }

    public Elements wrap(String string) {
        Validate.notEmpty(string);
        for (Element element : this.contents) {
            element.wrap(string);
        }
        return this;
    }

    public Elements unwrap() {
        for (Element element : this.contents) {
            element.unwrap();
        }
        return this;
    }

    public Elements empty() {
        for (Element element : this.contents) {
            element.empty();
        }
        return this;
    }

    public Elements remove() {
        for (Element element : this.contents) {
            element.remove();
        }
        return this;
    }

    public Elements select(String string) {
        return Selector.select(string, this);
    }

    public Elements not(String string) {
        Elements elements = Selector.select(string, this);
        return Selector.filterOut(this, elements);
    }

    public Elements eq(int n2) {
        return this.contents.size() > n2 ? new Elements(this.get(n2)) : new Elements();
    }

    public boolean is(String string) {
        Elements elements = this.select(string);
        return !elements.isEmpty();
    }

    public Elements parents() {
        LinkedHashSet<Element> linkedHashSet = new LinkedHashSet<Element>();
        for (Element element : this.contents) {
            linkedHashSet.addAll(element.parents());
        }
        return new Elements(linkedHashSet);
    }

    public Element first() {
        return this.contents.isEmpty() ? null : this.contents.get(0);
    }

    public Element last() {
        return this.contents.isEmpty() ? null : this.contents.get(this.contents.size() - 1);
    }

    public Elements traverse(NodeVisitor nodeVisitor) {
        Validate.notNull(nodeVisitor);
        NodeTraversor nodeTraversor = new NodeTraversor(nodeVisitor);
        for (Element element : this.contents) {
            nodeTraversor.traverse(element);
        }
        return this;
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.contents.contains(object);
    }

    @Override
    public Iterator<Element> iterator() {
        return this.contents.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.contents.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.contents.toArray(TArray);
    }

    @Override
    public boolean add(Element element) {
        return this.contents.add(element);
    }

    @Override
    public boolean remove(Object object) {
        return this.contents.remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.contents.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends Element> collection) {
        return this.contents.addAll(collection);
    }

    @Override
    public boolean addAll(int n2, Collection<? extends Element> collection) {
        return this.contents.addAll(n2, collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.contents.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.contents.retainAll(collection);
    }

    @Override
    public void clear() {
        this.contents.clear();
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.contents).equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.contents).hashCode();
    }

    @Override
    public Element get(int n2) {
        return this.contents.get(n2);
    }

    @Override
    public Element set(int n2, Element element) {
        return this.contents.set(n2, element);
    }

    @Override
    public void add(int n2, Element element) {
        this.contents.add(n2, element);
    }

    @Override
    public Element remove(int n2) {
        return this.contents.remove(n2);
    }

    @Override
    public int indexOf(Object object) {
        return this.contents.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.contents.lastIndexOf(object);
    }

    @Override
    public ListIterator<Element> listIterator() {
        return this.contents.listIterator();
    }

    @Override
    public ListIterator<Element> listIterator(int n2) {
        return this.contents.listIterator(n2);
    }

    @Override
    public List<Element> subList(int n2, int n3) {
        return this.contents.subList(n2, n3);
    }
}

