/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.jsoup.select;

import com.contrastsecurity.thirdparty.org.jsoup.helper.Validate;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Comment;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Document;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.DocumentType;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Element;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.Node;
import com.contrastsecurity.thirdparty.org.jsoup.nodes.XmlDeclaration;
import com.contrastsecurity.thirdparty.org.jsoup.select.Elements;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Evaluator {
    protected Evaluator() {
    }

    public abstract boolean matches(Element var1, Element var2);

    public static final class MatchesOwn
    extends Evaluator {
        private Pattern pattern;

        public MatchesOwn(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean matches(Element element, Element element2) {
            Matcher matcher = this.pattern.matcher(element2.ownText());
            return matcher.find();
        }

        public String toString() {
            return String.format(":matchesOwn(%s", this.pattern);
        }
    }

    public static final class Matches
    extends Evaluator {
        private Pattern pattern;

        public Matches(Pattern pattern) {
            this.pattern = pattern;
        }

        public boolean matches(Element element, Element element2) {
            Matcher matcher = this.pattern.matcher(element2.text());
            return matcher.find();
        }

        public String toString() {
            return String.format(":matches(%s", this.pattern);
        }
    }

    public static final class ContainsOwnText
    extends Evaluator {
        private String searchText;

        public ContainsOwnText(String string) {
            this.searchText = string.toLowerCase();
        }

        public boolean matches(Element element, Element element2) {
            return element2.ownText().toLowerCase().contains(this.searchText);
        }

        public String toString() {
            return String.format(":containsOwn(%s", this.searchText);
        }
    }

    public static final class ContainsText
    extends Evaluator {
        private String searchText;

        public ContainsText(String string) {
            this.searchText = string.toLowerCase();
        }

        public boolean matches(Element element, Element element2) {
            return element2.text().toLowerCase().contains(this.searchText);
        }

        public String toString() {
            return String.format(":contains(%s", this.searchText);
        }
    }

    public static abstract class IndexEvaluator
    extends Evaluator {
        int index;

        public IndexEvaluator(int n2) {
            this.index = n2;
        }
    }

    public static final class IsEmpty
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            List<Node> list = element2.childNodes();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Node node = list.get(i2);
                if (node instanceof Comment || node instanceof XmlDeclaration || node instanceof DocumentType) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return ":empty";
        }
    }

    public static final class IsOnlyOfType
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            Element element3 = element2.parent();
            if (element3 == null || element3 instanceof Document) {
                return false;
            }
            int n2 = 0;
            Elements elements = element3.children();
            for (int i2 = 0; i2 < elements.size(); ++i2) {
                if (!elements.get(i2).tag().equals(element2.tag())) continue;
                ++n2;
            }
            return n2 == 1;
        }

        public String toString() {
            return ":only-of-type";
        }
    }

    public static final class IsOnlyChild
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            Element element3 = element2.parent();
            return element3 != null && !(element3 instanceof Document) && element2.siblingElements().size() == 0;
        }

        public String toString() {
            return ":only-child";
        }
    }

    public static final class IsRoot
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            Element element3 = element instanceof Document ? element.child(0) : element;
            return element2 == element3;
        }

        public String toString() {
            return ":root";
        }
    }

    public static final class IsFirstChild
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            Element element3 = element2.parent();
            return element3 != null && !(element3 instanceof Document) && element2.elementSiblingIndex() == 0;
        }

        public String toString() {
            return ":first-child";
        }
    }

    public static class IsNthLastOfType
    extends CssNthEvaluator {
        public IsNthLastOfType(int n2, int n3) {
            super(n2, n3);
        }

        protected int calculatePosition(Element element, Element element2) {
            int n2 = 0;
            Elements elements = element2.parent().children();
            for (int i2 = element2.elementSiblingIndex().intValue(); i2 < elements.size(); ++i2) {
                if (elements.get(i2).tag() != element2.tag()) continue;
                ++n2;
            }
            return n2;
        }

        protected String getPseudoClass() {
            return "nth-last-of-type";
        }
    }

    public static class IsNthOfType
    extends CssNthEvaluator {
        public IsNthOfType(int n2, int n3) {
            super(n2, n3);
        }

        protected int calculatePosition(Element element, Element element2) {
            int n2 = 0;
            Elements elements = element2.parent().children();
            for (int i2 = 0; i2 < elements.size(); ++i2) {
                if (elements.get(i2).tag() == element2.tag()) {
                    ++n2;
                }
                if (elements.get(i2) == element2) break;
            }
            return n2;
        }

        protected String getPseudoClass() {
            return "nth-of-type";
        }
    }

    public static final class IsNthLastChild
    extends CssNthEvaluator {
        public IsNthLastChild(int n2, int n3) {
            super(n2, n3);
        }

        protected int calculatePosition(Element element, Element element2) {
            return element2.parent().children().size() - element2.elementSiblingIndex();
        }

        protected String getPseudoClass() {
            return "nth-last-child";
        }
    }

    public static final class IsNthChild
    extends CssNthEvaluator {
        public IsNthChild(int n2, int n3) {
            super(n2, n3);
        }

        protected int calculatePosition(Element element, Element element2) {
            return element2.elementSiblingIndex() + 1;
        }

        protected String getPseudoClass() {
            return "nth-child";
        }
    }

    public static abstract class CssNthEvaluator
    extends Evaluator {
        protected final int a;
        protected final int b;

        public CssNthEvaluator(int n2, int n3) {
            this.a = n2;
            this.b = n3;
        }

        public CssNthEvaluator(int n2) {
            this(0, n2);
        }

        public boolean matches(Element element, Element element2) {
            Element element3 = element2.parent();
            if (element3 == null || element3 instanceof Document) {
                return false;
            }
            int n2 = this.calculatePosition(element, element2);
            if (this.a == 0) {
                return n2 == this.b;
            }
            return (n2 - this.b) * this.a >= 0 && (n2 - this.b) % this.a == 0;
        }

        public String toString() {
            if (this.a == 0) {
                return String.format(":%s(%d)", this.getPseudoClass(), this.b);
            }
            if (this.b == 0) {
                return String.format(":%s(%dn)", this.getPseudoClass(), this.a);
            }
            return String.format(":%s(%dn%+d)", this.getPseudoClass(), this.a, this.b);
        }

        protected abstract String getPseudoClass();

        protected abstract int calculatePosition(Element var1, Element var2);
    }

    public static final class IsLastOfType
    extends IsNthLastOfType {
        public IsLastOfType() {
            super(0, 1);
        }

        public String toString() {
            return ":last-of-type";
        }
    }

    public static final class IsFirstOfType
    extends IsNthOfType {
        public IsFirstOfType() {
            super(0, 1);
        }

        public String toString() {
            return ":first-of-type";
        }
    }

    public static final class IsLastChild
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            Element element3 = element2.parent();
            return element3 != null && !(element3 instanceof Document) && element2.elementSiblingIndex() == element3.children().size() - 1;
        }

        public String toString() {
            return ":last-child";
        }
    }

    public static final class IndexEquals
    extends IndexEvaluator {
        public IndexEquals(int n2) {
            super(n2);
        }

        public boolean matches(Element element, Element element2) {
            return element2.elementSiblingIndex() == this.index;
        }

        public String toString() {
            return String.format(":eq(%d)", this.index);
        }
    }

    public static final class IndexGreaterThan
    extends IndexEvaluator {
        public IndexGreaterThan(int n2) {
            super(n2);
        }

        public boolean matches(Element element, Element element2) {
            return element2.elementSiblingIndex() > this.index;
        }

        public String toString() {
            return String.format(":gt(%d)", this.index);
        }
    }

    public static final class IndexLessThan
    extends IndexEvaluator {
        public IndexLessThan(int n2) {
            super(n2);
        }

        public boolean matches(Element element, Element element2) {
            return element2.elementSiblingIndex() < this.index;
        }

        public String toString() {
            return String.format(":lt(%d)", this.index);
        }
    }

    public static final class AllElements
    extends Evaluator {
        public boolean matches(Element element, Element element2) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }

    public static abstract class AttributeKeyPair
    extends Evaluator {
        String key;
        String value;

        public AttributeKeyPair(String string, String string2) {
            Validate.notEmpty(string);
            Validate.notEmpty(string2);
            this.key = string.trim().toLowerCase();
            this.value = string2.trim().toLowerCase();
        }
    }

    public static final class AttributeWithValueMatching
    extends Evaluator {
        String key;
        Pattern pattern;

        public AttributeWithValueMatching(String string, Pattern pattern) {
            this.key = string.trim().toLowerCase();
            this.pattern = pattern;
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasAttr(this.key) && this.pattern.matcher(element2.attr(this.key)).find();
        }

        public String toString() {
            return String.format("[%s~=%s]", this.key, this.pattern.toString());
        }
    }

    public static final class AttributeWithValueContaining
    extends AttributeKeyPair {
        public AttributeWithValueContaining(String string, String string2) {
            super(string, string2);
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasAttr(this.key) && element2.attr(this.key).toLowerCase().contains(this.value);
        }

        public String toString() {
            return String.format("[%s*=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValueEnding
    extends AttributeKeyPair {
        public AttributeWithValueEnding(String string, String string2) {
            super(string, string2);
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasAttr(this.key) && element2.attr(this.key).toLowerCase().endsWith(this.value);
        }

        public String toString() {
            return String.format("[%s$=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValueStarting
    extends AttributeKeyPair {
        public AttributeWithValueStarting(String string, String string2) {
            super(string, string2);
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasAttr(this.key) && element2.attr(this.key).toLowerCase().startsWith(this.value);
        }

        public String toString() {
            return String.format("[%s^=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValueNot
    extends AttributeKeyPair {
        public AttributeWithValueNot(String string, String string2) {
            super(string, string2);
        }

        public boolean matches(Element element, Element element2) {
            return !this.value.equalsIgnoreCase(element2.attr(this.key));
        }

        public String toString() {
            return String.format("[%s!=%s]", this.key, this.value);
        }
    }

    public static final class AttributeWithValue
    extends AttributeKeyPair {
        public AttributeWithValue(String string, String string2) {
            super(string, string2);
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasAttr(this.key) && this.value.equalsIgnoreCase(element2.attr(this.key));
        }

        public String toString() {
            return String.format("[%s=%s]", this.key, this.value);
        }
    }

    public static final class AttributeStarting
    extends Evaluator {
        private String keyPrefix;

        public AttributeStarting(String string) {
            this.keyPrefix = string;
        }

        public boolean matches(Element element, Element element2) {
            List<com.contrastsecurity.thirdparty.org.jsoup.nodes.Attribute> list = element2.attributes().asList();
            for (com.contrastsecurity.thirdparty.org.jsoup.nodes.Attribute attribute : list) {
                if (!attribute.getKey().startsWith(this.keyPrefix)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format("[^%s]", this.keyPrefix);
        }
    }

    public static final class Attribute
    extends Evaluator {
        private String key;

        public Attribute(String string) {
            this.key = string;
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasAttr(this.key);
        }

        public String toString() {
            return String.format("[%s]", this.key);
        }
    }

    public static final class Class
    extends Evaluator {
        private String className;

        public Class(String string) {
            this.className = string;
        }

        public boolean matches(Element element, Element element2) {
            return element2.hasClass(this.className);
        }

        public String toString() {
            return String.format(".%s", this.className);
        }
    }

    public static final class Id
    extends Evaluator {
        private String id;

        public Id(String string) {
            this.id = string;
        }

        public boolean matches(Element element, Element element2) {
            return this.id.equals(element2.id());
        }

        public String toString() {
            return String.format("#%s", this.id);
        }
    }

    public static final class Tag
    extends Evaluator {
        private String tagName;

        public Tag(String string) {
            this.tagName = string;
        }

        public boolean matches(Element element, Element element2) {
            return element2.tagName().equals(this.tagName);
        }

        public String toString() {
            return String.format("%s", this.tagName);
        }
    }
}

