/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.asm.commons;

import com.contrastsecurity.thirdparty.org.mvel2.asm.ClassVisitor;
import com.contrastsecurity.thirdparty.org.mvel2.asm.FieldVisitor;
import com.contrastsecurity.thirdparty.org.mvel2.asm.MethodVisitor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialVersionUIDAdder
extends ClassVisitor {
    private boolean computeSVUID;
    private boolean hasSVUID;
    private int access;
    private String name;
    private String[] interfaces;
    private Collection<Item> svuidFields = new ArrayList<Item>();
    private boolean hasStaticInitializer;
    private Collection<Item> svuidConstructors = new ArrayList<Item>();
    private Collection<Item> svuidMethods = new ArrayList<Item>();

    public SerialVersionUIDAdder(ClassVisitor classVisitor) {
        this(327680, classVisitor);
        if (this.getClass() != SerialVersionUIDAdder.class) {
            throw new IllegalStateException();
        }
    }

    protected SerialVersionUIDAdder(int n2, ClassVisitor classVisitor) {
        super(n2, classVisitor);
    }

    @Override
    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        boolean bl = this.computeSVUID = (n3 & 0x200) == 0;
        if (this.computeSVUID) {
            this.name = string;
            this.access = n3;
            this.interfaces = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this.interfaces, 0, stringArray.length);
        }
        super.visit(n2, n3, string, string2, string3, stringArray);
    }

    @Override
    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        if (this.computeSVUID) {
            if ("<clinit>".equals(string)) {
                this.hasStaticInitializer = true;
            }
            int n3 = n2 & 0xD3F;
            if ((n2 & 2) == 0) {
                if ("<init>".equals(string)) {
                    this.svuidConstructors.add(new Item(string, n3, string2));
                } else if (!"<clinit>".equals(string)) {
                    this.svuidMethods.add(new Item(string, n3, string2));
                }
            }
        }
        return super.visitMethod(n2, string, string2, string3, stringArray);
    }

    @Override
    public FieldVisitor visitField(int n2, String string, String string2, String string3, Object object) {
        if (this.computeSVUID) {
            if ("serialVersionUID".equals(string)) {
                this.computeSVUID = false;
                this.hasSVUID = true;
            }
            if ((n2 & 2) == 0 || (n2 & 0x88) == 0) {
                int n3 = n2 & 0xDF;
                this.svuidFields.add(new Item(string, n3, string2));
            }
        }
        return super.visitField(n2, string, string2, string3, object);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n2) {
        if (this.name != null && this.name.equals(string)) {
            this.access = n2;
        }
        super.visitInnerClass(string, string2, string3, n2);
    }

    @Override
    public void visitEnd() {
        if (this.computeSVUID && !this.hasSVUID) {
            try {
                this.addSVUID(this.computeSVUID());
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Error while computing SVUID for " + this.name, throwable);
            }
        }
        super.visitEnd();
    }

    public boolean hasSVUID() {
        return this.hasSVUID;
    }

    protected void addSVUID(long l2) {
        FieldVisitor fieldVisitor = super.visitField(24, "serialVersionUID", "J", null, new Long(l2));
        if (fieldVisitor != null) {
            fieldVisitor.visitEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long computeSVUID() throws IOException {
        DataOutputStream dataOutputStream = null;
        long l2 = 0L;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(this.name.replace('/', '.'));
            dataOutputStream.writeInt(this.access & 0x611);
            Arrays.sort(this.interfaces);
            for (int i2 = 0; i2 < this.interfaces.length; ++i2) {
                dataOutputStream.writeUTF(this.interfaces[i2].replace('/', '.'));
            }
            SerialVersionUIDAdder.writeItems(this.svuidFields, dataOutputStream, false);
            if (this.hasStaticInitializer) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            SerialVersionUIDAdder.writeItems(this.svuidConstructors, dataOutputStream, true);
            SerialVersionUIDAdder.writeItems(this.svuidMethods, dataOutputStream, true);
            dataOutputStream.flush();
            byte[] byArray = this.computeSHAdigest(byteArrayOutputStream.toByteArray());
            for (int i3 = Math.min(byArray.length, 8) - 1; i3 >= 0; --i3) {
                l2 = l2 << 8 | (long)(byArray[i3] & 0xFF);
            }
            Object var8_7 = null;
            if (dataOutputStream == null) return l2;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (dataOutputStream == null) throw throwable;
            dataOutputStream.close();
            throw throwable;
        }
        dataOutputStream.close();
        return l2;
    }

    protected byte[] computeSHAdigest(byte[] byArray) {
        try {
            return MessageDigest.getInstance("SHA").digest(byArray);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException(exception.toString());
        }
    }

    private static void writeItems(Collection<Item> collection, DataOutput dataOutput, boolean bl) throws IOException {
        int n2 = collection.size();
        Object[] objectArray = collection.toArray(new Item[n2]);
        Arrays.sort(objectArray);
        for (int i2 = 0; i2 < n2; ++i2) {
            dataOutput.writeUTF(((Item)objectArray[i2]).name);
            dataOutput.writeInt(((Item)objectArray[i2]).access);
            dataOutput.writeUTF(bl ? ((Item)objectArray[i2]).desc.replace('/', '.') : ((Item)objectArray[i2]).desc);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Item
    implements Comparable<Item> {
        final String name;
        final int access;
        final String desc;

        Item(String string, int n2, String string2) {
            this.name = string;
            this.access = n2;
            this.desc = string2;
        }

        @Override
        public int compareTo(Item item) {
            int n2 = this.name.compareTo(item.name);
            if (n2 == 0) {
                n2 = this.desc.compareTo(item.desc);
            }
            return n2;
        }

        public boolean equals(Object object) {
            if (object instanceof Item) {
                return this.compareTo((Item)object) == 0;
            }
            return false;
        }

        public int hashCode() {
            return (this.name + this.desc).hashCode();
        }
    }
}

