/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.ast;

import com.contrastsecurity.thirdparty.org.mvel2.CompileException;
import com.contrastsecurity.thirdparty.org.mvel2.DataConversion;
import com.contrastsecurity.thirdparty.org.mvel2.Operator;
import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.ScriptRuntimeException;
import com.contrastsecurity.thirdparty.org.mvel2.ast.ASTNode;
import com.contrastsecurity.thirdparty.org.mvel2.ast.BooleanNode;
import com.contrastsecurity.thirdparty.org.mvel2.ast.LiteralNode;
import com.contrastsecurity.thirdparty.org.mvel2.debug.DebugTools;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.math.MathProcessor;
import com.contrastsecurity.thirdparty.org.mvel2.util.CompatibilityStrategy;
import com.contrastsecurity.thirdparty.org.mvel2.util.CompilerTools;
import com.contrastsecurity.thirdparty.org.mvel2.util.NullType;
import com.contrastsecurity.thirdparty.org.mvel2.util.ParseTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryOperation
extends BooleanNode {
    private final int operation;
    private int lType = -1;
    private int rType = -1;

    public BinaryOperation(int n2, ParserContext parserContext) {
        super(parserContext);
        this.operation = n2;
    }

    public BinaryOperation(int n2, ASTNode aSTNode, ASTNode aSTNode2, ParserContext parserContext) {
        super(parserContext);
        this.operation = n2;
        this.left = aSTNode;
        if (this.left == null) {
            throw new ScriptRuntimeException("not a statement");
        }
        this.right = aSTNode2;
        if (this.right == null) {
            throw new ScriptRuntimeException("not a statement");
        }
        switch (n2) {
            case 0: {
                if (aSTNode.getEgressType() != String.class && aSTNode2.getEgressType() != String.class) break;
                this.egressType = String.class;
                this.lType = ParseTools.__resolveType(aSTNode.egressType);
                this.rType = ParseTools.__resolveType(aSTNode2.egressType);
                return;
            }
        }
        this.egressType = CompilerTools.getReturnTypeFromOp(n2, this.left.egressType, this.right.egressType);
        if (parserContext.isStrongTyping() && !aSTNode.getEgressType().isAssignableFrom(aSTNode2.getEgressType()) && !aSTNode2.getEgressType().isAssignableFrom(aSTNode.getEgressType())) {
            if (aSTNode2.isLiteral() && DataConversion.canConvert(aSTNode.getEgressType(), aSTNode2.getEgressType())) {
                Class clazz = this.isAritmeticOperation(n2) ? this.egressType : aSTNode.getEgressType();
                this.right = new LiteralNode(DataConversion.convert(aSTNode2.getReducedValueAccelerated(null, null, null), clazz), this.pCtx);
            } else if (!this.areCompatible(aSTNode.getEgressType(), aSTNode2.getEgressType()) && (n2 != 18 && n2 != 19 || !CompatibilityStrategy.areEqualityCompatible(aSTNode.getEgressType(), aSTNode2.getEgressType()))) {
                throw new CompileException("incompatible types in statement: " + aSTNode2.getEgressType() + " (compared from: " + aSTNode.getEgressType() + ")", aSTNode.getExpr() != null ? aSTNode.getExpr() : aSTNode2.getExpr(), aSTNode.getExpr() != null ? aSTNode.getStart() : aSTNode2.getStart());
            }
        }
        if (this.left.isLiteral() && this.right.isLiteral()) {
            if (this.left.egressType == this.right.egressType) {
                this.lType = this.rType = ParseTools.__resolveType(aSTNode.egressType);
            } else {
                this.lType = ParseTools.__resolveType(this.left.egressType);
                this.rType = ParseTools.__resolveType(this.right.egressType);
            }
        }
    }

    private boolean isAritmeticOperation(int n2) {
        return n2 <= 5;
    }

    private boolean areCompatible(Class<?> clazz, Class<?> clazz2) {
        return clazz.equals(NullType.class) || clazz2.equals(NullType.class) || Number.class.isAssignableFrom(clazz2) && Number.class.isAssignableFrom(clazz) || (clazz2.isPrimitive() || clazz.isPrimitive()) && DataConversion.canConvert(ParseTools.boxPrimitive(clazz), ParseTools.boxPrimitive(clazz2));
    }

    @Override
    public Object getReducedValueAccelerated(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        return MathProcessor.doOperations(this.lType, this.left.getReducedValueAccelerated(object, object2, variableResolverFactory), this.operation, this.rType, this.right.getReducedValueAccelerated(object, object2, variableResolverFactory));
    }

    @Override
    public Object getReducedValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        throw new RuntimeException("unsupported AST operation");
    }

    public int getOperation() {
        return this.operation;
    }

    public BinaryOperation getRightBinary() {
        return this.right != null && this.right instanceof BinaryOperation ? (BinaryOperation)this.right : null;
    }

    @Override
    public void setRightMost(ASTNode aSTNode) {
        BinaryOperation binaryOperation = this;
        while (binaryOperation.right != null && binaryOperation.right instanceof BinaryOperation) {
            binaryOperation = (BinaryOperation)binaryOperation.right;
        }
        binaryOperation.right = aSTNode;
        if (binaryOperation == this && (this.rType = ParseTools.__resolveType(binaryOperation.right.getEgressType())) == 0) {
            this.rType = -1;
        }
    }

    @Override
    public ASTNode getRightMost() {
        BinaryOperation binaryOperation = this;
        while (binaryOperation.right != null && binaryOperation.right instanceof BinaryOperation) {
            binaryOperation = (BinaryOperation)binaryOperation.right;
        }
        return binaryOperation.right;
    }

    public int getPrecedence() {
        return Operator.PTABLE[this.operation];
    }

    public boolean isGreaterPrecedence(BinaryOperation binaryOperation) {
        return binaryOperation.getPrecedence() > Operator.PTABLE[this.operation];
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public String toString() {
        return "(" + this.left + " " + DebugTools.getOperatorSymbol(this.operation) + " " + this.right + ")";
    }
}

