/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.ast;

import com.contrastsecurity.thirdparty.org.mvel2.CompileException;
import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.ast.ASTNode;
import com.contrastsecurity.thirdparty.org.mvel2.ast.PrototypalFunctionInstance;
import com.contrastsecurity.thirdparty.org.mvel2.ast.Safe;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExecutableStatement;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.ExpressionCompiler;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolver;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.integration.impl.DefaultLocalVariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.integration.impl.FunctionVariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.integration.impl.MapVariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.integration.impl.StackDemarcResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.util.ParseTools;
import java.util.Map;

public class Function
extends ASTNode
implements Safe {
    protected String name;
    protected ExecutableStatement compiledBlock;
    protected String[] parameters;
    protected int parmNum;
    protected boolean compiledMode = false;
    protected boolean singleton;

    public Function(String string, char[] cArray, int n2, int n3, int n4, int n5, int n6, ParserContext parserContext) {
        super(parserContext);
        this.name = string;
        if (this.name == null || string.length() == 0) {
            this.name = null;
        }
        this.expr = cArray;
        this.parameters = ParseTools.parseParameterDefList(cArray, n2, n3);
        this.parmNum = this.parameters.length;
        ParserContext parserContext2 = new ParserContext(parserContext.getParserConfiguration(), parserContext, true);
        if (!parserContext.isFunctionContext()) {
            this.singleton = true;
            parserContext.declareFunction(this);
        } else {
            parserContext2.declareFunction(this);
        }
        for (String string2 : this.parameters) {
            parserContext2.addVariable(string2, Object.class);
            parserContext2.addIndexedInput(string2);
        }
        parserContext2.setIndexAllocation(false);
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(cArray, n4, n5, parserContext2);
        expressionCompiler.setVerifyOnly(true);
        expressionCompiler.compile();
        parserContext2.setIndexAllocation(true);
        if (parserContext.getVariables() != null) {
            for (Map.Entry<String, Class> entry : parserContext.getVariables().entrySet()) {
                parserContext2.getVariables().remove(entry.getKey());
                parserContext2.addInput(entry.getKey(), entry.getValue());
            }
            parserContext2.processTables();
        }
        parserContext2.addIndexedInputs(parserContext2.getVariables().keySet());
        parserContext2.getVariables().clear();
        this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(cArray, n4, n5, parserContext2);
        this.parameters = new String[parserContext2.getIndexedInputs().size()];
        int n7 = 0;
        for (String string2 : parserContext2.getIndexedInputs()) {
            this.parameters[n7++] = string2;
        }
        this.compiledMode = (n6 & 0x10) != 0;
        this.egressType = this.compiledBlock.getKnownEgressType();
        parserContext.addVariable(string, Function.class);
    }

    public Object getReducedValueAccelerated(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        PrototypalFunctionInstance prototypalFunctionInstance = new PrototypalFunctionInstance(this, new MapVariableResolverFactory());
        if (this.name != null) {
            if (!variableResolverFactory.isIndexedFactory() && variableResolverFactory.isResolveable(this.name)) {
                throw new CompileException("duplicate function: " + this.name, this.expr, this.start);
            }
            variableResolverFactory.createVariable(this.name, prototypalFunctionInstance);
        }
        return prototypalFunctionInstance;
    }

    public Object getReducedValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        PrototypalFunctionInstance prototypalFunctionInstance = new PrototypalFunctionInstance(this, new MapVariableResolverFactory());
        if (this.name != null) {
            if (!variableResolverFactory.isIndexedFactory() && variableResolverFactory.isResolveable(this.name)) {
                throw new CompileException("duplicate function: " + this.name, this.expr, this.start);
            }
            variableResolverFactory.createVariable(this.name, prototypalFunctionInstance);
        }
        return prototypalFunctionInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(Object object, Object object2, VariableResolverFactory variableResolverFactory, Object[] objectArray) {
        if (objectArray != null && objectArray.length != 0) {
            FunctionVariableResolverFactory functionVariableResolverFactory;
            if (variableResolverFactory instanceof FunctionVariableResolverFactory && ((FunctionVariableResolverFactory)variableResolverFactory).getIndexedVariableResolvers().length == objectArray.length && (functionVariableResolverFactory = (FunctionVariableResolverFactory)variableResolverFactory).getFunction().equals(this)) {
                VariableResolver[] variableResolverArray = functionVariableResolverFactory.getIndexedVariableResolvers();
                functionVariableResolverFactory.updateParameters(objectArray);
                try {
                    Object object3 = this.compiledBlock.getValue(object, object2, functionVariableResolverFactory);
                    return object3;
                }
                finally {
                    functionVariableResolverFactory.setIndexedVariableResolvers(variableResolverArray);
                }
            }
            return this.compiledBlock.getValue(object2, new StackDemarcResolverFactory(new FunctionVariableResolverFactory(this, variableResolverFactory, this.parameters, objectArray)));
        }
        if (this.compiledMode) {
            return this.compiledBlock.getValue(object2, new StackDemarcResolverFactory(new DefaultLocalVariableResolverFactory(variableResolverFactory, this.parameters)));
        }
        return this.compiledBlock.getValue(object2, new StackDemarcResolverFactory(new DefaultLocalVariableResolverFactory(variableResolverFactory, this.parameters)));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.length != 0;
    }

    public void checkArgumentCount(int n2) {
        if (n2 != this.parmNum) {
            throw new CompileException("bad number of arguments in function call: " + n2 + " (expected: " + (this.parmNum == 0 ? "none" : Integer.valueOf(this.parmNum)) + ")", this.expr, this.start);
        }
    }

    public ExecutableStatement getCompiledBlock() {
        return this.compiledBlock;
    }

    public String toString() {
        return "FunctionDef:" + (this.name == null ? "Anonymous" : this.name);
    }
}

