/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.ast;

import com.contrastsecurity.thirdparty.org.mvel2.CompileException;
import com.contrastsecurity.thirdparty.org.mvel2.MVEL;
import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.ast.ASTNode;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.integration.impl.ImmutableDefaultFactory;
import com.contrastsecurity.thirdparty.org.mvel2.integration.impl.StackResetResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.util.ParseTools;

public class ImportNode
extends ASTNode {
    private Class importClass;
    private boolean packageImport;
    private int _offset;
    private static final char[] WC_TEST = new char[]{'.', '*'};

    public ImportNode(char[] cArray, int n2, int n3, ParserContext parserContext) {
        super(parserContext);
        this.expr = cArray;
        this.start = n2;
        this.offset = n3;
        this.pCtx = parserContext;
        if (ParseTools.endsWith(cArray, n2, n3, WC_TEST)) {
            this.packageImport = true;
            this._offset = (short)ParseTools.findLast(cArray, n2, n3, '.');
            if (this._offset == -1) {
                this._offset = 0;
            }
        } else {
            String string = new String(cArray, n2, n3);
            ClassLoader classLoader = this.getClassLoader();
            try {
                this.importClass = Class.forName(string, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                int n4 = string.lastIndexOf(46);
                string = (string.substring(0, n4) + "$" + string.substring(n4 + 1)).trim();
                try {
                    this.importClass = Class.forName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    throw new CompileException("class not found: " + new String(cArray), cArray, n2);
                }
            }
        }
    }

    public Object getReducedValueAccelerated(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        if (!this.packageImport) {
            if (MVEL.COMPILER_OPT_ALLOCATE_TYPE_LITERALS_TO_SHARED_SYMBOL_TABLE) {
                variableResolverFactory.createVariable(this.importClass.getSimpleName(), this.importClass);
                return this.importClass;
            }
            return ParseTools.findClassImportResolverFactory(variableResolverFactory, this.pCtx).addClass(this.importClass);
        }
        if (!(variableResolverFactory instanceof ImmutableDefaultFactory || variableResolverFactory instanceof StackResetResolverFactory && ((StackResetResolverFactory)variableResolverFactory).getDelegate() instanceof ImmutableDefaultFactory)) {
            ParseTools.findClassImportResolverFactory(variableResolverFactory, this.pCtx).addPackageImport(new String(this.expr, this.start, this._offset - this.start));
        }
        return null;
    }

    public Object getReducedValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        return this.getReducedValueAccelerated(object, object2, variableResolverFactory);
    }

    public Class getImportClass() {
        return this.importClass;
    }

    public boolean isPackageImport() {
        return this.packageImport;
    }

    public void setPackageImport(boolean bl) {
        this.packageImport = bl;
    }

    public String getPackageImport() {
        return new String(this.expr, this.start, this._offset - this.start);
    }
}

