/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.ast;

import com.contrastsecurity.thirdparty.org.mvel2.CompileException;
import com.contrastsecurity.thirdparty.org.mvel2.ParserContext;
import com.contrastsecurity.thirdparty.org.mvel2.ast.ASTNode;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.util.ArrayTools;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class StaticImportNode
extends ASTNode {
    private Class declaringClass;
    private String methodName;
    private transient Method method;

    public StaticImportNode(char[] cArray, int n2, int n3, ParserContext parserContext) {
        super(parserContext);
        try {
            this.expr = cArray;
            this.start = n2;
            this.offset = n3;
            ClassLoader classLoader = this.getClassLoader();
            this.expr = cArray;
            int n4 = ArrayTools.findLast('.', n2, n3, cArray);
            this.declaringClass = Class.forName(new String(cArray, n2, n4 - n2), true, classLoader);
            this.methodName = new String(cArray, ++n4, n3 - (n4 - n2));
            if (this.resolveMethod() == null) {
                throw new CompileException("can not find method for static import: " + this.declaringClass.getName() + "." + this.methodName, cArray, n2);
            }
        }
        catch (Exception exception) {
            throw new CompileException("unable to import class", cArray, n2, exception);
        }
    }

    private Method resolveMethod() {
        for (Method method : this.declaringClass.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !this.methodName.equals(method.getName())) continue;
            this.method = method;
            return this.method;
        }
        return null;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getReducedValueAccelerated(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        variableResolverFactory.createVariable(this.methodName, this.method == null ? (this.method = this.resolveMethod()) : this.method);
        return null;
    }

    public Object getReducedValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        return this.getReducedValueAccelerated(object, object2, variableResolverFactory);
    }
}

