/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.conversion;

import com.contrastsecurity.thirdparty.org.mvel2.ConversionException;
import com.contrastsecurity.thirdparty.org.mvel2.ConversionHandler;
import com.contrastsecurity.thirdparty.org.mvel2.conversion.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class FloatCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();
    private static Converter stringConverter = new Converter(){

        public Object convert(Object object) {
            if (((String)object).length() == 0) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf(Float.parseFloat((String)object));
        }
    };

    public Object convertFrom(Object object) {
        if (!CNV.containsKey(object.getClass())) {
            throw new ConversionException("cannot convert type: " + object.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(object.getClass()).convert(object);
    }

    public boolean canConvertFrom(Class clazz) {
        return CNV.containsKey(clazz);
    }

    static {
        CNV.put(String.class, stringConverter);
        CNV.put(Object.class, new Converter(){

            public Object convert(Object object) {
                return stringConverter.convert(String.valueOf(object));
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public Float convert(Object object) {
                return Float.valueOf(((BigDecimal)object).floatValue());
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            public Float convert(Object object) {
                return Float.valueOf(((BigInteger)object).floatValue());
            }
        });
        CNV.put(Float.class, new Converter(){

            public Object convert(Object object) {
                return object;
            }
        });
        CNV.put(Integer.class, new Converter(){

            public Float convert(Object object) {
                return Float.valueOf(((Integer)object).floatValue());
            }
        });
        CNV.put(Double.class, new Converter(){

            public Float convert(Object object) {
                return Float.valueOf(((Double)object).floatValue());
            }
        });
        CNV.put(Long.class, new Converter(){

            public Float convert(Object object) {
                return Float.valueOf(((Long)object).floatValue());
            }
        });
        CNV.put(Short.class, new Converter(){

            public Float convert(Object object) {
                return Float.valueOf(((Short)object).floatValue());
            }
        });
        CNV.put(Boolean.class, new Converter(){

            public Float convert(Object object) {
                if (((Boolean)object).booleanValue()) {
                    return Float.valueOf(1.0f);
                }
                return Float.valueOf(0.0f);
            }
        });
    }
}

