/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.integration.impl;

import com.contrastsecurity.thirdparty.org.mvel2.UnresolveablePropertyException;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolver;
import com.contrastsecurity.thirdparty.org.mvel2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.integration.impl.BaseVariableResolverFactory;
import com.contrastsecurity.thirdparty.org.mvel2.integration.impl.MapVariableResolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapVariableResolverFactory
extends BaseVariableResolverFactory {
    protected Map<String, Object> variables;

    public MapVariableResolverFactory() {
        this.variables = new HashMap<String, Object>();
    }

    public MapVariableResolverFactory(Map map) {
        this.variables = map;
    }

    public MapVariableResolverFactory(Map<String, Object> map, VariableResolverFactory variableResolverFactory) {
        this.variables = map;
        this.nextFactory = variableResolverFactory;
    }

    public MapVariableResolverFactory(Map<String, Object> map, boolean bl) {
        this.variables = map;
    }

    @Override
    public VariableResolver createVariable(String string, Object object) {
        try {
            VariableResolver variableResolver = this.getVariableResolver(string);
            variableResolver.setValue(object);
            return variableResolver;
        }
        catch (UnresolveablePropertyException unresolveablePropertyException) {
            MapVariableResolver mapVariableResolver = new MapVariableResolver(this.variables, string);
            this.addResolver(string, mapVariableResolver).setValue(object);
            return mapVariableResolver;
        }
    }

    @Override
    public VariableResolver createVariable(String string, Object object, Class<?> clazz) {
        VariableResolver variableResolver;
        try {
            variableResolver = this.getVariableResolver(string);
        }
        catch (UnresolveablePropertyException unresolveablePropertyException) {
            variableResolver = null;
        }
        if (variableResolver != null && variableResolver.getType() != null) {
            throw new RuntimeException("variable already defined within scope: " + variableResolver.getType() + " " + string);
        }
        variableResolver = new MapVariableResolver(this.variables, string, clazz);
        this.addResolver(string, variableResolver).setValue(object);
        return variableResolver;
    }

    @Override
    public VariableResolver getVariableResolver(String string) {
        VariableResolver variableResolver = (VariableResolver)this.variableResolvers.get(string);
        if (variableResolver != null) {
            return variableResolver;
        }
        if (this.variables.containsKey(string)) {
            variableResolver = new MapVariableResolver(this.variables, string);
            this.variableResolvers.put(string, variableResolver);
            return variableResolver;
        }
        if (this.nextFactory != null) {
            return this.nextFactory.getVariableResolver(string);
        }
        throw new UnresolveablePropertyException("unable to resolve variable '" + string + "'");
    }

    @Override
    public boolean isResolveable(String string) {
        return this.variableResolvers.containsKey(string) || this.variables != null && this.variables.containsKey(string) || this.nextFactory != null && this.nextFactory.isResolveable(string);
    }

    protected VariableResolver addResolver(String string, VariableResolver variableResolver) {
        this.variableResolvers.put(string, variableResolver);
        return variableResolver;
    }

    @Override
    public boolean isTarget(String string) {
        return this.variableResolvers.containsKey(string);
    }

    @Override
    public Set<String> getKnownVariables() {
        if (this.nextFactory == null) {
            if (this.variables != null) {
                return new HashSet<String>(this.variables.keySet());
            }
            return new HashSet<String>(0);
        }
        if (this.variables != null) {
            return new HashSet<String>(this.variables.keySet());
        }
        return new HashSet<String>(0);
    }

    public void clear() {
        this.variableResolvers.clear();
        this.variables.clear();
    }
}

