/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.math;

import com.contrastsecurity.thirdparty.org.mvel2.DataConversion;
import com.contrastsecurity.thirdparty.org.mvel2.Unit;
import com.contrastsecurity.thirdparty.org.mvel2.compiler.BlankLiteral;
import com.contrastsecurity.thirdparty.org.mvel2.debug.DebugTools;
import com.contrastsecurity.thirdparty.org.mvel2.util.InternalNumber;
import com.contrastsecurity.thirdparty.org.mvel2.util.ParseTools;
import com.contrastsecurity.thirdparty.org.mvel2.util.Soundex;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;

public strictfp class MathProcessor {
    private static final MathContext MATH_CONTEXT = MathContext.DECIMAL128;

    public static Object doOperations(Object object, int n2, Object object2) {
        return MathProcessor.doOperations(object == null ? 0 : ParseTools.__resolveType(object.getClass()), object, n2, object2 == null ? -1 : ParseTools.__resolveType(object2.getClass()), object2);
    }

    public static Object doOperations(Object object, int n2, int n3, Object object2) {
        return MathProcessor.doOperations(object == null ? 0 : ParseTools.__resolveType(object.getClass()), object, n2, n3, object2);
    }

    public static Object doOperations(int n2, Object object, int n3, int n4, Object object2) {
        if (n2 == -1) {
            int n5 = n2 = object == null ? 0 : ParseTools.__resolveType(object.getClass());
        }
        if (n4 == -1) {
            n4 = object2 == null ? 0 : ParseTools.__resolveType(object2.getClass());
        }
        switch (n2) {
            case 110: {
                switch (n4) {
                    case 110: {
                        return MathProcessor.doBigDecimalArithmetic((BigDecimal)object, n3, (BigDecimal)object2, false, -1);
                    }
                }
                if (n4 > 99) {
                    return MathProcessor.doBigDecimalArithmetic((BigDecimal)object, n3, MathProcessor.getInternalNumberFromType(object2, n4), false, -1);
                }
                return MathProcessor._doOperations(n2, object, n3, n4, object2);
            }
        }
        return MathProcessor._doOperations(n2, object, n3, n4, object2);
    }

    private static Object doPrimWrapperArithmetic(Number number, int n2, Number number2, boolean bl, int n3) {
        switch (n2) {
            case 0: {
                return MathProcessor.toType(number.doubleValue() + number2.doubleValue(), n3);
            }
            case 3: {
                return MathProcessor.toType(number.doubleValue() / number2.doubleValue(), n3);
            }
            case 1: {
                return MathProcessor.toType(number.doubleValue() - number2.doubleValue(), n3);
            }
            case 2: {
                return MathProcessor.toType(number.doubleValue() * number2.doubleValue(), n3);
            }
            case 5: {
                return MathProcessor.toType(Math.pow(number.doubleValue(), number2.doubleValue()), n3);
            }
            case 4: {
                return MathProcessor.toType(number.doubleValue() % number2.doubleValue(), n3);
            }
            case 15: {
                return number.doubleValue() > number2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return number.doubleValue() >= number2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return number.doubleValue() < number2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return number.doubleValue() <= number2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 18: {
                return number.doubleValue() == number2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 19: {
                return number.doubleValue() != number2.doubleValue() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    private static Object toType(Number number, int n2) {
        switch (n2) {
            case 103: 
            case 109: {
                return number.doubleValue();
            }
            case 104: 
            case 108: {
                return Float.valueOf(number.floatValue());
            }
            case 101: 
            case 106: {
                return number.intValue();
            }
            case 102: 
            case 107: {
                return number.longValue();
            }
            case 100: 
            case 105: {
                return number.shortValue();
            }
            case 110: {
                return new BigDecimal(number.doubleValue());
            }
            case 111: {
                return BigInteger.valueOf(number.longValue());
            }
            case 1: {
                return number.doubleValue();
            }
        }
        throw new RuntimeException("internal error: " + n2);
    }

    private static Object doBigDecimalArithmetic(BigDecimal bigDecimal, int n2, BigDecimal bigDecimal2, boolean bl, int n3) {
        switch (n2) {
            case 0: {
                if (bl) {
                    return ParseTools.narrowType(bigDecimal.add(bigDecimal2, MATH_CONTEXT), n3);
                }
                return bigDecimal.add(bigDecimal2, MATH_CONTEXT);
            }
            case 3: {
                if (bl) {
                    return ParseTools.narrowType(bigDecimal.divide(bigDecimal2, MATH_CONTEXT), n3);
                }
                return bigDecimal.divide(bigDecimal2, MATH_CONTEXT);
            }
            case 1: {
                if (bl) {
                    return ParseTools.narrowType(bigDecimal.subtract(bigDecimal2, MATH_CONTEXT), n3);
                }
                return bigDecimal.subtract(bigDecimal2, MATH_CONTEXT);
            }
            case 2: {
                if (bl) {
                    return ParseTools.narrowType(bigDecimal.multiply(bigDecimal2, MATH_CONTEXT), n3);
                }
                return bigDecimal.multiply(bigDecimal2, MATH_CONTEXT);
            }
            case 5: {
                if (bl) {
                    return ParseTools.narrowType(bigDecimal.pow(bigDecimal2.intValue(), MATH_CONTEXT), n3);
                }
                return bigDecimal.pow(bigDecimal2.intValue(), MATH_CONTEXT);
            }
            case 4: {
                if (bl) {
                    return ParseTools.narrowType(bigDecimal.remainder(bigDecimal2), n3);
                }
                return bigDecimal.remainder(bigDecimal2);
            }
            case 15: {
                return bigDecimal.compareTo(bigDecimal2) == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return bigDecimal.compareTo(bigDecimal2) >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return bigDecimal.compareTo(bigDecimal2) == -1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return bigDecimal.compareTo(bigDecimal2) <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 18: {
                return bigDecimal.compareTo(bigDecimal2) == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 19: {
                return bigDecimal.compareTo(bigDecimal2) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    private static Object _doOperations(int n2, Object object, int n3, int n4, Object object2) {
        if (n3 < 20) {
            if ((n2 > 49 || n3 == 18 || n3 == 19) && n2 == n4 || MathProcessor.isIntegerType(n2) && MathProcessor.isIntegerType(n4) && n3 >= 6 && n3 <= 13) {
                return MathProcessor.doOperationsSameType(n2, object, n3, object2);
            }
            if (MathProcessor.isNumericOperation(n2, object, n3, n4, object2)) {
                return MathProcessor.doPrimWrapperArithmetic(MathProcessor.getNumber(object, n2), n3, MathProcessor.getNumber(object2, n4), true, MathProcessor.box(n4) > MathProcessor.box(n2) ? MathProcessor.box(n4) : MathProcessor.box(n2));
            }
            if (n3 != 0 && (n2 == 15 || n4 == 15) && n2 != n4 && n2 != 200 && n4 != 200) {
                return MathProcessor.doOperationNonNumeric(n2, DataConversion.convert(object, Boolean.class), n3, DataConversion.convert(object2, Boolean.class));
            }
            if (!(n2 != 1 && n4 != 1 || n2 != 8 && n2 != 112 && n4 != 8 && n4 != 112)) {
                if (n2 == 1) {
                    return MathProcessor.doOperationNonNumeric(n2, object, n3, String.valueOf(object2));
                }
                return MathProcessor.doOperationNonNumeric(n2, String.valueOf(object), n3, object2);
            }
        }
        return MathProcessor.doOperationNonNumeric(n2, object, n3, object2);
    }

    private static boolean isNumericOperation(int n2, Object object, int n3, int n4, Object object2) {
        return n2 > 99 && n4 > 99 || n3 != 0 && (n2 > 99 || n4 > 99 || n3 < 14 || n3 > 17) && ParseTools.isNumber(object) && ParseTools.isNumber(object2);
    }

    private static boolean isIntegerType(int n2) {
        return n2 == 101 || n2 == 106 || n2 == 102 || n2 == 107;
    }

    private static Object doOperationNonNumeric(int n2, Object object, int n3, Object object2) {
        switch (n3) {
            case 0: {
                if (n2 == 50) {
                    ArrayList<Object> arrayList = new ArrayList<Object>((Collection)object);
                    arrayList.add(object2);
                    return arrayList;
                }
                return String.valueOf(object) + String.valueOf(object2);
            }
            case 18: {
                return MathProcessor.safeEquals(object2, object) != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 19: {
                return MathProcessor.safeNotEquals(object2, object) != false ? Boolean.TRUE : Boolean.FALSE;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 15: {
                if (object instanceof Comparable) {
                    try {
                        return object2 != null && (((Comparable)object).compareTo(object2) >= 1 ? Boolean.TRUE : Boolean.FALSE) != false;
                    }
                    catch (ClassCastException classCastException) {
                        throw new RuntimeException("uncomparable values <<" + object + ">> and <<" + object2 + ">>", classCastException);
                    }
                }
                return Boolean.FALSE;
            }
            case 17: {
                if (object instanceof Comparable) {
                    try {
                        return object2 != null && ((Comparable)object).compareTo(object2) >= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (ClassCastException classCastException) {
                        throw new RuntimeException("uncomparable values <<" + object + ">> and <<" + object2 + ">>", classCastException);
                    }
                }
                return Boolean.FALSE;
            }
            case 14: {
                if (object instanceof Comparable) {
                    try {
                        return object2 != null && ((Comparable)object).compareTo(object2) <= -1 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (ClassCastException classCastException) {
                        throw new RuntimeException("uncomparable values <<" + object + ">> and <<" + object2 + ">>", classCastException);
                    }
                }
                return Boolean.FALSE;
            }
            case 16: {
                if (object instanceof Comparable) {
                    try {
                        return object2 != null && ((Comparable)object).compareTo(object2) <= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (ClassCastException classCastException) {
                        throw new RuntimeException("uncomparable values <<" + object + ">> and <<" + object2 + ">>", classCastException);
                    }
                }
                return Boolean.FALSE;
            }
            case 27: {
                return Soundex.soundex(String.valueOf(object)).equals(Soundex.soundex(String.valueOf(object2)));
            }
            case 20: {
                return String.valueOf(object) + String.valueOf(object2);
            }
        }
        throw new RuntimeException("could not perform numeric operation on non-numeric types: left-type=" + (object != null ? object.getClass().getName() : "null") + "; right-type=" + (object2 != null ? object2.getClass().getName() : "null") + " [vals (" + String.valueOf(object) + ", " + String.valueOf(object2) + ") operation=" + DebugTools.getOperatorName(n3) + " (opcode:" + n3 + ") ]");
    }

    private static Boolean safeEquals(Object object, Object object2) {
        if (object != null) {
            return object.equals(object2) ? Boolean.TRUE : Boolean.FALSE;
        }
        return object2 == null || (object2.equals(object) ? Boolean.TRUE : Boolean.FALSE) != false;
    }

    private static Boolean safeNotEquals(Object object, Object object2) {
        if (object != null) {
            return !object.equals(object2) ? Boolean.TRUE : Boolean.FALSE;
        }
        return object2 != null && !object2.equals(object) ? Boolean.TRUE : Boolean.FALSE;
    }

    private static Object doOperationsSameType(int n2, Object object, int n3, Object object2) {
        switch (n2) {
            case 50: {
                switch (n3) {
                    case 0: {
                        ArrayList arrayList = new ArrayList((Collection)object);
                        arrayList.addAll((Collection)object2);
                        return arrayList;
                    }
                    case 18: {
                        return object.equals(object2);
                    }
                    case 19: {
                        return !object.equals(object2);
                    }
                }
                throw new UnsupportedOperationException("illegal operation on Collection type");
            }
            case 101: 
            case 106: {
                switch (n3) {
                    case 0: {
                        return (Integer)object + (Integer)object2;
                    }
                    case 1: {
                        return (Integer)object - (Integer)object2;
                    }
                    case 3: {
                        return ((Integer)object).doubleValue() / ((Integer)object2).doubleValue();
                    }
                    case 2: {
                        return (Integer)object * (Integer)object2;
                    }
                    case 5: {
                        double d2 = Math.pow(((Integer)object).intValue(), ((Integer)object2).intValue());
                        if (d2 > 2.147483647E9) {
                            return d2;
                        }
                        return (int)d2;
                    }
                    case 4: {
                        return (Integer)object % (Integer)object2;
                    }
                    case 15: {
                        return (Integer)object > (Integer)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 17: {
                        return (Integer)object >= (Integer)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 14: {
                        return (Integer)object < (Integer)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 16: {
                        return (Integer)object <= (Integer)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 18: {
                        return ((Integer)object).intValue() == ((Integer)object2).intValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 19: {
                        return ((Integer)object).intValue() != ((Integer)object2).intValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 6: {
                        if (object2 instanceof Long) {
                            return (long)((Integer)object).intValue() & (Long)object2;
                        }
                        return (Integer)object & (Integer)object2;
                    }
                    case 7: {
                        if (object2 instanceof Long) {
                            return (long)((Integer)object).intValue() | (Long)object2;
                        }
                        return (Integer)object | (Integer)object2;
                    }
                    case 10: {
                        if (object2 instanceof Long) {
                            return (Integer)object << (int)((Long)object2).longValue();
                        }
                        return (Integer)object << (Integer)object2;
                    }
                    case 9: {
                        if (object2 instanceof Long) {
                            return (Integer)object >> (int)((Long)object2).longValue();
                        }
                        return (Integer)object >> (Integer)object2;
                    }
                    case 11: {
                        if (object2 instanceof Long) {
                            return (Integer)object >>> (int)((Long)object2).longValue();
                        }
                        return (Integer)object >>> (Integer)object2;
                    }
                    case 8: {
                        if (object2 instanceof Long) {
                            return (long)((Integer)object).intValue() ^ (Long)object2;
                        }
                        return (Integer)object ^ (Integer)object2;
                    }
                }
            }
            case 100: 
            case 105: {
                switch (n3) {
                    case 0: {
                        return (Short)object + (Short)object2;
                    }
                    case 1: {
                        return (Short)object - (Short)object2;
                    }
                    case 3: {
                        return ((Short)object).doubleValue() / ((Short)object2).doubleValue();
                    }
                    case 2: {
                        return (Short)object * (Short)object2;
                    }
                    case 5: {
                        double d3 = Math.pow(((Short)object).shortValue(), ((Short)object2).shortValue());
                        if (d3 > 32767.0) {
                            return d3;
                        }
                        return (short)d3;
                    }
                    case 4: {
                        return (Short)object % (Short)object2;
                    }
                    case 15: {
                        return (Short)object > (Short)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 17: {
                        return (Short)object >= (Short)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 14: {
                        return (Short)object < (Short)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 16: {
                        return (Short)object <= (Short)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 18: {
                        return ((Short)object).shortValue() == ((Short)object2).shortValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 19: {
                        return ((Short)object).shortValue() != ((Short)object2).shortValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 6: {
                        return (Short)object & (Short)object2;
                    }
                    case 7: {
                        return (Short)object | (Short)object2;
                    }
                    case 10: {
                        return (Short)object << (Short)object2;
                    }
                    case 9: {
                        return (Short)object >> (Short)object2;
                    }
                    case 11: {
                        return (Short)object >>> (Short)object2;
                    }
                    case 8: {
                        return (Short)object ^ (Short)object2;
                    }
                }
            }
            case 102: 
            case 107: {
                switch (n3) {
                    case 0: {
                        return (Long)object + (Long)object2;
                    }
                    case 1: {
                        return (Long)object - (Long)object2;
                    }
                    case 3: {
                        return ((Long)object).doubleValue() / ((Long)object2).doubleValue();
                    }
                    case 2: {
                        return (Long)object * (Long)object2;
                    }
                    case 5: {
                        double d4 = Math.pow(((Long)object).longValue(), ((Long)object2).longValue());
                        if (d4 > 9.223372036854776E18) {
                            return d4;
                        }
                        return (long)d4;
                    }
                    case 4: {
                        return (Long)object % (Long)object2;
                    }
                    case 15: {
                        return (Long)object > (Long)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 17: {
                        return (Long)object >= (Long)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 14: {
                        return (Long)object < (Long)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 16: {
                        return (Long)object <= (Long)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 18: {
                        return ((Long)object).longValue() == ((Long)object2).longValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 19: {
                        return ((Long)object).longValue() != ((Long)object2).longValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 6: {
                        if (object2 instanceof Integer) {
                            return (Long)object & (long)((Integer)object2).intValue();
                        }
                        return (Long)object & (Long)object2;
                    }
                    case 7: {
                        if (object2 instanceof Integer) {
                            return (Long)object | (long)((Integer)object2).intValue();
                        }
                        return (Long)object | (Long)object2;
                    }
                    case 10: {
                        if (object2 instanceof Integer) {
                            return (Long)object << (Integer)object2;
                        }
                        return (Long)object << (int)((Long)object2).longValue();
                    }
                    case 12: {
                        throw new UnsupportedOperationException("unsigned left-shift not supported");
                    }
                    case 9: {
                        if (object2 instanceof Integer) {
                            return (Long)object >> (Integer)object2;
                        }
                        return (Long)object >> (int)((Long)object2).longValue();
                    }
                    case 11: {
                        if (object2 instanceof Integer) {
                            return (Long)object >>> (Integer)object2;
                        }
                        return (Long)object >>> (int)((Long)object2).longValue();
                    }
                    case 8: {
                        if (object2 instanceof Integer) {
                            return (Long)object ^ (long)((Integer)object2).intValue();
                        }
                        return (Long)object ^ (Long)object2;
                    }
                }
            }
            case 300: {
                object2 = ((Unit)object).convertFrom(object2);
                object = ((Unit)object).getValue();
            }
            case 103: 
            case 109: {
                switch (n3) {
                    case 0: {
                        return (Double)object + (Double)object2;
                    }
                    case 1: {
                        return (Double)object - (Double)object2;
                    }
                    case 3: {
                        return (Double)object / (Double)object2;
                    }
                    case 2: {
                        return (Double)object * (Double)object2;
                    }
                    case 5: {
                        return Math.pow((Double)object, (Double)object2);
                    }
                    case 4: {
                        return (Double)object % (Double)object2;
                    }
                    case 15: {
                        return (Double)object > (Double)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 17: {
                        return (Double)object >= (Double)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 14: {
                        return (Double)object < (Double)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 16: {
                        return (Double)object <= (Double)object2 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 18: {
                        return ((Double)object).doubleValue() == ((Double)object2).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 19: {
                        return ((Double)object).doubleValue() != ((Double)object2).doubleValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        throw new RuntimeException("bitwise operation on a non-fixed-point number.");
                    }
                }
            }
            case 104: 
            case 108: {
                switch (n3) {
                    case 0: {
                        return Float.valueOf(((Float)object).floatValue() + ((Float)object2).floatValue());
                    }
                    case 1: {
                        return Float.valueOf(((Float)object).floatValue() - ((Float)object2).floatValue());
                    }
                    case 3: {
                        return ((Float)object).doubleValue() / ((Float)object2).doubleValue();
                    }
                    case 2: {
                        return Float.valueOf(((Float)object).floatValue() * ((Float)object2).floatValue());
                    }
                    case 5: {
                        return ParseTools.narrowType(new InternalNumber(((Float)object).floatValue(), MATH_CONTEXT).pow(new InternalNumber(((Float)object2).floatValue()).intValue(), MATH_CONTEXT), -1);
                    }
                    case 4: {
                        return Float.valueOf(((Float)object).floatValue() % ((Float)object2).floatValue());
                    }
                    case 15: {
                        return ((Float)object).floatValue() > ((Float)object2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 17: {
                        return ((Float)object).floatValue() >= ((Float)object2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 14: {
                        return ((Float)object).floatValue() < ((Float)object2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 16: {
                        return ((Float)object).floatValue() <= ((Float)object2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 18: {
                        return ((Float)object).floatValue() == ((Float)object2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 19: {
                        return ((Float)object).floatValue() != ((Float)object2).floatValue() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        throw new RuntimeException("bitwise operation on a non-fixed-point number.");
                    }
                }
            }
            case 111: {
                switch (n3) {
                    case 0: {
                        return ((BigInteger)object).add((BigInteger)object2);
                    }
                    case 1: {
                        return ((BigInteger)object).subtract((BigInteger)object2);
                    }
                    case 3: {
                        return ((BigInteger)object).divide((BigInteger)object2);
                    }
                    case 2: {
                        return ((BigInteger)object).multiply((BigInteger)object2);
                    }
                    case 5: {
                        return ((BigInteger)object).pow(((BigInteger)object2).intValue());
                    }
                    case 4: {
                        return ((BigInteger)object).remainder((BigInteger)object2);
                    }
                    case 15: {
                        return ((BigInteger)object).compareTo((BigInteger)object2) == 1 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 17: {
                        return ((BigInteger)object).compareTo((BigInteger)object2) >= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 14: {
                        return ((BigInteger)object).compareTo((BigInteger)object2) == -1 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 16: {
                        return ((BigInteger)object).compareTo((BigInteger)object2) <= 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 18: {
                        return ((BigInteger)object).compareTo((BigInteger)object2) == 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 19: {
                        return ((BigInteger)object).compareTo((BigInteger)object2) != 0 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        throw new RuntimeException("bitwise operation on a number greater than 32-bits not possible");
                    }
                }
            }
        }
        switch (n3) {
            case 18: {
                return MathProcessor.safeEquals(object2, object);
            }
            case 19: {
                return MathProcessor.safeNotEquals(object2, object);
            }
            case 0: {
                return String.valueOf(object) + String.valueOf(object2);
            }
        }
        return null;
    }

    private static int box(int n2) {
        switch (n2) {
            case 101: {
                return 106;
            }
            case 103: {
                return 109;
            }
            case 102: {
                return 107;
            }
            case 100: {
                return 105;
            }
            case 9: {
                return 113;
            }
            case 104: {
                return 108;
            }
            case 8: {
                return 112;
            }
            case 7: {
                return 15;
            }
        }
        return n2;
    }

    private static Double getNumber(Object object, int n2) {
        if (object == null || object == BlankLiteral.INSTANCE) {
            return 0.0;
        }
        switch (n2) {
            case 110: {
                return ((Number)object).doubleValue();
            }
            case 111: {
                return ((Number)object).doubleValue();
            }
            case 101: 
            case 106: {
                return ((Number)object).doubleValue();
            }
            case 102: 
            case 107: {
                return ((Number)object).doubleValue();
            }
            case 1: {
                return Double.parseDouble((String)object);
            }
            case 104: 
            case 108: {
                return ((Number)object).doubleValue();
            }
            case 103: 
            case 109: {
                return (Double)object;
            }
            case 100: 
            case 105: {
                return ((Number)object).doubleValue();
            }
            case 8: 
            case 112: {
                return Double.parseDouble(String.valueOf((Character)object));
            }
            case 7: 
            case 15: {
                return (Boolean)object != false ? 1.0 : 0.0;
            }
            case 9: 
            case 113: {
                return ((Byte)object).doubleValue();
            }
        }
        throw new RuntimeException("cannot convert <" + object + "> to a numeric type: " + object.getClass() + " [" + n2 + "]");
    }

    private static InternalNumber getInternalNumberFromType(Object object, int n2) {
        if (object == null || object == BlankLiteral.INSTANCE) {
            return new InternalNumber(0, MATH_CONTEXT);
        }
        switch (n2) {
            case 110: {
                return new InternalNumber(((BigDecimal)object).doubleValue());
            }
            case 111: {
                return new InternalNumber((BigInteger)object, MathContext.DECIMAL128);
            }
            case 101: 
            case 106: {
                return new InternalNumber((Integer)object, MathContext.DECIMAL32);
            }
            case 102: 
            case 107: {
                return new InternalNumber((Long)object, MathContext.DECIMAL64);
            }
            case 1: {
                return new InternalNumber((String)object, MathContext.DECIMAL64);
            }
            case 104: 
            case 108: {
                return new InternalNumber(((Float)object).floatValue(), MathContext.DECIMAL64);
            }
            case 103: 
            case 109: {
                return new InternalNumber((Double)object, MathContext.DECIMAL64);
            }
            case 100: 
            case 105: {
                return new InternalNumber(((Short)object).shortValue(), MathContext.DECIMAL32);
            }
            case 8: 
            case 112: {
                return new InternalNumber(((Character)object).charValue(), MathContext.DECIMAL32);
            }
            case 7: 
            case 15: {
                return new InternalNumber((Boolean)object != false ? 1 : 0);
            }
            case 300: {
                return new InternalNumber(((Unit)object).getValue(), MathContext.DECIMAL64);
            }
            case 9: 
            case 113: {
                return new InternalNumber(((Byte)object).intValue());
            }
        }
        throw new RuntimeException("cannot convert <" + object + "> to a numeric type: " + object.getClass() + " [" + n2 + "]");
    }
}

