/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.mvel2.templates.util;

import com.contrastsecurity.thirdparty.org.mvel2.templates.TemplateError;
import com.contrastsecurity.thirdparty.org.mvel2.templates.res.Node;
import com.contrastsecurity.thirdparty.org.mvel2.templates.res.TerminalNode;
import com.contrastsecurity.thirdparty.org.mvel2.util.ParseTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class TemplateTools {
    public static Node getLastNode(Node node) {
        Node node2 = node;
        while (!(node2.getNext() instanceof TerminalNode)) {
            node2 = node2.getNext();
        }
        return node2;
    }

    public static int captureToEOS(char[] cArray, int n2) {
        int n3 = cArray.length;
        while (n2 != n3) {
            switch (cArray[n2]) {
                case '(': 
                case '[': 
                case '{': {
                    n2 = ParseTools.balancedCapture(cArray, n2, cArray[n2]);
                    break;
                }
                case ';': 
                case '}': {
                    return n2;
                }
            }
            ++n2;
        }
        return n2;
    }

    public static String readInFile(String string) {
        return TemplateTools.readInFile(new File(string));
    }

    public static String readInFile(File file) {
        try {
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(10);
            StringBuilder stringBuilder = new StringBuilder();
            block3: while (true) {
                byteBuffer.rewind();
                int n2 = fileChannel.read(byteBuffer);
                if (n2 == -1) break;
                byteBuffer.rewind();
                while (true) {
                    if (n2 == 0) continue block3;
                    stringBuilder.append((char)byteBuffer.get());
                    --n2;
                }
                break;
            }
            fileChannel.close();
            return stringBuilder.toString();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TemplateError("cannot include template '" + file.getName() + "': file not found.");
        }
        catch (IOException iOException) {
            throw new TemplateError("unknown I/O exception while including '" + file.getName() + "' (stacktrace nested)", iOException);
        }
    }

    public static String readStream(InputStream inputStream) {
        try {
            int n2;
            byte[] byArray = new byte[10];
            StringBuilder stringBuilder = new StringBuilder();
            while ((n2 = inputStream.read(byArray)) != -1) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringBuilder.append((char)byArray[i2]);
                }
            }
            return stringBuilder.toString();
        }
        catch (NullPointerException nullPointerException) {
            if (inputStream == null) {
                throw new TemplateError("null input stream", nullPointerException);
            }
            throw nullPointerException;
        }
        catch (IOException iOException) {
            throw new TemplateError("unknown I/O exception while including (stacktrace nested)", iOException);
        }
    }
}

