/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.objectweb.asm;

import com.contrastsecurity.thirdparty.org.objectweb.asm.AnnotationVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Attribute;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Constants;
import com.contrastsecurity.thirdparty.org.objectweb.asm.FieldVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.MethodVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.ModuleVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.RecordComponentVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.TypePath;

public abstract class ClassVisitor {
    protected final int api;
    protected ClassVisitor cv;

    public ClassVisitor(int n2) {
        this(n2, null);
    }

    public ClassVisitor(int n2, ClassVisitor classVisitor) {
        if (n2 != 524288 && n2 != 458752 && n2 != 393216 && n2 != 327680 && n2 != 262144 && n2 != 0x1090000) {
            throw new IllegalArgumentException("Unsupported api " + n2);
        }
        if (n2 == 0x1090000) {
            Constants.checkAsmExperimental(this);
        }
        this.api = n2;
        this.cv = classVisitor;
    }

    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        if (this.api < 524288 && (n3 & 0x10000) != 0) {
            throw new UnsupportedOperationException("Records requires ASM8");
        }
        if (this.cv != null) {
            this.cv.visit(n2, n3, string, string2, string3, stringArray);
        }
    }

    public void visitSource(String string, String string2) {
        if (this.cv != null) {
            this.cv.visitSource(string, string2);
        }
    }

    public ModuleVisitor visitModule(String string, int n2, String string2) {
        if (this.api < 393216) {
            throw new UnsupportedOperationException("This feature requires ASM6");
        }
        if (this.cv != null) {
            return this.cv.visitModule(string, n2, string2);
        }
        return null;
    }

    public void visitNestHost(String string) {
        if (this.api < 458752) {
            throw new UnsupportedOperationException("This feature requires ASM7");
        }
        if (this.cv != null) {
            this.cv.visitNestHost(string);
        }
    }

    public void visitOuterClass(String string, String string2, String string3) {
        if (this.cv != null) {
            this.cv.visitOuterClass(string, string2, string3);
        }
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        if (this.cv != null) {
            return this.cv.visitAnnotation(string, bl);
        }
        return null;
    }

    public AnnotationVisitor visitTypeAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        if (this.api < 327680) {
            throw new UnsupportedOperationException("This feature requires ASM5");
        }
        if (this.cv != null) {
            return this.cv.visitTypeAnnotation(n2, typePath, string, bl);
        }
        return null;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.cv != null) {
            this.cv.visitAttribute(attribute);
        }
    }

    public void visitNestMember(String string) {
        if (this.api < 458752) {
            throw new UnsupportedOperationException("This feature requires ASM7");
        }
        if (this.cv != null) {
            this.cv.visitNestMember(string);
        }
    }

    @Deprecated
    public void visitPermittedSubtypeExperimental(String string) {
        if (this.api != 0x1090000) {
            throw new UnsupportedOperationException("This feature requires ASM9_EXPERIMENTAL");
        }
        if (this.cv != null) {
            this.cv.visitPermittedSubtypeExperimental(string);
        }
    }

    public void visitInnerClass(String string, String string2, String string3, int n2) {
        if (this.cv != null) {
            this.cv.visitInnerClass(string, string2, string3, n2);
        }
    }

    public RecordComponentVisitor visitRecordComponent(String string, String string2, String string3) {
        if (this.api < 524288) {
            throw new UnsupportedOperationException("This feature requires ASM8");
        }
        if (this.cv != null) {
            return this.cv.visitRecordComponent(string, string2, string3);
        }
        return null;
    }

    public FieldVisitor visitField(int n2, String string, String string2, String string3, Object object) {
        if (this.cv != null) {
            return this.cv.visitField(n2, string, string2, string3, object);
        }
        return null;
    }

    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        if (this.cv != null) {
            return this.cv.visitMethod(n2, string, string2, string3, stringArray);
        }
        return null;
    }

    public void visitEnd() {
        if (this.cv != null) {
            this.cv.visitEnd();
        }
    }
}

