/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.objectweb.asm;

import com.contrastsecurity.thirdparty.org.objectweb.asm.AnnotationVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.AnnotationWriter;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Attribute;
import com.contrastsecurity.thirdparty.org.objectweb.asm.ByteVector;
import com.contrastsecurity.thirdparty.org.objectweb.asm.RecordComponentVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.SymbolTable;
import com.contrastsecurity.thirdparty.org.objectweb.asm.TypePath;

final class RecordComponentWriter
extends RecordComponentVisitor {
    private final SymbolTable symbolTable;
    private final int nameIndex;
    private final int descriptorIndex;
    private int signatureIndex;
    private AnnotationWriter lastRuntimeVisibleAnnotation;
    private AnnotationWriter lastRuntimeInvisibleAnnotation;
    private AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private Attribute firstAttribute;

    RecordComponentWriter(SymbolTable symbolTable, String string, String string2, String string3) {
        super(524288);
        this.symbolTable = symbolTable;
        this.nameIndex = symbolTable.addConstantUtf8(string);
        this.descriptorIndex = symbolTable.addConstantUtf8(string2);
        if (string3 != null) {
            this.signatureIndex = symbolTable.addConstantUtf8(string3);
        }
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        if (bl) {
            this.lastRuntimeVisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = AnnotationWriter.create(this.symbolTable, string, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    public AnnotationVisitor visitTypeAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        if (bl) {
            this.lastRuntimeVisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2, typePath, string, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, n2, typePath, string, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    public void visitAttribute(Attribute attribute) {
        attribute.nextAttribute = this.firstAttribute;
        this.firstAttribute = attribute;
    }

    public void visitEnd() {
    }

    int computeRecordComponentInfoSize() {
        int n2 = 6;
        n2 += Attribute.computeAttributesSize(this.symbolTable, 0, this.signatureIndex);
        n2 += AnnotationWriter.computeAnnotationsSize(this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation);
        if (this.firstAttribute != null) {
            n2 += this.firstAttribute.computeAttributesSize(this.symbolTable);
        }
        return n2;
    }

    void putRecordComponentInfo(ByteVector byteVector) {
        byteVector.putShort(this.nameIndex).putShort(this.descriptorIndex);
        int n2 = 0;
        if (this.signatureIndex != 0) {
            ++n2;
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            ++n2;
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            ++n2;
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            ++n2;
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            ++n2;
        }
        if (this.firstAttribute != null) {
            n2 += this.firstAttribute.getAttributeCount();
        }
        byteVector.putShort(n2);
        Attribute.putAttributes(this.symbolTable, 0, this.signatureIndex, byteVector);
        AnnotationWriter.putAnnotations(this.symbolTable, this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation, byteVector);
        if (this.firstAttribute != null) {
            this.firstAttribute.putAttributes(this.symbolTable, byteVector);
        }
    }

    final void collectAttributePrototypes(Attribute.Set set) {
        set.addAttributes(this.firstAttribute);
    }
}

