/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.objectweb.asm.commons;

import com.contrastsecurity.thirdparty.org.objectweb.asm.ClassVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.FieldVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.MethodVisitor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialVersionUIDAdder
extends ClassVisitor {
    private static final String CLINIT = "<clinit>";
    private boolean computeSvuid;
    private boolean hasSvuid;
    private int access;
    private String name;
    private String[] interfaces;
    private Collection<Item> svuidFields;
    private boolean hasStaticInitializer;
    private Collection<Item> svuidConstructors;
    private Collection<Item> svuidMethods;

    public SerialVersionUIDAdder(ClassVisitor classVisitor) {
        this(524288, classVisitor);
        if (this.getClass() != SerialVersionUIDAdder.class) {
            throw new IllegalStateException();
        }
    }

    protected SerialVersionUIDAdder(int n2, ClassVisitor classVisitor) {
        super(n2, classVisitor);
    }

    @Override
    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        boolean bl = this.computeSvuid = (n3 & 0x4000) == 0;
        if (this.computeSvuid) {
            this.name = string;
            this.access = n3;
            this.interfaces = (String[])stringArray.clone();
            this.svuidFields = new ArrayList<Item>();
            this.svuidConstructors = new ArrayList<Item>();
            this.svuidMethods = new ArrayList<Item>();
        }
        super.visit(n2, n3, string, string2, string3, stringArray);
    }

    @Override
    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        if (this.computeSvuid) {
            if (CLINIT.equals(string)) {
                this.hasStaticInitializer = true;
            }
            int n3 = n2 & 0xD3F;
            if ((n2 & 2) == 0) {
                if ("<init>".equals(string)) {
                    this.svuidConstructors.add(new Item(string, n3, string2));
                } else if (!CLINIT.equals(string)) {
                    this.svuidMethods.add(new Item(string, n3, string2));
                }
            }
        }
        return super.visitMethod(n2, string, string2, string3, stringArray);
    }

    @Override
    public FieldVisitor visitField(int n2, String string, String string2, String string3, Object object) {
        if (this.computeSvuid) {
            if ("serialVersionUID".equals(string)) {
                this.computeSvuid = false;
                this.hasSvuid = true;
            }
            if ((n2 & 2) == 0 || (n2 & 0x88) == 0) {
                int n3 = n2 & 0xDF;
                this.svuidFields.add(new Item(string, n3, string2));
            }
        }
        return super.visitField(n2, string, string2, string3, object);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n2) {
        if (this.name != null && this.name.equals(string)) {
            this.access = n2;
        }
        super.visitInnerClass(string, string2, string3, n2);
    }

    @Override
    public void visitEnd() {
        if (this.computeSvuid && !this.hasSvuid) {
            try {
                this.addSVUID(this.computeSVUID());
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Error while computing SVUID for " + this.name, iOException);
            }
        }
        super.visitEnd();
    }

    public boolean hasSVUID() {
        return this.hasSvuid;
    }

    protected void addSVUID(long l2) {
        FieldVisitor fieldVisitor = super.visitField(24, "serialVersionUID", "J", null, l2);
        if (fieldVisitor != null) {
            fieldVisitor.visitEnd();
        }
    }

    protected long computeSVUID() throws IOException {
        long l2 = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            Throwable throwable2 = null;
            try {
                dataOutputStream.writeUTF(this.name.replace('/', '.'));
                int n2 = this.access;
                if ((n2 & 0x200) != 0) {
                    n2 = this.svuidMethods.isEmpty() ? n2 & 0xFFFFFBFF : n2 | 0x400;
                }
                dataOutputStream.writeInt(n2 & 0x611);
                Arrays.sort(this.interfaces);
                String[] objectArray = this.interfaces;
                int n3 = objectArray.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    String string = objectArray[i2];
                    dataOutputStream.writeUTF(string.replace('/', '.'));
                }
                SerialVersionUIDAdder.writeItems(this.svuidFields, dataOutputStream, false);
                if (this.hasStaticInitializer) {
                    dataOutputStream.writeUTF(CLINIT);
                    dataOutputStream.writeInt(8);
                    dataOutputStream.writeUTF("()V");
                }
                SerialVersionUIDAdder.writeItems(this.svuidConstructors, dataOutputStream, true);
                SerialVersionUIDAdder.writeItems(this.svuidMethods, dataOutputStream, true);
                dataOutputStream.flush();
                byte[] byArray = this.computeSHAdigest(byteArrayOutputStream.toByteArray());
                for (n3 = Math.min(byArray.length, 8) - 1; n3 >= 0; --n3) {
                    l2 = l2 << 8 | (long)(byArray[n3] & 0xFF);
                }
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (dataOutputStream != null) {
                    if (throwable2 != null) {
                        try {
                            dataOutputStream.close();
                        }
                        catch (Throwable throwable4) {
                        }
                    } else {
                        dataOutputStream.close();
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            if (byteArrayOutputStream != null) {
                if (throwable != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Throwable throwable6) {
                    }
                } else {
                    byteArrayOutputStream.close();
                }
            }
        }
        return l2;
    }

    protected byte[] computeSHAdigest(byte[] byArray) {
        try {
            return MessageDigest.getInstance("SHA").digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException(noSuchAlgorithmException);
        }
    }

    private static void writeItems(Collection<Item> collection, DataOutput dataOutput, boolean bl) throws IOException {
        Object[] objectArray = collection.toArray(new Item[0]);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            dataOutput.writeUTF(((Item)object).name);
            dataOutput.writeInt(((Item)object).access);
            dataOutput.writeUTF(bl ? ((Item)object).descriptor.replace('/', '.') : ((Item)object).descriptor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Item
    implements Comparable<Item> {
        final String name;
        final int access;
        final String descriptor;

        Item(String string, int n2, String string2) {
            this.name = string;
            this.access = n2;
            this.descriptor = string2;
        }

        @Override
        public int compareTo(Item item) {
            int n2 = this.name.compareTo(item.name);
            if (n2 == 0) {
                n2 = this.descriptor.compareTo(item.descriptor);
            }
            return n2;
        }

        public boolean equals(Object object) {
            if (object instanceof Item) {
                return this.compareTo((Item)object) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.descriptor.hashCode();
        }
    }
}

