/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.objectweb.asm.tree;

import com.contrastsecurity.thirdparty.org.objectweb.asm.ClassVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.ModuleVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.ModuleExportNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.ModuleOpenNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.ModuleProvideNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.ModuleRequireNode;
import com.contrastsecurity.thirdparty.org.objectweb.asm.tree.Util;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleNode
extends ModuleVisitor {
    public String name;
    public int access;
    public String version;
    public String mainClass;
    public List<String> packages;
    public List<ModuleRequireNode> requires;
    public List<ModuleExportNode> exports;
    public List<ModuleOpenNode> opens;
    public List<String> uses;
    public List<ModuleProvideNode> provides;

    public ModuleNode(String string, int n2, String string2) {
        super(524288);
        if (this.getClass() != ModuleNode.class) {
            throw new IllegalStateException();
        }
        this.name = string;
        this.access = n2;
        this.version = string2;
    }

    public ModuleNode(int n2, String string, int n3, String string2, List<ModuleRequireNode> list, List<ModuleExportNode> list2, List<ModuleOpenNode> list3, List<String> list4, List<ModuleProvideNode> list5) {
        super(n2);
        this.name = string;
        this.access = n3;
        this.version = string2;
        this.requires = list;
        this.exports = list2;
        this.opens = list3;
        this.uses = list4;
        this.provides = list5;
    }

    @Override
    public void visitMainClass(String string) {
        this.mainClass = string;
    }

    @Override
    public void visitPackage(String string) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>(5);
        }
        this.packages.add(string);
    }

    @Override
    public void visitRequire(String string, int n2, String string2) {
        if (this.requires == null) {
            this.requires = new ArrayList<ModuleRequireNode>(5);
        }
        this.requires.add(new ModuleRequireNode(string, n2, string2));
    }

    @Override
    public void visitExport(String string, int n2, String ... stringArray) {
        if (this.exports == null) {
            this.exports = new ArrayList<ModuleExportNode>(5);
        }
        this.exports.add(new ModuleExportNode(string, n2, Util.asArrayList(stringArray)));
    }

    @Override
    public void visitOpen(String string, int n2, String ... stringArray) {
        if (this.opens == null) {
            this.opens = new ArrayList<ModuleOpenNode>(5);
        }
        this.opens.add(new ModuleOpenNode(string, n2, Util.asArrayList(stringArray)));
    }

    @Override
    public void visitUse(String string) {
        if (this.uses == null) {
            this.uses = new ArrayList<String>(5);
        }
        this.uses.add(string);
    }

    @Override
    public void visitProvide(String string, String ... stringArray) {
        if (this.provides == null) {
            this.provides = new ArrayList<ModuleProvideNode>(5);
        }
        this.provides.add(new ModuleProvideNode(string, Util.asArrayList(stringArray)));
    }

    @Override
    public void visitEnd() {
    }

    public void accept(ClassVisitor classVisitor) {
        int n2;
        int n3;
        ModuleVisitor moduleVisitor = classVisitor.visitModule(this.name, this.access, this.version);
        if (moduleVisitor == null) {
            return;
        }
        if (this.mainClass != null) {
            moduleVisitor.visitMainClass(this.mainClass);
        }
        if (this.packages != null) {
            n3 = this.packages.size();
            for (n2 = 0; n2 < n3; ++n2) {
                moduleVisitor.visitPackage(this.packages.get(n2));
            }
        }
        if (this.requires != null) {
            n3 = this.requires.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.requires.get(n2).accept(moduleVisitor);
            }
        }
        if (this.exports != null) {
            n3 = this.exports.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.exports.get(n2).accept(moduleVisitor);
            }
        }
        if (this.opens != null) {
            n3 = this.opens.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.opens.get(n2).accept(moduleVisitor);
            }
        }
        if (this.uses != null) {
            n3 = this.uses.size();
            for (n2 = 0; n2 < n3; ++n2) {
                moduleVisitor.visitUse(this.uses.get(n2));
            }
        }
        if (this.provides != null) {
            n3 = this.provides.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this.provides.get(n2).accept(moduleVisitor);
            }
        }
    }
}

