/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.objectweb.asm.util;

import com.contrastsecurity.thirdparty.org.objectweb.asm.ModuleVisitor;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.CheckClassAdapter;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.CheckMethodAdapter;
import java.util.HashSet;

public class CheckModuleAdapter
extends ModuleVisitor {
    private final boolean isOpen;
    private final NameSet requiredModules = new NameSet("Modules requires");
    private final NameSet exportedPackages = new NameSet("Module exports");
    private final NameSet openedPackages = new NameSet("Module opens");
    private final NameSet usedServices = new NameSet("Module uses");
    private final NameSet providedServices = new NameSet("Module provides");
    int classVersion;
    private boolean visitEndCalled;

    public CheckModuleAdapter(ModuleVisitor moduleVisitor, boolean bl) {
        this(524288, moduleVisitor, bl);
        if (this.getClass() != CheckModuleAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckModuleAdapter(int n2, ModuleVisitor moduleVisitor, boolean bl) {
        super(n2, moduleVisitor);
        this.isOpen = bl;
    }

    public void visitMainClass(String string) {
        CheckMethodAdapter.checkInternalName(53, string, "module main class");
        super.visitMainClass(string);
    }

    public void visitPackage(String string) {
        CheckMethodAdapter.checkInternalName(53, string, "module package");
        super.visitPackage(string);
    }

    public void visitRequire(String string, int n2, String string2) {
        this.checkVisitEndNotCalled();
        CheckClassAdapter.checkFullyQualifiedName(53, string, "required module");
        this.requiredModules.checkNameNotAlreadyDeclared(string);
        CheckClassAdapter.checkAccess(n2, 36960);
        if (this.classVersion >= 54 && string.equals("java.base") && (n2 & 0x60) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + n2 + " java.base can not be declared ACC_TRANSITIVE or ACC_STATIC_PHASE");
        }
        super.visitRequire(string, n2, string2);
    }

    public void visitExport(String string, int n2, String ... stringArray) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkInternalName(53, string, "package name");
        this.exportedPackages.checkNameNotAlreadyDeclared(string);
        CheckClassAdapter.checkAccess(n2, 36864);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                CheckClassAdapter.checkFullyQualifiedName(53, string2, "module export to");
            }
        }
        super.visitExport(string, n2, stringArray);
    }

    public void visitOpen(String string, int n2, String ... stringArray) {
        this.checkVisitEndNotCalled();
        if (this.isOpen) {
            throw new UnsupportedOperationException("An open module can not use open directive");
        }
        CheckMethodAdapter.checkInternalName(53, string, "package name");
        this.openedPackages.checkNameNotAlreadyDeclared(string);
        CheckClassAdapter.checkAccess(n2, 36864);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                CheckClassAdapter.checkFullyQualifiedName(53, string2, "module open to");
            }
        }
        super.visitOpen(string, n2, stringArray);
    }

    public void visitUse(String string) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkInternalName(53, string, "service");
        this.usedServices.checkNameNotAlreadyDeclared(string);
        super.visitUse(string);
    }

    public void visitProvide(String string, String ... stringArray) {
        this.checkVisitEndNotCalled();
        CheckMethodAdapter.checkInternalName(53, string, "service");
        this.providedServices.checkNameNotAlreadyDeclared(string);
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Providers cannot be null or empty");
        }
        for (String string2 : stringArray) {
            CheckMethodAdapter.checkInternalName(53, string2, "provider");
        }
        super.visitProvide(string, stringArray);
    }

    public void visitEnd() {
        this.checkVisitEndNotCalled();
        this.visitEndCalled = true;
        super.visitEnd();
    }

    private void checkVisitEndNotCalled() {
        if (this.visitEndCalled) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }

    private static class NameSet {
        private final String type;
        private final HashSet<String> names;

        NameSet(String string) {
            this.type = string;
            this.names = new HashSet();
        }

        void checkNameNotAlreadyDeclared(String string) {
            if (!this.names.add(string)) {
                throw new IllegalArgumentException(this.type + " '" + string + "' already declared");
            }
        }
    }
}

