/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.objectweb.asm.util;

import com.contrastsecurity.thirdparty.org.objectweb.asm.signature.SignatureVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class TraceSignatureVisitor
extends SignatureVisitor {
    private static final String COMMA_SEPARATOR = ", ";
    private static final String EXTENDS_SEPARATOR = " extends ";
    private static final String IMPLEMENTS_SEPARATOR = " implements ";
    private static final Map<Character, String> BASE_TYPES;
    private final boolean isInterface;
    private final StringBuilder declaration;
    private StringBuilder returnType;
    private StringBuilder exceptions;
    private boolean formalTypeParameterVisited;
    private boolean interfaceBoundVisited;
    private boolean parameterTypeVisited;
    private boolean interfaceVisited;
    private int argumentStack;
    private int arrayStack;
    private String separator = "";

    public TraceSignatureVisitor(int n2) {
        super(524288);
        this.isInterface = (n2 & 0x200) != 0;
        this.declaration = new StringBuilder();
    }

    private TraceSignatureVisitor(StringBuilder stringBuilder) {
        super(524288);
        this.isInterface = false;
        this.declaration = stringBuilder;
    }

    public void visitFormalTypeParameter(String string) {
        this.declaration.append(this.formalTypeParameterVisited ? COMMA_SEPARATOR : "<").append(string);
        this.formalTypeParameterVisited = true;
        this.interfaceBoundVisited = false;
    }

    public SignatureVisitor visitClassBound() {
        this.separator = EXTENDS_SEPARATOR;
        this.startType();
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        this.separator = this.interfaceBoundVisited ? COMMA_SEPARATOR : EXTENDS_SEPARATOR;
        this.interfaceBoundVisited = true;
        this.startType();
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        this.endFormals();
        this.separator = EXTENDS_SEPARATOR;
        this.startType();
        return this;
    }

    public SignatureVisitor visitInterface() {
        if (this.interfaceVisited) {
            this.separator = COMMA_SEPARATOR;
        } else {
            this.separator = this.isInterface ? EXTENDS_SEPARATOR : IMPLEMENTS_SEPARATOR;
            this.interfaceVisited = true;
        }
        this.startType();
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.endFormals();
        if (this.parameterTypeVisited) {
            this.declaration.append(COMMA_SEPARATOR);
        } else {
            this.declaration.append('(');
            this.parameterTypeVisited = true;
        }
        this.startType();
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.endFormals();
        if (this.parameterTypeVisited) {
            this.parameterTypeVisited = false;
        } else {
            this.declaration.append('(');
        }
        this.declaration.append(')');
        this.returnType = new StringBuilder();
        return new TraceSignatureVisitor(this.returnType);
    }

    public SignatureVisitor visitExceptionType() {
        if (this.exceptions == null) {
            this.exceptions = new StringBuilder();
        } else {
            this.exceptions.append(COMMA_SEPARATOR);
        }
        return new TraceSignatureVisitor(this.exceptions);
    }

    public void visitBaseType(char c2) {
        String string = BASE_TYPES.get(Character.valueOf(c2));
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.declaration.append(string);
        this.endType();
    }

    public void visitTypeVariable(String string) {
        this.declaration.append(this.separator).append(string);
        this.separator = "";
        this.endType();
    }

    public SignatureVisitor visitArrayType() {
        this.startType();
        this.arrayStack |= 1;
        return this;
    }

    public void visitClassType(String string) {
        if ("java/lang/Object".equals(string)) {
            boolean bl;
            boolean bl2 = bl = this.argumentStack % 2 != 0 || this.parameterTypeVisited;
            if (bl) {
                this.declaration.append(this.separator).append(string.replace('/', '.'));
            }
        } else {
            this.declaration.append(this.separator).append(string.replace('/', '.'));
        }
        this.separator = "";
        this.argumentStack *= 2;
    }

    public void visitInnerClassType(String string) {
        if (this.argumentStack % 2 != 0) {
            this.declaration.append('>');
        }
        this.argumentStack /= 2;
        this.declaration.append('.');
        this.declaration.append(this.separator).append(string.replace('/', '.'));
        this.separator = "";
        this.argumentStack *= 2;
    }

    public void visitTypeArgument() {
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.declaration.append('<');
        } else {
            this.declaration.append(COMMA_SEPARATOR);
        }
        this.declaration.append('?');
    }

    public SignatureVisitor visitTypeArgument(char c2) {
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.declaration.append('<');
        } else {
            this.declaration.append(COMMA_SEPARATOR);
        }
        if (c2 == '+') {
            this.declaration.append("? extends ");
        } else if (c2 == '-') {
            this.declaration.append("? super ");
        }
        this.startType();
        return this;
    }

    public void visitEnd() {
        if (this.argumentStack % 2 != 0) {
            this.declaration.append('>');
        }
        this.argumentStack /= 2;
        this.endType();
    }

    public String getDeclaration() {
        return this.declaration.toString();
    }

    public String getReturnType() {
        return this.returnType == null ? null : this.returnType.toString();
    }

    public String getExceptions() {
        return this.exceptions == null ? null : this.exceptions.toString();
    }

    private void endFormals() {
        if (this.formalTypeParameterVisited) {
            this.declaration.append('>');
            this.formalTypeParameterVisited = false;
        }
    }

    private void startType() {
        this.arrayStack *= 2;
    }

    private void endType() {
        if (this.arrayStack % 2 == 0) {
            this.arrayStack /= 2;
        } else {
            while (this.arrayStack % 2 != 0) {
                this.arrayStack /= 2;
                this.declaration.append("[]");
            }
        }
    }

    static {
        HashMap<Character, String> hashMap = new HashMap<Character, String>();
        hashMap.put(Character.valueOf('Z'), "boolean");
        hashMap.put(Character.valueOf('B'), "byte");
        hashMap.put(Character.valueOf('C'), "char");
        hashMap.put(Character.valueOf('S'), "short");
        hashMap.put(Character.valueOf('I'), "int");
        hashMap.put(Character.valueOf('J'), "long");
        hashMap.put(Character.valueOf('F'), "float");
        hashMap.put(Character.valueOf('D'), "double");
        hashMap.put(Character.valueOf('V'), "void");
        BASE_TYPES = Collections.unmodifiableMap(hashMap);
    }
}

