/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent;

import com.contrastsecurity.agent.ContrastStarter;
import com.contrastsecurity.agent.boot.DenylistedProcessCheck;
import com.contrastsecurity.agent.injection.ClassInjector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ContrastLoaderAgent {
    private static final AtomicBoolean ATTACHED = new AtomicBoolean();
    private static final String BASE_INJECTIONS = "/com/contrastsecurity/agent/lib/contrast-agent-base-injections.jar";

    public static void main(String[] args) {
        File agentJarFile = ContrastLoaderAgent.findAgentJar();
        if (agentJarFile == null) {
            System.err.println("The Contrast Agent is missing a required configuration of the `contrast.agent.location` system property. Continuing application startup without Contrast Agent....");
            return;
        }
        ContrastStarter.diagnostics(args, agentJarFile);
    }

    public static void agentmain(String args, Instrumentation inst) {
        ContrastLoaderAgent.premain(args, inst);
    }

    public static void premain(String args, Instrumentation inst) {
        if (ATTACHED.getAndSet(true)) {
            System.err.println("The Contrast Agent is already attached, verify that your VM arguments don't include `-javaagent` twice for the Contrast Agent.");
            return;
        }
        if (DenylistedProcessCheck.isDenied(ContrastLoaderAgent.getStartCommand())) {
            return;
        }
        File agentJarFile = ContrastLoaderAgent.findAgentJar();
        if (agentJarFile == null) {
            System.err.println("The Contrast Agent is missing a required configuration of the `contrast.agent.location` system property. Continuing application startup without Contrast Agent....");
            return;
        }
        long premainStart = System.nanoTime();
        long jvmUptime = ContrastLoaderAgent.getJvmUptime();
        try {
            ClassInjector.inject(inst, agentJarFile);
            ContrastStarter.start(args, inst, agentJarFile, premainStart, jvmUptime);
        }
        catch (AccessControlException e2) {
            System.err.println("When using a Java SecurityManager, the Contrast agent requires the java.security.AllPermission. Continuing without Contrast...");
            e2.printStackTrace(System.err);
        }
        catch (Exception e3) {
            e3.printStackTrace(System.err);
            System.err.println("Unexpected error during Contrast Agent initialization. Continuing application startup without Contrast Agent....");
        }
    }

    public static InputStream getBaseInjectionsAsStream() {
        return ContrastLoaderAgent.class.getResourceAsStream(BASE_INJECTIONS);
    }

    private static long getJvmUptime() {
        RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
        return mxBean != null ? mxBean.getUptime() : 0L;
    }

    private static String getStartCommand() {
        try {
            return System.getSecurityManager() == null ? System.getProperty("sun.java.command") : AccessController.doPrivileged(() -> System.getProperty("sun.java.command"));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private ContrastLoaderAgent() {
    }

    private static File findAgentJar() {
        return System.getSecurityManager() == null ? ContrastLoaderAgent._findAgentJar() : AccessController.doPrivileged(ContrastLoaderAgent::_findAgentJar);
    }

    private static File _findAgentJar() {
        File file = ContrastLoaderAgent.findAgentJarFromClassPath();
        if (file != null) {
            return file;
        }
        file = ContrastLoaderAgent.findAgentJarFromJavaAgentArgs();
        if (file != null) {
            return file;
        }
        file = new File(System.getProperty("contrast.agent.location"));
        return ContrastLoaderAgent.verifyAgentJar(file) ? file : null;
    }

    private static File findAgentJarFromClassPath() {
        ProtectionDomain pd = ContrastLoaderAgent.class.getProtectionDomain();
        if (pd == null) {
            return null;
        }
        CodeSource cs2 = pd.getCodeSource();
        if (cs2 == null) {
            return null;
        }
        URL url = cs2.getLocation();
        if (url == null) {
            return null;
        }
        try {
            File file = new File(url.toURI());
            if (ContrastLoaderAgent.verifyAgentJar(file)) {
                return file;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    private static File findAgentJarFromJavaAgentArgs() {
        List<String> args = ContrastLoaderAgent.getVMArguments();
        Pattern pattern = Pattern.compile("-javaagent:([^=]+).*");
        for (String arg : args) {
            String path;
            File file;
            Matcher matcher;
            if (!arg.startsWith("-javaagent") || !(matcher = pattern.matcher(arg)).find() || !ContrastLoaderAgent.verifyAgentJar(file = new File(path = matcher.group(1)))) continue;
            return file;
        }
        return null;
    }

    private static List<String> getVMArguments() {
        try {
            Object vmManagement;
            Class<?> helper = Class.forName("sun.management.ManagementFactoryHelper");
            Class<?> vmMgmt = Class.forName("sun.management.VMManagement");
            try {
                vmManagement = helper.getDeclaredMethod("getVMManagement", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e2) {
                Field field = helper.getDeclaredField("jvm");
                field.setAccessible(true);
                vmManagement = field.get(null);
                field.setAccessible(false);
            }
            return (List)vmMgmt.getMethod("getVmArguments", new Class[0]).invoke(vmManagement, new Object[0]);
        }
        catch (ReflectiveOperationException | UnsatisfiedLinkError e3) {
            try {
                Class<?> VMClass = Class.forName("com.ibm.oti.vm.VM");
                String[] argArray = (String[])VMClass.getMethod("getVMArgs", new Class[0]).invoke(null, new Object[0]);
                return Arrays.asList(argArray);
            }
            catch (ReflectiveOperationException e1) {
                return ManagementFactory.getRuntimeMXBean().getInputArguments();
            }
        }
    }

    private static boolean verifyAgentJar(File file) {
        boolean bl2;
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        JarFile jar = new JarFile(file);
        try {
            Manifest manifest = jar.getManifest();
            String premain = manifest.getMainAttributes().getValue("Premain-Class");
            bl2 = "com.contrastsecurity.agent.ContrastLoaderAgent".equals(premain);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        jar.close();
        return bl2;
    }
}

