/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.AppActivity;
import com.contrastsecurity.agent.apps.InventoryException;
import com.contrastsecurity.agent.apps.c;
import com.contrastsecurity.agent.apps.exclusions.ChainedExclusionProcessor;
import com.contrastsecurity.agent.apps.exclusions.DefaultExclusionProcessor;
import com.contrastsecurity.agent.apps.exclusions.d;
import com.contrastsecurity.agent.apps.exclusions.g;
import com.contrastsecurity.agent.apps.java.codeinfo.LibraryFacts;
import com.contrastsecurity.agent.commons.r;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.contrastapi_v1_0.HttpRequestDTM;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.messages.app.info.HTTPRoute;
import com.contrastsecurity.agent.messages.app.settings.ApplicationSettingsDTM;
import com.contrastsecurity.agent.messages.app.settings.RuleExceptionDTM;
import com.contrastsecurity.agent.messages.app.settings.SensitiveDataMaskingPolicyDTM;
import com.contrastsecurity.agent.o.e;
import com.contrastsecurity.agent.util.v;
import com.contrastsecurity.agent.x;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

@DontObfuscate
public class Application {
    private final com.contrastsecurity.agent.config.g config;
    @Deprecated
    private DefaultExclusionProcessor testExclusionProcessor;
    private final WeakReference<ClassLoader> classloaderRef;
    private final com.contrastsecurity.agent.f.b context;
    private final ConcurrentMap<String, LibraryFacts> libraryUsage;
    private final String classLoader;
    private final AtomicReference<AppActivity> activity;
    private final Set<String> technologies;
    private final String key;
    private final String resolvedFilePath;
    private final Collection<HTTPRoute> discoveredRoutes;
    private final b inventoryProvider;
    private final String version;
    private final Object createdLock = new Object();
    private final e eventListener;
    private String name;
    private String contextPath;
    private volatile boolean unwanted;
    private Collection<SoftReference<Runnable>> actionsBuffer = new ArrayList<SoftReference<Runnable>>();
    private boolean isDirty;
    private long lastReportedTime;
    private long lastActivityReportedTime;
    private long lastChangeOccurred;
    private boolean configuredAppNameUsed;
    @Deprecated
    private volatile g exclusionProcessor;
    private volatile long lastAppSettingsUpdatedProcessed;
    private volatile ApplicationSettingsDTM settingsDTM;
    private volatile c applicationState = c.a;
    private volatile com.contrastsecurity.agent.g.c dataMasker;
    @C
    static final String DEFAULT_ROOT_APP_NAME = "ROOT";
    @C
    static final String DEFAULT_CONTEXT_PATH = "/";
    private static final Logger logger = LoggerFactory.getLogger(Application.class);

    Application(String string, String string2, String string3, com.contrastsecurity.agent.config.g g2, String string4, String string5, b b2, com.contrastsecurity.agent.f.b b3, ClassLoader classLoader, e e2) {
        this(string, string2, string3, g2, string4, string5, b2, b3, classLoader, true, e2);
    }

    private Application(String string, String string2, String string3, com.contrastsecurity.agent.config.g g2, String string4, String string5, b b2, com.contrastsecurity.agent.f.b b3, ClassLoader classLoader, boolean bl2, e e2) {
        this.config = Objects.requireNonNull(g2);
        this.classloaderRef = new WeakReference<ClassLoader>(classLoader);
        this.classLoader = v.b(classLoader);
        this.technologies = new CopyOnWriteArraySet<String>();
        this.context = b3 == null ? new com.contrastsecurity.agent.f.c() : b3;
        this.libraryUsage = new ConcurrentHashMap<String, LibraryFacts>();
        this.testExclusionProcessor = new DefaultExclusionProcessor();
        this.exclusionProcessor = this.testExclusionProcessor;
        this.dataMasker = new com.contrastsecurity.agent.g.c(this.context, Collections.emptyList(), false, false);
        this.activity = new AtomicReference<AppActivity>(new AppActivity());
        this.contextPath = Application.checkContextPath(string2);
        this.key = string3 == null ? this.contextPath : string3;
        this.discoveredRoutes = new HashSet<HTTPRoute>();
        String string6 = StringUtils.trimToNull(string5);
        if (string6 != null && string6.length() > 256) {
            string6 = string6.substring(0, 256);
        }
        this.version = string6;
        String string7 = StringUtils.trimToNull(g2.b(this.context, ConfigProperty.APPLICATION_NAME));
        if (StringUtils.isNotBlank(string7)) {
            this.name = string7;
            this.configuredAppNameUsed = true;
        } else {
            this.name = StringUtils.isBlank(string) ? (DEFAULT_CONTEXT_PATH.equals(this.contextPath) ? StringUtils.defaultIfBlank(g2.b(this.context, ConfigProperty.ROOTAPP), DEFAULT_ROOT_APP_NAME) : StringUtils.removeStart(this.contextPath, DEFAULT_CONTEXT_PATH)) : string;
        }
        this.resolvedFilePath = string4 != null ? string4 : "";
        this.inventoryProvider = b2;
        this.eventListener = Objects.requireNonNull(e2);
        if (bl2) {
            this.readyForCreation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveredRoutes(Collection<HTTPRoute> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        Collection<HTTPRoute> collection2 = this.discoveredRoutes;
        synchronized (collection2) {
            this.discoveredRoutes.addAll(collection);
            logger.debug("{} routes added to application: {}", (Object)collection.size(), (Object)this);
        }
        this.markDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<HTTPRoute> getUnreportedDiscoveredRoutes() {
        Collection<HTTPRoute> collection = this.discoveredRoutes;
        synchronized (collection) {
            Set<Collection<HTTPRoute>> set = r.a(this.discoveredRoutes);
            this.discoveredRoutes.clear();
            return set;
        }
    }

    public void addIfAbsentLibraryFacts(String string, LibraryFacts libraryFacts) {
        this.setInventoryTags(libraryFacts);
        LibraryFacts libraryFacts2 = this.libraryUsage.putIfAbsent(string, libraryFacts);
        if (libraryFacts2 == null) {
            this.sendEventLibraryFound(libraryFacts);
        }
    }

    public void addLibraryFacts(String string, LibraryFacts libraryFacts) {
        this.setInventoryTags(libraryFacts);
        this.sendEventLibraryFound(libraryFacts);
        this.libraryUsage.put(string, libraryFacts);
    }

    public void addTechnology(String string) {
        this.technologies.add(string);
        this.markDirty();
    }

    @Deprecated
    public void addTestRuleExceptionDTM(RuleExceptionDTM ruleExceptionDTM) {
        logger.debug("Adding test exclusion");
        this.testExclusionProcessor.addRuleExceptionDTM(ruleExceptionDTM);
        logger.debug("Exclusion added to test processor, rebuilding app exclusions");
        this.refreshAppExclusions(this.settingsDTM);
    }

    @C
    public void applySettings(ApplicationSettingsDTM applicationSettingsDTM, long l2) {
        Objects.requireNonNull(applicationSettingsDTM);
        if (logger.isDebugEnabled()) {
            logger.debug("Applying app settings to {}", (Object)this.key);
        }
        this.settingsDTM = applicationSettingsDTM;
        this.refreshAppExclusions(applicationSettingsDTM);
        this.lastAppSettingsUpdatedProcessed = l2;
        SensitiveDataMaskingPolicyDTM sensitiveDataMaskingPolicyDTM = applicationSettingsDTM.getSensitiveDataMaskingPolicy();
        if (sensitiveDataMaskingPolicyDTM != null) {
            this.dataMasker = new com.contrastsecurity.agent.g.c(this.context, sensitiveDataMaskingPolicyDTM.rules(), sensitiveDataMaskingPolicyDTM.maskHttpBody(), sensitiveDataMaskingPolicyDTM.maskAttackVector());
        }
    }

    public AppActivity clearActivity() {
        return this.activity.getAndSet(new AppActivity());
    }

    public boolean containsTechnology(String string) {
        return this.technologies.contains(string);
    }

    public com.contrastsecurity.agent.f.b context() {
        return this.context;
    }

    public AppActivity getActivity() {
        return this.activity.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @C
    Collection<SoftReference<Runnable>> getActionsBuffer() {
        Object object = this.createdLock;
        synchronized (object) {
            return this.actionsBuffer;
        }
    }

    public Collection<LibraryFacts> getAllLibraryFacts() {
        return Collections.unmodifiableCollection(this.getLibraryUsage().values());
    }

    public ClassLoader getClassloader() {
        return (ClassLoader)this.classloaderRef.get();
    }

    public g getExclusionProcessor() {
        return this.exclusionProcessor;
    }

    @Deprecated
    @C
    public void setExclusionProcessor(g g2) {
        this.exclusionProcessor = g2;
    }

    public c getState() {
        return this.applicationState;
    }

    String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public long getLastActivityReportedTime() {
        return this.lastActivityReportedTime;
    }

    public void setLastActivityReportedTime(long l2) {
        this.lastActivityReportedTime = l2;
    }

    public long getLastAppSettingsUpdatedProcessed() {
        return this.lastAppSettingsUpdatedProcessed;
    }

    public long getLastChangeOccurred() {
        return this.lastChangeOccurred;
    }

    public long getLastReportedTime() {
        return this.lastReportedTime;
    }

    public void setLastReportedTime(long l2) {
        this.lastReportedTime = l2;
    }

    public Set<String> getLibraryFactNames() {
        return this.getLibraryUsage().keySet();
    }

    public LibraryFacts getLibraryFactsFor(String string) {
        return this.getLibraryUsage().get(string);
    }

    @C
    public Map<String, LibraryFacts> getLibraryUsage() {
        return this.libraryUsage;
    }

    public String getResolvedFilePath() {
        return this.resolvedFilePath;
    }

    public String getSessionId() {
        return this.config.b(this.context(), ConfigProperty.SESSION_ID);
    }

    @Deprecated
    @C
    public ApplicationSettingsDTM getSettingsDTM() {
        return this.settingsDTM;
    }

    public Set<String> getTechnologies() {
        return this.technologies;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasLibraryFactsFor(String string) {
        return this.getLibraryUsage().containsKey(string);
    }

    public com.contrastsecurity.agent.apps.a id() {
        return com.contrastsecurity.agent.apps.a.a(this.name);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isUnwanted() {
        return this.unwanted;
    }

    public void markClean() {
        this.isDirty = false;
        logger.debug("Application marked clean: {}", (Object)this);
    }

    void readyForCreation() {
        if (this.applicationState == c.a) {
            logger.debug("App ready for creation on remote server: {}", (Object)this);
            this.applicationState = c.b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void created() {
        if (this.applicationState.f()) {
            Collection<SoftReference<Runnable>> collection;
            logger.debug("App successfully created and ready for inventory: {}", (Object)this);
            Iterator<SoftReference<Runnable>> iterator = this.createdLock;
            synchronized (iterator) {
                this.applicationState = c.c;
                collection = this.actionsBuffer;
                this.actionsBuffer = new ArrayList<SoftReference<Runnable>>();
            }
            for (SoftReference<Runnable> softReference : collection) {
                Runnable runnable = softReference.get();
                if (runnable == null) continue;
                runnable.run();
            }
        }
    }

    public void markDirty() {
        this.isDirty = true;
        logger.debug("Application marked dirty: {}", (Object)this);
        long l2 = System.currentTimeMillis();
        logger.debug("Changing last change time for {} from {} to {}", this, this.lastChangeOccurred, l2);
        this.lastChangeOccurred = l2;
    }

    void inventoried() {
        if (this.applicationState == c.d) {
            logger.debug("App successfully inventoried: {}", (Object)this);
            this.applicationState = c.e;
            this.markDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenCreated(Runnable runnable) {
        Runnable runnable2 = null;
        Object object = this.createdLock;
        synchronized (object) {
            if (this.unwanted) {
                return;
            }
            if (this.applicationState.c()) {
                runnable2 = runnable;
            } else {
                this.actionsBuffer.add(new SoftReference<Runnable>(runnable));
            }
        }
        if (runnable2 != null) {
            runnable2.run();
        }
    }

    public void recreate() {
        if (this.applicationState.b()) {
            logger.debug("Remote server requested app recreation");
            this.applicationState = c.b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markUnwanted() {
        Object object = this.createdLock;
        synchronized (object) {
            this.unwanted = true;
            this.actionsBuffer.clear();
        }
    }

    public com.contrastsecurity.agent.g.c getDataMasker() {
        return this.dataMasker;
    }

    public com.contrastsecurity.agent.g.g<UserInputDTM> maskAttackVector(UserInputDTM userInputDTM) {
        return this.dataMasker.a(userInputDTM);
    }

    public com.contrastsecurity.agent.g.g<HttpRequestDTM> maskHttpRequest(HttpRequest httpRequest) {
        return httpRequest.toHttpRequestDTM(this.dataMasker);
    }

    public int numberOfLibraryFacts() {
        return this.getLibraryUsage().size();
    }

    boolean startInventory() {
        if (this.applicationState.a()) {
            this.applicationState = c.d;
            logger.debug("App inventory in progress {}", (Object)this);
            if (this.inventoryProvider != null) {
                this.inventoryProvider.a(this);
            }
        }
        return this.applicationState == c.d;
    }

    private void inventoryFailed(InventoryException inventoryException) {
        if (this.applicationState == c.d) {
            this.applicationState = c.c;
            logger.debug("App inventory failed {}", (Object)this, (Object)inventoryException);
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String toString() {
        return "Application{classLoader='" + this.classLoader + '\'' + ", key='" + this.key + '\'' + ", name='" + this.name + '\'' + ", resolvedFilePath='" + this.resolvedFilePath + '\'' + ", contextPath='" + this.contextPath + '\'' + ", applicationState=" + (Object)((Object)this.applicationState) + ", version='" + this.version + '\'' + '}';
    }

    private void refreshAppExclusions(ApplicationSettingsDTM applicationSettingsDTM) {
        LinkedList<g> linkedList = new LinkedList<g>();
        if (applicationSettingsDTM != null && applicationSettingsDTM.getExceptions() != null) {
            try {
                g g2 = d.a(applicationSettingsDTM.getExceptions());
                linkedList.add(g2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error("Problem parsing TeamServer exclusion settings", illegalArgumentException);
            }
        }
        if (this.testExclusionProcessor != null) {
            linkedList.add(this.testExclusionProcessor);
        }
        this.exclusionProcessor = new ChainedExclusionProcessor(Collections.unmodifiableList(linkedList));
    }

    private void sendEventLibraryFound(LibraryFacts libraryFacts) {
        this.eventListener.a(this, libraryFacts);
    }

    private void setInventoryTags(LibraryFacts libraryFacts) {
        if (libraryFacts == null) {
            return;
        }
        libraryFacts.setTags(StringUtils.trimToNull(this.config.b(this.context, ConfigProperty.INVENTORY_TAGS)));
    }

    private static String checkContextPath(String string) {
        return StringUtils.defaultIfBlank(StringUtils.trimToEmpty(string), DEFAULT_CONTEXT_PATH);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Application application = (Application)object;
        return Objects.equals(this.key, application.key);
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    @Deprecated
    public static abstract class b {
        private int b;
        static final Integer a = 5;

        void a(Application application) {
            if (++this.b <= a) {
                try {
                    this.b(application);
                }
                catch (InventoryException inventoryException) {
                    application.inventoryFailed(inventoryException);
                }
                return;
            }
            logger.debug("Stopped trying to inventory after the maximum number of attempts {}", (Object)a);
        }

        protected abstract void b(Application var1) throws InventoryException;
    }

    static final class a {
        private final Application a;
        private final boolean b;

        a(com.contrastsecurity.agent.config.g g2, e e2) {
            this.a = new Application(null, null, null, g2, null, null, null, null, x.a(Thread.currentThread()), false, e2);
            String string = StringUtils.trimToNull(g2.c(ConfigProperty.STANDALONE_APPNAME));
            if (string != null) {
                this.a.name = string;
                this.b = true;
            } else {
                this.b = false;
            }
        }

        boolean a() {
            return this.b;
        }

        Application b() {
            return this.a;
        }

        void a(String string, String string2) {
            if (this.a.getState().b()) {
                logger.debug("Cannot prepare app for creation as app is already resolved: {}", (Object)this.a);
                return;
            }
            if (!this.b && !this.a.configuredAppNameUsed && StringUtils.isNotBlank(string)) {
                this.a.name = string;
            }
            this.a.contextPath = Application.checkContextPath(string2);
            this.a.readyForCreation();
        }

        void c() {
            if (this.a.getState().d()) {
                this.a.applicationState = c.c;
                logger.debug("Marking app ready for re-inventory: {}", (Object)this);
            }
        }

        void a(Application application) {
            for (String object2 : application.getTechnologies()) {
                this.a.addTechnology(object2);
            }
            this.a.testExclusionProcessor = application.testExclusionProcessor;
            ArrayList arrayList = new ArrayList();
            g g2 = this.a.getExclusionProcessor();
            g g3 = application.getExclusionProcessor();
            if (g2 instanceof ChainedExclusionProcessor) {
                arrayList.addAll(((ChainedExclusionProcessor)g2).getProcessors());
            } else {
                arrayList.add(g2);
            }
            if (g3 instanceof ChainedExclusionProcessor) {
                arrayList.addAll(((ChainedExclusionProcessor)g3).getProcessors());
            } else {
                arrayList.add(g3);
            }
            this.a.exclusionProcessor = new ChainedExclusionProcessor(arrayList);
            Map<String, LibraryFacts> map = application.getLibraryUsage();
            for (Map.Entry<String, LibraryFacts> entry : map.entrySet()) {
                LibraryFacts libraryFacts = (LibraryFacts)this.a.libraryUsage.get(entry.getKey());
                if (libraryFacts == null) {
                    this.a.libraryUsage.put(entry.getKey(), entry.getValue());
                    continue;
                }
                libraryFacts.merge(entry.getValue());
            }
            AppActivity appActivity = this.a.getActivity();
            appActivity.merge(application.clearActivity());
            this.a.activity.set(appActivity);
            this.a.addDiscoveredRoutes(application.getUnreportedDiscoveredRoutes());
            application.markClean();
            logger.debug("Application successfully merged into DefaultApp: {}", (Object)application);
        }

        void d() {
            if (!this.a.unwanted) {
                logger.debug("Disabling the default application {}", (Object)this.a);
            }
            this.a.markUnwanted();
            this.a.applicationState = c.a;
            this.a.clearActivity();
            this.a.libraryUsage.clear();
        }
    }
}

