/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps.java.codeinfo;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.core.ContrastAgent;
import com.contrastsecurity.agent.messages.app.info.LibraryDTM;
import com.contrastsecurity.agent.util.f;
import com.contrastsecurity.thirdparty.com.google.gson.annotations.SerializedName;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@DontObfuscate
public final class LibraryFacts {
    private final String hash;
    private final Set<String> usedClasses = Collections.synchronizedSet(new HashSet());
    @SerializedName(value="file")
    private String jarName;
    private long internalDate;
    private long externalDate;
    private String manifestInfo;
    private int classCount;
    private URL url;
    private String versionCaptured;
    private String tags;

    @C
    public LibraryFacts() {
        this("hash");
    }

    public LibraryFacts(String string) {
        this.hash = Objects.requireNonNull(string, () -> "hash parameter cannot be null");
        this.versionCaptured = ContrastAgent.getBuildVersion();
    }

    public String getHash() {
        return this.hash;
    }

    public String getFile() {
        return this.jarName;
    }

    public void setFile(String string) {
        this.jarName = string != null ? string.toLowerCase() : null;
    }

    public Set<String> getUsedClasses() {
        return this.usedClasses;
    }

    public long getInternalDate() {
        return this.internalDate;
    }

    public void setInternalDate(long l2) {
        this.internalDate = l2;
    }

    public long getExternalDate() {
        return this.externalDate;
    }

    public void setExternalDate(long l2) {
        this.externalDate = l2;
    }

    public String getManifestInfo() {
        return this.manifestInfo;
    }

    public void setManifestInfo(String string) {
        this.manifestInfo = string;
    }

    public int getClassCount() {
        return this.classCount;
    }

    public void setClassCount(int n2) {
        this.classCount = n2;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public LibraryDTM toDTM() {
        return LibraryDTM.builder().file(this.getFile()).hash(this.getHash()).internalDate(this.getInternalDate()).externalDate(this.getExternalDate()).manifest(this.getManifestInfo()).classCount(this.getClassCount()).usedClassCount(this.getUsedClasses().size()).tags(this.getTags()).build();
    }

    public String getVersionCaptured() {
        return this.versionCaptured;
    }

    public void setVersionCaptured(String string) {
        this.versionCaptured = string;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String string) {
        this.tags = string;
    }

    public String toString() {
        return "\n\tHash    : " + this.getHash() + "\n\tIDate   : " + this.getInternalDate() + "\n\tEDate   : " + this.getExternalDate() + "\n\tClasses : " + this.classCount + "\n\tUsed    : " + this.getUsedClasses().size() + "\n\tManifest: " + this.getManifestInfo();
    }

    public synchronized void addUsedClass(String string) {
        if (f.a(string)) {
            return;
        }
        this.usedClasses.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void merge(LibraryFacts libraryFacts) {
        Set<String> set;
        Set<String> set2 = set = libraryFacts.getUsedClasses();
        synchronized (set2) {
            this.usedClasses.addAll(set);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LibraryFacts libraryFacts = (LibraryFacts)object;
        return this.hash.equals(libraryFacts.hash);
    }

    public int hashCode() {
        return this.hash.hashCode();
    }

    public static a builder() {
        return new a();
    }

    public static final class a {
        private String a;
        private String b;
        private long c;
        private long d;
        private String e;
        private int f;
        private URL g;
        private String h = ContrastAgent.getBuildVersion();
        private String i;

        private a() {
        }

        public a a(String string) {
            this.a = string;
            return this;
        }

        public a b(String string) {
            this.b = string;
            return this;
        }

        public a a(long l2) {
            this.c = l2;
            return this;
        }

        public a b(long l2) {
            this.d = l2;
            return this;
        }

        public a c(String string) {
            this.e = string;
            return this;
        }

        public a a(int n2) {
            this.f = n2;
            return this;
        }

        public a a(URL uRL) {
            this.g = uRL;
            return this;
        }

        public a d(String string) {
            this.h = string;
            return this;
        }

        public a e(String string) {
            this.i = string;
            return this;
        }

        public LibraryFacts a() {
            LibraryFacts libraryFacts = new LibraryFacts(this.a);
            libraryFacts.setFile(this.b);
            libraryFacts.setInternalDate(this.c);
            libraryFacts.setExternalDate(this.d);
            libraryFacts.setManifestInfo(this.e);
            libraryFacts.setClassCount(this.f);
            libraryFacts.setUrl(this.g);
            libraryFacts.setVersionCaptured(this.h);
            libraryFacts.setTags(this.i);
            return libraryFacts;
        }
    }
}

