/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.config;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.j;
import com.contrastsecurity.agent.commons.s;
import com.contrastsecurity.agent.config.a;
import com.contrastsecurity.agent.config.enums.SaveReportMode;
import com.contrastsecurity.agent.config.enums.TraceMapStrategy;
import com.contrastsecurity.agent.config.f;
import com.contrastsecurity.agent.config.k;
import com.contrastsecurity.agent.config.l;
import com.contrastsecurity.agent.config.m;
import com.contrastsecurity.agent.config.w;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.DiagnosticsDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.DiagnosticsLoggerDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsDTM;
import com.contrastsecurity.agent.e;
import com.contrastsecurity.agent.logging.b;
import com.contrastsecurity.agent.messages.app.settings.ApplicationAssessSettingsDTM;
import com.contrastsecurity.agent.messages.app.settings.ApplicationSettingsDTM;
import com.contrastsecurity.agent.messages.server.features.protect.LogLevel;
import com.contrastsecurity.agent.messages.server.features.protect.SyslogSeverity;
import com.contrastsecurity.agent.plugins.protect.Q;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@DontObfuscate
public enum ConfigProperty {
    ZOMBIE_CHECK_PERIOD_MS(k.a(Integer.class).a(10000).d().b("On IBM systems, Contrast periodically checks to see if it is preventing a graceful JVM shutdown. This is the period (in milliseconds) between these checks. A negative value disables the checks").a(Category.PERFORMANCE).b(f.a("agent.java.zombie_check_period_ms")).g()),
    TELEMETRY_SEMANTIC_SQL_START_DATE(k.a(String.class).a("2020-04-01").d().b("Date and time (format yyyy-MM-dd 00:00:00z) at which to start the Protect SQLi semantic analysis experiment").a(Category.DIAGNOSTICS).b(f.a("agent.java.stx.sqli_semantic.start_date")).g()),
    TELEMETRY_SEMANTIC_SQL_EXPIRATION_DATE(k.a(String.class).a("2020-05-01").d().b("Date and time (format yyyy-MM-dd 00:00:00z) after which to the Protect SQLi semantic analysis experiment expires").a(Category.DIAGNOSTICS).b(f.a("agent.java.stx.sqli_semantic.expired_date")).g()),
    TELEMETRY_SEMANTIC_SQL_REPORT_INTERVAL(k.a(Long.class).a(300000L).d().b("Interval in millis for reporting Protect SQLi semantic analysis telemetry data").a(Category.DIAGNOSTICS).b(f.a("agent.java.stx.sqli_semantic.report_interval_ms")).g()),
    TELEMETRY_SEMANTIC_SQL_SAMPLE_SPACING(k.a(Integer.class).a(300000).d().b("frequency (expres in number of queries) with which to report SQL queries for the Protect SQLi semantic analysis experiment").a(Category.DIAGNOSTICS).b(f.a("agent.java.stx.sqli_semantic.sample_spacing")).g()),
    USE_RUNTIME_CACHE(k.a(Boolean.class).a((Boolean)true).d().b("Set to false to force the agent to discover the Java runtime class hierarchy each time it starts up. You might want to do this if there is reason to believe our pre-cached snapshot of the runtime hierarchy is insufficient, but it will increase agent startup time. By default the agent uses a prepackaged cache to improve startup time.").a(Category.PERFORMANCE).b(f.a("agent.java.runtime_hierarchy_cache")).g()),
    AGENT_METADATA(k.a(String.class).a("contrast.agent.metadata").c().b("Metadata from the agent to Contrast UI defined. The format should be HTTP Request header compatible where key=value pairs are separated by semicolons. Spaces between key and value and between entries is not significant. (e.g. key=value; key=value)").a(Category.GENERAL_PROPERTIES).b(f.a("application.metadata", true)).g()),
    SESSION_ID(k.a(String.class).c().b("Provide the ID of a session which already exists in the Contrast UI. Vulnerabilities discovered by the agent are associated with this session. If an invalid ID is supplied, the agent will be disabled. This option and `application.session_metadata` are mutually exclusive; if both are set, the agent will be disabled.").a(Category.GENERAL_PROPERTIES).f().b(f.a("application.session_id", true)).g()),
    SESSION_METADATA(k.a(String.class).c().b("Provide metadata which is used to create a new session ID in the Contrast UI. Vulnerabilities discovered by the agent are associated with this new session. This value should be formatted as key=value pairs (conforming to RFC 2253). Available key names for this configuration are branchName, buildNumber, commitHash, committer, gitTag, repository, testRun, and version. This option and `application.session_id` are mutually exclusive; if both are set the agent will be disabled.").a(Category.GENERAL_PROPERTIES).b(f.a("application.session_metadata", true)).g()),
    PROBABILISTIC_STARTUP(k.a(Integer.class).a((Integer)((Object)"contrast.startup.probabilistic")).a(-1).d().b("the percentage chance that the agent should startup (values are 1-99 inclusive)").a(Category.GENERAL_PROPERTIES).b(f.a("agent.probabilistic_startup")).g()),
    INVENTORY_PRUNE_LIBRARY_MANIFEST(k.a(Boolean.class).a((Boolean)((Object)"contrast.inventory.prune.library.manifest")).a((Boolean)true).b("limits the manifest information reported for libraries").a(Category.GENERAL_PROPERTIES).b(f.a("inventory.prune_package_details")).g()),
    INVENTORY_LIBRARIES(k.a(Boolean.class).a((Boolean)((Object)"contrast.inventory.libraries")).a((Boolean)true).b("controls whether libraries are analyzed").a(Category.GENERAL_PROPERTIES).b(f.a("inventory.analyze_libraries")).g()),
    LIBRARY_USAGE_REPORTING(k.a(Boolean.class).a((Boolean)((Object)"contrast.libraries.reporting")).a((Boolean)true).b("controls whether library usage is reported").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.library_usage.reporting.enable")).g()),
    EFFECTIVE_CONFIG_REPORTING(k.a(Boolean.class).a((Boolean)true).b("controls whether effective config is reported").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.effective_config.reporting.enable")).g()),
    COLLAPSING_QUEUE_SIZE(k.a(Integer.class).a(5000).d().b("Set the maximum size (in number of items) of the buffer used to collapse pending reports.").a(Category.INTERNAL_USAGE).b(f.a("agent.java.reporting.collapsing_queue_size")).g()),
    PRINT_THREAD_DUMP_ON_SHUTDOWN(k.a(Boolean.class).a((Boolean)false).a(Category.INTERNAL_USAGE).d().b("Set to to true to configure the JVM to print a summary of all threads and to stdout, identifying those that are deadlocked, when the JVM is shut down.").b(f.a("agent.java.print_thread_dump_on_shutdown")).g()),
    COLLAPSING_WINDOW(k.a(Long.class).a(15000L).d().b("Set the time (in milliseconds) to wait before collapsing pending reports. Longer wait times may reduce the network traffic at the expense of consuming more memory.").a(Category.INTERNAL_USAGE).b(f.a("agent.java.reporting.collapsing_window_ms")).g()),
    AGENT_LOCATION(k.a(String.class).a("contrast.agent.location").c().d().b("set by the launcher agent to tell agents where the location of the agent jar").a(Category.INTERNAL_USAGE).d("TODO: looks launcher related. Remove.").g()),
    USE_HTTP_COMPRESSION(k.a(Boolean.class).a((Boolean)((Object)"contrast.agent.http.compression")).a((Boolean)true).d().b("set for debugging purposes, tells the Agent not to compress HTTP Request payloads; default true").a(Category.INTERNAL_USAGE).b(f.a("agent.java.enable_http_compression")).g()),
    IGNORE_CERTIFICATE_ERRORS(k.a(Boolean.class).a((Boolean)((Object)"contrast.agent.http.ignorecerterrors")).a((Boolean)false).b("whether certificate errors are ignored when talking to TeamServer").a(Category.DIAGNOSTICS).b(f.a("api.ignore_cert_errors", j.a("contrast.ignore_cert_errors"))).g()),
    ISOLATED_SOCKET_FACTORY(k.a(Boolean.class).a((Boolean)false).d().b("Configure the agent to use an isolated socket strategy to avoid conflicts with container socket strategies").a(Category.DIAGNOSTICS).b(f.a("agent.java.isolated_socket_factory")).g()),
    EXPLICIT_SNI_SOCKET_FACTORY(k.a(Boolean.class).a((Boolean)false).d().b("set SNI information on TLS extension manually to avoid JDK bugs where the information is not sent in niche cases").a(Category.DIAGNOSTICS).b(f.a("api.explicit_sni_socket_factory")).g()),
    MQ_TELEMETRY(k.a(Boolean.class).a((Boolean)((Object)"contrast.mq")).a((Boolean)false).d().b("true, if the agent should send telemetry MQ messages -- false otherwise").a(Category.INTERNAL_USAGE).b(f.a("agent.java.mq_reporter.enable")).g()),
    MQ_HOST_NAME(k.a(String.class).a("contrast.mq.host.name").a("localhost").d().b("if contrast.mq is true, this allows us to specify the MQ host name").a(Category.INTERNAL_USAGE).b(f.a("agent.java.mq_reporter.hostname")).g()),
    MQ_PORT(k.a(Integer.class).a((Integer)((Object)"contrast.mq.host.port")).a(5672).d().b("if contrast.mq is true, this allows us to specify the MQ port").a(Category.INTERNAL_USAGE).b(f.a("agent.java.mq_reporter.port")).g()),
    MQ_USERNAME(k.a(String.class).c().d().b("Optional property, if contrast.mq is true, this allows us to specify the username for the MQ connection").a(Category.INTERNAL_USAGE).b(f.a("agent.java.mq_reporter.username")).g()),
    MQ_PASSWORD(k.a(String.class).c().d().b("Optional property, if contrast.mq is true, this allows us to specify the password for the MQ connection").a(Category.INTERNAL_USAGE).b(f.a("agent.java.mq_reporter.password")).g()),
    MQ_QUEUE_NAME(k.a(String.class).a("contrast.mq.queue.name").a("contrastEvents").d().b("if contrast.mq is true, this allows us to specify the MQ queue name").a(Category.INTERNAL_USAGE).b(f.a("agent.java.mq_reporter.queue_name")).g()),
    LOG_CONTEXT_SWITCH(k.a(String.class).a("NONE").d().b("set for debugging purposes, tells the Agent how much detail to log when context switching. Valid values are NONE (the default), IDENTITY, and FULL. If debug logs are not enabled, this property has no effect. See JAVA-3308 for more details.").a(Category.INTERNAL_USAGE).b(f.a("agent.java.log_context_switch")).g()),
    DIAGNOSTICS_LOGGER_ENABLE(k.a(Boolean.class).a((Boolean)false).d().b("Enables the agent diagnostics logger which will stream logs to a remote collector.").a(Category.DIAGNOSTICS).b(f.a("agent.diagnostics.logger.enable")).a(serverSettingsDTM -> {
        DiagnosticsLoggerDTM diagnosticsLoggerDTM = ConfigProperty.getDiagnosticsLogger(serverSettingsDTM);
        if (diagnosticsLoggerDTM == null) {
            return null;
        }
        return diagnosticsLoggerDTM.isEnabled();
    }).g()),
    DIAGNOSTICS_LOGGER_LEVEL(k.a(String.class).a(b.e.toString()).d().b("The log level for the diagnostics logger.").a(Category.DIAGNOSTICS).b(f.a("agent.diagnostics.logger.level")).a(serverSettingsDTM -> {
        DiagnosticsLoggerDTM diagnosticsLoggerDTM = ConfigProperty.getDiagnosticsLogger(serverSettingsDTM);
        if (diagnosticsLoggerDTM == null) {
            return null;
        }
        LogLevel logLevel = diagnosticsLoggerDTM.getLevel();
        if (logLevel == null) {
            return null;
        }
        return logLevel.name();
    }).g()),
    DIAGNOSTICS_LOGGER_EXPIRATION_TIME_MS(k.a(Long.class).a(-1L).b("The expiration time for diagnostics (in milliseconds since the Unix Epoch, 1970-01-01). Defaults to 1 hour from when diagnostics start. Maximum is 24 hours from when diagnostics start.").a(Category.DIAGNOSTICS).b(f.a("agent.diagnostics.logger.expires_ms")).a(serverSettingsDTM -> {
        DiagnosticsLoggerDTM diagnosticsLoggerDTM = ConfigProperty.getDiagnosticsLogger(serverSettingsDTM);
        if (diagnosticsLoggerDTM == null) {
            return null;
        }
        return diagnosticsLoggerDTM.getExpiresMs();
    }).g()),
    DIAGNOSTICS_LOGGER_UUID(k.a(String.class).c().b("The unique identifier for the current diagnostics logger collection. Defaults to a new UUID if none is provided.").a(Category.DIAGNOSTICS).b(f.a("agent.diagnostics.logger.uuid")).a(serverSettingsDTM -> {
        DiagnosticsLoggerDTM diagnosticsLoggerDTM = ConfigProperty.getDiagnosticsLogger(serverSettingsDTM);
        if (diagnosticsLoggerDTM == null) {
            return null;
        }
        return diagnosticsLoggerDTM.getUuid();
    }).g()),
    DIAGNOSTICS_LOGGER_BACKOFF_FACTOR_MS(k.a(Long.class).a(1000L).d().b("The factor which will be multiplied by the exponential backoff factor to obtain the total backoff milliseconds when retrying Diagnostics requests.").a(Category.DIAGNOSTICS).b(f.a("agent.java.diagnostics.logger.backoff_factor_ms")).g()),
    DIAGNOSTICS_LOGGER_MAX_TOTAL_BACKOFF_MS(k.a(Long.class).a(60000L).d().b("The maximum total backoff in milliseconds that should be used when retrying Diagnostics logger requests. Once this maximum is exceeded, no more retries will be attempted for the specific failed request.").a(Category.DIAGNOSTICS).b(f.a("agent.java.diagnostics.logger.max_backoff_ms")).g()),
    DIAGNOSTICS_LOGGER_BATCHING_TIMEOUT_MS(k.a(Long.class).a(5000L).d().b("The time the Diagnostics logger will wait before forcing a (non-full) batch of logs to be sent to the collector.").a(Category.DIAGNOSTICS).b(f.a("agent.java.diagnostics.logger.batching_timeout_ms")).g()),
    DIAGNOSTICS_LOGGER_MAX_BATCH_SIZE(k.a(Integer.class).a(128).d().b("Specify the number of messages that will be batched and sent to the Diagnostics logger.").a(Category.DIAGNOSTICS).b(f.a("agent.java.diagnostics.logger.batch_size")).g()),
    DIAGNOSTICS_LOGGER_BUFFER_SIZE(k.a(Integer.class).a(-1).d().b("Specify the Diagnostics logger buffer size cap. Must be a power of 2. The default is 128. The default if the agent is in DEBUG mode or higher is 16384. Log messages are dropped if the buffer exceeds the size.").a(Category.DIAGNOSTICS).b(f.a("agent.java.diagnostics.logger.buffer_size")).g()),
    LOGGER_CLOCK_CLASS(k.a(String.class).c().d().b("The class to be used for the logger's clock. Only used for testing.").a(Category.INTERNAL_USAGE).b(f.a("agent.java.logger.clock_class")).g()),
    DIAGNOSTICS_LOGGER_SLEEPER_CLASS(k.a(String.class).c().d().b("The class to be used for the Diagnostics logger streaming thread sleeper. Only used for testing. Defaults to " + s.class.getTypeName()).a(Category.INTERNAL_USAGE).b(f.a("agent.java.diagnostics.logger.sleeper_class")).g()),
    DIAGNOSTICS_LOGGER_JITTER_CLASS(k.a(String.class).c().d().b("The class to be used for the diagnostics logger streaming thread jitter provider. Only used for testing. Defaults to com.contrastsecurity.agent.logging.log4j2.plugins.OtelAppender$DefaultJitter.").a(Category.INTERNAL_USAGE).b(f.a("agent.java.diagnostics.logger.jitter_class")).g()),
    PROFILE_PURGEABLES(k.a(Boolean.class).a((Boolean)((Object)"contrast.profile.purgeables")).a((Boolean)false).d().b("set for debugging purposes, tells the Agent to print to stdout purgeable metrics").a(Category.INTERNAL_USAGE).b(f.a("agent.java.report_purgeables")).g()),
    PROFILE_CONTEXT_METRICS(k.a(Boolean.class).a((Boolean)((Object)"contrast.profile.contextmetrics")).a((Boolean)false).d().b("set for debugging purposes, tells the Agent to print to stdout metrics about per-request data collection").a(Category.INTERNAL_USAGE).b(f.a("agent.java.report_context_metrics")).g()),
    PROFILE_STARTUP(k.a(Boolean.class).a((Boolean)((Object)"contrast.profile.startup")).a((Boolean)false).d().b("set for debugging purposes, tells the Agent to print to stdout startup metrics").a(Category.INTERNAL_USAGE).d("The YAML property cannot be used since this property is obtained before the Config object is created. This property can only be set as a system property: -Dcontrast.profile.startup}").g()),
    CONTEXT_MAP_PURGE_TIMEOUT(k.a(Integer.class).a((Integer)((Object)"contrast.context.purge.timeout")).a(30000).d().b("number of milliseconds to allow strongly reachable threads to pass thread context. Defaults to 30000(30 seconds in milliseconds).").a(Category.INTERNAL_USAGE).b(f.a("agent.java.context_thread_timeout_ms")).g()),
    CONTEXT_MAP_PURGE_ENTRY_MINIMUM(k.a(Integer.class).a((Integer)((Object)"contrast.context.purge.minimum")).a(350).d().b("number of threads to concurrently manage in our context manager before we proactively purge strongly reachable threads").a(Category.INTERNAL_USAGE).b(f.a("agent.java.context_minimum_threads")).g()),
    WEB_SESSION_TIMEOUT(k.a(Integer.class).a(30).b("Overrides the maximum \"safe\" session timeout value to check against the <session-timeout> detected in the application web.xml file, ServletContext.setSessionTimeout(int), or Spring Boot application.properties. The default value is 30 (minutes).").a(Category.RULES_CONFIG).b(f.a("agent.java.web_session_timeout")).g()),
    JACKSON_INTERN_ENABLE(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jackson.interning")).a((Boolean)true).b("Controls whether String interning is disabled in Jackson. The default value is true.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.enable_jackson_intern")).g()),
    SUPPORTER_AKKA(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.akka")).a((Boolean)true).d().b("boolean to enable/disable Akka support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_akka_support")).g()),
    SUPPORTER_ANTLR(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.antlr")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of standard Antlr classes").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_antlr_support")).g()),
    SUPPORTER_APACHE_FILE_UPLOAD(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache.file.uploader")).a((Boolean)true).d().b("boolean enable/disable support of Apache Commons FileUpload library").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_apache_fileupload_support")).g()),
    SUPPORTER_APACHE_ACTIVEMQ(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache.activemq")).a((Boolean)true).d().b("boolean enable/disable support of Apache ActiveMQ library").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_activemq_support")).g()),
    SUPPORTER_APACHE_CLIENT(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache.client")).a((Boolean)true).d().b("boolean enable/disable support of Apache HTTP Client").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_apache_client_support")).g()),
    SUPPORT_APACHE_REQUEST(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache.request")).a((Boolean)true).d().b("boolean enable/disable support of Apache Request Library").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_apache_request_support")).g()),
    SUPPORTER_APP_DYNAMICS(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.appdynamics")).a((Boolean)false).d().b("boolean enable/disable support of special sensors to avoid conflicts with AppDynamics").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_app_dynamics_support")).g()),
    SUPPORTER_APACHE(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.apache")).a((Boolean)true).d().b("boolean to enable/disable support/instrumentation of Apache HTTP libraries").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_apache_http_support")).g()),
    SUPPORTER_AWS(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.aws")).a((Boolean)true).d().b("boolean to enable/disable support/instrumentation of AWS HTTP client").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_aws_client_support")).g()),
    SUPPORTER_AWS_DYNAMODB(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.aws_dynamodb")).a((Boolean)true).d().b("boolean to enable/disable support/instrumentation of AWS Dynamo client").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_aws_dynamo_support")).g()),
    SUPPORTER_CARBON(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.carbon")).a((Boolean)true).d().b("boolean to enable/disable support for Carbon").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_carbon_support")).g()),
    SUPPORTER_STRUTS1(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.struts1")).a((Boolean)true).d().b("boolean to enable/disable support for Struts1 applications").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_struts1_support")).g()),
    SUPPORTER_STRUTS2(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.struts2")).a((Boolean)true).d().b("boolean to enable/disable support for Struts2 applications").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_struts2_support")).g()),
    SUPPORTER_CLASSLOADING(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.classloading")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of ClassLoaders").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_classloading_support")).g()),
    SUPPORTER_COVERITY(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.coverity")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of Coverity").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_coverity_support")).g()),
    SUPPORTER_CODE_EXCLUSIONS(k.a(Boolean.class).a((Boolean)true).d().b("boolean to enable/disable instrumentation of code exclusion classes").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_code_exclusion_support")).g()),
    SUPPORTER_CONCURRENCY(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.concurrency")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of Java Concurrency classes").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_concurrency_support")).g()),
    SUPPORTER_FRAMEWORK_DEBUGGER(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.framework.debugging")).a((Boolean)true).d().b("boolean to enable/disable support for framework debugging").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_framework_debugging_support")).g()),
    SUPPORTER_DROPWIZARD(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.dropwizard")).a((Boolean)true).d().b("boolean to enable/disable support for DropWizard applications").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_dropwizard_support")).g()),
    SUPPORTER_DWR(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.dwr")).a((Boolean)true).d().b("boolean to enable/disable Direct Web Remoting support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_dwr_support")).g()),
    SUPPORTER_ESAPI(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.esapi")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of ESAPI classes").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_esapi_support")).g()),
    SUPPORTER_FREEMARKER(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.freemarker")).a((Boolean)true).d().b("boolean to enable/disable FreeMarker support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_freemarker_support")).g()),
    SUPPORTER_GRIZZLY(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.grizzly")).a((Boolean)true).d().b("boolean to enable/disable Grizzly support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_grizzly_support")).g()),
    SUPPORTER_GLOWROOT(k.a(Boolean.class).a((Boolean)true).d().b("boolean to enable/disable Glowroot support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_glowroot_support")).g()),
    SUPPORTER_GRAILS(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.grails")).a((Boolean)true).d().b("boolean to enable/disable Grails support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_grails_support")).g()),
    SUPPORTER_GROOVY(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.groovy")).a((Boolean)true).d().b("boolean to enable/disable Groovy support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_groovy_support")).g()),
    SUPPORTER_HIBERNATE(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.hibernate")).a((Boolean)true).d().b("boolean to enable/disable Hibernate support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_hibernate_support")).g()),
    SUPPORTER_HTTP4K(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.http4k")).a((Boolean)true).d().b("boolean to enable/disable Http4k support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_http4k_support")).g()),
    SUPPORTER_JBOSS(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jboss")).a((Boolean)true).d().b("boolean to enable/disable JBoss support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_jboss_support")).g()),
    SUPPORTER_J2EE(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.j2ee")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of standard J2EE servlet classes").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_j2ee_support")).g()),
    SUPPORTER_JASPER(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jasper")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of standard Apache's Jasper classes").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_jasper_support")).g()),
    SUPPORTER_JDK_HTTP_SERVER(k.a(Boolean.class).a((Boolean)false).d().b("boolean to enable/disable instrumentation of the built-in JDK HTTP server").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_jdk_http_server_support")).g()),
    SUPPORTER_JETTY(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jetty")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of standard Jetty classes").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_jetty_support")).g()),
    SUPPORTER_JMS(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jms")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of standard JMS classes").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_jms_support")).g()),
    SUPPORTER_JSP(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jsp")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of compiled JSP classes").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_jsp_support")).g()),
    SUPPORTER_KAFKA(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.kafka")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of standard Kafka classes").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_kafka_support")).g()),
    SUPPORTER_LAMBDA(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.lambda")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of Java lambdas").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_lambda_support")).g()),
    SUPPORTER_LDAP(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.ldap")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of standard LDAP classes").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_ldap_support")).g()),
    SUPPORTER_LOG4J(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.log4j")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of standard Log4j classes").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_log4j_support")).g()),
    SUPPORTER_MODULE(k.a(Boolean.class).a((Boolean)true).d().b("boolean to enable/disable java.lang.Module and --illegal-access=deny support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_module_support")).g()),
    SUPPORTER_MONGO(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.mongo")).a((Boolean)true).d().b("boolean to enable/disable instrumentation of standard Mongo classes").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_mongo_support")).g()),
    SUPPORTER_JACKSON(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jackson")).a((Boolean)true).d().b("boolean to enable/disable Jackson support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_jackson_support")).g()),
    SUPPORTER_JAXB(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jaxb")).a((Boolean)true).d().b("boolean to enable/disable JAXB support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_jaxb_support")).g()),
    SUPPORTER_JAVAX_WS_RS(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.javax.ws.rs")).a((Boolean)true).d().b("boolean to enable/disable Javax support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_javax_ws_rs_support")).g()),
    SUPPORTER_JERSEY(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jersey")).a((Boolean)true).d().b("boolean to enable/disable Jersey support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_jersey_support")).g()),
    SUPPORTER_JSF(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jsf")).a((Boolean)true).d().b("boolean to enable/disable JSF support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_jsf_support")).g()),
    SUPPORTER_JSF_ADF(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jsf.adf")).a((Boolean)true).d().b("boolean to enable/disable JSF ADF support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_jsf_adf_support")).g()),
    SUPPORTER_JSF_TRINIDAD(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.jsf.trinidad")).a((Boolean)true).d().b("boolean to enable/disable JSF Apache Trinidad support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_jsf_trinidad_support")).g()),
    SUPPORTER_KRYO(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.kryo")).a((Boolean)true).d().b("boolean to enable/disable Kryo support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_kyro_support")).g()),
    SUPPORTER_LIFERAY(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.liferay")).a((Boolean)true).d().b("boolean to enable/disable Liferay support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_liferay_support")).g()),
    SUPPORTER_MINIDEV_JSON(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.minidevjson")).a((Boolean)true).b("boolean to enable/disable net.minidev.json support").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.enable_minidev_json_support")).g()),
    SUPPORTER_MULESOFT(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.mulesoft")).a((Boolean)false).d().b("boolean to enable/disable MuleSoft support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_mulesoft_support")).g()),
    SUPPORTER_MUSTACHE(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.mustache")).a((Boolean)true).d().b("boolean to enable/disable Mustache support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_mustache_support")).g()),
    SUPPORTER_NETTY(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.netty")).a((Boolean)true).d().b("boolean to enable/disable Netty support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_netty_support")).g()),
    SUPPORTER_OPEN_TELEMETRY(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.opentelemtetry")).a((Boolean)true).d().b("boolean to enable/disable OpenTelemetry support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_opentelemetry_support")).g()),
    SUPPORTER_ORACLE(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.oracle")).a((Boolean)true).d().b("boolean to enable/disable Oracle support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_oracle_support")).g()),
    SUPPORTER_OSGI(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.osgi")).a((Boolean)true).d().b("boolean to enable/disable OSGi support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_osgi_support")).g()),
    SUPPORTER_OUTSYSTEMS(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.outsystems")).a((Boolean)true).d().b("boolean to enable/disable OutSystems support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_out_systems_support")).g()),
    SUPPORTER_PLAY(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.play")).a((Boolean)true).d().b("boolean to enable/disable Play support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_play_support")).g()),
    SUPPORTER_QUARKUS(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.quarkus")).a((Boolean)true).d().b("boolean to enable/disable Quarkus related support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_quarkus_support")).g()),
    SUPPORTER_RABBITMQ(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.rabbitmq")).a((Boolean)true).d().b("boolean to enable/disable Rabbit MQ support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_rabbit_mq_support")).g()),
    SUPPORTER_RESIN(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.resin")).a((Boolean)true).d().b("boolean to enable/disable Resin support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_resin_support")).g()),
    SUPPORTER_RESTEASY(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.resteasy")).a((Boolean)true).d().b("boolean to enable/disable RESTEasy support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_resteasy_support")).g()),
    SUPPORTER_SCALA(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.scala")).a((Boolean)true).d().b("boolean to enable/disable Scala support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_scala_support")).g()),
    SUPPORTER_SECONDORDER_CANARIES(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.secondorder.canary")).a((Boolean)true).d().b("boolean to enable/disable second-order canary support.  see the option assess.second_order_canary for more configuration details.").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_secondorder_canary_support")).g()),
    SUPPORTER_SEAM(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.seam")).a((Boolean)true).d().b("boolean to enable/disable SEAM support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_seam_support")).g()),
    SUPPORTER_SECURITY_MANAGER(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.security_manager")).a((Boolean)true).d().b("boolean to enable/disable Security Manager support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_security_manager_support")).g()),
    SUPPORTER_SMAP(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.smap")).a((Boolean)true).d().b("boolean to enable/disable SMAP support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_smap_support")).g()),
    SUPPORTER_SQL(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.sql")).a((Boolean)true).d().b("boolean to enable/disable java.sql support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_java_sql_support")).g()),
    SUPPORTER_SPRINGBOOT(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.spring_boot")).a((Boolean)true).d().b("boolean to enable/disable Spring Boot support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_spring_boot_support")).g()),
    SUPPORTER_SPRING(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.spring")).a((Boolean)true).d().b("boolean to enable/disable Spring support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_spring_support")).g()),
    SUPPORTER_STRUTS(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.struts")).a((Boolean)true).d().b("boolean to enable/disable Struts support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_struts_support")).g()),
    SUPPORTER_TECHNOLOGY_DETECTION(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.technology.detection")).a((Boolean)true).d().b("boolean to enable/disable Technology Detection support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_technology_detection_support")).g()),
    SUPPORTER_TOMCAT(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.tomcat")).a((Boolean)true).d().b("boolean to enable/disable Tomcat support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_tomcat_support")).g()),
    SUPPORTER_UNDERTOW(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.undertow")).a((Boolean)true).d().b("boolean to enable/disable support for Undertow applications").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_undertow_support")).g()),
    SUPPORTER_URL(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.url")).a((Boolean)true).d().b("boolean to enable/disable java.net.URL support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_java_url_support")).g()),
    SUPPORTER_VERTX(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.vertx")).a((Boolean)true).d().b("boolean to enable/disable Vert.x support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_vertx_support")).g()),
    SUPPORTER_WEBLOGIC(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.weblogic")).a((Boolean)true).d().b("boolean to enable/disable Weblogic support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_weblogic_support")).g()),
    SUPPORTER_W3C(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.w3c")).a((Boolean)true).d().b("boolean to enable/disable W3C API support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_w3c_support")).g()),
    SUPPORTER_JAVA_STRING(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.string")).a((Boolean)true).d().b("boolean to enable/disable java.lang.String support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_java_string_support")).g()),
    SUPPORTER_JAVA_NIO(k.a(Boolean.class).a((Boolean)true).d().b("boolean to enable/disable java.nio support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_nio_support")).g()),
    SUPPORTER_WEBSPHERE(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.websphere")).a((Boolean)true).d().b("boolean to enable/disable WebSphere support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_websphere_support")).g()),
    SUPPORTER_CXF(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.cxf")).a((Boolean)true).d().b("boolean to enable/disable Apache CXF support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_cxf_support")).g()),
    SUPPORTER_POI(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.poi")).a((Boolean)true).d().b("boolean to enable/disable Apache POI support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_poi_support")).g()),
    SUPPORTER_XENON(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.xenon")).a((Boolean)true).d().b("boolean to enable/disable VMware Xenon support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_xenon_support")).g()),
    SUPPORTER_XSTREAM(k.a(Boolean.class).a((Boolean)((Object)"contrast.supporter.xstream")).a((Boolean)true).d().b("boolean to enable/disable XStream support").a(Category.FRAMEWORK_SUPPORT).b(f.a("java.agent.enable_xstream_support")).g()),
    CACHE_HIERARCHY(k.a(Boolean.class).a((Boolean)((Object)"contrast.cache.hierarchy")).a((Boolean)true).b("boolean to enable/disable hierarchy cache").a(Category.PERFORMANCE).b(f.a("assess.cache.hierarchy_enable")).g()),
    HIERARCHY_REBUILD(k.a(Boolean.class).a((Boolean)((Object)"contrast.hierarchy.rebuild")).a((Boolean)false).b("boolean to trigger rebuilding/resetting the hierarchy cache").a(Category.PERFORMANCE).b(f.a("assess.cache.hierarchy_rebuild")).g()),
    ASSESS_SNAPSHOT_CACHE_MAX_STRING_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.snapshotcache.maxstringsize")).a(8192).d().b("maximum size of a string that can be cached in snapshot cache").a(Category.PERFORMANCE).b(f.a("assess.cache.snapshot_cache_string_max", j.a("agent.cache.snapshot_cache_string_max"), false)).g()),
    ASSESS_SNAPSHOT_CACHE_MIN_STRING_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.snapshotcache.minstringsize")).a(4).d().b("minimum size of a string that can be cached in snapshot cache").a(Category.PERFORMANCE).b(f.a("assess.cache.snapshot_cache_string_min", j.a("agent.cache.snapshot_cache_string_min"), false)).g()),
    ASSESS_SNAPSHOT_CACHE_MAX_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.snapshotcache.maxcachesize")).a(4000000).d().b("maximum size of the assess snapshot cache (in total combined string size), must be divisible by 4").a(Category.PERFORMANCE).b(f.a("assess.cache.snapshot_cache_size_max", j.a("agent.cache.snapshot_cache_size_max"), false)).g()),
    HIERARCHY_UPDATE(k.a(Boolean.class).a((Boolean)((Object)"contrast.hierarchy.update")).a((Boolean)false).b("boolean to trigger updating the hierarchy cache").a(Category.PERFORMANCE).b(f.a("assess.cache.hierarchy_update")).g()),
    ANALYSIS_CACHE_MAX_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.analysiscache.size")).a(500000).d().b("maximum weighted size of the protect analysis cache. cache is weighted on total number of chars in each input value. This limits the usage of memory for the analysis cache. The default value of 500,000 limits usage to approximately 977 KB with 16bit char code units. This will vary depending on the JVM.").a(Category.PERFORMANCE).b(f.a("protect.cache.analysis_cache_size_max")).g()),
    ANALYSIS_CACHE_STRING_LIMIT(k.a(Integer.class).a((Integer)((Object)"contrast.analysiscache.stringlimit")).a(100000).d().b("maximum length in chars of a user input value that will be stored in the analysis cache. Larger values than this will not be cached.").a(Category.PERFORMANCE).b(f.a("protect.cache.analysis_cache_string_limit")).g()),
    ANALYSIS_CACHE_EXPIRY(k.a(Long.class).a((Long)((Object)"contrast.analysiscache.expiry.ms")).a(300000L).d().b("expiration time of elements within the analysis cache in milliseconds").a(Category.PERFORMANCE).b(f.a("protect.cache.analysis_cache_expiry_ms")).g()),
    NESTED_LIBS_DEPTH(k.a(Integer.class).a((Integer)((Object)"contrast.nested.libs.depth")).a(3).b("max archive unpacking depth when analyzing libraries").a(Category.GENERAL_PROPERTIES).b(f.a("inventory.library_depth")).g()),
    CLASSPATH_LIBS(k.a(Boolean.class).a((Boolean)((Object)"contrast.classpath.libs")).a((Boolean)false).b("Boolean to enable/disable analysis of libraries listed in java.class.path property. Determines whether Contrast will track usage of libraries listed in the environment's *java.class.path* property. This should only be on in J2SE/desktop situations.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.enable_classpath_libs")).g()),
    EVALUATE_PROTECT_TIMING_THRESHOLD(k.a(Long.class).a(60000L).d().b("Timing threshold to log potentially slow evaluations for Protect in milliseconds.  A value of 0 is disabled.").a(Category.DIAGNOSTICS).b(f.a("agent.java.protect_evaluate_timing_threshold")).g()),
    EXTERNAL_LIB_DIR(k.a(String.class).a("contrast.external.lib.dir").c().b("List of directories where external libraries are stored; used during library analysis, delimited by ';' on Windows and ':' on Unix").a(Category.GENERAL_PROPERTIES).b(f.a("inventory.library_dirs")).g()),
    APPLICATION_NAME(k.a(String.class).a("contrast.override.appname").c().b("sets the application name; this name will be reported to TeamServer").a(Category.GENERAL_PROPERTIES).b(f.a("application.name", true)).g()),
    APPLICATION_VERSION(k.a(String.class).a("contrast.override.appversion").c().b("sets the application version; this version will be reported to TeamServer").a(Category.GENERAL_PROPERTIES).b(f.a("application.version", true)).f().g()),
    CONCURRENT_REQUESTS(k.a(Integer.class).a((Integer)((Object)"contrast.concurrent.requests")).a(20).b("average number of concurrent users logged into the application at any one time").a(Category.PERFORMANCE).b(f.a("agent.concurrent_requests")).g()),
    STANDALONE_APPNAME(k.a(String.class).a("contrast.standalone.appname").c().b("Indicates the application is a standalone app with the provided name").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.standalone_app_name")).g()),
    TEAMSERVER_CHANNEL_PAUSE_PERIOD(k.a(Long.class).a((Long)((Object)"contrast.teamserver.channel.pause.period")).a(900000L).b("The amount of time to pause agent to TeamServer communication when a bad response code is received. 900000 (15 minutes in milliseconds).").a(Category.GENERAL_PROPERTIES).b(f.a("agent.polling.contrast_ui_channel_pause_period_ms")).g()),
    TEAMSERVER_URL(k.a(String.class).a("contrast.teamserver.url").b("Set the URL for the Contrast UI").a("https://app.contrastsecurity.com/Contrast").a(Category.GENERAL_PROPERTIES).b(f.a("api.url", j.a("contrast.url"))).g()),
    TEAMSERVER_HEARTBEAT_INTERVAL(k.a(Integer.class).a(30000).d().b("The interval of which to send heartbeat messages to the Contrast UI. (in milliseconds).  A value of -1 will disable the heartbeat.").a(Category.DIAGNOSTICS).b(f.a("agent.polling.heartbeat_ms")).g()),
    TEAMSERVER_STARTUP_RETRY_TIME_MS(k.a(Long.class).a(-1L).b("Set the time period to retry the initial connection to Contrast UI, after this timeout period is exceeded the agent will take action depending upon the associated failure_strategy property. The agent will immediately start as normal if the request succeeds. The default value is -1 indicating that retry is disabled. The expiry period must be longer than the retry_delay_ms setting.").a(Category.GENERAL_PROPERTIES).d().b(f.a("agent.startup.retry_expiry_ms")).g()),
    TEAMSERVER_STARTUP_RETRY_DELAY_TIME_MS(k.a(Long.class).a(500L).b("Set the time period to wait between retrying connecting to Contrast UI on startup. If the agent needs to retry the request it will sleep for this period in ms. The minimum allowed value is 500ms.").a(Category.GENERAL_PROPERTIES).d().b(f.a("agent.startup.retry_delay_ms")).g()),
    STARTUP_FAILURE_STRATEGY(k.a(String.class).a("continue").b("Set the action to take if the agent fails to start up correctly. Valid options are `continue` (default), `abort`. The `continue` option indicates the application continues without the agent being enabled. The abort option will stop the application if Contrast cannot startup and MUST be used with care.").a(Category.GENERAL_PROPERTIES).d().b(f.a("agent.startup.failure_strategy")).g()),
    SERVER_SETTINGS_POLL_INTERVAL_MS(k.a(Integer.class).a(30000).d().b("Set the frequency with which the agent sends server settings polls to the Contrast UI. This value is bounded within the agents, with a minimum of 1_000 and a maximum of 300_000.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.polling.server_settings_ms")).g()),
    TIMEOUT_MS(k.a(Integer.class).a(10000).b("This value can override the default timeout (in milliseconds) for communicating with TeamServer.").a(Category.GENERAL_PROPERTIES).b(f.a("api.timeout_ms", j.a("contrast.timeout_ms"))).g()),
    PROXY_ENABLED(k.a(String.class).a("contrast.proxy.enable").c().b("If present, determines whether the Agent should communicate with TeamServer over a proxy. Otherwise, enabled status is determined by the presence of a valid proxy host and port").a(Category.PROXY_SETTINGS).b(f.a("api.proxy.enable", j.a("contrast.proxy.enable"))).g()),
    PROXY_URL(k.a(String.class).a("contrast.proxy.url").c().b("Proxy url, e.g. https://host:port. This value should be set in place of scheme, host, and port settings. If both this and one of the others are set, a ContrastConfigurationException will be thrown").a(Category.PROXY_SETTINGS).b(f.a("api.proxy.url", j.a("contrast.proxy.url"))).g()),
    PROXY_PROTOCOL(k.a(String.class).a("contrast.proxy.protocol").c().b("Proxy protocol, e.g. http, https").a(Category.PROXY_SETTINGS).b(f.a("api.proxy.scheme", j.a("contrast.proxy.scheme"))).g()),
    PROXY_AUTH(k.a(String.class).c().b("Override authentication type for Proxy").a(Category.PROXY_SETTINGS).b(f.a("api.proxy.auth_type", j.a("contrast.proxy.auth_type"))).g()),
    PROXY_HOST(k.a(String.class).c().b("Override Host for Proxy").a(Category.PROXY_SETTINGS).b(f.a("api.proxy.host", j.a("contrast.proxy.host"))).g()),
    PROXY_PORT(k.a(Integer.class).a(0).b("Override Port for Proxy. Defaults to 0, an invalid port number.").a(Category.PROXY_SETTINGS).b(f.a("api.proxy.port", j.a("contrast.proxy.port"))).g()),
    PROXY_USER(k.a(String.class).c().b("Override User for Proxy").a(Category.PROXY_SETTINGS).b(f.a("api.proxy.user", j.a("contrast.proxy.user"))).g()),
    PROXY_PASSWORD(k.a(String.class).c().b("Override Password for Proxy").a(Category.PROXY_SETTINGS).e().b(f.a("api.proxy.pass", j.a("contrast.proxy.pass"))).g()),
    ACTIVITY(k.a(Boolean.class).a((Boolean)((Object)"contrast.activity")).a((Boolean)true).b("boolean to enable/disable the Contrast activity thread").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.enable_activity_thread")).g()),
    APP_ACTIVITY_PERIOD_MS(k.a(Long.class).a((Long)((Object)"contrast.app.activity.period")).a(30000L).b("Contrast app activity thread polling period in milliseconds. 30000 (30  seconds, in milliseconds)").a(Category.GENERAL_PROPERTIES).b(f.a("agent.polling.app_activity_ms")).g()),
    STALE_APP_ACTIVITY_UPDATE_MS(k.a(Long.class).a((Long)((Object)"contrast.stale.app.activity.update.ms")).a(TimeUnit.MINUTES.toMillis(5L)).b("The maximum amount of time to wait before requesting new \"application settings\" from TeamServer. Typically, the agent receives new settings each time it sends activity, but if there is no activity the agent will wait this long before requesting new settings. Defaults to " + TimeUnit.MINUTES.toMillis(5L) + " (5 minutes, in milliseconds)").a(Category.GENERAL_PROPERTIES).b(f.a("agent.polling.app_activity_stale_ms")).g()),
    APPUPDATE(k.a(Boolean.class).a((Boolean)((Object)"contrast.appupdate")).a((Boolean)true).b("boolean to enable/disable threads that sends updates about applications to Team Server").a(Category.GENERAL_PROPERTIES).b(f.a("application.enable_app_updates")).g()),
    APP_UPDATE_PERIOD(k.a(Long.class).a((Long)((Object)"contrast.app.update.period")).a(5000L).b("Contrast app update thread polling period in milliseconds").a(Category.GENERAL_PROPERTIES).b(f.a("agent.polling.app_update_ms")).g()),
    APP_UPDATE_STALE_THRESHOLD(k.a(Long.class).a((Long)((Object)"contrast.app.update.threshold")).a(1800000L).d().b("Even when no appupdate is warranted on client side, ask TeamServer via preflight if needed on this frequency. 30 mins, in milliseconds.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.polling.app_update_stale_threshold_ms")).g()),
    APP_FEATURES(k.a(String.class).a("contrast.app.features").c().b("JSON from disk to use for app").a(Category.GENERAL_PROPERTIES).b(f.a("application.app_features_file")).g()),
    DENYLIST_PATH(k.a(String.class).a("contrast.blacklist").c().b("The path to the file that lists classes currently on the denylist.  Classes listed here will be ignored by the agent.").a(Category.PERFORMANCE).b(f.a("agent.blacklist")).g()),
    PACKAGE_DENYLIST_PATH(k.a(String.class).c().d().b("The path to the file that lists packages currently on the denylist.  Classes with packages matching the prefixes listed will be ignore by the agent.  Packages should match the format \"com/example/\", without quotes.").a(Category.PERFORMANCE).b(f.a("agent.java.package_denylist")).g()),
    CLONEINPUT(k.a(Boolean.class).a((Boolean)((Object)"contrast.cloneinput")).a((Boolean)true).b("boolean to enable/disable cloning of tracked objects").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.enable_input_cloning")).g()),
    DEEP_CLONEINPUT(k.a(Boolean.class).a((Boolean)((Object)"contrast.deepclone")).a((Boolean)true).b("boolean to enable/disable cloning of leaf nodes in object graphs of deserialized objects").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.enable_deep_cloning")).g()),
    DEEP_TAINTKEYS(k.a(Boolean.class).a((Boolean)((Object)"contrast.deep.mapkeys")).a((Boolean)false).b("boolean to enable/disable tainting of keys in maps of deserialized objects").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.taint_map_key")).g()),
    DESERIALIZER_MAX_DEPTH(k.a(Integer.class).a((Integer)((Object)"contrast.deserializer.maxdepth")).a(10).d().b("The max depth to traverse and analyze deserialized objects in Protect. Set to 0 to disable deserialized object analysis.").a(Category.PERFORMANCE).b(f.a("agent.java.protect_deserialization_analysis_traversal_depth")).g()),
    SERVER_TYPE(k.a(String.class).a("contrast.container").c().b("manually override the web app container name/id").a(Category.GENERAL_PROPERTIES).b(f.a("server.type")).g()),
    WORKING_DIR(k.a(String.class).a("contrast.dir").c().b("This value can override the default location of the Contrast working directory. Defaults to ${HOME}/.contrast of the user account the application runs under.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.contrast_working_dir")).g()),
    SERVER_TAGS(k.a(String.class).c().b("comma separated list of tags to be sent with each server update and create").a(Category.GENERAL_PROPERTIES).b(f.a("server.tags")).g()),
    APPLICATION_TAGS(k.a(String.class).c().b("comma separated list of tags to be sent with each application message").a(Category.GENERAL_PROPERTIES).b(f.a("application.tags", true)).g()),
    INVENTORY_TAGS(k.a(String.class).c().b("comma separated list of tags to be sent with each inventory message").a(Category.GENERAL_PROPERTIES).b(f.a("inventory.tags", true)).g()),
    ASSESS_TAGS(k.a(String.class).c().b("comma separated list of tags to be sent with each assess message").a(Category.GENERAL_PROPERTIES).b(f.a("assess.tags", true)).g()),
    HTTP_ANALYSIS_PARAMETERS(k.a(Boolean.class).a((Boolean)((Object)"contrast.http.analysis.parameters")).a((Boolean)true).b("boolean to enable/disable analysis of HTTP parameters").a(Category.PERFORMANCE).b(f.a("agent.java.enable_http_parameter_analysis")).g()),
    DBINSPECTION(k.a(Boolean.class).a((Boolean)((Object)"contrast.dbinspection")).a((Boolean)true).b("boolean to enable/disable DB inspection when analyzing application architecture").a(Category.GENERAL_PROPERTIES).b(f.a("inventory.inspect_database")).g()),
    INVENTORY_MONITOR_LDAP(k.a(Boolean.class).a((Boolean)((Object)"contrast.monitorldap")).a((Boolean)true).b("boolean to enable/disable LDAP call counting and analysis").a(Category.GENERAL_PROPERTIES).b(f.a("inventory.inspect_ldap")).g()),
    INVENTORY_MONITOR_WEB_CALL(k.a(Boolean.class).a((Boolean)((Object)"contrast.monitorwebcalls")).a((Boolean)true).b("boolean to enable/disable web call counting and analysis, web calls being the HTTP requests made to this application").a(Category.GENERAL_PROPERTIES).b(f.a("inventory.inspect_web_calls")).g()),
    ENABLED(k.a(Boolean.class).a((Boolean)((Object)"contrast.enabled")).a((Boolean)true).b("Determines whether Contrast will monitor the JVM. You can use this feature to quickly turn Contrast on or off without removing the *-javaagent* flag.").a(Category.GENERAL_PROPERTIES).b(f.a("enable", j.a("contrast.enable"))).g()),
    LAST_CONFIG_PATH(k.a(String.class).a("contrast.last_config_path").c().b("The file to which the last configuration from TeamServer should be loaded or reloaded.").a(Category.GENERAL_PROPERTIES).b(f.a("api.last_config_path", j.a("contrast.last_config_path"))).g()),
    FEATUREJSON(k.a(String.class).a("contrast.featureJSON").c().d().b("location of features JSON").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.features_file_override")).g()),
    IDENTITYTAGS(k.a(Boolean.class).a((Boolean)((Object)"contrast.identitytags")).a((Boolean)true).b("boolean to enable/disable identity tags").a(Category.RULES_CONFIG).b(f.a("assess.enable_identity_tagging")).g()),
    JFR(k.a(Boolean.class).a((Boolean)false).d().b("boolean to enable/disable JFR event emitting").a(Category.DIAGNOSTICS).b(f.a("agent.java.enable_jfr_events")).g()),
    JMX(k.a(Boolean.class).a((Boolean)((Object)"contrast.jmx")).a((Boolean)false).d().b("boolean to enable/disable jmx support").a(Category.FRAMEWORK_SUPPORT).b(f.a("agent.java.enable_jmx_support")).g()),
    J2EE_CLASSCACHE(k.a(Boolean.class).a((Boolean)((Object)"contrast.j2ee.classcache")).a((Boolean)true).b("boolean to enable/disable caching of instrumented classes").a(Category.PERFORMANCE).b(f.a("agent.java.enable_j2ee_class_cache")).g()),
    J2EE_CONTEXT_DISCOVERY(k.a(Boolean.class).a((Boolean)((Object)"contrast.j2ee.context.discovery")).a((Boolean)true).d().b("boolean to enable/disable J2EE context discovery").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.j2ee_context_discovery")).g()),
    MODE(k.a(String.class).a("contrast.mode").c().d().b("Valid values: assess/defend/inventory/all. assess: data flow analysis, defend: defend features, inventory: library catalog and analysis, all: all features; Note when this property is enabled, the Agent will ignore all customizations from TeamServer.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.mode")).g()),
    ASSESS_ENABLED(k.a(Boolean.class).a((Boolean)((Object)"contrast.assess.enabled")).a((Boolean)false).b("If present, used to determine if the Assess feature should be enabled. If not present, decision delegated to Contrast UI").a(Category.GENERAL_PROPERTIES).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null) {
            return serverSettingsDTM.getAssess().getEnable();
        }
        return null;
    }).b(f.a("assess.enable")).g()),
    INVENTORY_ENABLED(k.a(Boolean.class).a((Boolean)((Object)"contrast.inventory.enabled")).a((Boolean)true).b("Used to determine if the Inventory feature should be enabled. Inventory encompasses several facets of application analysis including library detection and usage, HTTP call counting and database usage analysis").a(Category.GENERAL_PROPERTIES).b(f.a("inventory.enable")).g()),
    NOTEAMSERVER_ENABLE(k.a(Boolean.class).a((Boolean)((Object)"contrast.noteamserver.enable")).a((Boolean)false).d().b("boolean to enable/disable Contrast to start up without access to TeamServer").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.enable_disconnected_startup")).g()),
    SERVER_PATH(k.a(String.class).a("contrast.path").c().b("Contrast \"working directory\" override. Defaults to CWD.").a(Category.GENERAL_PROPERTIES).b(f.a("server.path")).g()),
    SERVER_VERSION(k.a(String.class).c().b("Overrides reported server version").a(Category.GENERAL_PROPERTIES).b(f.a("server.version")).g()),
    ROOTAPP(k.a(String.class).a("contrast.rootapp").c().b("This value can override (or provide one if none exist) a display name for the app running at the root context. This may be needed for Contrast to collect analytics on the application.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.root_app_name")).g()),
    SAMPLING(k.a(String.class).a("contrast.sampling").c().b("Enable and configure *sampling mode*. By default, just placing this flag will result in a *baseline* (how many times a request should be analyzed before it is considered sampled) and *frequency* (how often after the baseline has been established should new samples be taken) of **5** and a *sampling window* (how long the baseline is valid, in seconds) of **180 seconds**. This means that after the same request has been seen five times in 180 seconds, it will only be analyzed every subsequent fifth time. You can customize this further by setting the value to \"#,#,#\". In this case, the baseline will be set to the first number, the frequency second, and the window third. Note that if you choose to customize any value, you must provide all three inputs.").a(Category.PERFORMANCE).d("TODO: Do we still need this configuration?").g()),
    ASSESS_SAMPLING_ENABLED(k.a(Boolean.class).a((Boolean)((Object)"contrast.sampling.enabled")).a((Boolean)false).b("Enable sampling mode").a(Category.PERFORMANCE).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getSampling() != null) {
            return serverSettingsDTM.getAssess().getSampling().isEnabled();
        }
        return null;
    }).b(f.a("assess.sampling.enable")).g()),
    ASSESS_SAMPLING_BASELINE(k.a(Integer.class).a((Integer)((Object)"contrast.sampling.baseline")).a(5).b("indicates how many requests to analyze in each window before sampling begins").a(Category.PERFORMANCE).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getSampling() != null) {
            Integer n2 = serverSettingsDTM.getAssess().getSampling().getBaseline();
            return ConfigProperty.isPositive(n2) ? n2 : null;
        }
        return null;
    }).b(f.a("assess.sampling.baseline")).g()),
    ASSESS_SAMPLING_REQ_FREQUENCY(k.a(Integer.class).a((Integer)((Object)"contrast.sampling.request_frequency")).a(10).b("indicates every nth request (after baseline) will be analyzed").a(Category.PERFORMANCE).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getSampling() != null) {
            Integer n2 = serverSettingsDTM.getAssess().getSampling().getRequestFrequency();
            return ConfigProperty.isPositive(n2) ? n2 : null;
        }
        return null;
    }).b(f.a("assess.sampling.request_frequency")).g()),
    ASSESS_SAMPLING_RES_FREQUENCY(k.a(Integer.class).a((Integer)((Object)"contrast.sampling.response_frequency")).a(25).b("indicates every nth request (after baseline) will be analyzed").a(Category.PERFORMANCE).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getSampling() != null) {
            Integer n2 = serverSettingsDTM.getAssess().getSampling().getResponseFrequency();
            return ConfigProperty.isPositive(n2) ? n2 : null;
        }
        return null;
    }).b(f.a("assess.sampling.response_frequency")).g()),
    ASSESS_SAMPLING_WINDOW_MS(k.a(Integer.class).a((Integer)((Object)"contrast.sampling.window_ms")).a(180000).b("indicates duration for which a sample set is valid, in ms").a(Category.PERFORMANCE).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getAssess() != null && serverSettingsDTM.getAssess().getSampling() != null) {
            Integer n2 = serverSettingsDTM.getAssess().getSampling().getWindow();
            return ConfigProperty.isPositive(n2) ? Integer.valueOf(n2 * 1000) : null;
        }
        return null;
    }).b(f.a("assess.sampling.window_ms")).g()),
    FEATURE_REQUEST_SAMPLING_ENABLED(k.a(Boolean.class).a((Boolean)true).b("Set to false to disable features that use feature request sampling.").a(Category.INTERNAL_USAGE).b(true).b(f.a("agent.java.feature_request_sampling_enabled")).g()),
    FEATURE_REQUEST_SAMPLING_FREQUENCY(k.a(Integer.class).a(10000).b("").a(Category.INTERNAL_USAGE).b(true).b(f.a("agent.java.feature_request_sampling_frequency")).g()),
    SAVEBYTECODE(k.a(String.class).a("contrast.savebytecode").c().b("Output location of the saved *before/after bytecode* of classes where sensors have been added.").a(Category.DIAGNOSTICS).b(f.a("agent.java.save_bytecode")).g()),
    SAVERESULTS(k.a(String.class).a("contrast.saveresults").a("" + (Object)((Object)SaveReportMode.Never)).b("controls when Contrast findings are saved locally").a(Category.DIAGNOSTICS).b(f.a("assess.save_results")).g()),
    LOCAL_RESULTS_DIR(k.a(String.class).a("contrast.local.results.dir").c().b("controls where Contrast findings are saved locally").a(Category.DIAGNOSTICS).b(f.a("assess.local_results_dir")).g()),
    JARVERIFIER_OVERRIDE(k.a(Boolean.class).a((Boolean)((Object)"contrast.scoped.jarverifier")).a((Boolean)false).b("controls whether the JarInputStream verifier is disabled during our scoped operations").a(Category.DIAGNOSTICS).b(f.a("agent.java.override_scoped_jar_verifier")).g()),
    SCANRESPONSES(k.a(Boolean.class).a((Boolean)((Object)"contrast.scanresponses")).a((Boolean)true).b("boolean to enable/disable scanning of HTTP responses -- override for assess and protect").a(Category.GENERAL_PROPERTIES).d("CONTRAST-30445").g()),
    SCAN_ASSESS_RESPONSES(k.a(Boolean.class).a((Boolean)((Object)"contrast.assess.scanresponses")).a((Boolean)true).b("boolean to enable/disable scanning of HTTP responses -- assess only").a(Category.GENERAL_PROPERTIES).b(f.a("assess.enable_scan_response")).g()),
    SERVER_NAME(k.a(String.class).a("contrast.server").c().b("Overrides name of the server displayed in the Contrast TeamServer. Includes any valid path characters, e.g. *myserver-1/myapp* or *john_dev*.").a(Category.GENERAL_PROPERTIES).b(f.a("server.name")).g()),
    SERVER_ACTIVITY_PERIOD(k.a(Long.class).a((Long)((Object)"contrast.server.activity.period")).a(30000L).b("Polling period for TeamServer polling thread 30000 (30  seconds in milliseconds)").a(Category.GENERAL_PROPERTIES).b(f.a("agent.polling.server_activity_ms")).g()),
    STALE_SERVER_ACTIVITY_UPDATE_MS(k.a(Long.class).a((Long)((Object)"contrast.stale.server.activity.update.ms")).a(300000L).b("The maximum amount of time to wait before requesting new \"server settings\" from TeamServer. Typically, the agent receives new settings each time it sends activity, but if there is no activity the agent will wait this long before requesting new settings. (5 minutes, in milliseconds)").a(Category.GENERAL_PROPERTIES).b(f.a("agent.polling.server_activity_stale_ms")).g()),
    STACKS_MAXDEPTH(k.a(Integer.class).a((Integer)((Object)"contrast.stacks.maxdepth")).a(75).b("max stack depth to include in reported findings, minimum of 2").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.max_stack_depth")).g()),
    TELEMETRY_DIR(k.a(String.class).a("contrast.telemetry.dir").c().b("Location for Contrast telemetry output").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.telemetry_directory")).g()),
    USECONFIG(k.a(String.class).a("contrast.useconfig").c().b("use the contrast.config file packaged in another contrast.jar").a(Category.GENERAL_PROPERTIES).d("TODO: wait what? seriously?").g()),
    LOGGER_STDOUT(k.a(Boolean.class).a((Boolean)((Object)"contrast.stdout")).a((Boolean)false).b("When set to true, all logs will be written to stdout instead of the file system.  May be combined with the corresponding stderr configuration to write to both streams.").a(Category.DIAGNOSTICS).b(f.a("agent.logger.stdout")).g()),
    LOGGER_STDERR(k.a(Boolean.class).a((Boolean)((Object)"contrast.stderr")).a((Boolean)false).b("When set to true, all logs will be written to stderr instead of the file system. May be combined with the corresponding stdout configuration to write to both streams.").a(Category.DIAGNOSTICS).b(f.a("agent.logger.stderr")).g()),
    SUPPRESS_STDOUT(k.a(Boolean.class).a((Boolean)((Object)"contrast.stdout.quiet")).a((Boolean)false).b("When set to true, all normal stdout messages will be suppressed -- has no effects on file or syslog logging").a(Category.DIAGNOSTICS).d("TODO: why do we have this setting and `agent.logger.stdout`?").g()),
    SECURITY_LOGGER_LEVEL(k.a(String.class).a("contrast.security.log.level").a(b.c.toString()).b("Set the log level for security logging. Values include: trace, debug, info, warn, error, fatal, off. Setting this to off will disable security logging.").a(Category.LOGGING_PROTECT).b(f.a("agent.security_logger.level")).g()),
    LOGGER_LEVEL(k.a(String.class).a("contrast.level").a(b.c.toString()).b("Log output level").a(Category.LOGGING_ASSESS).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getLogger() != null) {
            LogLevel logLevel = serverSettingsDTM.getLogger().getLevel();
            return logLevel == null ? null : logLevel.name();
        }
        return null;
    }).b(f.a("agent.logger.level")).g()),
    SECURITY_LOGGER_FILE(k.a(String.class).a("contrast.security.log.file").a("security.log").b("The file to which logging of security events will occur. By default, this file is located at ${HOME}/.contrast/security.log.").a(Category.LOGGING_PROTECT).b(f.a("agent.security_logger.path")).g()),
    LOGGER_LOCATION(k.a(String.class).a("contrast.log").a("contrast.log").b("Enable *diagnostic logging*. This hurts performance, but generates useful information for debugging Contrast. The value set here will be the location to which log output is saved. If no log file exists at this location, one will be created. For instance, */opt/Contrast/contrast.log* will create a log in the */opt/Contrast* directory and rotate it automatically as needed. By default, this file is located at ${HOME}/.contrast/contrast.log").a(Category.LOGGING_ASSESS).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getLogger() != null) {
            return serverSettingsDTM.getLogger().getPath();
        }
        return null;
    }).b(f.a("agent.logger.path")).g()),
    SECURITY_LOGGER_DAILY(k.a(Boolean.class).a((Boolean)((Object)"contrast.security.log.daily")).a((Boolean)false).b("Change the Contrast security logger from a file sized based rolling scheme to a date based rolling scheme. At midnight server time, the previous day's log will be renamed to file_name.yyyy-MM-dd. Note, this scheme does not have a size limit, so manual log pruning will be required. This flag must be set to use the backups and size flags.").a(Category.LOGGING_PROTECT).b(f.a("agent.security_logger.roll_daily")).g()),
    LOGGER_DAILY(k.a(Boolean.class).a((Boolean)((Object)"contrast.log.daily")).a((Boolean)false).b("Change the Contrast logger from a file sized based rolling scheme to a date based rolling scheme. At midnight server time, the previous day's log will be renamed to file_name.yyyy-MM-dd. Note, this scheme does not have a size limit, so manual log pruning will be required. This flag must be set to use the backups and size flags.").a(Category.LOGGING_ASSESS).b(f.a("agent.logger.roll_daily")).g()),
    SECURITY_LOGGER_BACKUPS(k.a(Integer.class).a((Integer)((Object)"contrast.security.log.backups")).a(10).b("Specify the number of \"backup\" logs that will be created before Contrast will clean up the oldest file. This value has a cap of 100, meaning no more than 100 log files can be stored on the file system at one time. A value of 0 here means that no backups will be created and the log will simply be truncated when it reaches its size cap. Note: This property must be used with contrast.security.log.daily=false, or we will continue to log daily and disregard this limit.").a(Category.LOGGING_PROTECT).b(f.a("agent.security_logger.backups")).g()),
    LOGGER_BACKUPS(k.a(Integer.class).a((Integer)((Object)"contrast.log.backups")).a(10).b("Specify the number of \"backup\" logs that will be created before Contrast will clean up the oldest file. This value has a cap of 100, meaning no more than 100 log files can be stored on the file system at one time. A value of 0 here means that no backups will be created and the log will simply be truncated when it reaches its size cap. Note: This property must be used with contrast.log.daily=false, or we will continue to log daily and disregard this limit.").a(Category.LOGGING_ASSESS).b(f.a("agent.logger.backups")).g()),
    SECURITY_LOGGER_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.security.log.size")).a(100).b("Specify the file size cap, in MB, of each log file. By default, this value is \"100\". Note: This property must be used with contrast.log.daily=false, or we will continue to log daily and disregard this limit.").a(Category.LOGGING_PROTECT).b(f.a("agent.security_logger.roll_size")).g()),
    SECURITY_LOGGER_BUFFER_SIZE(k.a(Integer.class).a(-1).d().b("Specify the Security logger buffer size cap. Must be a power of 2. The default is 128. Log messages are dropped if the buffer exceeds the size.").a(Category.LOGGING_PROTECT).b(f.a("agent.java.security_logger.buffer_size")).g()),
    LOGGER_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.log.size")).a(100).b("Specify the file size cap, in MB, of each log file. By default, this value is \"100\". Note: This property must be used with contrast.log.daily=false, or we will continue to log daily and disregard this limit.").a(Category.LOGGING_ASSESS).b(f.a("agent.logger.roll_size")).g()),
    LOGGER_BUFFER_SIZE(k.a(Integer.class).a(-1).d().b("Specify the Contrast logger buffer size cap. Must be a power of 2. The default is 128. The default if the agent is in DEBUG mode or higher is 16384. Log messages are dropped if the buffer exceeds the size.").a(Category.LOGGING_ASSESS).b(f.a("agent.java.logger.buffer_size")).g()),
    LOGGER_SHUTDOWN_TIMEOUT(k.a(Long.class).a(10000L).d().b("LoggerManager shutdown timeout in seconds.").a(Category.LOGGING_ASSESS).b(f.a("agent.java.logger.shutdown_timeout_ms")).g()),
    CEF_SYSLOGGER_ENABLE(k.a(Boolean.class).a((Boolean)false).b("flag for controlling the use of Syslog").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().isSyslogEnabled();
        }
        return null;
    }).b(f.a("agent.security_logger.syslog.enable")).g()),
    CEF_SYSLOGGER_BUFFER_SIZE(k.a(Integer.class).a(-1).d().b("Specify the Syslog logger buffer size cap. Must be a power of 2. The default is 128. Log messages are dropped if the buffer exceeds the size.").a(Category.LOGGING_PROTECT).b(f.a("agent.java.security_logger.syslog.buffer_size")).g()),
    CEF_SYSLOGGER_HOST_NEW(k.a(String.class).a("").d().b("Set the address of the Syslog server to which the agent should send messages.  This can be a fully qualified domain name or ip address; e.g. syslog.hostname.com or 10.10.10.13").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogIpAddress();
        }
        return null;
    }).b(f.a("agent.security_logger.syslog.server_host", false)).g()),
    CEF_SYSLOGGER_HOST(k.a(String.class).a("localhost").b("Set the address of the Syslog server to which the agent should send messages.  This can be a fully qualified domain name or ip address; e.g. syslog.hostname.com or 10.10.10.13").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogIpAddress();
        }
        return null;
    }).b(f.a("agent.security_logger.syslog.ip")).g()),
    CEF_SYSLOGGER_PROTOCOL(k.a(String.class).a("").d().b("Specify the connection protocol used for the Syslog server connection.  Value options are 'UDP' (default), 'TCP', or 'TCP_TLS'.  Default if missing is UDP.").a(Category.LOGGING_PROTECT).b(f.a("agent.security_logger.syslog.protocol")).g()),
    CEF_SYSLOGGER_PORT(k.a(Integer.class).a(514).b("The port of the Syslog server to which we should send messages").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogPortNumber();
        }
        return null;
    }).b(f.a("agent.security_logger.syslog.port")).g()),
    CEF_SYSLOGGER_FACILITY(k.a(Integer.class).a(19).b("The facility code of the messages we are sending to Syslog").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            return serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogFacilityCode();
        }
        return null;
    }).b(f.a("agent.security_logger.syslog.facility")).g()),
    CEF_SYSLOGGER_HEARTBEAT(k.a(Boolean.class).a((Boolean)false).b("Set to `true` to enable the Syslog heartbeat.  The heartbeat will issue a Syslog message every after every interval passes.").a(Category.LOGGING_PROTECT).b(f.a("agent.security_logger.syslog.heartbeat.enable")).g()),
    CEF_SYSLOGGER_HEARTBEAT_INTERVAL(k.a(Integer.class).a(60000).b("Set the interval of the Syslog server of which to send heartbeat messages to the Syslog server. (in milliseconds)").a(Category.LOGGING_PROTECT).b(f.a("agent.security_logger.syslog.heartbeat.interval_ms")).g()),
    CEF_SYSLOGGER_EXPLOITED_LEVEL(k.a(String.class).a("ALERT").b("Set the log level of Exploited attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            SyslogSeverity syslogSeverity = serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogSeverityExploited();
            return syslogSeverity == null ? null : syslogSeverity.name();
        }
        return null;
    }).b(f.a("agent.security_logger.syslog.severity_exploited")).g()),
    CEF_SYSLOGGER_SUSPICIOUS_LEVEL(k.a(String.class).a("WARNING").d().b("Set the log level of Suspicious attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.").a(Category.LOGGING_PROTECT).b(f.a("agent.security_logger.syslog.severity_suspicious")).g()),
    CEF_SYSLOGGER_BLOCKED_LEVEL(k.a(String.class).a("NOTICE").b("Set the log level of Blocked attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            SyslogSeverity syslogSeverity = serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogSeverityBlocked();
            return syslogSeverity == null ? null : syslogSeverity.name();
        }
        return null;
    }).b(f.a("agent.security_logger.syslog.severity_blocked")).g()),
    CEF_SYSLOGGER_PROBED_LEVEL(k.a(String.class).a("WARNING").b("Set the log level of Probed attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.").a(Category.LOGGING_PROTECT).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getSecurityLogger() != null && serverSettingsDTM.getSecurityLogger().getSyslog() != null) {
            SyslogSeverity syslogSeverity = serverSettingsDTM.getSecurityLogger().getSyslog().getSyslogSeverityProbed();
            return syslogSeverity == null ? null : syslogSeverity.name();
        }
        return null;
    }).b(f.a("agent.security_logger.syslog.severity_probed")).g()),
    OBSERVE_ENABLE(k.a(Boolean.class).a((Boolean)false).d().a((Boolean)((Object)"contrast.agent.observe.enable")).b("Lightweight and low overhead observation mode for the agent.").a(Category.GENERAL_PROPERTIES).d("Not yet supported by common config").g()),
    OBSERVE_PERIODIC_EXPORT_INTERVAL(k.a(Integer.class).d().a(60000).a((Integer)((Object)"contrast.agent.observe.export.interval")).b("Interval the metrics are flushed to the upstream collector.").a(Category.GENERAL_PROPERTIES).d("Not yet supported by common config").g()),
    OBSERVE_COLLECTOR_ENDPOINT(k.a(String.class).a("contrast.agent.observe.collector.endpoint").a("").b("The URL to which observability metrics will be sent at submission").a(Category.GENERAL_PROPERTIES).d().d("Not yet supported by common config").g()),
    PROTECT_SQL_CANARY(k.a(String.class).a("contrast.defend.sql.canary").c().d().b("In order to get diagnostics about how the SQL is being analyzed for protect purposes, you can log queries that contain the canary specified by this setting.").a(Category.LOGGING_PROTECT).b(f.a("protect.sql_canary")).g()),
    PROTECT_BEAN_INTROSPECTION_MODE(k.a(String.class).a("contrast.defend.cve-2010-1622.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.a)).b(f.a("protect.rules.cve-2010-1622.mode")).g()),
    PROTECT_CLASS_LOADER_MANIPULATION_MODE(k.a(String.class).a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.c)).b(f.a("protect.rules.class-loader-manipulation.mode")).g()),
    PROTECT_CMDI_MODE(k.a(String.class).a("contrast.defend.cmd-injection.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.d)).b(f.a("protect.rules.cmd-injection.mode")).g()),
    PROTECT_CMDI_BACKDOORS(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.cmdinjection.backdoors")).a((Boolean)true).b("Detect when the agent sees user parameters being executed as system commands. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.cmd-injection.detect_parameter_command_backdoors")).g()),
    PROTECT_CMDI_CHAINS(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.cmdinjection.chaining")).a((Boolean)true).b("Detect when a system command is issued which contains chained commands. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.cmd-injection.detect_chained_commands")).g()),
    PROTECT_CMDI_DANGEROUS_PATH_ARGS(k.a(Boolean.class).a((Boolean)true).b("Detect when a system command is issued which contains a dangerous path argument - e.g. /etc/passwd. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.cmd-injection.detect_dangerous_path_args")).g()),
    PROTECT_CMDI_PHASES(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.cmdinjection.phases")).a((Boolean)true).d().b("controls whether phased commands queries will be blocked").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.cmd-injection.detect_phased_commands")).g()),
    PROTECT_CVE_2011_2730_MODE(k.a(String.class).a("contrast.defend.cve-2011-2730.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.f)).b(f.a("protect.rules.cve-2011-2730.mode")).g()),
    PROTECT_CVE_2011_2732_MODE(k.a(String.class).a("contrast.defend.cve-2011-2732.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.z)).b(f.a("protect.rules.cve-2011-2732.mode")).g()),
    PROTECT_CVE_2014_0112_MODE(k.a(String.class).a("contrast.defend.cve-2014-0112.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.g)).b(f.a("protect.rules.cve-2014-0112.mode")).g()),
    PROTECT_CVE_2014_0114_MODE(k.a(String.class).a("contrast.defend.cve-2014-0114.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.m)).b(f.a("protect.rules.cve-2014-0114.mode")).g()),
    PROTECT_CVE_2014_0116_MODE(k.a(String.class).a("contrast.defend.cve-2014-0116.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.h)).b(f.a("protect.rules.cve-2014-0116.mode")).g()),
    PROTECT_CVE_2017_5638_MODE(k.a(String.class).a("contrast.defend.cve-2017-5638.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.i)).b(f.a("protect.rules.cve-2017-5638.mode")).g()),
    PROTECT_CVE_2017_9791_MODE(k.a(String.class).a("contrast.defend.cve-2017-9791.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.j)).b(f.a("protect.rules.cve-2017-9791.mode")).g()),
    PROTECT_CVE_2017_12616_MODE(k.a(String.class).a("contrast.defend.cve-2017-12616.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.n)).b(f.a("protect.rules.cve-2017-12616.mode")).g()),
    PROTECT_CVE_2017_12617_MODE(k.a(String.class).a("contrast.defend.cve-2017-12617.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.o)).b(f.a("protect.rules.cve-2017-12617.mode")).g()),
    PROTECT_CVE_2016_4438_MODE(k.a(String.class).a("contrast.defend.cve-2016-4438.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.p)).b(f.a("protect.rules.cve-2016-4438.mode")).g()),
    PROTECT_CVE_2016_3081_MODE(k.a(String.class).a("contrast.defend.cve-2016-3081.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.q)).b(f.a("protect.rules.cve-2016-3081.mode")).g()),
    PROTECT_EL_INJECTION_MODE(k.a(String.class).a("contrast.defend.expression-language-injection.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.r)).b(f.a("protect.rules.expression-language-injection.mode")).g()),
    PROTECT_METHOD_TAMPERING_MODE(k.a(String.class).a("contrast.defend.method-tampering.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.s)).b(f.a("protect.rules.method-tampering.mode")).g()),
    PROTECT_METRIC_GATHERING_MODE(k.a(String.class).a("MONITOR").b("if present, controls the mode of the metric gathering synthetic rule; can be monitor or off (default: monitor). If at any point the telemetry system is disabled then the metric gathering rule will be as well, regardless of the value of this property.").a(Category.INTERNAL_USAGE).d().b(f.a("protect.rules.metric-gathering.mode")).g()),
    PROTECT_OGNL_MODE(k.a(String.class).a("contrast.defend.ognl-injection.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.w)).b(f.a("protect.rules.ognl-injection.mode")).g()),
    PROTECT_PATH_TRAVERSAL_MODE(k.a(String.class).a("contrast.defend.path-traversal.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.x)).b(f.a("protect.rules.path-traversal.mode")).g()),
    PROTECT_PT_CUSTOM_CODE_ACCESS(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.pathtraversal.detect_custom_code_accessing_system_files")).a((Boolean)true).b("Detect when custom code attempts to access sensitive system files. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.path-traversal.detect_custom_code_accessing_system_files")).g()),
    PROTECT_PT_COMMON_EXPLOIT(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.pathtraversal.detect_common_file_exploits")).a((Boolean)true).b("Detect when users attempt to bypass filters by using \"::$DATA\" channels or null bytes in file names. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.path-traversal.detect_common_file_exploits")).g()),
    PROTECT_PROCESS_HARDENING_MODE(k.a(String.class).a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.y)).b(f.a("protect.rules.process-hardening.mode")).g()),
    PROTECT_SIGNATURE_TAMPERING_MODE(k.a(String.class).a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.E)).b(f.a("protect.rules.signature-tampering.mode")).g()),
    PROTECT_SQLI_MODE(k.a(String.class).a("contrast.defend.sql-injection.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.A)).b(f.a("protect.rules.sql-injection.mode")).g()),
    PROTECT_SQL_SEMANTIC_UNIONS(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.suspiciousunions")).a((Boolean)false).b("Tell the agent to detect when semantic analysis of the query reveals database queries are being made for system tables and sensitive information. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.sql-injection.detect_suspicious_unions")).g()),
    PROTECT_SQL_SEMANTIC_TAUTOLOGIES(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.tautologies")).a((Boolean)false).b("Tell the agent to detect when semantic analysis of the query reveals tautologies used in exfiltration attacks (e.g., \"or 1=1\" or \"or 2<>3\"). The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.sql-injection.detect_tautologies")).g()),
    PROTECT_SQL_SEMANTIC_CHAINING(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.chaining")).a((Boolean)false).b("Tell the agent to detect when semantic analysis of the query reveals chained queries, which is uncommon in normal usage but common in exploit. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.sql-injection.detect_chained_queries")).g()),
    PROTECT_SQL_AGGRESSIVE_COMMENT(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.aggressive_comment")).a((Boolean)false).b("controls whether aggressive comment filtering is used to block").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.sql-injection.aggressive_comment")).g()),
    PROTECT_SQL_SEMANTIC_DANGEROUS_FUNCTIONS(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sqlinjection.dangerous_functions")).a((Boolean)false).b("Tell the agent to detect when semantic analysis of the query reveals the invocation of dangerous functions typically used in weaponized exploits. The agent blocks if blocking is enabled.").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.sql-injection.detect_dangerous_functions")).g()),
    PROTECT_SQL_SEMANTIC_FINDING_CACHE_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.semantic_findings_cache_size")).a(300).b("Set the number of queries for which semantic analysis findings are cached. Set to 0 to disable caching").a(Category.PROTECT_MODE_CONFIG).b(f.a("agent.java.semantic_findings_cache_size")).g()),
    PROTECT_CVE_2013_2251_MODE(k.a(String.class).a("contrast.defend.cve-2013-2251.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.D)).b(f.a("protect.rules.cve-2013-2251.mode")).g()),
    PROTECT_CVE_2021_44228_MODE(k.a(String.class).a("contrast.defend.cve-2021-44228.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.k)).b(f.a("protect.rules.cve-2021-44228.mode")).g()),
    PROTECT_CVE_2022_41852_MODE(k.a(String.class).a("OFF").b("Set the rule mode. Valid values are `monitor`, `block`, or `off`.\nUse `monitor` to report attacks but not block them, or `block` to block attacks, and `off` to disable the rule's analysis entirely.\nPlease refer to https://docs.contrastsecurity.com/en/set-protect-rules.html to learn more about the different rule modes.").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.l)).b(f.a("protect.rules.cve-2022-41852.mode")).g()),
    PROTECT_DESERIALIZATION_MODE(k.a(String.class).a("contrast.defend.untrusted-deserialization.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.G)).b(f.a("protect.rules.untrusted-deserialization.mode")).g()),
    PROTECT_XSLT_MODE(k.a(String.class).a("contrast.defend.cve-2016-3082.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.K)).b(f.a("protect.rules.cve-2016-3082.mode")).g()),
    PROTECT_XSS_MODE(k.a(String.class).a("contrast.defend.reflected-xss.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.I)).b(f.a("protect.rules.reflected-xss.mode")).g()),
    PROTECT_XXE_MODE(k.a(String.class).a("contrast.defend.xxe.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.J)).b(f.a("protect.rules.xxe.mode")).g()),
    PROTECT_UNSAFE_FILE_UPLOAD_MODE(k.a(String.class).a("contrast.defend.unsafe-file-upload.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.F)).b(f.a("protect.rules.unsafe-file-upload.mode")).g()),
    UNSAFE_FILE_UPLOAD_KEYWORDS(k.a(String.class).a("contrast.unsafe-file-upload.keywords").c().d().b("File path to overriding Unsafe File Upload keywords file").a(Category.PROTECT_MODE_CONFIG).d("We don't need to make this available to users").g()),
    UNSAFE_FILE_UPLOAD_PATTERNS(k.a(String.class).a("contrast.unsafe-file-upload.patterns").c().d().b("Location of Unsafe File Upload patterns file").a(Category.PROTECT_MODE_CONFIG).d("We don't need to make this available to users").g()),
    UNSAFE_FILE_UPLOAD_THRESHOLD_DISABLED(k.a(Boolean.class).a((Boolean)((Object)"contrast.unsafe-file-upload.threshold")).a((Boolean)false).d().b("boolean to enable/disable the threshold after which an input is no longer checked against possible attack patterns").a(Category.PROTECT_MODE_CONFIG).d("We don't need to make this available to users").g()),
    PROTECT_ZFO_MODE(k.a(String.class).a("contrast.defend.zip-file-overwrite.mode").a("OFF").b("if present, controls the mode of the rule; can be monitor, block or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.L)).b(f.a("protect.rules.zip-file-overwrite.mode")).g()),
    PROTECT_JNDI_MODE(k.a(String.class).a("OFF").b("if present, controls the mode of the rule; can be monitor, block, or off (default: off)").a(Category.PROTECT_MODE_CONFIG).a(new a.a(Q.u)).b(f.a("protect.rules.jndi-injection.mode")).g()),
    PROTECT_RULE_STATE_MAX_TIME(k.a(Integer.class).a((Integer)((Object)"contrast.defend.rulestate.ttlmax")).a(90).d().b("Some rules keep state in order to detect repetitive or multi-payload attacks. This can be tuned down to eat less persistent heap").a(Category.PROTECT_MODE_CONFIG).d("CONTRAST-30447").g()),
    PROTECT_RULE_MODE_OVERRIDE(k.a(String.class).a("contrast.defend.rulemode").c().d().b("Valid values: off, blocking, monitoring. An override setting for whether protection rules should all be in off, monitoring or blocking modes").a(Category.PROTECT_MODE_CONFIG).d("JAVA-212").g()),
    PROTECT_RULE_STATE_MAX_REFRESH(k.a(Integer.class).a((Integer)((Object)"contrast.defend.rulestate.ttlrefresh")).a(30).d().b("Some rules keep state in order to detect repetitive or multi-payload attacks. This can be tuned down to eat less persistent heap").a(Category.PROTECT_MODE_CONFIG).d("CONTRAST-30444").g()),
    POLICY(k.a(String.class).a("contrast.policy").c().b("If you set this value to a file or URL, Contrast will use it in addition to the pre-packaged security policy. This means that rules from both the standard Contrast policy and your custom policy will be used, with conflicts being resolved in favor of the external policy, i.e. if two sources have the same ID, one in the internal policy and one in the external, the external source will be used.").a(Category.POLICY).b(f.a("agent.java.external_policy_files")).g()),
    POLICY_OVERRIDES(k.a(String.class).a("contrast.policy.overrides").c().b("Same functionality as contrast.policy, but policies listed here have a higher priority, meaning that conflicts will be resolved in favor of the overrides policy, i.e. if two sources have the same ID, one in the policy and one in the override, the override source will be used. ").a(Category.POLICY).b(f.a("agent.java.external_policy_overrides")).g()),
    POLICY_STANDALONE(k.a(String.class).a("contrast.policy.standalone").c().b("If you set this value to a file or URL, Contrast will use it instead of the pre-packaged security policy. For more information about rule customization, please contact your account manager.").a(Category.POLICY).b(f.a("agent.java.standalone_policy")).g()),
    POLICY_CUSTOM_TRIGGERS(k.a(String.class).a("contrast.policy.custom.triggers").c().d().b("A list of rule and custom trigger for each rule, formatted rule-id:com.package.Class.methodname(argType,argType,argType,...) where the argType of interest is marked with a *").a(Category.POLICY).b(f.a("agent.java.custom_triggers")).g()),
    ASSESS_DISABLED_RULES(k.a(String.class).a("contrast.disabledrules").a("").b("list of comma-separated disabled rule ids").a(Category.RULES_CONFIG).a(applicationSettingsDTM -> {
        if (applicationSettingsDTM == null) {
            return null;
        }
        ApplicationAssessSettingsDTM applicationAssessSettingsDTM = applicationSettingsDTM.getAssessment();
        if (applicationAssessSettingsDTM == null) {
            return null;
        }
        Set<String> set = applicationAssessSettingsDTM.getDisabledRules();
        if (set == null || set.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(set.size() * 16);
        for (String string : set) {
            stringBuilder.append(string);
            stringBuilder.append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }).b(f.a("assess.rules.disabled_rules")).g()),
    DISABLEDSOURCES(k.a(String.class).a("contrast.disabledsources").c().b("list of comma-separated disabled source ids").a(Category.RULES_CONFIG).b(f.a("agent.java.disabled_sources")).g()),
    DISABLEDPROPAGATORS(k.a(String.class).a("contrast.disabledpropagators").c().d().b("list of comma-separated disabled propagator ids").a(Category.RULES_CONFIG).b(f.a("agent.java.disabled_propagators")).g()),
    DEADZONES(k.a(Boolean.class).a((Boolean)((Object)"contrast.deadzones")).a((Boolean)true).b("boolean to enable/disable loading of deadzones from policy").a(Category.RULES_CONFIG).b(f.a("assess.enable_deadzones")).g()),
    SOURCES(k.a(Boolean.class).a((Boolean)((Object)"contrast.sources")).a((Boolean)true).b("boolean to enable/disable loading of sources from policy").a(Category.RULES_CONFIG).b(f.a("assess.enable_sources")).g()),
    DYNAMIC_SOURCES(k.a(Boolean.class).a((Boolean)((Object)"contrast.dynamicsources")).a((Boolean)true).b("boolean to enable/disable loading of dynamic sources from policy").a(Category.RULES_CONFIG).b(f.a("assess.enable_dynamic_sources")).g()),
    PROPAGATORS(k.a(Boolean.class).a((Boolean)((Object)"contrast.propagators")).a((Boolean)true).b("boolean enable/disable loading of propagators from policy").a(Category.RULES_CONFIG).b(f.a("assess.enable_propagators")).g()),
    TAGS(k.a(Boolean.class).a((Boolean)((Object)"contrast.tags")).a((Boolean)true).b("boolean to enable/disable loading of tags from policy").a(Category.RULES_CONFIG).b(f.a("assess.enable_taggers")).g()),
    ENABLE_PROPERTIES(k.a(Boolean.class).a((Boolean)((Object)"contrast.enable_properties")).a((Boolean)true).b("boolean to enable/disable loading of properties from policy").a(Category.RULES_CONFIG).b(f.a("assess.enable_properties")).g()),
    ANNOTATIONS(k.a(Boolean.class).a((Boolean)((Object)"contrast.annotations")).a((Boolean)true).b("boolean enable/disable loading of annotations from policy").a(Category.RULES_CONFIG).b(f.a("assess.enable_annotations")).g()),
    RULES(k.a(Boolean.class).a((Boolean)((Object)"contrast.rules")).a((Boolean)true).b("boolean to enable/disable loading of rules from policy").a(Category.RULES_CONFIG).b(f.a("assess.enable_rules")).g()),
    VALIDATORS(k.a(Boolean.class).a((Boolean)((Object)"contrast.validators")).a((Boolean)true).b("boolean to enable/disable loading of validators from policy").a(Category.RULES_CONFIG).b(f.a("assess.enable_validators")).g()),
    ADAPTIVE_OPTIMIZATION(k.a(Boolean.class).a((Boolean)((Object)"contrast.adaptiveoptimizations")).a((Boolean)false).d().b("boolean to enable/disable the real-time learning to tune Assess rules").a(Category.RULES_CONFIG).b(f.a("assess.enable_adaptive_optimization")).g()),
    ADAPTIVE_OPTIMIZATION_FREQUENCY(k.a(Integer.class).a((Integer)((Object)"contrast.adaptiveoptimizations.frequency")).a(200).d().b("how many propagation events should be sampled to find low-yield code paths (turn higher to hurt short-term performance in order to find optimizations quicker)").a(Category.RULES_CONFIG).b(f.a("assess.adaptive_optimization_frequency")).g()),
    ADAPTIVE_OPTIMIZATION_MAXIMUM(k.a(Integer.class).a((Integer)((Object)"contrast.adaptiveoptimizations.max")).a(20).d().b("how many instances of a particular low-yield propagation code path can be observed before being disabled").a(Category.RULES_CONFIG).b(f.a("assess.adaptive_optimization_max")).g()),
    ADAPTIVE_OPTIMIZATION_PER_REQUEST(k.a(Boolean.class).a((Boolean)((Object)"contrast.adaptiveoptimizations.sources.considerrequest")).a((Boolean)false).d().b("controls whether data paths should be considered per-URI instead of globally").a(Category.RULES_CONFIG).b(f.a("assess.adaptive_optimization_per_request")).g()),
    VALIDATOR_SCOPES(k.a(Boolean.class).a((Boolean)((Object)"contrast.validator.scopes")).a((Boolean)true).b("boolean to enable/disable loading of validator-scopes").a(Category.RULES_CONFIG).b(f.a("assess.enable_validator_scopes")).g()),
    INTERN_PREVENTION_SCOPES(k.a(Boolean.class).a((Boolean)((Object)"contrast.internPrevention.scopes")).a((Boolean)true).d().b("boolean to enable/disable loading of intern-prevention-scopes").a(Category.RULES_CONFIG).b(f.a("assess.enable_intern_scopes")).g()),
    MAX_CONTEXT_SOURCE_EVENTS(k.a(Integer.class).a((Integer)((Object)"contrast.assess.context.max.sources")).a(100).d().b("the maximum number of untrusted data flows to observe per request").a(Category.PERFORMANCE).b(f.a("assess.max_context_source_events")).g()),
    MAX_CONTEXT_PROPAGATION_EVENTS(k.a(Integer.class).a((Integer)((Object)"contrast.assess.context.max.propagations")).a(250).d().b("the maximum number of untrusted data flow propagations to observe per request").a(Category.PERFORMANCE).b(f.a("assess.max_propagation_events")).g()),
    MAX_CONTEXT_SNAPSHOT_CACHE_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.assess.context.max.snapshots")).a(64).d().b("the maximum number of cached method object snapshots per context").a(Category.PERFORMANCE).b(f.a("assess.max_cached_context_snapshots")).g()),
    MAX_TRACE_TTL(k.a(Long.class).a((Long)((Object)"contrast.trace.ttl.max")).a(15000L).d().b("the number of milliseconds to retain a trace with a strongly held reference").a(Category.PERFORMANCE).b(f.a("assess.trace_max_ttl_ms")).g()),
    TRACE_MAP_STRATEGY(k.a(String.class).a("contrast.trace.map").a("" + (Object)((Object)TraceMapStrategy.BOTH)).d().b("the strategy for tracking data: 'global', which allows data to be tracked across threads and requests, 'context', which limits data flows to a single request/response scope, or 'both', which tries to use context scope, but defaults to both").a(Category.PERFORMANCE).b(f.a("agent.java.trace_map_strategy")).g()),
    PROPERTIES(k.a(String.class).a("contrast.properties").c().d().b("location of file containing Java properties style key, value pairs. ").d("Like contrast.config.path, impossible to set via YAML").a(Category.GENERAL_PROPERTIES).g()),
    PROTECT_ENABLED(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.enabled")).a((Boolean)false).b("If present, used to determine if the Protect feature should be enabled. If not present, decision delegated to Contrast UI").a(Category.PROTECT_MODE_CONFIG).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getProtect() != null) {
            return serverSettingsDTM.getProtect().getEnable();
        }
        return null;
    }).b(f.a("protect.enable")).g()),
    PROTECT_APPCHECK_ENABLED(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.appcheck.enabled")).a((Boolean)true).d().b("boolean to enable/disable AppCheck when Contrast is in PROTECT mode").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.enable_appcheck")).g()),
    PROTECT_API_BODY_READ(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.api.bodyread")).a((Boolean)true).b("boolean to enable/disable whether API request bodies should be scanned for attacks if no known deserializers are in use").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.enable_api_request_body_reading")).g()),
    PROTECT_BOT_BLOCKER_ENABLE(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.botblocker")).a((Boolean)false).b("configures Contrast to use simple signaturing to block traffic from scrapers, attack tools, and other unwanted automation.").a(Category.PROTECT_MODE_CONFIG).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getProtect() != null && serverSettingsDTM.getProtect().getRules() != null && serverSettingsDTM.getProtect().getRules().getBotBlocker() != null) {
            return serverSettingsDTM.getProtect().getRules().getBotBlocker().getEnabled();
        }
        return null;
    }).b(f.a("protect.rules.bot-blocker.enable")).g()),
    PROTECT_SINKS(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.sinks")).a((Boolean)true).d().b("boolean to enable/disable monitoring sinks when Contrast is in PROTECT mode").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.enable_sinks")).g()),
    DESERIALIZER_TRACE_BODY_READ(k.a(Boolean.class).a((Boolean)((Object)"contrast.deserializer.trace.body.read")).a((Boolean)false).d().b("Outputs stack trace when agent fails to analyze request body deserialization").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.enable_body_stacktraces")).g()),
    XSS_KEYWORDS(k.a(String.class).a("contrast.xss.keywords").c().b("File path to overriding XSS keywords file").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.xss_keywords_file")).g()),
    XSS_PATTERNS(k.a(String.class).a("contrast.xss.patterns").c().b("Location of XSS patterns file").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.xss_patterns_file")).g()),
    XSS_THRESHOLD_DISABLED(k.a(Boolean.class).a((Boolean)((Object)"contrast.xss.threshold")).a((Boolean)false).d().b("boolean to enable/disable the threshold after which an input is no longer checked against possible attack patterns").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.enable_xss_threshold")).g()),
    SQLINJECTION_KEYWORDS(k.a(String.class).a("contrast.sqlinjection.keywords").c().b("File path to overriding SQL Injection keywords file").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.sql-injection.keywords_file")).g()),
    SQLINJECTION_PATTERNS(k.a(String.class).a("contrast.sqlinjection.patterns").c().b("Location of SQL Injection patterns file").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.sql-injection.patterns_file")).g()),
    SQLINJECTION_THRESHOLD_DISABLED(k.a(Boolean.class).a((Boolean)((Object)"contrast.sqlinjection.threshold")).a((Boolean)false).d().b("boolean to enable/disable the threshold after which an input is no longer checked against possible SQL Injection attack patterns").a(Category.PROTECT_MODE_CONFIG).d("CONTRAST-30448").g()),
    CMDINJECTION_THRESHOLD_DISABLED(k.a(Boolean.class).a((Boolean)((Object)"contrast.cmdinjection.threshold")).a((Boolean)false).d().b("boolean to enable/disable the threshold after which an input is no longer checked against possible Command Injection attack patterns").a(Category.PROTECT_MODE_CONFIG).d("CONTRAST-30449").g()),
    CMDINJECTION_KEYWORDS(k.a(String.class).a("contrast.cmdinjection.keywords").c().b("File path to overriding Command Injection keywords file").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.cmd-injection.keywords_file")).g()),
    CMDINJECTION_PATTERNS(k.a(String.class).a("contrast.cmdinjection.patterns").c().b("Location of Command Injection patterns file").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.cmd-injection.patterns_file")).g()),
    PATH_TRAVERSAL_KEYWORDS(k.a(String.class).a("contrast.pathtraversal.keywords").d().c().b("File path to overriding Path traversal keywords file").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.path-traversal.keywords_file")).g()),
    PATH_TRAVERSAL_PATTERNS(k.a(String.class).a("contrast.pathtraversal.patterns").d().c().b("Location of Path traversal patterns file").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.path-traversal.patterns_file")).g()),
    PATH_TRAVERSAL_THRESHOLD_DISABLED(k.a(Boolean.class).a((Boolean)((Object)"contrast.pathtraversal.threshold")).a((Boolean)false).d().b("boolean to enable/disable the threshold after which an input is no longer checked against possible Path traversal attack patterns").a(Category.PROTECT_MODE_CONFIG).d("JAVA-3554").g()),
    PROTECT_INEFFECTIVE_SAMPLES(k.a(Integer.class).a((Integer)((Object)"contrast.defend.ineffective.samples")).a(50).b("Max number of detailed reports generated for ineffective attacks detected during a reporting period").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.samples.probed")).g()),
    PROTECT_BLOCKED_SAMPLES(k.a(Integer.class).a((Integer)((Object)"contrast.defend.blocked.samples")).a(25).b("Max number of detailed reports generated for blocked attacks detected during a reporting period").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.samples.blocked")).g()),
    PROTECT_PERIMETER_BLOCKED_SAMPLES(k.a(Integer.class).a((Integer)((Object)"contrast.defend.blockedperimeter.samples")).a(25).b("Max number of detailed reports generated for perimeter blocked attacks detected during a reporting period").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.samples.blocked_at_perimeter")).g()),
    PROTECT_EXPLOITED_SAMPLES(k.a(Integer.class).a((Integer)((Object)"contrast.defend.exploited.samples")).a(100).b("Max number of detailed reports generated for exploited attacks during a reporting period").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.samples.exploited")).g()),
    PROTECT_SUSPICIOUS_SAMPLES(k.a(Integer.class).a((Integer)((Object)"contrast.protect.suspicious.samples")).a(100).b("Max number of detailed reports generated for suspicious attacks during a reporting period").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.samples.suspicious")).g()),
    PROTECT_DISABLED_RULES(k.a(String.class).a("contrast.defend.disabled.rules").a("").b("Comma separated list of protect rules to disable for this JVM").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.rules.disabled_rules")).g()),
    PERF(k.a(Boolean.class).a((Boolean)((Object)"contrast.perf")).a((Boolean)false).d().b("boolean to enable/disable the PerformanceMonitor utility class.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.enable_performance_monitor")).g()),
    USE_URL_IN_HASH(k.a(Boolean.class).a((Boolean)((Object)"contrast.assess.hashing.includeurl")).a((Boolean)false).b("Set to \"true\" to factor in request URL when computing hash for reported finding").a(Category.RULES_CONFIG).b(f.a("assess.include_url_in_finding_hash")).g()),
    USE_METHOD_CACHE(k.a(Boolean.class).a((Boolean)((Object)"contrast.assess.methodcache")).a((Boolean)true).d().b("used to tell whether we should attempt to conserve heap by caching method signatures").a(Category.PERFORMANCE).b(f.a("assess.enable_method_cache")).g()),
    WEBSERVICE_RESPONSE_TRACK(k.a(Boolean.class).a((Boolean)false).d().b("Configures Contrast Assess analysis for responses from requests to web services.\nTRUE:   The agent will treat web service responses as untrusted and track propagation of data from web service responses.\nFALSE:  The agent will treat web service responses as trusted.").a(Category.PERFORMANCE).b(f.a("agent.java.enable_web_service_response_tracking")).g()),
    WEBSPHERE_SHARED_LIB_DIR(k.a(String.class).a("contrast.websphere.shared.libs").c().b("Location of shared library directory on WebSphere").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.websphere_shared_libs_directory")).g()),
    ASSESS_AUTODETECT_CONTROLS(k.a(Boolean.class).a((Boolean)((Object)"contrast.assess.autodetect.controls")).a((Boolean)true).b("boolean to enable/disable detecting security sensors").a(Category.DIAGNOSTICS).b(f.a("assess.enable_sensor_autodetection")).g()),
    ASSESS_DETECT_CANARIES(k.a(String.class).a("contrast.assess.secondorder.canary").c().b("A value that will be fed by attack testing tools in order to test stored XSS or other second-order injection attacks to be detected coming out of databases").a(Category.DIAGNOSTICS).b(f.a("assess.second_order_canary")).g()),
    ASSESS_THRESHOLD_ENTRIES(k.a(Integer.class).a(100).b("The maximum number of vulnerabilities per rule type that can be discovered within a period defined by contrast.assess.threshold.period").a(Category.PERFORMANCE).b(f.a("assess.threshold.entries")).g()),
    ASSESS_THRESHOLD_PERIOD_MS(k.a(Integer.class).a((Integer)((Object)"contrast.assess.threshold.period.ms")).a(60000).b("The period, in milliseconds, in which a maximum number of vulnerabilities per rule type can be discovered").a(Category.PERFORMANCE).b(f.a("assess.threshold.period_ms")).g()),
    LIBRARY_UPDATE_QUEUE_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.agent.reporting.library_update.queue.size")).a(20000).b("size of queue that holds library update events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(f.a("agent.reporting.library_update.observations.queue.size")).g()),
    TEAMSERVER_REPORTING_MAX_RETRY(k.a(Integer.class).b(true).a(3).b("Set the number of times the to retry recoverable network and HTTP failures when communicating with Contrast UI.").a(Category.GENERAL_PROPERTIES).b(f.a("api.max_retries")).g()),
    TEAMSERVER_REPORTING_RETRY_INTERVAL(k.a(Integer.class).b(true).a(1000).b("Set the interval (in milliseconds) the agent will wait before retrying a recoverable network or HTTP failure when communicating with Contrast UI.").a(Category.GENERAL_PROPERTIES).b(f.a("api.retry_interval")).g()),
    REPORTING_THREAD_GRACE_PERIOD_MS(k.a(Long.class).a(120000L).b("Set the grace period (in milliseconds) after agent shutdown to allow draining pending reports.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.reporting.shutdown_grace_period_ms")).g()),
    REPORTING_THREAD_POOL_SIZE(k.a(Integer.class).b(true).a(1).b("Set size of reporting service's thread pool. More threads may increase reporting throughput at the expense of increased contention for CPU resources.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.reporting.thread_pool_size")).g()),
    ROUTE_OBSERVATION_QUEUE_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.agent.reporting.route_coverage.queue.size")).a(3000).b("size of queue that holds route observation events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(f.a("agent.reporting.route_coverage.observations.queue.size")).g()),
    ROUTE_OBSERVATION_MAP_DEDUPLICATION_SIZE(k.a(Integer.class).b(true).a(512).b("size of map that holds route observation events to check for duplicates in a given time window before being sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(f.a("agent.reporting.route_coverage.observations.dedup.map.size")).g()),
    ROUTE_OBSERVATION_DEDUPLICATION_TIME(k.a(Long.class).b(true).a(30000L).b("The time window (in milliseconds) of a route being observed more than once to be considered a duplicate and not reported to team server. If <= 0, no duplicate check will occur").a(Category.GENERAL_PROPERTIES).b(f.a("agent.reporting.route_coverage.observations.dedup.window.time")).g()),
    ROUTE_OBSERVATION_INTERNAL_QUEUE_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.agent.reporting.route_coverage.internal_queue.size")).a(400).d().b("size of internal queue that holds route observation events that are intended to be sent to TeamServer, prior to the availability of a valid session ID").a(Category.GENERAL_PROPERTIES).b(f.a("agent.reporting.route_coverage.observations.internal_queue.size")).g()),
    SILENT_TELEMETRY_QUEUE_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.agent.reporting.silent_telemetry.queue.size")).a(3000).d().b("size of queue that holds silent telemetry events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(f.a("agent.reporting.silent_telemetry.observations.queue.size")).g()),
    APP_INVENTORY_QUEUE_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.agent.reporting.app_inventory.queue.size")).a(300).b("size of queue that holds app inventory events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(f.a("agent.reporting.app_inventory.observations.queue.size")).g()),
    EFFECTIVE_CONFIG_QUEUE_SIZE(k.a(Integer.class).a(100).d().b("size of queue that holds effective config reports that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(f.a("agent.reporting.effective_config.observations.queue.size")).g()),
    ARCHITECTURE_COMPONENT_QUEUE_SIZE(k.a(Integer.class).a(300).b("size of queue that holds app architecture component events that are intended to be sent to TeamServer").a(Category.GENERAL_PROPERTIES).b(f.a("agent.reporting.architecture_component.observations.queue.size")).g()),
    CLASS_EVENT_QUEUE_SIZE(k.a(Integer.class).a(1000).d().b("size of queue that holds class load events prior to being processed").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.class_load_event.queue_size")).g()),
    LEGACY_REPORTING_PERIOD(k.a(Long.class).a((Long)((Object)"contrast.reporting.period")).a(5000L).b("Set the polling period for spooling reports.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.polling.reporting_period_ms")).g()),
    REPORTING_PERIOD(k.a(Integer.class).a(500).d().b("Specifies period between sending single report to TeamServer through the agent reporting service.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.reporting.period")).g()),
    DUP_DELAY(k.a(Long.class).a((Long)((Object)"contrast.duplicate.delay")).a(5000L).b("The period for which duplicate traces, based on Contrast hashing methods, will be supressed (in milliseconds)").a(Category.GENERAL_PROPERTIES).b(f.a("assess.duplicate_delay_ms")).g()),
    CSRF_IDEMPOTENT_URLS(k.a(String.class).c().b("Set the path to a file containing line-separated URLs patterns which don't require CSRF tokens").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.csrf_exempt_urls_file")).g()),
    CSRF_PROTECTED_URLS(k.a(String.class).c().b("Set the path to a file containing line-separated URLs patterns which require CSRF tokens").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.csrf_protected_urls_file")).g()),
    SCAN_CODE_SOURCES(k.a(Boolean.class).a((Boolean)((Object)"contrast.process.codesources")).a((Boolean)true).d().b("By default, the Java agent will visit all classes at startup to look for vulnerabilities which may be detected by scanning a class (for example, hardcoded passwords). Set this property to `false` to disable the default behavior so that the agent will instead only visit classes which are likely to require sensors. This can improve application startup time, but may produce less findings (most likely those which require static analysis).").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.scan_all_code_sources")).g()),
    INSPECT_ALL_CLASSES(k.a(Boolean.class).a((Boolean)((Object)"contrast.inspect.allclasses")).a((Boolean)true).d().b("By default, the Java agent will deeply inspect all jar and war files loaded by the JVM in order to build a comprehensive understanding of the type hierarchy. Building this comprehensive understanding allows Contrast to instrument sensors into types that it might otherwise overlook. In most cases this produces a slight increase in accuracy at the cost of increased application startup time. Customers can disable this scanning by setting this property to `false`.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.scan_all_classes")).g()),
    HIERARCHY_OVERRIDE(k.a(String.class).a("contrast.hierarchy.path").c().d().b("A path on disk where additional hierarchy information can be found (as XML)").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.hierarchy_file")).g()),
    PACKAGES_TO_SCAN(k.a(String.class).a("contrast.user.packages").c().d().b("A comma-separated list of packages that Contrast should deeply scan for SMAP information, vulnerabilities, and other app-related analysis").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.user_packages")).g()),
    PREFLIGHT_FAIL_OPEN(k.a(Boolean.class).a((Boolean)((Object)"contrast.preflight.open")).a((Boolean)false).b("boolean to enable/disable preflight reporting fail open. In this case, fail open means that in the event of an error during a preflight check, all reports will be sent to TeamServer. Typically, the Contrast Agent uses a preflight hashing mechanism to avoid duplicate reporting, reducing load on TeamServer. Occasionally, this process can be overwhelmed, and TeamServer cannot reply quickly enough. In this case, in order to avoid losing any vulnerability data, the Agent will send any reports that are being filtered by preflight. While TeamServer can usually recover and resume preflight, it sometimes falls behind (for instance if the application being monitored is placed under a load test). To ensure that TeamServer has a chance to catch up, you can set this flag to false; however, it is worth noting that doing so may result in lost vulnerability information as all reports will be disregarded.").a(Category.PERFORMANCE).b(f.a("agent.java.enable_preflight_fail_open")).g()),
    INSPECT_PARAMETERS_AS_XML(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.parameters.xml")).a((Boolean)false).d().b("boolean to enable/disable XML scanning inside of individual parameters").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.enable_xml_parameter_inspection")).g()),
    INSPECT_PARAMETERS_AS_JSON(k.a(Boolean.class).a((Boolean)((Object)"contrast.defend.parameters.json")).a((Boolean)false).d().b("boolean to enable/disable JSON scanning inside of individual parameters").a(Category.PROTECT_MODE_CONFIG).b(f.a("protect.enable_json_parameter_inspection")).g()),
    DELAYED_STARTUP(k.a(Integer.class).a((Integer)((Object)"contrast.startup.delay")).a(0).d().b("this is the number of milliseconds to delay startup of the agent, if 0 or less, no startup delay").a(Category.PERFORMANCE).b(f.a("agent.startup_delay_ms")).g()),
    DELAYED_STARTUP_STRATEGY(k.a(String.class).a("contrast.startup.strategy").a("activation").d().b("can be 'activation' or 'boot'; when doing delayed startup, what strategy should be used.  For `activation` booting and instrumentation do take place but the sensors are only enabled later.  For `boot` very little action is taken at agent startup, the agent booting and instrumentation occur later after the delay period.").a(Category.PERFORMANCE).b(f.a("agent.java.delayed_startup_strategy")).g()),
    ALLOW_INSTRUCTION_CACHE(k.a(Boolean.class).a((Boolean)((Object)"contrast.instrcache.allow")).a((Boolean)true).d().b("whether instruction caching is allowed").a(Category.INTERNAL_USAGE).b(f.a("agent.java.allow_instruction_caching")).g()),
    SERVER_ENVIRONMENT(k.a(String.class).a("contrast.env").c().b("the name of the environment this server should be associated with in the TeamServer").a(Category.GENERAL_PROPERTIES).b(f.a("server.environment")).g()),
    GROUP(k.a(String.class).a("contrast.group").c().b("the name of the application group this application should be associated with in the TeamServer").a(Category.GENERAL_PROPERTIES).b(f.a("application.group", true)).g()),
    APP_CODE(k.a(String.class).c().b("the 'application code' for the application to be used in TeamServer").a(Category.GENERAL_PROPERTIES).b(f.a("application.code", true)).g()),
    FREEZE_THRESHOLD(k.a(Integer.class).a((Integer)((Object)"contrast.freeze.threshold")).a(140).d().b("Number of summarized events in a trace before trace is frozen").a(Category.PERFORMANCE).b(f.a("agent.java.trace_summary.freeze_threshold")).g()),
    SUMMARIZATION_THRESHOLD(k.a(Integer.class).a((Integer)((Object)"contrast.summarization.threshold")).a(100).d().b("Number of events in a trace before summarization kicks in").a(Category.PERFORMANCE).b(f.a("agent.java.trace_summary.threshold")).g()),
    SUMMARIZATION_LEADING_EVENTS(k.a(Integer.class).a((Integer)((Object)"contrast.summarization.leading.events")).a(10).d().b("Number of leading events to preserve when summarizing a trace").a(Category.PERFORMANCE).b(f.a("agent.java.trace_summary.leading_events")).g()),
    SUMMARIZATION_TRAILING_EVENTS(k.a(Integer.class).a((Integer)((Object)"contrast.summarization.trailing.events")).a(10).d().b("Minimum number of trailing events to preserve when summarizing a trace").a(Category.PERFORMANCE).b(f.a("agent.java.trace_summary.trailing_events")).g()),
    USER_NAME(k.a(String.class).a("contrast.user.name").c().b("Overrides the Contrast user name.").a(Category.GENERAL_PROPERTIES).b(f.a("api.user_name", j.a("contrast.user_name"))).g()),
    API_KEY(k.a(String.class).a("contrast.api.key").c().b("Overrides the Contrast api key.").a(Category.GENERAL_PROPERTIES).e().b(f.a("api.api_key", j.a("contrast.api_key"))).g()),
    SERVICE_KEY(k.a(String.class).a("contrast.service.key").c().b("Overrides the Contrast service key.").a(Category.GENERAL_PROPERTIES).e().b(f.a("api.service_key", j.a("contrast.service_key"))).g()),
    VM_ID(k.a(String.class).a("contrast.vm.id").a("Java").d().b("Override the reported VM").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.vm_id")).g()),
    APPLICATION_PATH(k.a(String.class).c().b("Overrides the detected context path (location) of the application. This affects the \"Application-Path\" header value when sending reports. Overriding this could cause reports to be thrown away.").a(Category.GENERAL_PROPERTIES).b(f.a("application.path")).g()),
    ENABLE_TRANSFORM_PRIMORDIAL_TASK(k.a(Boolean.class).a((Boolean)true).d().b("Used for testing purposes, in cases that require a faked ContrastEngine to be started to mimic agent startup (e.g., needing access to the generated dispatcher instances). Overriding this property forces an early return in ContrastEngine startup tasks (TransformPrimordialTask & AddTransformerTask) to avoid errors caused by the faked ContrastEngine.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.enable_transform_primordial")).g()),
    STRICT(k.a(Boolean.class).a((Boolean)((Object)"contrast.testing.strict")).a((Boolean)false).d().b("USE WITH CAUTION! If enabled, Contrast will intentionally fail to start up if certain conditions are met! Currently, this includes detecting if a retired/deprecated property is in use.").a(Category.INTERNAL_USAGE).b(f.a("agent.java.enable_strict_startup")).g()),
    INVENTORY_CACHE_LIBRARY_FACTS(k.a(Boolean.class).a((Boolean)((Object)"contrast.inventory.cache.library.facts")).a((Boolean)true).b("Controls caching of basic information gathered from detected libraries.").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.cache_library_facts")).g()),
    INVENTORY_MAX_JAR_SIZE_TO_BUFFER_IN_MEM(k.a(Integer.class).a(0x3200000).b("Controls the maximum size of the in memory buffer for parsing jar contents in bytes. Min size supported is 512KB").a(Category.GENERAL_PROPERTIES).b(f.a("agent.java.inventory.jar_mem_buffer_size")).d().g()),
    ROUTE_COVERAGE(k.a(Boolean.class).a((Boolean)true).b("Toggle the route based coverage feature").a(Category.GENERAL_PROPERTIES).b(f.a("agent.route_coverage.enable")).g()),
    INVENTORY_DENYLIST(k.a(String.class).c().d().b("List of JAR, EAR, or WAR file names to skip during library scanning").a(Category.GENERAL_PROPERTIES).b(f.a("inventory.blacklist")).g()),
    ENABLE_RELOADABLE_BEANS(k.a(Boolean.class).a((Boolean)((Object)"contrast.agent.java.enable_reloadable_beans")).a((Boolean)false).d().b("Set to true to enable functionality in the com.contrastsecurity.agent.reloadable package. This is only needed for our legacy integration tests").a(Category.GENERAL_PROPERTIES).d("This should be removed along with the integration tests").g()),
    ENABLE_AGENT_CHANNEL_HUB(k.a(Boolean.class).a((Boolean)((Object)"contrast.agent.java.agent_channel_hub")).a((Boolean)false).d().b("Set to true to register the AgentChannelHub. This is only needed for our legacy integration tests").a(Category.INTERNAL_USAGE).d("This should be removed along with the integration tests").g()),
    SILENT_TELEMETRY_ENABLE(k.a(Boolean.class).a((Boolean)false).d().b("Toggle the diagnostics telemetry feature").a(Category.GENERAL_PROPERTIES).a(serverSettingsDTM -> {
        if (serverSettingsDTM != null && serverSettingsDTM.getTelemetry() != null) {
            return serverSettingsDTM.getTelemetry().getEnable();
        }
        return null;
    }).b(f.a("agent.silent_telemetry.enable")).g()),
    MAX_RETAINED_BUFFER_SIZE(k.a(Integer.class).a(512000).d().b("Maximum retained buffer size for request and response buffers").a(Category.PERFORMANCE).b(f.a("agent.retained_buffer_size")).g()),
    MAX_REQUEST_BODY_BUFFERING_DEFAULT(k.a(Integer.class).a(4096).d().b("Assess maximum request body size to buffer").a(Category.PERFORMANCE).b(f.a("assess.max_request_bytes_buffer")).g()),
    MAX_REQUEST_BODY_BYTES_CAPTURED(k.a(Integer.class).a(0x7FFFFFEE).d().b("Maximum number of request body bytes that will be captured for analysis. Note that individual plugins may specify lower values for this property than the default.").a(Category.PERFORMANCE).b(f.a("agent.java.max_request_body_bytes_captured")).g()),
    MAX_SNAPSHOT_TOSTRING_LENGTH(k.a(Integer.class).a(10000).d().b("Maximum length a String snapshot can be in DefaultObjectSnapshotFactory. Object's with toString implementations that produce longer Strings than this max will be denylisted and their class name used instead.").a(Category.PERFORMANCE).b(f.a("assess.max_snapshot_tostring_length")).g()),
    CMD_INJECTION_CENTRAL_RULES_ENABLE(k.a(Boolean.class).a((Boolean)false).d().b("Enable/disable the agent using the patterns and keywords from the Central Rules Repo for CmdInjection").a(Category.RULES_CONFIG).b(f.a("protect.cmd_injection.cr.enable")).g()),
    CMD_INJECTION_V2_ENABLE(k.a(Boolean.class).a((Boolean)false).d().b("Enable/disable path traversal using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.RULES_CONFIG).b(f.a("protect.cmd_injection.engine_v2")).g()),
    PATH_TRAVERSAL_CENTRAL_RULES_ENABLE(k.a(Boolean.class).a((Boolean)false).d().b("Enable/disable the agent using the patterns and keywords from the Central Rules Repo for PathTraversal").a(Category.RULES_CONFIG).b(f.a("protect.path_traversal.cr.enable")).g()),
    PATH_TRAVERSAL_V2_ENABLE(k.a(Boolean.class).a((Boolean)false).d().b("Enable/disable path traversal using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.RULES_CONFIG).b(f.a("protect.path_traversal.engine_v2")).g()),
    SQL_INJECTION_V2_ENABLE(k.a(Boolean.class).a((Boolean)false).d().b("Enable/disable SQLi using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.RULES_CONFIG).b(f.a("protect.sql_injection.engine_v2")).g()),
    SQL_INJECTION_PATTERNS_V2_ENABLE(k.a(Boolean.class).a((Boolean)false).d().b("Set to true to use the v2 patterns for SQLi").a(Category.INTERNAL_USAGE).b(f.a("protect.sql_injection.v2_patterns.enable")).g()),
    UNSAFE_FILE_UPLOAD_CENTRAL_RULES_ENABLE(k.a(Boolean.class).a((Boolean)false).d().b("Enable/disable the agent using the patterns and keywords from the Central Rules Repo for Unsafe File Upload").a(Category.RULES_CONFIG).b(f.a("protect.unsafe_file_upload.cr.enable")).g()),
    UNSAFE_FILE_UPLOAD_V2_ENABLE(k.a(Boolean.class).a((Boolean)false).d().b("Enable/disable UnsafeFileUpload using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.INTERNAL_USAGE).b(f.a("protect.unsafe_file_upload.engine_v2")).g()),
    XSS_CENTRAL_RULES_ENABLE(k.a(Boolean.class).a((Boolean)false).d().b("Enable/disable the agent using the patterns and keywords from the Central Rules Repo for XSS").a(Category.RULES_CONFIG).b(f.a("protect.xss.cr.enable")).g()),
    XSS_V2_ENABLE(k.a(Boolean.class).a((Boolean)false).d().b("Enable/disable SQLi using the Brics regex engine, see also alternative global setting: PROTECT_PATTERN_EVALUATION_V2_ENABLE").a(Category.RULES_CONFIG).b(f.a("protect.xss.engine_v2")).g()),
    SMTP_INJECTION_SAFE_TAGS(k.a(String.class).a("smtp-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    SSRF_SAFE_TAGS(k.a(String.class).a("ssrf.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    UNSAFE_XML_DECODE_SAFE_TAGS(k.a(String.class).a("unsafe-xml-decode.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    HARDCODED_PASSWORD_SAFE_TAGS(k.a(String.class).a("hardcoded-password.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    HARDCODED_KEY_SAFE_TAGS(k.a(String.class).a("hardcoded-key.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    INSECURE_SOCKET_FACTORY_SAFE_TAGS(k.a(String.class).a("insecure-socket-factory.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    SPRING_UNCHECKED_AUTOBINDING_SAFE_TAGS(k.a(String.class).a("spring-unchecked-autobinding.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    SCALA_PLAY_UNCHECKED_AUTOBINDING_SAFE_TAGS(k.a(String.class).a("scala-play-unchecked-autobinding.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    XXE_SAFE_TAGS(k.a(String.class).a("xxe.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    INSECURE_AUTH_PROTOCOL_SAFE_TAGS(k.a(String.class).a("insecure-auth-protocol.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    CLICKJACKING_CONTROL_MISSING_SAFE_TAGS(k.a(String.class).a("clickjacking-control-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    SESSION_REWRITING_SAFE_TAGS(k.a(String.class).a("session-rewriting.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    PARAMETER_POLLUTION_SAFE_TAGS(k.a(String.class).a("parameter-pollution.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    CACHE_CONTROLS_MISSING_SAFE_TAGS(k.a(String.class).a("cache-controls-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    AUTOCOMPLETE_MISSING_SAFE_TAGS(k.a(String.class).a("autocomplete-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    CSRF_SAFE_TAGS(k.a(String.class).a("csrf.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    INSECURE_JSP_ACCESS_SAFE_TAGS(k.a(String.class).a("insecure-jsp-access.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    SESSION_TIMEOUT_SAFE_TAGS(k.a(String.class).a("session-timeout.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    VERB_TAMPERING_SAFE_TAGS(k.a(String.class).a("verb-tampering.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    OVERLY_PERMISSIVE_CROSS_DOMAIN_POLICY_SAFE_TAGS(k.a(String.class).a("overly-permissive-cross-domain-policy.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    CMD_INJECTION_SAFE_TAGS(k.a(String.class).a("cmd-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    COOKIE_FLAGS_MISSING_SAFE_TAGS(k.a(String.class).a("cookie-flags-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    CRYPTO_BAD_CIPHERS_SAFE_TAGS(k.a(String.class).a("crypto-bad-ciphers.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    CRYPTO_BAD_MAC_SAFE_TAGS(k.a(String.class).a("crypto-bad-mac.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    CRYPTO_WEAK_RANDOMNESS_SAFE_TAGS(k.a(String.class).a("crypto-weak-randomness.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    EXPRESSION_LANGUAGE_INJECTION_SAFE_TAGS(k.a(String.class).a("expression-language-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    HTTPONLY_SAFE_TAGS(k.a(String.class).a("httponly.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    LDAP_INJECTION_SAFE_TAGS(k.a(String.class).a("ldap-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    LOG_INJECTION_SAFE_TAGS(k.a(String.class).a("log-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    PATH_TRAVERSAL_SAFE_TAGS(k.a(String.class).a("path-traversal.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    REFLECTED_XSS_SAFE_TAGS(k.a(String.class).a("reflected-xss.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    REFLECTION_INJECTION_SAFE_TAGS(k.a(String.class).a("reflection-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    HQL_INJECTION_SAFE_TAGS(k.a(String.class).a("hql-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    NOSQL_INJECTION_SAFE_TAGS(k.a(String.class).a("nosql-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    NOSQL_INJECTION_DYNAMODB_SAFE_TAGS(k.a(String.class).a("nosql-injection-dynamodb.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    SQL_INJECTION_SAFE_TAGS(k.a(String.class).a("sql-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    TRUST_BOUNDARY_VIOLATION_SAFE_TAGS(k.a(String.class).a("trust-boundary-violation.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    UNSAFE_READLINE_SAFE_TAGS(k.a(String.class).a("unsafe-readline.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    UNVALIDATED_FORWARD_SAFE_TAGS(k.a(String.class).a("unvalidated-forward.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    UNVALIDATED_REDIRECT_SAFE_TAGS(k.a(String.class).a("unvalidated-redirect.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    XPATH_INJECTION_SAFE_TAGS(k.a(String.class).a("xpath-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    HEADER_INJECTION_SAFE_TAGS(k.a(String.class).a("header-injection.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    UNTRUSTED_DESERIALIZATION_SAFE_TAGS(k.a(String.class).a("untrusted-deserialization.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    HSTS_HEADER_MISSING_SAFE_TAGS(k.a(String.class).a("hsts-header-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    XCONTENTTYPE_HEADER_MISSING_SAFE_TAGS(k.a(String.class).a("xcontenttype-header-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    XXSSPROTECTION_HEADER_DISABLED_SAFE_TAGS(k.a(String.class).a("xxssprotection-header-disabled.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    CSP_HEADER_MISSING_SAFE_TAGS(k.a(String.class).a("csp-header-missing.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    CSP_HEADER_INSECURE_SAFE_TAGS(k.a(String.class).a("csp-header-insecure.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    REDOS_SAFE_TAGS(k.a(String.class).a("redos.safetags").c().b("Comma separated list of additional custom safe tags to apply to Assess rule").a(Category.SAFE_TAGS).d().d("Safe-tags are not supported by the Common Config spec").g()),
    NONEXISTENT_CONFIG_PROPERTY(k.a(String.class).a("config.does-not-exist").c().b("A nonexistent config property that will always return null").a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    TEST_CONFIG_STRING_PROPERTY(k.a(String.class).a("config.test.string").a("foo").b("Test config property used in unit tests for the Config or ConfigProviders").a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    TEST_CONFIG_INT_PROPERTY(k.a(Integer.class).a((Integer)((Object)"config.test.int")).a(420).b("Test config property used in unit tests for the Config or ConfigProviders").a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    TEST_CONFIG_BOOLEAN_PROPERTY(k.a(Boolean.class).a((Boolean)((Object)"config.test.boolean")).a((Boolean)false).b("Test config property used in unit tests for the Config or ConfigProviders").a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    PROTECT_FAKE_RULE_MODE(k.a(String.class).a("contrast.defend.fake-rule.mode").c().b("Test property for enabling ProtectRule").a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    FAKE_RULE_MODE_ENABLED(k.a(String.class).a("enabled-fake-rule").c().b("Test property for enabling ProtectRule").a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    FAKE_RULE_MODE_DISABLED(k.a(String.class).a("disabled-fake-rule").c().b("Test property for disabling ProtectRule").a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    FAKE_FEATURES_CONFIGURABLE_STRING_PROPERTY(k.a(String.class).a("test-key").c().a(serverSettingsDTM -> "foo").a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    FAKE_FEATURES_CONFIGURABLE_INT_PROPERTY(k.a(Integer.class).a((Integer)((Object)"test-key-int")).a(17).a(serverSettingsDTM -> 42).a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    FAKE_FEATURES_CONFIGURABLE_LONG_PROPERTY(k.a(Long.class).a((Long)((Object)"test-key-long")).a(100000000000L).a(serverSettingsDTM -> 420L).a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    FAKE_FEATURES_CONFIGURABLE_BOOLEAN_PROPERTY(k.a(Boolean.class).a((Boolean)((Object)"test-key-bool")).a((Boolean)false).a(serverSettingsDTM -> true).a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    PROPERTY_OVERRIDE_PATTERN_JSON(k.a(String.class).a("contrast.pattern.json.override").c().a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    PROPERTY_OVERRIDE_KEYWORD_JSON(k.a(String.class).a("contrast.keyword.json.override").c().a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    PROPERTY_OVERRIDE_BREAK_ON_THRESHOLD(k.a(Boolean.class).a((Boolean)((Object)"contrast.break.on.threshold")).a((Boolean)true).a(Category.INTERNAL_USAGE).d().d("Test properties cannot be set via YAML").g()),
    AGENT_TELEMETRY_OPT_OUT(k.a(Boolean.class).a((Boolean)false).b("Opt out of the collection of metrics and their submission to the remote endpoint").a(Category.TELEMETRY).d().b(f.a("agent.telemetry.optout")).g()),
    AGENT_TELEMETRY_INITIAL_DELAY(k.a(Long.class).a((Long)((Object)"contrast.agent.telemetry.initial.delay.mins")).a(2L).b("Grace period following start-up, before which metric publishing will be prohibited").a(Category.TELEMETRY).d().d("Not yet supported by common config").g()),
    AGENT_TELEMETRY_SUBMISSION_CADENCE(k.a(Long.class).a((Long)((Object)"contrast.agent.telemetry.submission.cadence.mins")).a(180L).b("Time between submissions of metric registry contents to remote endpoint (minutes)").a(Category.TELEMETRY).d().d("Not yet supported by common config").g()),
    AGENT_TELEMETRY_SUBMISSION_ENDPOINT(k.a(String.class).a("contrast.agent.telemetry.submission.endpoint").a("https://telemetry.java.contrastsecurity.com/api/v1/telemetry/").b("The URL to which metrics will be sent at submission").a(Category.TELEMETRY).d().d("Not yet supported by common config").g()),
    AGENT_TELEMETRY_SUBMISSION_TIMEOUT(k.a(Integer.class).a((Integer)((Object)"contrast.agent.telemetry.submission.timeout")).a(30000).b("The connect or read timeout for submitting to Telemetry").a(Category.TELEMETRY).d().d("Not yet supported by common config").g()),
    AGENT_TELEMETRY_CUSTOM_TAGS(k.a(String.class).c().b("Allows specific tags to be set for Telemetry, two tags can be set using this value, separated by a comma. Commas are not allowed as tag values. Any leading or trailing whitespace will be trimmed for each tag value. The first tag will be named 'customTag1' and the second 'customTag2'").a(Category.TELEMETRY).d().b(f.a("agent.telemetry.tags")).g()),
    APPMGR_JARANALYZER_TTL(k.a(Long.class).a((Long)((Object)"contrast.agent.appmgr.jaranalyzer.ttl")).a(TimeUnit.MINUTES.toMillis(10L)).b("TTL for JarAnalyzer in ApplicationManager in milliseconds, default 10 minutes").a(Category.PERFORMANCE).d().d("Agent-only config").g()),
    TELEMETRY_ERROR_MAX_RETAINED_IN_MEM_BYTES(k.a(Long.class).a((Long)((Object)"contrast.agent.telemetry.error.max_error_retained_bytes")).a(0x600000L).b("The max size in bytes we allow to be stored in memory before error submissions. This is a best effort setting and the size in some JVMs may be larger than this value.").a(Category.TELEMETRY).d().d("Not yet supported by common config").g()),
    TELEMETRY_ERROR_MAX_QUEUE_SIZE(k.a(Integer.class).a((Integer)((Object)"contrast.agent.telemetry.error.max_queue_size")).a(32).b("The max number of Throwables to emit for Agent Telemetry Error Reporting.").a(Category.TELEMETRY).d().d("Not yet supported by common config").g()),
    PROTECT_PATTERN_EVALUATION_V2_ENABLE(k.a(Boolean.class).a((Boolean)false).b("Whether the agent should use it's v2 Protect pattern evaluation").a(Category.INTERNAL_USAGE).d().b(f.a("agent.java.protect_pattern_evaluation_engine_v2")).g());

    public static final int INT_PROPERTY_NOT_SET = -1;
    private final k<?> metadata;

    private static DiagnosticsLoggerDTM getDiagnosticsLogger(ServerSettingsDTM serverSettingsDTM) {
        if (serverSettingsDTM == null) {
            return null;
        }
        DiagnosticsDTM diagnosticsDTM = serverSettingsDTM.getDiagnostics();
        if (diagnosticsDTM == null) {
            return null;
        }
        DiagnosticsLoggerDTM diagnosticsLoggerDTM = diagnosticsDTM.getDiagnosticsLogger();
        if (diagnosticsLoggerDTM == null) {
            return null;
        }
        return diagnosticsLoggerDTM;
    }

    private ConfigProperty(k<?> k2) {
        this.metadata = Objects.requireNonNull(k2);
    }

    public boolean isHidden() {
        return this.metadata.h();
    }

    public String legacySystemPropertyName() {
        return this.metadata.b();
    }

    public Class<?> type() {
        return this.metadata.a();
    }

    public String description() {
        return this.metadata.c();
    }

    public boolean hasNullDefaultValue() {
        return this.metadata.e();
    }

    public String deprecationAlternative() {
        return this.metadata.f();
    }

    public boolean isDeprecated() {
        return this.metadata.f() == null;
    }

    public Object defaultValue() {
        if (this.hasNullDefaultValue()) {
            return null;
        }
        return this.metadata.d();
    }

    public boolean isAppSpecific() {
        return this.metadata.j();
    }

    public Category category() {
        return this.metadata.g();
    }

    public boolean isCommonConfigExempt() {
        return this.metadata.m() != null;
    }

    public boolean isYamlConfigurable() {
        return this.metadata.o() != null;
    }

    public String commonConfigPathOrNull() {
        return this.metadata.o() != null ? this.metadata.o().a() : null;
    }

    public final String commonConfigSystemPropertyName() {
        f f2 = this.metadata.o();
        if (f2 == null) {
            throw new UnsupportedOperationException("This property does not support common config");
        }
        return "contrast." + f2.a();
    }

    public final String commonConfigEnvVarName() {
        String string = this.canonicalName();
        if (string == null) {
            throw new UnsupportedOperationException("This property does not support common config");
        }
        return ConfigProperty.commonConfigPathToEnvVarName(string);
    }

    public static String commonConfigPathToEnvVarName(String string) {
        return ("CONTRAST__" + StringUtils.join((Object[])StringUtils.split(string, "."), "__")).toUpperCase(Locale.US);
    }

    public final String canonicalName() {
        return this.metadata.o() != null ? this.metadata.o().a() : this.metadata.b();
    }

    public List<String> deprecatedPathsOrEmpty() {
        return this.metadata.o() != null ? this.metadata.o().b() : Collections.emptyList();
    }

    public boolean shouldMask() {
        return this.metadata.i();
    }

    public boolean supportsProfile() {
        if (this.metadata.o() != null) {
            return this.metadata.o().c();
        }
        return false;
    }

    public Object parse(String string, l l2) {
        try {
            return l2.a(this.type(), string);
        }
        catch (com.contrastsecurity.agent.config.e | NumberFormatException illegalArgumentException) {
            throw new e("Value " + string + " for config property " + this.legacySystemPropertyName() + " could not be parsed as a " + this.type().getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new e("Attempted to parse " + this.legacySystemPropertyName() + " as a " + this.type().getName() + " but " + this.type().getName() + " is not a supported configuration property type");
        }
    }

    public static ConfigProperty propertyFromString(String string) {
        Objects.requireNonNull(string);
        for (ConfigProperty configProperty : ConfigProperty.values()) {
            if (!string.equals(configProperty.legacySystemPropertyName())) continue;
            return configProperty;
        }
        return null;
    }

    public static ConfigProperty propertyFromYamlString(String string) {
        for (ConfigProperty configProperty : m.b.a()) {
            Object object;
            String string2 = configProperty.commonConfigPathOrNull();
            if (string2 != null) {
                if (string2.equals(string)) {
                    return configProperty;
                }
                object = "contrast." + string2;
                if (((String)object).equals(string)) {
                    return configProperty;
                }
            }
            object = configProperty.deprecatedPathsOrEmpty();
            Iterator<String> iterator = object.iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                if (string3.equals(string)) {
                    return configProperty;
                }
                String string4 = "contrast." + string3;
                if (!string4.equals(string)) continue;
                return configProperty;
            }
        }
        return null;
    }

    public w<?> serverSettingsExtractor() {
        return this.metadata.k();
    }

    public boolean isFeatureConfigurable() {
        return this.metadata.k() != null;
    }

    public Object fromServerSettings(ServerSettingsDTM serverSettingsDTM) {
        w<?> w2 = this.serverSettingsExtractor();
        return w2.extract(serverSettingsDTM);
    }

    public com.contrastsecurity.agent.config.a<?> appSettingsExtractorClass() {
        return this.metadata.l();
    }

    public boolean isAppSettingsConfigurable() {
        return this.metadata.l() != null;
    }

    public Object fromAppSettings(ApplicationSettingsDTM applicationSettingsDTM) {
        com.contrastsecurity.agent.config.a<?> a2 = this.appSettingsExtractorClass();
        return a2.extract(applicationSettingsDTM);
    }

    public String toString() {
        return this.canonicalName();
    }

    private static boolean isPositive(Integer n2) {
        return n2 != null && n2 > 0;
    }

    public static final class a {
        public static final int a = 10000;

        private a() {
        }
    }

    @DontObfuscate
    public static enum Category {
        GENERAL_PROPERTIES,
        LOGGING_ASSESS,
        LOGGING_PROTECT,
        DIAGNOSTICS,
        PERFORMANCE,
        POLICY,
        RULES_CONFIG,
        PROTECT_MODE_CONFIG,
        FRAMEWORK_SUPPORT,
        PROXY_SETTINGS,
        INTERNAL_USAGE,
        SAFE_TAGS,
        TELEMETRY;

    }
}

