/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.contrastapi_v1_0.telemetry;

import com.contrastsecurity.agent.commons.k;
import com.contrastsecurity.agent.contrastapi_v1_0.HttpRequestDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.telemetry.ApplicationDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.telemetry.ServerDTM;
import com.contrastsecurity.thirdparty.com.google.gson.JsonElement;
import com.contrastsecurity.thirdparty.com.google.gson.JsonObject;
import com.contrastsecurity.thirdparty.com.google.gson.JsonPrimitive;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSerializationContext;
import com.contrastsecurity.thirdparty.com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

public final class SilentTelemetryDTM {
    private final String agentLanguage;
    private final String agentVersion;
    private final ApplicationDTM application;
    private final HttpRequestDTM httpRequest;
    private final String experimentName;
    private final Map<String, String> results;
    private final ServerDTM server;
    private final Long timestamp;

    private SilentTelemetryDTM(Builder builder) {
        Objects.requireNonNull(builder.agentLanguage);
        Objects.requireNonNull(builder.agentVersion);
        Objects.requireNonNull(builder.experimentName);
        Objects.requireNonNull(builder.results);
        Objects.requireNonNull(builder.timestamp);
        this.agentLanguage = builder.agentLanguage;
        this.agentVersion = builder.agentVersion;
        this.application = builder.application;
        this.httpRequest = builder.httpRequest;
        this.experimentName = builder.experimentName;
        this.results = k.a(builder.results);
        this.server = builder.server;
        this.timestamp = builder.timestamp;
    }

    public String agentLanguage() {
        return this.agentLanguage;
    }

    public String agentVersion() {
        return this.agentVersion;
    }

    public ApplicationDTM application() {
        return this.application;
    }

    public HttpRequestDTM httpRequest() {
        return this.httpRequest;
    }

    public String experimentName() {
        return this.experimentName;
    }

    public Map<String, String> results() {
        return this.results;
    }

    public ServerDTM server() {
        return this.server;
    }

    public Long timestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "SilentTelemetryDTM{agentLanguage='" + this.agentLanguage + '\'' + ", agentVersion='" + this.agentVersion + '\'' + ", application=" + this.application + ", httpRequest=" + this.httpRequest + ", experimentName='" + this.experimentName + '\'' + ", results=" + this.results + ", server=" + this.server + ", timestamp=" + this.timestamp + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SilentTelemetryDTM silentTelemetryDTM = (SilentTelemetryDTM)object;
        if (!this.agentLanguage.equals(silentTelemetryDTM.agentLanguage)) {
            return false;
        }
        if (!this.agentVersion.equals(silentTelemetryDTM.agentVersion)) {
            return false;
        }
        if (this.application != null ? !this.application.equals(silentTelemetryDTM.application) : silentTelemetryDTM.application != null) {
            return false;
        }
        if (this.httpRequest != null ? !this.httpRequest.equals(silentTelemetryDTM.httpRequest) : silentTelemetryDTM.httpRequest != null) {
            return false;
        }
        if (!this.experimentName.equals(silentTelemetryDTM.experimentName)) {
            return false;
        }
        if (!this.results.equals(silentTelemetryDTM.results)) {
            return false;
        }
        if (this.server != null ? !this.server.equals(silentTelemetryDTM.server) : silentTelemetryDTM.server != null) {
            return false;
        }
        return this.timestamp.equals(silentTelemetryDTM.timestamp);
    }

    public int hashCode() {
        int n2 = this.agentLanguage.hashCode();
        n2 = 31 * n2 + this.agentVersion.hashCode();
        n2 = 31 * n2 + (this.application != null ? this.application.hashCode() : 0);
        n2 = 31 * n2 + (this.httpRequest != null ? this.httpRequest.hashCode() : 0);
        n2 = 31 * n2 + this.experimentName.hashCode();
        n2 = 31 * n2 + this.results.hashCode();
        n2 = 31 * n2 + (this.server != null ? this.server.hashCode() : 0);
        n2 = 31 * n2 + this.timestamp.hashCode();
        return n2;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class SilentTelemetrySerializer
    implements JsonSerializer<SilentTelemetryDTM> {
        @Override
        public JsonElement serialize(SilentTelemetryDTM silentTelemetryDTM, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("agent_language", silentTelemetryDTM.agentLanguage());
            jsonObject.addProperty("agent_version", silentTelemetryDTM.agentVersion());
            jsonObject.add("application", jsonSerializationContext.serialize(silentTelemetryDTM.application()));
            jsonObject.addProperty("name", silentTelemetryDTM.experimentName());
            jsonObject.add("results", jsonSerializationContext.serialize(silentTelemetryDTM.results()));
            jsonObject.add("server", jsonSerializationContext.serialize(silentTelemetryDTM.server()));
            jsonObject.addProperty("timestamp", silentTelemetryDTM.timestamp());
            if (silentTelemetryDTM.httpRequest() != null) {
                JsonObject jsonObject2 = jsonSerializationContext.serialize(silentTelemetryDTM.httpRequest()).getAsJsonObject();
                JsonPrimitive jsonPrimitive = jsonObject2.getAsJsonPrimitive("queryString");
                if (jsonPrimitive != null) {
                    jsonObject2.addProperty("query_string", ((JsonElement)jsonPrimitive).getAsString());
                }
                jsonObject2.remove("queryString");
                jsonObject2.remove("standardNormalizedUri");
                jsonObject2.remove("contextPath");
                jsonObject2.remove("serverVersionInfo");
                jsonObject.add("http_request", jsonObject2);
            }
            return jsonObject;
        }
    }

    public static final class Builder {
        private String agentLanguage;
        private String agentVersion;
        private ApplicationDTM application;
        private HttpRequestDTM httpRequest;
        private String experimentName;
        private Map<String, String> results;
        private ServerDTM server;
        private Long timestamp;

        private Builder() {
        }

        public Builder agentLanguage(String string) {
            this.agentLanguage = string;
            return this;
        }

        public Builder agentVersion(String string) {
            this.agentVersion = string;
            return this;
        }

        public Builder application(ApplicationDTM applicationDTM) {
            this.application = applicationDTM;
            return this;
        }

        public Builder httpRequest(HttpRequestDTM httpRequestDTM) {
            this.httpRequest = httpRequestDTM;
            return this;
        }

        public Builder experimentName(String string) {
            this.experimentName = string;
            return this;
        }

        public Builder results(Map<String, String> map) {
            this.results = map;
            return this;
        }

        public Builder server(ServerDTM serverDTM) {
            this.server = serverDTM;
            return this;
        }

        public Builder timestamp(Long l2) {
            this.timestamp = l2;
            return this;
        }

        public SilentTelemetryDTM build() {
            return new SilentTelemetryDTM(this);
        }
    }
}

