/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.core;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.c.a;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.commons.d;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.j;
import com.contrastsecurity.agent.config.y;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.core.ContrastVersion;
import com.contrastsecurity.agent.core.c;
import com.contrastsecurity.agent.core.q;
import com.contrastsecurity.agent.core.s;
import com.contrastsecurity.agent.e;
import com.contrastsecurity.agent.g;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.l;
import com.contrastsecurity.agent.m;
import com.contrastsecurity.agent.p;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.J2EEClassCache;
import com.contrastsecurity.agent.plugins.frameworks.o;
import com.contrastsecurity.agent.plugins.frameworks.x.h;
import com.contrastsecurity.agent.plugins.i;
import com.contrastsecurity.agent.s.b;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.scope.ScopeModule;
import com.contrastsecurity.agent.services.a.f;
import com.contrastsecurity.agent.startup.FatalStartupException;
import com.contrastsecurity.agent.startup.v;
import com.contrastsecurity.agent.telemetry.b.k;
import com.contrastsecurity.agent.util.G;
import com.contrastsecurity.agent.util.N;
import com.contrastsecurity.agent.util.O;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.agent.x;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@DontObfuscate
public class ContrastAgent {
    private static final String DELAYED_BOOT_STRATEGY = "boot";
    private static final String DELAYED_ACTIVATION_STRATEGY = "activation";
    private static final String ERROR_PROBABILISTIC_VALUE = "Unable to process probabilistic startup value";
    private static ContrastVersion version = ContrastVersion.fromDefaults();

    @ScopedSensor
    public static void setup(String string, Instrumentation instrumentation, File file, StartupTiming startupTiming) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        String string2 = string;
        Instrumentation instrumentation2 = instrumentation;
        File file2 = file;
        StartupTiming startupTiming2 = startupTiming;
        try {
            block10: {
                com.contrastsecurity.agent.config.g g2;
                Objects.requireNonNull(instrumentation2);
                version = ContrastVersion.fromJarFile(file2);
                N n2 = O.b();
                ContrastAgent.patchLiferayLocaleErrors();
                com.contrastsecurity.agent.startup.e e2 = new com.contrastsecurity.agent.startup.e();
                try {
                    g2 = e2.a(string2);
                }
                catch (e e3) {
                    G.b("Couldn't initialize Contrast. Invalid configuration: " + e3.getMessage());
                    e3.printStackTrace(System.err);
                    ContrastAgent.logStartingWithoutContrast();
                    break block10;
                }
                j.a(g2);
                n2.b();
                startupTiming2.configLoadTimeNs(n2.e());
                boolean bl2 = g2.f(ConfigProperty.SUPPRESS_STDOUT);
                if (bl2) {
                    G.a();
                }
                if (!ContrastAgent.isAgentStartupDisabled(g2)) {
                    int n3 = ContrastAgent.getStartupDelay(g2);
                    if (n3 > 0) {
                        ContrastAgent.delayedStartup(string2, instrumentation2, g2, n3, startupTiming2);
                    } else {
                        ContrastEngine contrastEngine = ContrastAgent.startup(string2, instrumentation2, g2, startupTiming2);
                        if (contrastEngine != null) {
                            contrastEngine.activatePlugins();
                        }
                    }
                }
            }
            string2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (string2 != null) {
            throw string2;
        }
    }

    @C
    static boolean isAgentStartupDisabled(com.contrastsecurity.agent.config.g g2) {
        if (!g2.f(ConfigProperty.ENABLED)) {
            return true;
        }
        try {
            a a2 = ContrastAgent.probabilisticStartupCheck(g2);
            return a2 != null && !a2.a();
        }
        catch (FatalStartupException fatalStartupException) {
            return true;
        }
    }

    private static a probabilisticStartupCheck(com.contrastsecurity.agent.config.g g2) throws FatalStartupException {
        int n2;
        try {
            n2 = g2.d(ConfigProperty.PROBABILISTIC_STARTUP);
        }
        catch (e e2) {
            ContrastAgent.logProbabilisticStartupConfigError("Probabilistic startup was specified but with non-numeric value");
            throw new FatalStartupException(ERROR_PROBABILISTIC_VALUE);
        }
        if (n2 != -1) {
            try {
                return new a(n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ContrastAgent.logProbabilisticStartupConfigError("Probabilistic startup was specified but with an invalid value: " + n2);
                throw new FatalStartupException(ERROR_PROBABILISTIC_VALUE);
            }
        }
        return null;
    }

    private static void logProbabilisticStartupConfigError(String string) {
        G.b(string);
        G.b("Please specify a number between 1 and 99 (percentage)");
        ContrastAgent.logStartingWithoutContrast();
    }

    private static void logStartingWithoutContrast() {
        G.b("Continuing without Contrast...");
    }

    private static void delayedStartup(String string, Instrumentation instrumentation, com.contrastsecurity.agent.config.g g2, int n2, StartupTiming startupTiming) {
        String string2 = g2.c(ConfigProperty.DELAYED_STARTUP_STRATEGY);
        if (string2 == null || DELAYED_ACTIVATION_STRATEGY.equalsIgnoreCase(string2)) {
            ContrastEngine contrastEngine = ContrastAgent.startup(string, instrumentation, g2, startupTiming);
            l l2 = new l(contrastEngine, n2, contrastEngine.getErrorEmitter());
            l2.setDaemon(true);
            l2.start();
        } else if (DELAYED_BOOT_STRATEGY.equalsIgnoreCase(string2)) {
            m m2 = new m(n2, string, instrumentation, g2, startupTiming);
            m2.setDaemon(true);
            m2.start();
        } else {
            G.b("Invalid delayed startup strategy (" + string2 + ")");
        }
    }

    static int getStartupDelay(com.contrastsecurity.agent.config.g g2) {
        int n2 = 0;
        try {
            n2 = g2.d(ConfigProperty.DELAYED_STARTUP);
        }
        catch (e e2) {
            // empty catch block
        }
        return Math.max(n2, 0);
    }

    public static ContrastEngine startup(String string, Instrumentation instrumentation, com.contrastsecurity.agent.config.g g2, StartupTiming startupTiming) {
        N n2 = O.b();
        G.a("Starting Contrast (build " + ContrastAgent.getBuildVersion() + ") Pat. 8,458,789 B2");
        com.contrastsecurity.agent.services.b b2 = new com.contrastsecurity.agent.services.b();
        com.contrastsecurity.agent.v.s s2 = com.contrastsecurity.agent.v.s.a(g2);
        com.contrastsecurity.agent.logging.c c2 = com.contrastsecurity.agent.logging.log4j2.g.a(g2, s2, b2);
        Logger logger = LoggerFactory.getLogger(ContrastAgent.class);
        try {
            new b().a();
            com.contrastsecurity.agent.telemetry.f f2 = com.contrastsecurity.agent.telemetry.f.a(g2, s2);
            com.contrastsecurity.agent.commons.v v2 = new com.contrastsecurity.agent.commons.v();
            k k2 = f2.d();
            c2.a(b2, k2);
            com.contrastsecurity.agent.telemetry.b.c.f.a(k2, v2);
            com.contrastsecurity.agent.telemetry.b b3 = new com.contrastsecurity.agent.telemetry.b(k2.a());
            com.contrastsecurity.agent.q.b b4 = com.contrastsecurity.agent.q.b.a();
            ContrastEngine contrastEngine = ContrastAgent.createContrastEngine(string, instrumentation, g2, new com.contrastsecurity.agent.plugins.a.l(), c2, startupTiming, s2, b2, v2, f2, b3, b4);
            n2.b();
            String string2 = "JVM uptime time before agent: " + startupTiming.getJvmUptimeAtPremainMs() + "ms";
            PerfUtil.printStartupTimingMessage(string2);
            long l2 = TimeUnit.NANOSECONDS.toMillis(startupTiming.getTimeForJarTmpInjectionNs());
            PerfUtil.printStartupTimingMessage(PerfUtil.a.a, "jar-injection", l2);
            b3.a(PerfUtil.a.a, "load-config", startupTiming.configLoadMs());
            b3.a(PerfUtil.a.a, "primordial", n2);
            contrastEngine.start(startupTiming);
            return contrastEngine;
        }
        catch (FatalStartupException fatalStartupException) {
            G.b("Couldn't initialize Contrast. See log for details.");
            logger.error("Unexpected error starting up. Continuing without Contrast", fatalStartupException);
            return null;
        }
    }

    @C
    static void patchLiferayLocaleErrors() {
        String string = x.b("java.locale.providers");
        if (string == null || string.isEmpty()) {
            return;
        }
        String string2 = string.toUpperCase(Locale.ROOT);
        if (!string2.contains("COMPAT")) {
            return;
        }
        String[] stringArray = string2.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if (string3.trim().equals("COMPAT")) {
                stringBuilder.append("JRE");
                continue;
            }
            stringBuilder.append(string3.trim());
        }
        x.a("java.locale.providers", stringBuilder.toString());
    }

    @C
    static ContrastEngine createContrastEngine(String string, Instrumentation instrumentation, com.contrastsecurity.agent.config.g g2, com.contrastsecurity.agent.plugins.a.l l2, com.contrastsecurity.agent.logging.c c2, StartupTiming startupTiming, com.contrastsecurity.agent.v.s s2, com.contrastsecurity.agent.services.b b2, d d2, com.contrastsecurity.agent.telemetry.f f2, com.contrastsecurity.agent.telemetry.b b3, com.contrastsecurity.agent.q.b b4) throws FatalStartupException {
        y y2;
        try {
            y2 = y.a(g2);
        }
        catch (IOException iOException) {
            throw new g("Unable to create references to working directories", iOException);
        }
        c c3 = q.a().a(d2).a(g2).a(s2).a(y2).a(b2).a(instrumentation).a(f2).a(startupTiming).a(b3).a();
        com.contrastsecurity.agent.services.a.C c4 = c3.a();
        com.contrastsecurity.agent.o.e e2 = c3.b();
        com.contrastsecurity.agent.o.l l3 = c3.i();
        com.contrastsecurity.agent.plugins.a.a a2 = c3.s();
        com.contrastsecurity.agent.n.a a3 = c3.t();
        h h2 = c3.d();
        J2EEClassCache j2EEClassCache = c3.e();
        com.contrastsecurity.agent.plugins.frameworks.j2ee.h h3 = c3.f();
        com.contrastsecurity.agent.apps.java.codeinfo.b b5 = c3.g();
        com.contrastsecurity.agent.apps.java.codeinfo.d d3 = c3.h();
        ApplicationManager applicationManager = c3.k();
        com.contrastsecurity.agent.features.c c5 = c3.c();
        o o2 = c3.r();
        HttpManager httpManager = c3.q();
        i i2 = c3.j();
        com.contrastsecurity.agent.plugins.security.d.g g3 = c3.u();
        p p2 = c3.v();
        com.contrastsecurity.agent.telemetry.errors.m m2 = f2.g();
        com.contrastsecurity.agent.telemetry.c.a a4 = c3.w();
        if (l3 instanceof com.contrastsecurity.agent.o.o) {
            ((com.contrastsecurity.agent.o.o)l3).a(httpManager);
        }
        l2.a(g2);
        a4.a();
        com.contrastsecurity.agent.services.a a5 = c3.m();
        List<com.contrastsecurity.agent.services.a> list = com.contrastsecurity.agent.commons.j.a(a5, a3, f2);
        com.contrastsecurity.agent.services.ngreporting.g g4 = c3.x();
        f<ArchitectureComponent> f3 = c3.n();
        List<v> list2 = s.a(g2, d2, g3, c5, o2, i2, httpManager, p2, d3, applicationManager, a2, s2, l2, g4, ScopeModule.scopeProvider(), j2EEClassCache, h3, y2, b5, f2, c2, a3.d(), l3, c3.o(), c3.p(), h2, f3, b3, b2.a(), a4, b4, e2);
        return new ContrastEngine(string, instrumentation, s2, g2, list2, null, d2, list, c5, o2, i2, applicationManager, l2, c4, g4, ScopeModule.scopeProvider(), y2, f2.d(), m2, a3.d(), c2, b2, b3, a4, e2);
    }

    public static String getJarName() {
        return version.getJarName();
    }

    static void setVersion(ContrastVersion contrastVersion) {
        version = contrastVersion;
    }

    public static String getBuildVersion() {
        return version.getVersion();
    }

    public static String getBuildTime() {
        return version.getBuildTime();
    }
}

