/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.core;

import com.contrastsecurity.agent.Contrast;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.commons.d;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.y;
import com.contrastsecurity.agent.core.r;
import com.contrastsecurity.agent.core.s;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.instr.a.c;
import com.contrastsecurity.agent.j;
import com.contrastsecurity.agent.o.e;
import com.contrastsecurity.agent.p;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.frameworks.o;
import com.contrastsecurity.agent.plugins.i;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.services.a.C;
import com.contrastsecurity.agent.services.a.X;
import com.contrastsecurity.agent.services.a.at;
import com.contrastsecurity.agent.services.h;
import com.contrastsecurity.agent.services.k;
import com.contrastsecurity.agent.services.ngreporting.LegacyReport;
import com.contrastsecurity.agent.services.ngreporting.g;
import com.contrastsecurity.agent.startup.FatalStartupException;
import com.contrastsecurity.agent.startup.u;
import com.contrastsecurity.agent.startup.v;
import com.contrastsecurity.agent.startup.x;
import com.contrastsecurity.agent.telemetry.errors.m;
import com.contrastsecurity.agent.util.G;
import com.contrastsecurity.agent.util.N;
import com.contrastsecurity.agent.util.O;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.agent.util.V;
import com.contrastsecurity.agent.v.t;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@DontObfuscate
public class ContrastEngine
implements i {
    private final com.contrastsecurity.agent.features.c featureManager;
    private final o frameworkManager;
    private final i pluginManager;
    private final ApplicationManager applicationManager;
    private final com.contrastsecurity.agent.plugins.a.k applicationSettingsUpdateEventBus;
    private final ScopeProvider scopeProvider;
    private j transformer;
    private final g legacyReportingService;
    private com.contrastsecurity.agent.services.a compositeServices;
    private final String args;
    private final Instrumentation inst;
    private final com.contrastsecurity.agent.config.g config;
    private final com.contrastsecurity.agent.services.b executorServiceModule;
    private final d clock;
    private final y directories;
    private final a servicesFactory;
    private final C apiClient;
    private final r failureStrategy;
    private final com.contrastsecurity.agent.v.s server;
    private final Queue<com.contrastsecurity.agent.apps.java.b> classLoadEvents;
    private final com.contrastsecurity.agent.logging.c loggerManager;
    private final m errorEmitter;
    private final com.contrastsecurity.agent.telemetry.b startupTimingReporter;
    private final com.contrastsecurity.agent.telemetry.c.a observabilityService;
    private final e eventListener;
    private final List<v> startupTasks;
    private final com.contrastsecurity.agent.telemetry.b.k metrics;
    private static final Logger logger = LoggerFactory.getLogger(ContrastEngine.class);

    public Instrumentation getInstrumentation() {
        return this.inst;
    }

    @Override
    public List<ContrastPlugin> getPlugins() {
        return this.pluginManager.getPlugins();
    }

    @Override
    public void forEachEnabled(Application application, HttpRequest httpRequest, Consumer<ContrastPlugin> consumer) {
        this.pluginManager.forEachEnabled(application, httpRequest, consumer);
    }

    @Override
    public void forEachDisabled(Application application, HttpRequest httpRequest, Consumer<ContrastPlugin> consumer) {
        this.pluginManager.forEachDisabled(application, httpRequest, consumer);
    }

    public m getErrorEmitter() {
        return this.errorEmitter;
    }

    public ContrastEngine(String string, Instrumentation instrumentation, com.contrastsecurity.agent.v.s s2, com.contrastsecurity.agent.config.g g2, List<v> list, a a2, d d2, List<com.contrastsecurity.agent.services.a> list2, com.contrastsecurity.agent.features.c c2, o o2, i i2, ApplicationManager applicationManager, com.contrastsecurity.agent.plugins.a.k k2, C c3, g g3, ScopeProvider scopeProvider, y y2, com.contrastsecurity.agent.telemetry.b.k k3, m m2, Queue<com.contrastsecurity.agent.apps.java.b> queue, com.contrastsecurity.agent.logging.c c4, com.contrastsecurity.agent.services.b b2, com.contrastsecurity.agent.telemetry.b b3, com.contrastsecurity.agent.telemetry.c.a a3, e e2) {
        this.args = string;
        this.inst = Objects.requireNonNull(instrumentation);
        this.server = Objects.requireNonNull(s2);
        this.config = Objects.requireNonNull(g2);
        this.startupTasks = com.contrastsecurity.agent.commons.j.a((Collection)Objects.requireNonNull(list));
        this.eventListener = Objects.requireNonNull(e2);
        this.servicesFactory = a2 == null ? new b(com.contrastsecurity.agent.commons.j.a((Collection)Objects.requireNonNull(list2))) : a2;
        this.clock = Objects.requireNonNull(d2);
        this.featureManager = Objects.requireNonNull(c2);
        this.frameworkManager = Objects.requireNonNull(o2);
        this.pluginManager = Objects.requireNonNull(i2);
        this.applicationManager = Objects.requireNonNull(applicationManager);
        this.applicationSettingsUpdateEventBus = Objects.requireNonNull(k2);
        this.apiClient = Objects.requireNonNull(c3);
        this.executorServiceModule = Objects.requireNonNull(b2);
        this.legacyReportingService = Objects.requireNonNull(g3);
        this.scopeProvider = Objects.requireNonNull(scopeProvider);
        this.directories = Objects.requireNonNull(y2);
        this.metrics = Objects.requireNonNull(k3);
        this.classLoadEvents = Objects.requireNonNull(queue);
        this.loggerManager = Objects.requireNonNull(c4);
        this.errorEmitter = Objects.requireNonNull(m2);
        this.failureStrategy = r.a(g2.b(ConfigProperty.STARTUP_FAILURE_STRATEGY));
        this.startupTimingReporter = Objects.requireNonNull(b3);
        this.observabilityService = Objects.requireNonNull(a3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartupTiming startupTiming) throws FatalStartupException {
        Objects.requireNonNull(startupTiming);
        N n2 = O.b();
        Contrast.starting(this.directories);
        u u2 = this.startupContext();
        n2.b();
        this.startupTimingReporter.a(PerfUtil.a.a, "init-working-dir", n2);
        n2.c();
        try {
            for (v v2 : this.startupTasks) {
                this.doStartupTask(v2, u2);
            }
        }
        catch (FatalStartupException fatalStartupException) {
            this.errorAndPointToLog();
            logger.error("Problem starting up Contrast", fatalStartupException);
            logger.error(this.failureStrategy.b());
            this.failureStrategy.a(fatalStartupException);
            this.ifWebSphereAddFallbackTransformer(u2);
            return;
        }
        catch (Throwable throwable) {
            this.logUnexpectedError(throwable, this.failureStrategy.b());
            this.failureStrategy.a(throwable);
            return;
        }
        finally {
            n2.a();
            for (v v3 : this.startupTasks) {
                v3.b(u2);
            }
        }
        this.transformer = u2.b();
        try {
            this.initBackgroundServicesAndRegisterPlugins(n2, startupTiming);
        }
        catch (Throwable throwable) {
            G.b("Error reading Contrast configuration or policy. Are you sure your XML is right? " + this.failureStrategy.b());
            this.failureStrategy.a(throwable);
            throwable.printStackTrace(System.err);
        }
    }

    private void ifWebSphereAddFallbackTransformer(u u2) {
        j j2 = u2.b();
        if (j2 == null && s.a(this.serverInfo())) {
            logger.debug("Running in WebSphere, PhoneHome to TeamServer failed, attempting to add fallback transformer");
            try {
                this.addWebSphereFallBackTransformer(u2);
                logger.debug("Added WebSphereFallbackTransformer");
                new x(this.errorEmitter).a(u2);
            }
            catch (Exception exception) {
                logger.warn("Unable to prepare to correct disabled TLS algorithms in WebSphere", exception);
            }
        }
    }

    private void addWebSphereFallBackTransformer(u u2) {
        p p2 = new p(this.config, this.directories.b(), this.server, this.frameworkManager);
        new com.contrastsecurity.agent.plugins.frameworks.K.a.a(this.config, this.server, p2, this.scopeProvider, this.classLoadEvents).a(u2);
    }

    private u startupContext() {
        u u2 = new u();
        u2.a(this.inst);
        u2.a(this.args);
        u2.a(this);
        u2.a(this.errorEmitter);
        return u2;
    }

    private void logUnexpectedError(Throwable throwable, String string) {
        this.errorAndPointToLog();
        throwable.printStackTrace();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string2 = stringWriter.toString();
        G.b("Unexpected error starting up. " + string + " Exception message [1]: " + string2);
        throwable.printStackTrace(System.err);
        G.a("Unexpected error starting up. " + string + " Exception message [2]:  " + string2);
    }

    private void doStartupTask(v v2, u u2) throws FatalStartupException {
        N n2 = O.b();
        v2.a(u2);
        n2.b();
        this.startupTimingReporter.a(PerfUtil.a.a, v2.a(), n2);
    }

    private void initBackgroundServicesAndRegisterPlugins(N n2, StartupTiming startupTiming) {
        logger.info("Installing Contrast plugins...");
        List<com.contrastsecurity.agent.services.a> list = this.servicesFactory.a(this);
        this.compositeServices = new com.contrastsecurity.agent.core.b(this.config, list, this.clock);
        this.compositeServices.a(this.inst, this.pluginManager.getPlugins());
        this.pluginManager.handoffToJVM();
        this.sendServerInfoUpdate();
        this.logStartupMessages(n2, startupTiming);
        Contrast.active(this.directories);
    }

    private void logStartupMessages(N n2, StartupTiming startupTiming) {
        startupTiming.premainEndTimeNs(this.clock.b());
        long l2 = startupTiming.premainElapsedTimeMs();
        n2.b();
        this.startupTimingReporter.a(PerfUtil.a.a, "init-services-plugins", n2);
        PerfUtil.printStartupTimingMessage(String.format("All Startup Tasks: %s", com.contrastsecurity.agent.util.j.a(l2)));
        logger.info("Beginning application...");
        G.a("Starting JVM [" + l2 + "ms]");
        ScheduledExecutorService scheduledExecutorService = this.executorServiceModule.b();
        this.startupTimingReporter.b("startupTimeAgent", l2);
        this.metrics.a(scheduledExecutorService, this.config.e(ConfigProperty.AGENT_TELEMETRY_INITIAL_DELAY), this.startupTimingReporter);
    }

    private void sendServerInfoUpdate() {
        t t2 = new t(null, true);
        this.legacyReportingService.a(t2);
    }

    private void errorAndPointToLog() {
        String string = this.config.b(ConfigProperty.LOGGER_LOCATION);
        G.b("Contrast not enabled. Check log for details - " + string);
    }

    public synchronized void stop() {
        logger.info("Stopping Contrast...");
        Contrast.stopping(this.directories);
        if (this.compositeServices != null) {
            this.compositeServices.c();
        }
        this.observabilityService.b();
        this.pluginManager.deactivatePlugins();
        this.executorServiceModule.close();
        Contrast.inactive(this.directories);
        logger.info("Stopped");
        this.loggerManager.a(this.config.e(ConfigProperty.LOGGER_SHUTDOWN_TIMEOUT), TimeUnit.SECONDS);
    }

    public void deinstrument() {
        this.transformer.b();
        List<Class<?>> list = Arrays.stream(this.inst.getAllLoadedClasses()).filter(this.inst::isModifiableClass).collect(Collectors.toList());
        logger.info("De-instrumenting {} classes", (Object)list.size());
        V.a(this.inst, this.errorEmitter, list);
    }

    @Override
    public void registerPlugin(ContrastPlugin contrastPlugin) {
        this.pluginManager.registerPlugin(contrastPlugin);
    }

    @Override
    public void activatePlugins() {
        this.pluginManager.activatePlugins();
    }

    @Override
    public void deactivatePlugins() {
        this.pluginManager.deactivatePlugins();
    }

    @Override
    public void handoffToJVM() {
        this.pluginManager.handoffToJVM();
    }

    @Override
    public List<c> getDenylistAwarePlugins() {
        return this.pluginManager.getDenylistAwarePlugins();
    }

    public com.contrastsecurity.agent.e.g<String> sendRealTimeReport(LegacyReport legacyReport) {
        if (this.legacyReportingService == null) {
            throw new IllegalStateException("can't send report until reporting service is initialized");
        }
        return this.legacyReportingService.b(legacyReport);
    }

    public com.contrastsecurity.agent.v.s serverInfo() {
        return this.server;
    }

    public com.contrastsecurity.agent.services.b executorServiceModule() {
        return this.executorServiceModule;
    }

    private final class b
    implements a {
        private final List<com.contrastsecurity.agent.services.a> b;

        b(List<com.contrastsecurity.agent.services.a> list) {
            this.b = list;
        }

        @Override
        public List<com.contrastsecurity.agent.services.a> a(ContrastEngine contrastEngine) {
            com.contrastsecurity.agent.services.ngreporting.u u2 = new com.contrastsecurity.agent.services.ngreporting.u(ContrastEngine.this.config, ContrastEngine.this, ContrastEngine.this.applicationSettingsUpdateEventBus, ObjectShare.GSON, ContrastEngine.this.clock, ContrastEngine.this.featureManager, ContrastEngine.this.applicationManager, ContrastEngine.this.frameworkManager, ContrastEngine.this.legacyReportingService, ContrastEngine.this.scopeProvider, ContrastEngine.this.errorEmitter, ContrastEngine.this.eventListener);
            ScheduledExecutorService scheduledExecutorService = ContrastEngine.this.executorServiceModule.a();
            X x2 = new X(ContrastEngine.this.config, ContrastEngine.this.apiClient, ContrastEngine.this.applicationManager, scheduledExecutorService);
            at at2 = new at(ContrastEngine.this.config, ContrastEngine.this.apiClient, ContrastEngine.this.featureManager, scheduledExecutorService);
            h h2 = new h(ContrastEngine.this.config, ContrastEngine.this.errorEmitter);
            ArrayList<com.contrastsecurity.agent.services.a> arrayList = new ArrayList<com.contrastsecurity.agent.services.a>();
            arrayList.add(u2);
            arrayList.addAll(this.b);
            arrayList.add(x2);
            arrayList.add(at2);
            arrayList.add(ContrastEngine.this.legacyReportingService);
            if (com.contrastsecurity.agent.util.v.c()) {
                logger.info("On IBM JVM, adding zombie watcher thread.");
                k k2 = new k(ContrastEngine.this.config, contrastEngine, ContrastEngine.this.errorEmitter);
                arrayList.add(k2);
            }
            arrayList.add(h2);
            return arrayList;
        }
    }

    public static interface a {
        public List<com.contrastsecurity.agent.services.a> a(ContrastEngine var1);
    }
}

