/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.core;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

@DontObfuscate
public final class ContrastVersion {
    static final String BUILD_TIME = "Build-Time";
    static final String BUILD_IMPL_VERSION = "Implementation-Build";
    static final String DEFAULT_JAR_NAME = "contrast.jar";
    static final String UNKNOWN = "Unknown";
    private final String jarName;
    private final String buildTime;
    private final String version;

    ContrastVersion(String string, String string2, String string3) {
        this.jarName = Objects.requireNonNull(string);
        this.buildTime = Objects.requireNonNull(string2);
        this.version = Objects.requireNonNull(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ContrastVersion fromJarFile(File file) {
        Objects.requireNonNull(file, () -> "file parameter cannot be null");
        ZipFile zipFile = null;
        String string = DEFAULT_JAR_NAME;
        String string2 = UNKNOWN;
        String string3 = UNKNOWN;
        try {
            zipFile = new JarFile(URLDecoder.decode(file.getAbsolutePath(), "UTF-8"));
            Manifest manifest = ((JarFile)zipFile).getManifest();
            string = file.getName();
            string2 = manifest.getMainAttributes().getValue(BUILD_TIME);
            string3 = ContrastVersion.versionFromManifest(manifest);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (string2 == null) {
            string2 = UNKNOWN;
        }
        return new ContrastVersion(string, string2, string3);
    }

    static ContrastVersion fromDefaults() {
        return new ContrastVersion(DEFAULT_JAR_NAME, UNKNOWN, UNKNOWN);
    }

    String getJarName() {
        return this.jarName;
    }

    String getBuildTime() {
        return this.buildTime;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ContrastVersion contrastVersion = (ContrastVersion)object;
        if (!this.jarName.equals(contrastVersion.jarName)) {
            return false;
        }
        if (!this.buildTime.equals(contrastVersion.buildTime)) {
            return false;
        }
        return this.version.equals(contrastVersion.version);
    }

    public int hashCode() {
        int n2 = this.jarName.hashCode();
        n2 = 31 * n2 + this.buildTime.hashCode();
        n2 = 31 * n2 + this.version.hashCode();
        return n2;
    }

    private static String versionFromManifest(Manifest manifest) {
        String string = ConfigProperty.SERVER_VERSION.commonConfigSystemPropertyName();
        String string2 = System.getProperty(string);
        if (StringUtils.isEmpty(string2)) {
            string2 = manifest.getMainAttributes().getValue(BUILD_IMPL_VERSION);
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = "5.2.3";
        }
        if (StringUtils.isEmpty(string2)) {
            return UNKNOWN;
        }
        return string2;
    }
}

