/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.http.a;
import com.contrastsecurity.agent.http.b;
import com.contrastsecurity.agent.http.i;
import com.contrastsecurity.agent.http.m;
import com.contrastsecurity.agent.http.r;
import com.contrastsecurity.agent.o.e;
import com.contrastsecurity.agent.util.H;
import com.contrastsecurity.agent.util.P;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.apache.commons.io.FileUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;

@Singleton
@DontObfuscate
public class HttpManager
implements a {
    private final com.contrastsecurity.agent.plugins.i pluginManager;
    private final ApplicationManager applicationManager;
    private final AtomicBoolean isFirstRequest;
    private final i firstRequestEndListener;
    private final e eventBus;
    private final boolean featureSamplingEnabled;
    private final int featureSamplingFrequency;
    private final ThreadLocal<HttpRequest> httpRequest = ThreadLocal.withInitial(() -> null);
    private final ThreadLocal<HttpResponse> httpResponse = ThreadLocal.withInitial(() -> null);
    private final int maxRetainedBufferSize;
    private static final Logger logger = LoggerFactory.getLogger(HttpManager.class);

    @Inject
    public HttpManager(g g2, com.contrastsecurity.agent.plugins.i i2, ApplicationManager applicationManager, i i3, e e2) {
        this.pluginManager = i2;
        this.applicationManager = applicationManager;
        this.firstRequestEndListener = i3;
        this.isFirstRequest = new AtomicBoolean(true);
        this.eventBus = e2;
        this.maxRetainedBufferSize = g2.d(ConfigProperty.MAX_RETAINED_BUFFER_SIZE);
        this.featureSamplingEnabled = g2.f(ConfigProperty.FEATURE_REQUEST_SAMPLING_ENABLED);
        this.featureSamplingFrequency = g2.d(ConfigProperty.FEATURE_REQUEST_SAMPLING_FREQUENCY);
    }

    public HttpRequest getCurrentRequest() {
        return this.httpRequest.get();
    }

    public HttpRequest cloneCurrentRequest() {
        HttpRequest httpRequest = this.getCurrentRequest();
        return httpRequest == null ? null : httpRequest.copy();
    }

    public void setCurrentRequest(HttpRequest httpRequest) {
        try {
            this.updateRequestCrumbs(httpRequest);
        }
        catch (Exception exception) {
            logger.error("Problem updating HTTP request crumbs", exception);
        }
        if (httpRequest == null) {
            this.httpRequest.remove();
        } else {
            this.httpRequest.set(httpRequest);
        }
    }

    public void setCurrentResponse(HttpResponse httpResponse) {
        try {
            this.updateResponseBreadCrumbs(httpResponse);
        }
        catch (Exception exception) {
            logger.error("Problem updating HTTP response crumbs", exception);
        }
        if (httpResponse == null) {
            this.httpResponse.remove();
        } else {
            this.httpResponse.set(httpResponse);
        }
    }

    public HttpResponse getCurrentResponse() {
        return this.httpResponse.get();
    }

    private void updateRequestCrumbs(HttpRequest httpRequest) {
        if (httpRequest == null) {
            HttpRequest httpRequest2 = this.httpRequest.get();
            if (httpRequest2 != null) {
                httpRequest2.updateBreadCrumbs(b.b.c);
            }
        } else {
            httpRequest.updateBreadCrumbs(b.b.b);
        }
    }

    private void updateResponseBreadCrumbs(HttpResponse httpResponse) {
        if (httpResponse == null) {
            HttpResponse httpResponse2 = this.httpResponse.get();
            if (httpResponse2 != null) {
                httpResponse2.updateBreadCrumbs(b.b.c);
            }
        } else {
            httpResponse.updateBreadCrumbs(b.b.b);
        }
    }

    public void onRequestStart(HttpRequest httpRequest) {
        httpRequest.reset(this.maxRetainedBufferSize);
        Application application = this.applicationManager.current();
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            List<r> list = contrastPlugin.getRequestLifecycleListeners();
            for (r r2 : list) {
                r2.a(httpRequest);
            }
        });
        this.pluginManager.forEachDisabled(application, httpRequest, contrastPlugin -> {
            List<r> list = contrastPlugin.getRequestLifecycleListeners();
            for (r r2 : list) {
                r2.a();
            }
        });
    }

    public void onResponseStart(HttpRequest httpRequest, HttpResponse httpResponse) {
        httpResponse.getMemoryBuffer().a(this.maxRetainedBufferSize);
        Application application = this.applicationManager.current();
        this.pluginManager.forEachEnabled(application, httpRequest, contrastPlugin -> {
            List<r> list = contrastPlugin.getRequestLifecycleListeners();
            for (r r2 : list) {
                r2.a(httpRequest, httpResponse);
            }
        });
    }

    public void onRequestEnd() {
        Object object;
        HttpRequest httpRequest = this.getCurrentRequest();
        if (httpRequest == null || !httpRequest.endRequest()) {
            return;
        }
        HttpResponse httpResponse = this.getCurrentResponse();
        if (httpResponse != null) {
            this.eventBus.a(httpRequest, httpResponse);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Request ending for {} - response is {} and output mechanism is {}", httpRequest.getUri(), P.a(httpResponse), httpResponse != null ? P.a(httpResponse.getOutputMechanism()) : "response-null");
            if (httpResponse != null && httpResponse.getOutputMechanism() != null) {
                object = httpResponse.getOutputMechanism();
                logger.debug("De-assigning output mechanism {}", (Object)P.a(object));
            }
        }
        if (httpResponse != null && httpResponse.isCapturingInFile()) {
            logger.debug("Closing response file");
            try {
                httpResponse.closeFileBuffer();
            }
            catch (IOException iOException) {
                logger.error("Problem closing response file buffer", iOException);
            }
        }
        if (httpResponse != null && httpResponse.isCapturing()) {
            this.analyzeResponseContents(httpRequest, httpResponse);
        }
        if (logger.isDebugEnabled() && httpResponse == null) {
            this.logCrumbData(httpRequest);
        }
        object = this.applicationManager.current();
        this.pluginManager.forEachEnabled((Application)object, httpRequest, contrastPlugin -> {
            List<r> list = contrastPlugin.getRequestLifecycleListeners();
            for (r r2 : list) {
                try {
                    r2.b(httpRequest, httpResponse);
                }
                catch (Throwable throwable) {
                    logger.warn("Problem ending request watching with {}", (Object)r2, (Object)throwable);
                }
            }
        });
        this.pluginManager.forEachDisabled((Application)object, httpRequest, contrastPlugin -> {
            List<r> list = contrastPlugin.getRequestLifecycleListeners();
            for (r r2 : list) {
                try {
                    r2.b();
                }
                catch (Throwable throwable) {
                    logger.warn("Problem ending request watching with {}", (Object)r2, (Object)throwable);
                }
            }
        });
        httpRequest.reset(this.maxRetainedBufferSize);
        if (httpResponse != null) {
            httpResponse.getMemoryBuffer().a(this.maxRetainedBufferSize);
        }
        this.setCurrentRequest(null);
        this.setCurrentResponse(null);
        this.applicationManager.current(null);
        httpRequest.markEndTime();
        long l2 = httpRequest.elapsedTimeMs();
        httpRequest.getJfrEvent().a(httpRequest, httpResponse);
        if (logger.isDebugEnabled()) {
            logger.debug("{}{}|RequestEnded|uri={}&elapsed={}", "!LM!", "RequestTime", httpRequest.getNormalizedUri(), l2);
        }
        if (this.isFirstRequest.get() && this.isFirstRequest.getAndSet(false)) {
            this.firstRequestEndListener.onFirstRequestEnd(l2);
        }
    }

    @C
    void analyzeResponseContents(HttpRequest httpRequest, HttpResponse httpResponse) {
        byte[] byArray;
        if (httpRequest == null || httpResponse == null || !httpResponse.isCapturing()) {
            return;
        }
        String string = httpRequest.getUri();
        if (httpResponse.isEmpty()) {
            logger.debug("Response was empty for URI {}", (Object)string);
            return;
        }
        logger.debug("Scanning response for {}", (Object)string);
        H h2 = httpResponse.getMemoryBuffer().a(Charset.defaultCharset());
        if (httpResponse.isCapturingInMemory()) {
            byArray = h2.b();
        } else if (httpResponse.isCapturingInFile()) {
            byArray = this.readFile(httpResponse.getFileBufferPath());
        } else {
            throw new IllegalStateException("\"Problem scanning response to {}: nothing captured in memory or file!\": " + string);
        }
        String string2 = httpResponse.getCharacterEncoding();
        try {
            if (string2 == null || !Charset.isSupported(string2)) {
                string2 = Charset.defaultCharset().name();
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            String string3 = Charset.defaultCharset().name();
            logger.error("Encountered a strange charset encoding of '{}', falling back to '{}'", (Object)string2, (Object)string3);
            string2 = string3;
        }
        try {
            String string4 = httpResponse.isCapturingInMemory() ? new String(byArray, 0, h2.a(), string2) : new String(byArray, string2);
            logger.debug("Scanning {} response text with length {}/charset {}", string, string4.length(), string2);
            this.pluginManager.forEachEnabled(this.applicationManager.current(), httpRequest, contrastPlugin -> {
                List<r> list = contrastPlugin.getRequestLifecycleListeners();
                for (r r2 : list) {
                    try {
                        r2.a(httpRequest, httpResponse, string4);
                    }
                    catch (Throwable throwable) {
                        logger.warn("Problem ending request watching with {}", (Object)r2, (Object)throwable);
                    }
                }
            });
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("Couldn't parse response body because of weird encoding", unsupportedEncodingException);
        }
    }

    private void logCrumbData(HttpRequest httpRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < Math.min(10, stackTraceElementArray.length); ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            stringBuilder.append("\t\t").append(stackTraceElement.getClassName()).append(".").append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(":").append(stackTraceElement.getLineNumber()).append(")\n");
        }
        logger.debug("Unexpected null response for request=[{}], CRUMB:\n{}", (Object)httpRequest, (Object)stringBuilder);
    }

    public void onMultipartHeaderRead(HttpRequest httpRequest, MultipartItem multipartItem) {
        this.pluginManager.forEachEnabled(this.applicationManager.current(), httpRequest, contrastPlugin -> {
            List<r> list = contrastPlugin.getRequestLifecycleListeners();
            for (r r2 : list) {
                r2.a(httpRequest, multipartItem);
            }
        });
    }

    public void onParametersResolved(HttpRequest httpRequest) {
        this.pluginManager.forEachEnabled(this.applicationManager.current(), httpRequest, contrastPlugin -> {
            List<r> list = contrastPlugin.getRequestLifecycleListeners();
            for (r r2 : list) {
                r2.b(httpRequest);
            }
        });
    }

    public void onMoreParametersResolved(HttpRequest httpRequest, Map<String, String[]> map) {
        this.pluginManager.forEachEnabled(this.applicationManager.current(), httpRequest, contrastPlugin -> {
            List<r> list = contrastPlugin.getRequestLifecycleListeners();
            for (r r2 : list) {
                r2.a(httpRequest, map);
            }
        });
    }

    @Override
    public void onBodyInputReceived(com.contrastsecurity.agent.plugins.protect.d.m m2, String string, String string2) {
        this.pluginManager.forEachEnabled(this.applicationManager.current(), this.getCurrentRequest(), contrastPlugin -> {
            List<r> list = contrastPlugin.getRequestLifecycleListeners();
            for (r r2 : list) {
                r2.a(string, string2, m2);
            }
        });
    }

    public boolean isSamplingCurrentRequest(m m2) {
        if (!this.featureSamplingEnabled) {
            return false;
        }
        HttpRequest httpRequest = this.getCurrentRequest();
        return httpRequest != null && httpRequest.isSampling(m2, this::initialIsSamplingValue);
    }

    private boolean initialIsSamplingValue(m m2) {
        return ThreadLocalRandom.current().nextInt(1, this.featureSamplingFrequency + 1) == 1;
    }

    private byte[] readFile(String string) {
        try {
            return FileUtils.readFileToByteArray(new File(string));
        }
        catch (IOException iOException) {
            logger.error("Problem reading response file", iOException);
            return Empty.BYTE_ARRAY;
        }
    }
}

