/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.commons.v;
import com.contrastsecurity.agent.contrastapi_v1_0.HttpRequestDTM;
import com.contrastsecurity.agent.g.f;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.http.c;
import com.contrastsecurity.agent.http.d;
import com.contrastsecurity.agent.http.e;
import com.contrastsecurity.agent.http.h;
import com.contrastsecurity.agent.http.j;
import com.contrastsecurity.agent.http.k;
import com.contrastsecurity.agent.http.m;
import com.contrastsecurity.agent.http.o;
import com.contrastsecurity.agent.http.s;
import com.contrastsecurity.agent.m.g;
import com.contrastsecurity.agent.m.i;
import com.contrastsecurity.agent.messages.HTTPRequestID;
import com.contrastsecurity.agent.messages.HttpVersion;
import com.contrastsecurity.agent.messages.Protocol;
import com.contrastsecurity.agent.messages.mq.MqHttpRequestDTM;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.HttpWatcher;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.util.H;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.ArrayUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

@DontObfuscate
public abstract class HttpRequest
extends c {
    public static final String DEFAULT_REMOTE_IP = "0.0.0.0";
    private static final char BOM = '\ufeff';
    private static final int CONTENT_LENGTH_NOT_SET = -1;
    private Protocol protocol = Protocol.FALLBACK_VALUE;
    private HttpVersion version = HttpVersion.FALLBACK_VALUE;
    private String method;
    private String uri;
    private String normalizedUri;
    private String queryString;
    private String remoteIp;
    private int port;
    private Map<String, String[]> parameters;
    private Map<String, String[]> headers;
    private String contextPath;
    private String serverVersionInfo;
    private boolean parsedParameters;
    private boolean parsedMultipartParameters;
    private Collection<HttpWatcher> responseWatchers;
    private boolean analyzing;
    private j frameworkInfo;
    private int scope;
    private H cachedBody;
    private String cachedBodyStr;
    protected String cachedEncodedBodyAsString;
    private HashMap<String, Object> properties;
    private Set<MultipartItem> multipartItems;
    private d cachedContentType;
    private int cachedContentLength = -1;
    private boolean cachedXForwardedFor;
    private String[] cachedXForwardedForHeaders;
    private boolean cachedXForwardedForAsString;
    private String cachedXForwardedForHeadersAsString;
    private final com.contrastsecurity.agent.commons.d clock;
    private final HTTPRequestID requestID;
    private boolean appendEllipsisBytes;
    private final g jfrEvent;
    protected WeakReference<Object> requestObj;
    private boolean checkedForDeserializer;
    private int maxRequestBodyBytesCaptured = 4096;
    private final long startTime;
    private long elapsedTimeMs;
    private final com.contrastsecurity.agent.f.g context;
    private final AtomicBoolean active = new AtomicBoolean(true);
    private final Map<m, Boolean> sampling = Collections.synchronizedMap(new EnumMap(m.class));
    private static final char[] ALLOWED_BODY_SPECIAL_CHARS = new char[]{'<', '>', '\"', '\'', '&', ';', '[', ']', '{', '}', '!', '@', '#', '$', '%', '^', '_', '-', '+', '=', ':', ';', '.', ',', '(', ')', '?', '|', '\\', '/'};
    private final byte[] ellipsisBytes = "...".getBytes();
    private static final int TARGET_SCOPE = 1;
    private static final o BUFFER = new s();
    private static final h FILE_BUFFER = new h("request");
    private static final Logger logger = LoggerFactory.getLogger(HttpRequest.class);
    public static final int NOT_CAPTURE_HTTP_REQUEST_BODY = -1;
    private static final int MAX_REQUEST_BYTES_CACHED = 4096;

    public HTTPRequestID getRequestID() {
        return this.requestID;
    }

    boolean isSampling(m m2, Function<m, Boolean> function) {
        return this.sampling.computeIfAbsent(m2, function);
    }

    public HttpRequest() {
        this(null, new com.contrastsecurity.agent.f.g());
    }

    public HttpRequest(H h2) {
        this(h2, new com.contrastsecurity.agent.f.g());
    }

    protected HttpRequest(H h2, com.contrastsecurity.agent.f.g g2) {
        this(new k().a(), h2, g2, new v());
    }

    @C
    HttpRequest(HTTPRequestID hTTPRequestID, H h2, com.contrastsecurity.agent.f.g g2, com.contrastsecurity.agent.commons.d d2) {
        super("request");
        this.properties = new HashMap();
        this.multipartItems = new HashSet<MultipartItem>();
        this.clock = d2;
        this.startTime = d2.b();
        this.elapsedTimeMs = -1L;
        this.requestID = hTTPRequestID;
        this.cachedBody = h2;
        this.cachedBodyStr = h2 != null ? h2.c() : null;
        this.context = g2;
        this.jfrEvent = i.b();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public boolean endRequest() {
        return this.active.getAndSet(false);
    }

    public boolean isSameRequest(Object object) {
        if (object == null || this.requestObj == null) {
            return false;
        }
        return this.requestObj.get() == object;
    }

    public boolean isCurrentActiveRequest(Object object) {
        return this.isActive() && this.isSameRequest(object);
    }

    public final com.contrastsecurity.agent.f.f context() {
        return this.context;
    }

    protected final com.contrastsecurity.agent.f.g contextImplementation() {
        return this.context;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String string) {
        this.contextPath = string;
    }

    public String[] getXForwardedFor() {
        if (!this.cachedXForwardedFor) {
            this.cachedXForwardedForHeaders = this.getHeaders("X-Forwarded-For");
            this.cachedXForwardedFor = true;
        }
        return this.cachedXForwardedForHeaders;
    }

    public String getXForwardedForAsString() {
        if (!this.cachedXForwardedForAsString) {
            StringBuilder stringBuilder = new StringBuilder(64);
            String[] stringArray = this.getXForwardedFor();
            if (stringArray != null) {
                for (String string : stringArray) {
                    for (int i2 = 0; i2 < string.length(); ++i2) {
                        char c2 = string.charAt(i2);
                        if (c2 == ' ') continue;
                        stringBuilder.append(c2);
                    }
                    stringBuilder.append(',');
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            this.cachedXForwardedForHeadersAsString = stringBuilder.toString();
            this.cachedXForwardedForAsString = true;
        }
        return this.cachedXForwardedForHeadersAsString;
    }

    public d getContentType() {
        if (this.cachedContentType != null) {
            return this.cachedContentType;
        }
        this.cachedContentType = new d(this.getHeader("Content-Type"));
        return this.cachedContentType;
    }

    public Charset getCharset() {
        return this.getContentType().b();
    }

    public int getContentLength() {
        if (this.cachedContentLength != -1) {
            return this.cachedContentLength;
        }
        this.cachedContentLength = 0;
        String string = this.getHeader("Content-Length");
        if (string == null || "0".equals(string)) {
            return 0;
        }
        try {
            this.cachedContentLength = (int)Math.min(Long.parseLong(string.trim()), Integer.MAX_VALUE);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Invalid content length header value detected: {}", (Object)string, (Object)numberFormatException);
        }
        return this.cachedContentLength != -1 ? this.cachedContentLength : 0;
    }

    @C
    protected void setCachedContentLength(int n2) {
        this.cachedContentLength = n2;
    }

    public final Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        if (string == null) {
            return;
        }
        try {
            this.setProtocol(Protocol.fromString(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setProtocol(Protocol protocol) {
        if (protocol != null) {
            this.protocol = protocol;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String string) {
        this.uri = string;
        this.normalizedUri = com.contrastsecurity.agent.util.s.a(string);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public void addMultipartItem(MultipartItem multipartItem) {
        this.multipartItems.add(multipartItem);
    }

    public void setMultipartItems(Set<MultipartItem> set) {
        this.multipartItems = set;
    }

    public Set<MultipartItem> getMultipartItems() {
        return this.multipartItems;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String[]> map) {
        this.parameters = map;
    }

    public void setHeaders(Map<String, String[]> map) {
        if (map == null) {
            return;
        }
        this.headers = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
        this.headers.putAll(map);
    }

    public Map<String, String[]> getHeaders() {
        return this.headers;
    }

    public String[] getHeaders(String string) {
        if (this.headers == null || this.headers.isEmpty() || StringUtils.isBlank(string)) {
            return null;
        }
        String[] stringArray = this.headers.get(string);
        if (stringArray != null && stringArray.length > 0) {
            return stringArray;
        }
        return null;
    }

    public String getHeader(String string) {
        String[] stringArray = this.getHeaders(string);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    public boolean isParametersResolved() {
        return this.parsedParameters;
    }

    public void resolvedParameters() {
        this.parsedParameters = true;
    }

    public void markParametersUnresolved() {
        this.parsedParameters = false;
    }

    public boolean isMultipartParametersResolved() {
        return this.parsedMultipartParameters;
    }

    public void resolvedMultipartParameters() {
        this.parsedMultipartParameters = true;
    }

    public String getCookie() {
        return this.getHeader("Cookie");
    }

    public com.contrastsecurity.agent.d.d[] parseCookies() {
        String string = this.getCookie();
        if (string == null || string.length() == 0) {
            return ObjectShare.NO_COOKIES;
        }
        return e.a(string);
    }

    public final HttpVersion getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        if (string == null) {
            return;
        }
        try {
            this.setVersion(HttpVersion.parse(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setVersion(HttpVersion httpVersion) {
        if (httpVersion != null) {
            this.version = httpVersion;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public String getNormalizedUri() {
        return this.normalizedUri;
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    public void setRemoteIp(String string) {
        this.remoteIp = string == null ? DEFAULT_REMOTE_IP : string;
    }

    public HttpRequest copy() {
        HttpRequest httpRequest = this.newInstance(new com.contrastsecurity.agent.f.g(this.contextImplementation()));
        httpRequest.version = this.version;
        httpRequest.method = this.method;
        httpRequest.uri = this.uri;
        httpRequest.normalizedUri = this.normalizedUri;
        httpRequest.queryString = this.queryString;
        httpRequest.remoteIp = this.remoteIp;
        httpRequest.port = this.port;
        httpRequest.parameters = this.parameters;
        httpRequest.headers = this.headers;
        httpRequest.contextPath = this.contextPath;
        httpRequest.serverVersionInfo = this.serverVersionInfo;
        httpRequest.parsedParameters = this.parsedParameters;
        httpRequest.parsedMultipartParameters = this.parsedMultipartParameters;
        httpRequest.responseWatchers = this.responseWatchers;
        httpRequest.analyzing = this.analyzing;
        httpRequest.frameworkInfo = this.frameworkInfo;
        httpRequest.scope = this.scope;
        httpRequest.cachedBody = this.cachedBody;
        httpRequest.cachedEncodedBodyAsString = this.cachedEncodedBodyAsString;
        httpRequest.cachedBodyStr = this.cachedBodyStr;
        httpRequest.properties = this.properties;
        httpRequest.multipartItems = this.multipartItems;
        httpRequest.cachedContentType = this.cachedContentType;
        httpRequest.cachedContentLength = this.cachedContentLength;
        httpRequest.cachedXForwardedFor = this.cachedXForwardedFor;
        httpRequest.cachedXForwardedForHeaders = this.cachedXForwardedForHeaders;
        httpRequest.cachedXForwardedForAsString = this.cachedXForwardedForAsString;
        httpRequest.cachedXForwardedForHeadersAsString = this.cachedXForwardedForHeadersAsString;
        return httpRequest;
    }

    protected abstract HttpRequest newInstance(com.contrastsecurity.agent.f.g var1);

    protected H getBody() {
        this.cacheBody();
        return this.cachedBody;
    }

    protected void setCachedBody(H h2) {
        this.cachedBody = h2;
        this.cachedBodyStr = this.cachedBody != null ? this.cachedBody.c() : null;
    }

    void clearBodyCache() {
        this.cachedBody = null;
        this.cachedBodyStr = null;
        this.cachedEncodedBodyAsString = null;
    }

    public void reset(int n2) {
        BUFFER.a(n2);
        this.cachedContentLength = -1;
        this.cachedContentType = null;
    }

    public Collection<HttpWatcher> getResponseWatchers() {
        return this.responseWatchers == null ? Collections.emptyList() : this.responseWatchers;
    }

    public void setResponseWatchers(Collection<HttpWatcher> collection) {
        this.responseWatchers = collection;
    }

    public void setAnalyzing(boolean bl2) {
        this.analyzing = bl2;
    }

    public boolean isAnalyzing() {
        return this.analyzing;
    }

    public String getServerVersionInfo() {
        return this.serverVersionInfo;
    }

    public void setServerVersionInfo(String string) {
        this.serverVersionInfo = string;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap<String, Object> hashMap) {
        this.properties = hashMap;
    }

    public boolean isScanningResponse() {
        return this.responseWatchers != null && !this.responseWatchers.isEmpty();
    }

    @ScopedSensor
    public void onBytesRead(int n2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpRequest httpRequest = this;
        int n3 = n2;
        try {
            if (httpRequest.scope == 1 && n3 != -1) {
                try {
                    Object object;
                    if (httpRequest.capturingInMemory) {
                        object = BUFFER.a();
                        int n4 = ((ByteArrayOutputStream)object).size();
                        if (n4 < httpRequest.maxRequestBodyBytesCaptured) {
                            ((ByteArrayOutputStream)object).write(n3);
                        } else if (!httpRequest.appendEllipsisBytes && httpRequest.maxRequestBodyBytesCaptured != -1) {
                            ((OutputStream)object).write(httpRequest.ellipsisBytes);
                            httpRequest.appendEllipsisBytes = true;
                        }
                    }
                    if (httpRequest.bufferToPlugins) {
                        object = httpRequest.bufferingPlugins.iterator();
                        while (object.hasNext()) {
                            ContrastPlugin contrastPlugin = (ContrastPlugin)object.next();
                            contrastPlugin.onRequestBodyChunkRead(httpRequest, n3);
                        }
                    }
                    if (httpRequest.capturingInFile && (object = httpRequest.openFile()) != null) {
                        ((FileOutputStream)object).write(n3);
                    }
                }
                catch (AttackBlockedException attackBlockedException) {
                    throw attackBlockedException;
                }
                catch (Throwable throwable) {
                    logger.error("Problem writing file", throwable);
                }
            }
            httpRequest = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (httpRequest != null) {
            throw httpRequest;
        }
    }

    @ScopedSensor
    public void onBytesRead(int n2, byte[] byArray) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpRequest httpRequest = this;
        int n3 = n2;
        byte[] byArray2 = byArray;
        try {
            if (httpRequest.scope == 1 && n3 != -1 && byArray2 != null) {
                httpRequest.onBytesRead(n3, byArray2, 0, byArray2.length);
            }
            httpRequest = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (httpRequest != null) {
            throw httpRequest;
        }
    }

    @ScopedSensor
    public void onBytesRead(int n2, byte[] byArray, int n3, int n4) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpRequest httpRequest = this;
        int n5 = n2;
        byte[] byArray2 = byArray;
        int n6 = n3;
        int n7 = n4;
        try {
            if (httpRequest.scope == 1 && byArray2 != null && n6 >= 0 && (n7 >= 0 || n5 == -1)) {
                try {
                    Object object;
                    if (httpRequest.capturingInMemory) {
                        object = BUFFER.a();
                        int n8 = ((ByteArrayOutputStream)object).size();
                        if (n8 < httpRequest.maxRequestBodyBytesCaptured) {
                            int n9 = Math.min(n5, httpRequest.maxRequestBodyBytesCaptured - n8);
                            ((ByteArrayOutputStream)object).write(byArray2, n6, n9);
                        } else if (!httpRequest.appendEllipsisBytes && httpRequest.maxRequestBodyBytesCaptured != -1) {
                            ((OutputStream)object).write(httpRequest.ellipsisBytes);
                            httpRequest.appendEllipsisBytes = true;
                        }
                    }
                    if (httpRequest.bufferToPlugins) {
                        object = httpRequest.bufferingPlugins.iterator();
                        while (object.hasNext()) {
                            ContrastPlugin contrastPlugin = (ContrastPlugin)object.next();
                            contrastPlugin.onRequestBodyChunkRead(httpRequest, n5, byArray2, n6, n7);
                        }
                    }
                    if (httpRequest.capturingInFile && (object = httpRequest.openFile()) != null) {
                        ((FileOutputStream)object).write(byArray2, n6, n5);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    logger.error("Response write with bad indices", indexOutOfBoundsException);
                }
                catch (AttackBlockedException attackBlockedException) {
                    throw attackBlockedException;
                }
                catch (Throwable throwable) {
                    logger.error("Unknown problem capturing response", throwable);
                }
            }
            httpRequest = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (httpRequest != null) {
            throw httpRequest;
        }
    }

    public void cacheBody() {
        if (!(this.cachedBody != null || this.getContentLength() <= 0 && BUFFER.d())) {
            Charset charset = this.getCharset();
            this.cachedBody = BUFFER.a(charset);
            this.cachedBodyStr = BUFFER.b() > 4096 ? new String(this.cachedBody.b(), 0, 4096, charset) + "..." : this.cachedBody.c();
        }
    }

    @Override
    public File getFile() throws IOException {
        return FILE_BUFFER.b();
    }

    @Override
    public o getMemoryBuffer() {
        return BUFFER;
    }

    @Override
    public h getFileBuffer() {
        return FILE_BUFFER;
    }

    public void enterReadingScope() {
        ++this.scope;
    }

    public void leaveReadingScope() {
        --this.scope;
    }

    public boolean isCheckedForDeserializer() {
        return this.checkedForDeserializer;
    }

    public void setCheckedForDeserializer(boolean bl2) {
        this.checkedForDeserializer = bl2;
    }

    @Override
    protected String getAdditionalBreadCrumbInfo() {
        return this.uri;
    }

    public long startTimeNs() {
        return this.startTime;
    }

    public void markEndTime() {
        this.elapsedTimeMs = TimeUnit.NANOSECONDS.toMillis(this.clock.b() - this.startTime);
    }

    public long elapsedTimeMs() {
        return this.elapsedTimeMs;
    }

    public String getEncodedBodyAsString() {
        String string = this.getBodyAsString();
        if (string != null && string.length() > 0 && this.cachedEncodedBodyAsString == null) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            this.appendTranslatedBody(stringBuilder, string);
            this.cachedEncodedBodyAsString = stringBuilder.toString();
        }
        return this.cachedEncodedBodyAsString;
    }

    public String getBodyAsString() {
        this.cacheBody();
        return this.cachedBodyStr;
    }

    public String headersToString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String[]> entry : this.headers.entrySet()) {
            arrayList.add(entry.getKey() + "= " + Arrays.toString(entry.getValue()));
        }
        return "Headers{" + StringUtils.join(arrayList, ", ") + "}";
    }

    public int getMaxRequestBodyBytesCaptured() {
        return this.maxRequestBodyBytesCaptured;
    }

    public void setMaxRequestBodyBytesCaptured(int n2) {
        this.maxRequestBodyBytesCaptured = n2;
    }

    public g getJfrEvent() {
        return this.jfrEvent;
    }

    public String toString() {
        return "HttpRequest{protocol=" + (Object)((Object)this.protocol) + ", version=" + (Object)((Object)this.version) + ", method='" + this.method + '\'' + ", uri='" + this.uri + '\'' + ", normalizedUri='" + this.normalizedUri + '\'' + ", queryString='" + this.queryString + '\'' + ", remoteIp='" + this.remoteIp + '\'' + ", port=" + this.port + ", parameters=" + this.parameters + ", headers=" + this.headersToString() + ", contextPath='" + this.contextPath + '\'' + ", serverVersionInfo='" + this.serverVersionInfo + '\'' + ", parsedParameters=" + this.parsedParameters + ", parsedMultipartParameters=" + this.parsedMultipartParameters + ", responseWatchers=" + this.responseWatchers + ", analyzing=" + this.analyzing + ", frameworkInfo=" + this.frameworkInfo + ", scope=" + this.scope + ", cachedBody=" + (this.cachedBody != null ? this.cachedBody.a(50) : "null") + ", cachedBodyStr='" + this.cachedBodyStr + '\'' + ", properties=" + this.properties + ", multipartItems=" + this.multipartItems + ", cachedContentType='" + this.cachedContentType + '\'' + ", cachedContentLength=" + this.cachedContentLength + ", cachedXForwardedFor=" + this.cachedXForwardedFor + ", cachedXForwardedForHeaders=" + Arrays.toString(this.cachedXForwardedForHeaders) + ", cachedXForwardedForAsString=" + this.cachedXForwardedForAsString + ", cachedXForwardedForHeadersAsString='" + this.cachedXForwardedForHeadersAsString + '\'' + ", requestID=" + this.requestID + ", checkedForDeserializer=" + this.checkedForDeserializer + ", startTime=" + this.startTime + ", elapsed=" + this.elapsedTimeMs + '}';
    }

    private void appendTranslatedBody(StringBuilder stringBuilder, String string) {
        if (string != null && string.length() > 0) {
            int n2;
            for (int i2 = n2 = string.charAt(0) == '\ufeff' ? 1 : 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (Character.isWhitespace(c2) || Character.isLetterOrDigit(c2)) {
                    stringBuilder.append(c2);
                    continue;
                }
                if (ArrayUtils.contains(ALLOWED_BODY_SPECIAL_CHARS, c2)) {
                    com.contrastsecurity.agent.util.k.a(stringBuilder, c2);
                    continue;
                }
                stringBuilder.append(".");
            }
        }
    }

    public void setFrameworkInfo(j j2) {
        this.frameworkInfo = j2;
    }

    public j getFrameworkInfo() {
        return this.frameworkInfo;
    }

    public final MqHttpRequestDTM toMqHttpRequestDTM() {
        MqHttpRequestDTM.Builder builder = this.mqHttpRequestBuilder();
        return builder == null ? null : builder.build();
    }

    protected MqHttpRequestDTM.Builder mqHttpRequestBuilder() {
        return MqHttpRequestDTM.builder().body(this.getEncodedBodyAsString()).contextPath(this.contextPath).headers(this.headers).method(this.method).parameters(this.parameters).port(this.port).protocol(this.protocol).queryString(this.queryString).serverVersionInfo(this.serverVersionInfo).uri(this.uri).version(this.getVersion());
    }

    public final com.contrastsecurity.agent.g.g<HttpRequestDTM> toHttpRequestDTM(com.contrastsecurity.agent.g.c c2) {
        HashSet<f> hashSet = new HashSet<f>();
        HttpRequestDTM.Builder builder = HttpRequestDTM.builder().method(this.getMethod()).port(this.getPort()).protocol(this.getProtocol()).uri(this.getUri()).version(this.getVersion()).contextPath(this.getContextPath()).normalizedUri(this.getNormalizedUri()).serverVersionInfo(this.getServerVersionInfo()).requestID(this.getRequestID()).parameters(c2.a(this, hashSet)).queryString(c2.a(this.getQueryString(), hashSet)).headers(c2.b(this, hashSet)).body(c2.c(this, hashSet));
        return com.contrastsecurity.agent.g.g.a(builder.build(), Collections.unmodifiableSet(hashSet));
    }
}

