/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.commons.k;
import com.contrastsecurity.agent.http.ReplacedResponseChunk;
import com.contrastsecurity.agent.http.c;
import com.contrastsecurity.agent.http.h;
import com.contrastsecurity.agent.http.o;
import com.contrastsecurity.agent.http.t;
import com.contrastsecurity.agent.messages.mq.HttpResponseDTM;
import com.contrastsecurity.agent.plugins.protect.AttackBlockedException;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.P;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@DontObfuscate
public abstract class HttpResponse
extends c {
    protected final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    protected final Map<String, List<String>> headers = new ConcurrentHashMap<String, List<String>>();
    protected int scope;
    public static final int ENCODING_UTF8 = 0;
    public static final int ENCODING_UTF16 = 1;
    public static final int ENCODING_UTF32 = 2;
    public static final int ENCODING_ASCII = 3;
    public static final int ENCODING_ISO88591 = 4;
    public static final int ENCODING_SYSTEM_DEFAULT = 5;
    private static final o BUFFER = new t();
    private static final h FILE_BUFFER = new h("response");
    private static final String[] ALLOWED_CONTENT_TYPES = new String[]{"text/html", "text/plain", "application/xhtml", "application/xml"};
    private static final int TARGET_SCOPE = 1;
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final Logger logger = LoggerFactory.getLogger(HttpResponse.class);
    private static final int MAX_CAPTURED_SIZE = 65536;
    public static Map<Integer, String> CHARSET_MAP = k.a().a(3, "ASCII").a(0, "UTF-8").a(1, "UTF-16").a(2, "UTF-32").a(4, "ISO-8859-1").a(5, Charset.defaultCharset().name()).a();

    public HttpResponse() {
        super("response");
    }

    public abstract int getStatus();

    public abstract String getContentType();

    public abstract String getCharacterEncoding();

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public HttpResponseDTM toHttpResponseDTM() {
        return HttpResponseDTM.builder().characterEncoding(this.getCharacterEncoding()).contentType(this.getContentType()).status(this.getStatus()).headers(this.getHeaders()).build();
    }

    public Object getOutputMechanism() {
        return null;
    }

    public boolean isEmpty() {
        return this.getMemoryBuffer().a().size() <= 0;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void enterWritingScope(Object object) {
        ++this.scope;
    }

    public void leaveWritingScope(Object object) {
        --this.scope;
    }

    public final ReplacedResponseChunk write(byte[] byArray, String string) {
        return this.write(string);
    }

    public final ReplacedResponseChunk write(String string, int n2, int n3) {
        if (string != null && this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            this.doWrite(string, n2, n3);
        }
        return null;
    }

    public final ReplacedResponseChunk write(String string) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            if (string == null) {
                string = "null";
            }
            this.doWrite(string);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(char[] cArray) {
        if (cArray != null) {
            this.write(cArray, 0, cArray.length);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(byte[] byArray) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            this.doWrite(byArray);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(char[] cArray, int n2, int n3) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            this.doWrite(cArray, n2, n3);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(byte[] byArray, int n2, int n3) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            this.doWrite(byArray, n2, n3);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(byte by2) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            this.doWrite(by2);
        }
        return null;
    }

    public final ContrastReplacedResponseChunkModel write(int n2) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            this.doWrite(n2);
        }
        return null;
    }

    @ScopedSensor
    private void doWrite(String string, int n2, int n3) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        String string2 = string;
        int n4 = n2;
        int n5 = n3;
        try {
            try {
                string2 = string2.substring(n4, n4 + n5);
                byte[] byArray = httpResponse.toEncodedBytes(string2);
                if (httpResponse.capturingInMemory || httpResponse.capturingInFile) {
                    OutputStream outputStream;
                    if (httpResponse.capturingInMemory) {
                        outputStream = httpResponse.getMemoryBuffer().a();
                        int n6 = Math.max(0, 65536 - ((ByteArrayOutputStream)outputStream).size());
                        int n7 = Math.min(n6, byArray.length);
                        ((ByteArrayOutputStream)outputStream).write(byArray, 0, n7);
                    }
                    if (httpResponse.capturingInFile && (outputStream = httpResponse.openFile()) != null) {
                        ((FileOutputStream)outputStream).write(byArray);
                    }
                }
            }
            catch (IOException iOException) {
                logger.error("Couldn't write response chunk to stream", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            httpResponse = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (httpResponse != null) {
            throw httpResponse;
        }
    }

    @ScopedSensor
    private void doWrite(String string) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        String string2 = string;
        try {
            try {
                if (httpResponse.capturingInFile || httpResponse.capturingInMemory) {
                    OutputStream outputStream;
                    byte[] byArray = httpResponse.toEncodedBytes(string2);
                    if (httpResponse.capturingInMemory) {
                        outputStream = httpResponse.getMemoryBuffer().a();
                        int n2 = Math.max(0, 65536 - ((ByteArrayOutputStream)outputStream).size());
                        ((ByteArrayOutputStream)outputStream).write(byArray, 0, Math.min(byArray.length, n2));
                    }
                    if (httpResponse.capturingInFile && (outputStream = httpResponse.openFile()) != null) {
                        ((FileOutputStream)outputStream).write(byArray);
                    }
                }
            }
            catch (IOException iOException) {
                logger.error("Couldn't write response chunk to stream", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            httpResponse = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (httpResponse != null) {
            throw httpResponse;
        }
    }

    @ScopedSensor
    private void doWrite(byte[] byArray) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        byte[] byArray2 = byArray;
        try {
            try {
                OutputStream outputStream;
                if (httpResponse.capturingInMemory) {
                    outputStream = httpResponse.getMemoryBuffer().a();
                    int n2 = Math.max(0, 65536 - ((ByteArrayOutputStream)outputStream).size());
                    ((ByteArrayOutputStream)outputStream).write(byArray2, 0, Math.min(byArray2.length, n2));
                }
                if (httpResponse.capturingInFile && (outputStream = httpResponse.openFile()) != null) {
                    ((FileOutputStream)outputStream).write(byArray2);
                }
            }
            catch (IOException iOException) {
                logger.error("Couldn't write response chunk to stream", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            httpResponse = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (httpResponse != null) {
            throw httpResponse;
        }
    }

    @ScopedSensor
    private void doWrite(char[] cArray, int n2, int n3) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        char[] cArray2 = cArray;
        int n4 = n2;
        int n5 = n3;
        try {
            try {
                if (httpResponse.capturingInFile) {
                    FileOutputStream fileOutputStream = httpResponse.openFile();
                    for (int i2 = n4; i2 < n4 + n5; ++i2) {
                        fileOutputStream.write(cArray2[i2]);
                    }
                }
                if (httpResponse.capturingInMemory) {
                    ByteArrayOutputStream byteArrayOutputStream = httpResponse.getMemoryBuffer().a();
                    for (int i3 = n4; i3 < n4 + n5; ++i3) {
                        if (byteArrayOutputStream.size() >= 65536) continue;
                        byteArrayOutputStream.write(cArray2[i3]);
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                logger.error("Response write with bad indices", indexOutOfBoundsException);
            }
            catch (IOException iOException) {
                logger.error("Problem writing response to file", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            httpResponse = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (httpResponse != null) {
            throw httpResponse;
        }
    }

    @ScopedSensor
    private void doWrite(byte[] byArray, int n2, int n3) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        byte[] byArray2 = byArray;
        int n4 = n2;
        int n5 = n3;
        try {
            try {
                OutputStream outputStream;
                if (httpResponse.capturingInFile) {
                    outputStream = httpResponse.openFile();
                    ((FileOutputStream)outputStream).write(byArray2, n4, n5);
                }
                if (httpResponse.capturingInMemory) {
                    outputStream = httpResponse.getMemoryBuffer().a();
                    int n6 = Math.max(0, 65536 - ((ByteArrayOutputStream)outputStream).size());
                    ((ByteArrayOutputStream)outputStream).write(byArray2, n4, Math.min(n5, n6));
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                logger.error("Response write with bad indices", indexOutOfBoundsException);
            }
            catch (IOException iOException) {
                logger.error("Problem writing response to file", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            httpResponse = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (httpResponse != null) {
            throw httpResponse;
        }
    }

    @ScopedSensor
    private void doWrite(byte by2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        byte by3 = by2;
        try {
            try {
                OutputStream outputStream;
                if (httpResponse.capturingInMemory && ((ByteArrayOutputStream)(outputStream = httpResponse.getMemoryBuffer().a())).size() < 65536) {
                    ((ByteArrayOutputStream)outputStream).write(by3);
                }
                if (httpResponse.capturingInFile) {
                    outputStream = httpResponse.openFile();
                    ((FileOutputStream)outputStream).write(by3);
                }
            }
            catch (IOException iOException) {
                logger.error("Problem writing response to file", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            httpResponse = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (httpResponse != null) {
            throw httpResponse;
        }
    }

    @ScopedSensor
    private void doWrite(int n2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        int n3 = n2;
        try {
            try {
                OutputStream outputStream;
                if (httpResponse.capturingInMemory && ((ByteArrayOutputStream)(outputStream = httpResponse.getMemoryBuffer().a())).size() < 65536) {
                    ((ByteArrayOutputStream)outputStream).write(n3);
                }
                if (httpResponse.capturingInFile && (outputStream = httpResponse.openFile()) != null) {
                    ((FileOutputStream)outputStream).write(n3);
                }
            }
            catch (IOException iOException) {
                logger.error("Problem writing response to file", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            httpResponse = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (httpResponse != null) {
            throw httpResponse;
        }
    }

    public final ContrastReplacedResponseChunkModel print(String string, int n2, int n3) {
        return this.write(string, n2, n3);
    }

    public ContrastReplacedResponseChunkModel print(String string) {
        return this.write(string);
    }

    public final ContrastReplacedResponseChunkModel print(char[] cArray, int n2, int n3) {
        return this.write(cArray, n2, n3);
    }

    public final ContrastReplacedResponseChunkModel print(byte[] byArray, int n2, int n3) {
        return this.write(byArray, n2, n3);
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(char c2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        char c3 = c2;
        try {
            String string = String.valueOf(c3);
            httpResponse.write(string);
            httpResponse = null;
            return httpResponse;
        }
        finally {
            Object var4_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(short s2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        short s3 = s2;
        try {
            String string = String.valueOf(s3);
            httpResponse.write(string);
            httpResponse = null;
            return httpResponse;
        }
        finally {
            Object var4_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(int n2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        int n3 = n2;
        try {
            String string = String.valueOf(n3);
            httpResponse.write(string);
            httpResponse = null;
            return httpResponse;
        }
        finally {
            Object var4_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(long l2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        Object object = this;
        long l3 = l2;
        try {
            String string = String.valueOf(l3);
            object = ((HttpResponse)object).write(string);
            return object;
        }
        finally {
            Object var5_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(double d2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        Object object = this;
        double d3 = d2;
        try {
            String string = String.valueOf(d3);
            object = ((HttpResponse)object).write(string);
            return object;
        }
        finally {
            Object var5_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(float f2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        Object object = this;
        float f3 = f2;
        try {
            String string = String.valueOf(f3);
            object = ((HttpResponse)object).write(string);
            return object;
        }
        finally {
            Object var4_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(boolean bl2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        Object object = this;
        boolean bl3 = bl2;
        try {
            String string = String.valueOf(bl3);
            object = ((HttpResponse)object).write(string);
            return object;
        }
        finally {
            Object var4_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(Object object) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        Object object2 = this;
        Object object3 = object;
        try {
            String string = String.valueOf(object3);
            object2 = ((HttpResponse)object2).write(string);
            return object2;
        }
        finally {
            object3 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(char[] cArray) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        Object object = this;
        char[] cArray2 = cArray;
        try {
            String string = String.valueOf(cArray2);
            object = ((HttpResponse)object).write(string);
            return object;
        }
        finally {
            cArray2 = null;
        }
    }

    public final ContrastReplacedResponseChunkModel println(String string) {
        ReplacedResponseChunk replacedResponseChunk = this.write(string);
        this.write(ObjectShare.LINE_SEPARATOR);
        return replacedResponseChunk;
    }

    public ContrastReplacedResponseChunkModel println() {
        this.write(ObjectShare.LINE_SEPARATOR);
        return null;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(char c2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        char c3 = c2;
        try {
            httpResponse.print(c3);
            httpResponse.println();
            httpResponse = null;
            return httpResponse;
        }
        finally {
            Object var4_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(short s2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        short s3 = s2;
        try {
            httpResponse.print(s3);
            httpResponse.println();
            httpResponse = null;
            return httpResponse;
        }
        finally {
            Object var4_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(int n2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        int n3 = n2;
        try {
            httpResponse.print(n3);
            httpResponse.println();
            httpResponse = null;
            return httpResponse;
        }
        finally {
            Object var4_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(long l2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        long l3 = l2;
        try {
            httpResponse.print(l3);
            httpResponse.println();
            httpResponse = null;
            return httpResponse;
        }
        finally {
            Object var5_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(double d2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        double d3 = d2;
        try {
            httpResponse.print(d3);
            httpResponse.println();
            httpResponse = null;
            return httpResponse;
        }
        finally {
            Object var5_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(float f2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        float f3 = f2;
        try {
            httpResponse.print(f3);
            httpResponse.println();
            httpResponse = null;
            return httpResponse;
        }
        finally {
            Object var4_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(boolean bl2) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        boolean bl3 = bl2;
        try {
            httpResponse.print(bl3);
            httpResponse.println();
            httpResponse = null;
            return httpResponse;
        }
        finally {
            Object var4_5 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(Object object) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        Object object2 = object;
        try {
            httpResponse.print(object2);
            httpResponse.println();
            httpResponse = null;
            return httpResponse;
        }
        finally {
            object2 = null;
        }
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(char[] cArray) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        HttpResponse httpResponse = this;
        char[] cArray2 = cArray;
        try {
            httpResponse.print(cArray2);
            httpResponse.println();
            httpResponse = null;
            return httpResponse;
        }
        finally {
            cArray2 = null;
        }
    }

    private byte[] toEncodedBytes(String string) throws IOException {
        String string2 = this.getCharacterEncoding();
        if (string2 == null || !this.isKnownEncoding(string2)) {
            string2 = DEFAULT_ENCODING;
        }
        return string.getBytes(string2);
    }

    private boolean isKnownEncoding(String string) {
        return Charset.isSupported(string);
    }

    public void onHeaderSet(String string2, String string3, String string4) {
        if (string2 == null || string3 == null) {
            return;
        }
        if ("Content-Disposition".equals(string2) && string3.contains("attachment")) {
            this.capturingInMemory = false;
            logger.debug("Detecting file download {} at path {}: not buffering response in memory", (Object)string3, (Object)(string4 != null ? string4 : "(unknown)"));
            return;
        }
        if ("Content-Type".equals(string2) && this.isUntrackableContentType(string3)) {
            this.capturingInMemory = false;
            logger.debug("Detected Content-Type {} at path {}: not buffering response in memory", (Object)string3, (Object)(string4 != null ? string4 : "(unknown)"));
        }
        List list = this.headers.computeIfAbsent(string2, string -> new CopyOnWriteArrayList());
        list.add(string3);
    }

    private boolean isUntrackableContentType(String string) {
        return !P.d(ALLOWED_CONTENT_TYPES, string);
    }

    @Override
    public File getFile() throws IOException {
        return FILE_BUFFER.b();
    }

    @Override
    public o getMemoryBuffer() {
        return BUFFER;
    }

    @Override
    public h getFileBuffer() {
        return FILE_BUFFER;
    }
}

