/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.injection;

import com.contrastsecurity.agent.BaseInjectionInitializer;
import com.contrastsecurity.agent.ContrastLoaderAgent;
import com.contrastsecurity.agent.injection.Injector;
import com.contrastsecurity.agent.injection.MethodHandlesInjector;
import com.contrastsecurity.agent.injection.UnsafeInjector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ClassInjector {
    private static final Pattern MARKER_REGEX = Pattern.compile("^java/lang/ContrastAnalyzed(.+)$");
    private static final Pattern DISPATCHER_REGEX = Pattern.compile("^java/lang/(.+)Dispatcher$");
    private static final Pattern MODEL_REGEX = Pattern.compile("^java/lang/(.+)Model$");
    private static final Pattern LOCATOR_INTERFACE_REGEX = Pattern.compile("^java/lang/(.+)Locator$");
    private static final Pattern LOCATOR_SINGLETON_REGEX = Pattern.compile("^java/lang/(.+)Locator\\$Singleton$");
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int EOF = -1;

    public static void inject(Instrumentation inst, File agentJarFile) {
        if (!ClassInjector.doesSupportModules()) {
            ClassInjector.injectBaseInjections(new UnsafeInjector());
        } else {
            ClassInjector.redefineJavaBaseModule(inst);
            ClassInjector.injectBaseInjections(new MethodHandlesInjector());
        }
        if (!BaseInjectionInitializer.initialize(agentJarFile)) {
            throw new IllegalStateException("Failed to initialize base injections");
        }
    }

    public static boolean doesSupportModules() {
        try {
            Class.forName("java.lang.Module");
        }
        catch (ClassNotFoundException e2) {
            return false;
        }
        return true;
    }

    private static void redefineJavaBaseModule(Instrumentation instrumentation) {
        if (!ClassInjector.doesSupportModules()) {
            return;
        }
        try {
            Instrumentation.class.getMethod("redefineModule", Class.forName("java.lang.Module"), Set.class, Map.class, Map.class, Set.class, Map.class).invoke((Object)instrumentation, ClassInjector.getModule(Object.class), Collections.emptySet(), Collections.emptyMap(), Collections.singletonMap("java.lang", Collections.singleton(ClassInjector.getModule(MethodHandlesInjector.class))), Collections.emptySet(), Collections.emptyMap());
        }
        catch (Exception e2) {
            throw new IllegalStateException("There was a problem redefining the java.base module", e2);
        }
    }

    private static Object getModule(Class<?> clazz) {
        try {
            return Class.class.getMethod("getModule", new Class[0]).invoke(clazz, new Object[0]);
        }
        catch (Exception e2) {
            throw new IllegalStateException("There was a problem while getting the module of the class", e2);
        }
    }

    public static void injectBaseInjections(Injector injector) {
        LinkedList<Runnable> dispatcherInterfaceInjections = new LinkedList<Runnable>();
        LinkedList<Runnable> locatorInterfaceInjections = new LinkedList<Runnable>();
        LinkedList<Runnable> locatorSingletonInjections = new LinkedList<Runnable>();
        Set<String> additionalTypes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java/lang/ContrastClassFinder", "java/lang/ContrastObjectShare", "java/lang/ContrastPreconditions", "java/lang/ContrastSecurityScope")));
        try (ZipInputStream zis = new ZipInputStream(ContrastLoaderAgent.getBaseInjectionsAsStream());){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                int entrySize;
                String name = zipEntry.getName();
                if (!name.endsWith(CLASS_FILE_SUFFIX) || (entrySize = (int)zipEntry.getSize()) == -1) continue;
                String typeName = name.substring(0, name.length() - CLASS_FILE_SUFFIX.length());
                byte[] bytecode = ClassInjector.readFully(zis, entrySize);
                Runnable injectRunnable = () -> {
                    try {
                        injector.inject(typeName, bytecode);
                    }
                    catch (Exception e2) {
                        throw new IllegalStateException(e2);
                    }
                };
                if (additionalTypes.contains(typeName) || MARKER_REGEX.matcher(typeName).matches() || MODEL_REGEX.matcher(typeName).matches()) {
                    injectRunnable.run();
                    continue;
                }
                if (DISPATCHER_REGEX.matcher(typeName).matches()) {
                    dispatcherInterfaceInjections.add(injectRunnable);
                    continue;
                }
                if (LOCATOR_INTERFACE_REGEX.matcher(typeName).matches()) {
                    locatorInterfaceInjections.add(injectRunnable);
                    continue;
                }
                if (LOCATOR_SINGLETON_REGEX.matcher(typeName).matches()) {
                    locatorSingletonInjections.add(injectRunnable);
                    continue;
                }
                throw new IllegalArgumentException("Contrast java-agent-base-injections jar contains type with unexpected name " + typeName);
            }
        }
        catch (IOException e2) {
            throw new IllegalStateException("Unexpected exception reading classes from java-agent-base-injections jar", e2);
        }
        for (Runnable runnable : dispatcherInterfaceInjections) {
            runnable.run();
        }
        for (Runnable runnable : locatorInterfaceInjections) {
            runnable.run();
        }
        for (Runnable runnable : locatorSingletonInjections) {
            runnable.run();
        }
    }

    private static byte[] readFully(InputStream stream, int size) throws IOException {
        int location;
        int count;
        if (size == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] buffer = new byte[size];
        for (int remaining = size; remaining > 0 && -1 != (count = stream.read(buffer, location = size - remaining, remaining)); remaining -= count) {
        }
        return buffer;
    }

    private ClassInjector() {
    }
}

