/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.logging.log4j2.plugins;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.p;
import com.contrastsecurity.agent.t.b;
import com.contrastsecurity.agent.t.c;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.filter.AbstractFilter;
import java.util.Objects;

@Plugin(name="AsyncAppenderThreadFilter", category="Core", elementType="filter")
@DontObfuscate
public final class AsyncAppenderThreadFilter
extends AbstractFilter {
    private final String newAsyncAppenderName;
    private final Configuration configuration;
    private final long previousAsyncAppenderThreadId;
    private volatile long currentAsyncAppenderThreadId;

    public AsyncAppenderThreadFilter(String string, String string2, Configuration configuration) {
        this.newAsyncAppenderName = p.a(string2);
        this.configuration = Objects.requireNonNull(configuration);
        this.previousAsyncAppenderThreadId = AsyncAppenderThreadFilter.getAppenderThreadId(configuration, string);
        this.currentAsyncAppenderThreadId = -1L;
    }

    @Override
    public void start() {
        this.currentAsyncAppenderThreadId = AsyncAppenderThreadFilter.getAppenderThreadId(this.configuration, this.newAsyncAppenderName);
        super.start();
    }

    @Override
    public Filter.Result filter(LogEvent logEvent) {
        assert (this.currentAsyncAppenderThreadId > 0L);
        long l2 = logEvent.getThreadId();
        return this.currentAsyncAppenderThreadId == l2 || this.previousAsyncAppenderThreadId == l2 ? Filter.Result.DENY : super.filter(logEvent);
    }

    @PluginFactory
    public static AsyncAppenderThreadFilter createFilter(@PluginAttribute(value="newAsyncAppenderName") String string, @PluginAttribute(value="previousAsyncAppenderName") String string2, @PluginConfiguration Configuration configuration) {
        return new AsyncAppenderThreadFilter(string2, string, configuration);
    }

    private static long getAppenderThreadId(Configuration configuration, String string) {
        Object t2 = configuration.getAppender(string);
        if (t2 == null) {
            return -1L;
        }
        try {
            return b.a(t2).c("dispatcher").a(Thread.class).getId();
        }
        catch (c c2) {
            throw new IllegalStateException(c2);
        }
    }
}

