/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.logging.log4j2.plugins;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.p;
import com.contrastsecurity.agent.commons.t;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.DiagnosticsDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.DiagnosticsLoggerDTM;
import com.contrastsecurity.agent.contrastapi_v1_0.settings.server.ServerSettingsDTM;
import com.contrastsecurity.agent.e.d;
import com.contrastsecurity.agent.logging.log4j2.h;
import com.contrastsecurity.agent.v.s;
import com.contrastsecurity.thirdparty.com.google.protobuf.CodedInputStream;
import com.contrastsecurity.thirdparty.com.google.protobuf.CodedOutputStream;
import com.contrastsecurity.thirdparty.com.google.protobuf.Empty;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.collector.logs.v1.ExportLogsPartialSuccess;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceRequest;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.collector.logs.v1.ExportLogsServiceResponse;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.common.v1.AnyValue;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.common.v1.KeyValue;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.logs.v1.LogRecord;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.logs.v1.ResourceLogs;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.logs.v1.ScopeLogs;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.logs.v1.SeverityNumber;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.resource.v1.Resource;
import com.contrastsecurity.thirdparty.org.apache.commons.io.IOUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.http.Header;
import com.contrastsecurity.thirdparty.org.apache.http.HeaderElement;
import com.contrastsecurity.thirdparty.org.apache.http.HttpEntity;
import com.contrastsecurity.thirdparty.org.apache.http.client.methods.HttpPost;
import com.contrastsecurity.thirdparty.org.apache.http.entity.AbstractHttpEntity;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Appender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AbstractAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.appender.AsyncAppender;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.core.util.Builder;
import com.contrastsecurity.thirdparty.org.apache.logging.log4j.spi.StandardLevel;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

@Plugin(name="OtelAppender", category="Core", elementType="appender")
@DontObfuscate
public final class OtelAppender
extends AbstractAppender
implements com.contrastsecurity.agent.logging.log4j2.b {
    @C
    public static final int MAX_CONSECUTIVE_FAILURES = 10;
    private static final String ASYNC_APPENDER_PREFIX = h.b.name() + ".";
    private static final String SYNC_APPENDER_PREFIX = h.b.name() + ".sync" + ".";
    private static final String PROTOBUF_CONTENT_TYPE = "application/x-protobuf";
    private static final AtomicInteger UNIQUE_INDEX = new AtomicInteger(0);
    private static final AtomicBoolean SHUTDOWN_DUE_TO_ERRORS = new AtomicBoolean(false);
    private final Configuration log4j2Configuration;
    private final g contrastConfig;
    private final String parentAppenderName;
    private final long backoffFactorMs;
    private final long maxTotalBackoffMs;
    private final int maxBatchSize;
    private final long batchTimeoutMs;
    private final com.contrastsecurity.agent.e.d httpClient;
    private final t sleeper;
    private final c jitter;
    private final LogEvent[] batchedMessages;
    private final ExportLogsServiceRequest.Builder requestBodyBuilder;
    private final ScopeLogs.Builder logMessageBuilder;
    private final HttpPost request;
    private final e reponseBodyBuffer;
    private final f requestBody;
    private int batchedMessagesCount;
    private int consecutiveFailures;
    private static final ScopeLogs EMPTY = ScopeLogs.newBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET).buildPartial();

    @C
    OtelAppender(String string, Layout<? extends Serializable> layout, Filter filter, boolean bl2, Property[] propertyArray, Configuration configuration, g g2, String string2, String string3, String string4, String string5, String string6, String string7, long l2, long l3, int n2, long l4, com.contrastsecurity.agent.e.d d2, t t2, c c2) {
        super(string, filter, layout, bl2, propertyArray);
        this.log4j2Configuration = Objects.requireNonNull(configuration);
        this.contrastConfig = Objects.requireNonNull(g2);
        Objects.requireNonNull(string2);
        this.parentAppenderName = p.a(string4);
        p.a(string5);
        Objects.requireNonNull(string6);
        Objects.requireNonNull(string7);
        p.a(l2 > 0L, "backoffFactorMs must be greater than 0.");
        this.backoffFactorMs = l2;
        p.a(l3 > 0L, "maxTotalBackoffMs must be greater than 0.");
        this.maxTotalBackoffMs = l3;
        p.a(n2 > 0, "maxBatchSize must be greater than 0.");
        this.maxBatchSize = n2;
        p.a(l4 > 0L, "batchTimeoutMs must be greater than 0.");
        this.batchTimeoutMs = l4;
        this.httpClient = Objects.requireNonNull(d2);
        this.sleeper = Objects.requireNonNull(t2);
        this.jitter = Objects.requireNonNull(c2);
        this.batchedMessages = new LogEvent[n2];
        HttpPost httpPost = new HttpPost(string5 + "/agents/v2.0/diagnostics/logs");
        this.reponseBodyBuffer = new e();
        f f2 = new f(new e(), PROTOBUF_CONTENT_TYPE);
        httpPost.setEntity(f2);
        httpPost.setHeader("Content-Type", PROTOBUF_CONTENT_TYPE);
        httpPost.setHeader("Authorization", string6);
        httpPost.setHeader("API-KEY", string7);
        this.requestBody = f2;
        this.request = httpPost;
        AnyValue.Builder builder = AnyValue.newBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET);
        ExportLogsServiceRequest.Builder builder2 = ExportLogsServiceRequest.newBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET);
        builder2.addResourceLogsBuilder(0).setUnknownFields(Empty.UNKNOWN_FIELD_SET).setResource(Resource.newBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET).addAttributes(KeyValue.newBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET).setKey("server.name").setValue(builder.setStringValue(string2).build()).build()).addAttributes(KeyValue.newBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET).setKey("diagnostics.uuid").setValue(builder.setStringValue(string3).build()).build()).addAttributes(KeyValue.newBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET).setKey("service.name").setValue(builder.setStringValue("contrast_agent:java").build()).build()).addAttributes(KeyValue.newBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET).setKey("telemetry.sdk.language").setValue(builder.setStringValue("java").build()).build()).addAttributes(KeyValue.newBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET).setKey("telemetry.sdk.name").setValue(builder.setStringValue("contrast.opentelemetry.java").build()).build()).addAttributes(KeyValue.newBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET).setKey("telemetry.sdk.version").setValue(builder.setStringValue("5.2.3").build()).build()).addAttributes(KeyValue.newBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET).setKey("contrast.agent.version").setValue(builder.setStringValue("5.2.3").build()).build()).build());
        this.requestBodyBuilder = builder2;
        ScopeLogs.Builder builder3 = ScopeLogs.newBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET);
        builder3.getScopeBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET);
        LogRecord.Builder builder4 = builder3.addLogRecordsBuilder(0);
        builder4.setUnknownFields(Empty.UNKNOWN_FIELD_SET);
        builder4.getBodyBuilder().setUnknownFields(Empty.UNKNOWN_FIELD_SET);
        ResourceLogs.Builder builder5 = builder2.getResourceLogsBuilder(0);
        for (int i2 = 0; i2 < n2; ++i2) {
            builder5.addScopeLogs(i2, EMPTY);
        }
        this.logMessageBuilder = builder3;
    }

    public static long newIndex() {
        return UNIQUE_INDEX.getAndIncrement();
    }

    public static String asyncName(long l2) {
        return ASYNC_APPENDER_PREFIX + l2;
    }

    public static String syncName(long l2) {
        return SYNC_APPENDER_PREFIX + l2;
    }

    public static boolean shutdownDueToErrors() {
        return SHUTDOWN_DUE_TO_ERRORS.get();
    }

    private static <T> T getOrDefault(g g2, ConfigProperty configProperty, Supplier<T> supplier, Class<T> clazz) {
        String string = g2.c(configProperty);
        if (string == null) {
            return supplier.get();
        }
        try {
            return clazz.cast(Class.forName(string, true, OtelAppender.class.getClassLoader()).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new IllegalArgumentException("Failed to create instance of " + string + ". Does it have a default, no-args constructor?", reflectiveOperationException);
        }
    }

    @Override
    public void append(LogEvent logEvent) {
        d.a<ExportLogsServiceResponse> a2;
        if (OtelAppender.isShutdownDueToConsecutiveErrors(this.consecutiveFailures)) {
            return;
        }
        if (!this.isStarted() && !this.isStopping()) {
            return;
        }
        ResourceLogs.Builder builder = this.requestBodyBuilder.getResourceLogsBuilder(0);
        if (!logEvent.isEndOfBatch()) {
            this.batchedMessages[this.batchedMessagesCount] = logEvent.toImmutable();
            ++this.batchedMessagesCount;
            if (this.batchedMessagesCount < this.maxBatchSize) {
                return;
            }
        }
        if (this.batchedMessagesCount == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.batchedMessagesCount; ++i2) {
            a2 = this.batchedMessages[i2];
            this.logMessageBuilder.getScopeBuilder().setName(a2.getLoggerName());
            this.logMessageBuilder.getLogRecordsBuilder(0).setTimeUnixNano(TimeUnit.MILLISECONDS.toNanos(a2.getTimeMillis())).setObservedTimeUnixNano(TimeUnit.MILLISECONDS.toNanos(a2.getTimeMillis())).setSeverityNumber(OtelAppender.level(a2.getLevel().getStandardLevel())).setSeverityText(a2.getLevel().name()).getBodyBuilder().setStringValue(a2.getMessage().getFormattedMessage());
            builder.setScopeLogs(i2, this.logMessageBuilder.build());
            this.batchedMessages[i2] = null;
        }
        while (this.batchedMessagesCount < this.maxBatchSize) {
            builder.setScopeLogs(this.batchedMessagesCount, EMPTY);
            ++this.batchedMessagesCount;
        }
        this.batchedMessagesCount = 0;
        ExportLogsServiceRequest exportLogsServiceRequest = this.requestBodyBuilder.build();
        this.requestBody.a.a(exportLogsServiceRequest.getSerializedSize());
        try {
            exportLogsServiceRequest.writeTo(CodedOutputStream.newInstance(this.requestBody.a.b, 0, this.requestBody.a.c));
        }
        catch (IOException iOException) {
            d.a.debug("Unexpected error writing request to byte buffer.", iOException);
            throw new AssertionError((Object)iOException);
        }
        a2 = d.a.b.b.a();
        long l2 = 0L;
        int n2 = 0;
        while (l2 <= this.maxTotalBackoffMs && d.a.b.b == a2.a()) {
            if (n2 > 0) {
                long l3 = a2.a((long)(1 << n2) * this.backoffFactorMs) + this.jitter.a();
                if (l3 <= 0L) break;
                l2 += l3;
                this.sleeper.a(l3);
            }
            a2 = this.httpClient.b(this.request, httpResponse -> {
                HttpEntity httpEntity = httpResponse.getEntity();
                if (httpEntity == null) {
                    return null;
                }
                Header header = httpEntity.getContentType();
                if (header == null) {
                    return null;
                }
                HeaderElement[] headerElementArray = header.getElements();
                if (headerElementArray == null || headerElementArray.length == 0) {
                    return null;
                }
                String string = headerElementArray[0].getName();
                if (!PROTOBUF_CONTENT_TYPE.equals(string)) {
                    return null;
                }
                long l2 = httpEntity.getContentLength();
                if (l2 < -1L || l2 > Integer.MAX_VALUE) {
                    return null;
                }
                try (InputStream inputStream = httpEntity.getContent();){
                    if (inputStream == null) {
                        ExportLogsServiceResponse exportLogsServiceResponse = null;
                        return exportLogsServiceResponse;
                    }
                    this.reponseBodyBuffer.a((int)l2);
                    IOUtils.readFully(inputStream, this.reponseBodyBuffer.b, 0, this.reponseBodyBuffer.c);
                    ExportLogsServiceResponse exportLogsServiceResponse = ExportLogsServiceResponse.parseFrom(CodedInputStream.newInstance(this.reponseBodyBuffer.b, 0, this.reponseBodyBuffer.c));
                    return exportLogsServiceResponse;
                }
            });
            ++n2;
        }
        if (d.a.b.a != a2.a()) {
            d.a.debug("Otel log request failed with response code: {}", (Object)a2.b(), (Object)a2.e());
            ++this.consecutiveFailures;
            if (OtelAppender.isShutdownDueToConsecutiveErrors(this.consecutiveFailures)) {
                this.stopImmediately();
            }
            return;
        }
        ExportLogsServiceResponse exportLogsServiceResponse = (ExportLogsServiceResponse)a2.d();
        this.consecutiveFailures = 0;
        if (exportLogsServiceResponse == null) {
            d.a.debug("Otel log request succeeded with no response body.");
            return;
        }
        if (!exportLogsServiceResponse.hasPartialSuccess()) {
            return;
        }
        ExportLogsPartialSuccess exportLogsPartialSuccess = exportLogsServiceResponse.getPartialSuccess();
        String string = exportLogsPartialSuccess.getErrorMessage();
        d.a.debug("Otel log request partially failed. {} Rejected {} logs.", (Object)string, (Object)exportLogsPartialSuccess.getRejectedLogRecords());
    }

    private static boolean isShutdownDueToConsecutiveErrors(int n2) {
        return n2 >= 10;
    }

    private static void close(String string, Closeable closeable) {
        try {
            Objects.requireNonNull(closeable).close();
        }
        catch (IOException iOException) {
            d.a.debug("Failed to close {} for diagnostic logger.", (Object)string, (Object)iOException);
        }
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        boolean bl2 = super.stop(l2, timeUnit);
        OtelAppender.close("client", this.httpClient);
        return bl2;
    }

    @C
    void stopImmediately() {
        d.a.debug("Disabling Otel log collection due to {} consecutive failures.", (Object)this.consecutiveFailures);
        this.contrastConfig.a(OtelAppender::disableDiagnosticsLogger);
        SHUTDOWN_DUE_TO_ERRORS.set(true);
        super.stop(1L, TimeUnit.NANOSECONDS);
        Thread.currentThread().interrupt();
        try {
            this.log4j2Configuration.getAppenders().remove(this.getName());
            this.log4j2Configuration.getLoggerContext().getRootLogger().removeAppender(this);
            Appender appender = this.log4j2Configuration.getAppenders().remove(this.parentAppenderName);
            if (appender == null) {
                return;
            }
            this.log4j2Configuration.getLoggerContext().getRootLogger().removeAppender(appender);
            if (!(appender instanceof AsyncAppender)) {
                throw new IllegalStateException("Unable to stop async appender thread.");
            }
            try {
                com.contrastsecurity.agent.t.b b2 = com.contrastsecurity.agent.t.b.a(appender);
                b2.a("setStopped");
                b2.c("dispatcher").c("queue").a(Queue.class).clear();
            }
            catch (com.contrastsecurity.agent.t.c c2) {
                throw new IllegalStateException("Unable to stop async appender thread.", c2);
            }
        }
        finally {
            OtelAppender.close("client", this.httpClient);
        }
    }

    public static ServerSettingsDTM disableDiagnosticsLogger(ServerSettingsDTM serverSettingsDTM) {
        if (serverSettingsDTM == null) {
            serverSettingsDTM = new ServerSettingsDTM().setDiagnostics(new DiagnosticsDTM().setDiagnosticsLogger(new DiagnosticsLoggerDTM()));
        }
        serverSettingsDTM.getDiagnostics().getDiagnosticsLogger().setEnabled(false);
        return serverSettingsDTM;
    }

    @Override
    public long batchTimeoutMs() {
        return this.batchTimeoutMs;
    }

    private static SeverityNumber level(StandardLevel standardLevel) {
        switch (standardLevel) {
            case OFF: {
                return SeverityNumber.SEVERITY_NUMBER_UNSPECIFIED;
            }
            case FATAL: {
                return SeverityNumber.SEVERITY_NUMBER_FATAL;
            }
            case ERROR: {
                return SeverityNumber.SEVERITY_NUMBER_ERROR;
            }
            case WARN: {
                return SeverityNumber.SEVERITY_NUMBER_WARN;
            }
            case INFO: {
                return SeverityNumber.SEVERITY_NUMBER_INFO;
            }
            case TRACE: 
            case ALL: {
                return SeverityNumber.SEVERITY_NUMBER_TRACE;
            }
        }
        return SeverityNumber.SEVERITY_NUMBER_DEBUG;
    }

    @PluginBuilderFactory
    public static <B extends a<B>> B builder() {
        return (B)((a)new a().asBuilder());
    }

    private static final class d {
        private static final Logger a = LoggerFactory.getLogger(OtelAppender.class);

        private d() {
        }
    }

    public static final class a<B extends a<B>>
    extends AbstractAppender.Builder<B>
    implements Builder<OtelAppender> {
        @PluginBuilderAttribute(value="uuid")
        private String a;
        @PluginBuilderAttribute(value="parentAppenderName")
        private String b;
        @PluginBuilderAttribute(value="teamserverUrl")
        private String c;
        @PluginBuilderAttribute(value="authorization")
        private String d;
        @PluginBuilderAttribute(value="apiKey")
        private String e;
        @PluginBuilderAttribute(value="timeoutMs")
        private int f;
        @PluginBuilderAttribute(value="backoffFactorMs")
        private long g;
        @PluginBuilderAttribute(value="maxTotalBackoffMs")
        private long h;
        @PluginBuilderAttribute(value="maxBatchSize")
        private int i;
        @PluginBuilderAttribute(value="batchTimeoutMs")
        private long j;

        public a<B> a(String string) {
            this.a = p.a(string);
            return this;
        }

        public a<B> b(String string) {
            this.b = string;
            return this;
        }

        public a<B> c(String string) {
            this.c = string;
            return this;
        }

        public a<B> d(String string) {
            this.d = string;
            return this;
        }

        public a<B> e(String string) {
            this.e = string;
            return this;
        }

        public a<B> a(int n2) {
            this.f = n2;
            return this;
        }

        public a<B> a(long l2) {
            this.g = l2;
            return this;
        }

        public a<B> b(long l2) {
            this.h = l2;
            return this;
        }

        public a<B> b(int n2) {
            this.i = n2;
            return this;
        }

        public a<B> c(long l2) {
            this.j = l2;
            return this;
        }

        public OtelAppender a() {
            Configuration configuration = this.getConfiguration();
            if (!(configuration instanceof com.contrastsecurity.agent.logging.b)) {
                throw new IllegalArgumentException("Log4j2 configuration must be an instance of " + com.contrastsecurity.agent.logging.b.class.getTypeName());
            }
            com.contrastsecurity.agent.logging.b b2 = (com.contrastsecurity.agent.logging.b)((Object)configuration);
            g g2 = b2.a();
            s s2 = b2.b();
            p.a(this.f > 0, "timeoutMs must be greater than 0.");
            com.contrastsecurity.agent.e.d d2 = com.contrastsecurity.agent.e.e.a(g2).a(this.c).a(this.f).a(s2).b();
            t t2 = (t)OtelAppender.getOrDefault(g2, ConfigProperty.DIAGNOSTICS_LOGGER_SLEEPER_CLASS, com.contrastsecurity.agent.commons.s::new, t.class);
            c c2 = (c)OtelAppender.getOrDefault(g2, ConfigProperty.DIAGNOSTICS_LOGGER_JITTER_CLASS, () -> new b(), c.class);
            return new OtelAppender(this.getName(), this.getLayout(), this.getFilter(), this.isIgnoreExceptions(), this.getPropertyArray(), configuration, g2, StringUtils.trimToEmpty(s2.a()), this.a, this.b, this.c, this.d, this.e, this.g, this.h, this.i, this.j, d2, t2, c2);
        }

        @Override
        public /* synthetic */ Object build() {
            return this.a();
        }
    }

    private static final class f
    extends AbstractHttpEntity {
        private final e a;

        private f(e e2, String string) {
            this.setContentType(p.a(string));
            this.a = Objects.requireNonNull(e2);
        }

        @Override
        public boolean isRepeatable() {
            return true;
        }

        @Override
        public long getContentLength() {
            return this.a.c;
        }

        @Override
        public InputStream getContent() {
            return this.a.d;
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            Objects.requireNonNull(outputStream);
            outputStream.write(this.a.b, 0, this.a.c);
            outputStream.flush();
        }

        @Override
        public boolean isStreaming() {
            return false;
        }
    }

    private static final class e {
        private static final int a = 4096;
        private byte[] b;
        private int c;
        private ByteArrayInputStream d;

        private e() {
        }

        private void a(int n2) {
            if (this.b == null || n2 > this.b.length) {
                int n3;
                for (n3 = 4096; n3 < n2; n3 += 4096) {
                }
                this.b = new byte[n3];
                this.d = new ByteArrayInputStream(this.b);
            } else {
                this.d.reset();
            }
            this.c = n2;
        }
    }

    private static final class b
    implements c {
        private final Random a = new Random();

        private b() {
        }

        @Override
        public long a() {
            return (int)(30.0 * this.a.nextDouble());
        }
    }

    public static interface c {
        public long a();
    }
}

