/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.app.settings.protect;

import com.contrastsecurity.agent.commons.p;
import com.contrastsecurity.agent.messages.app.settings.protect.CommonConfigProtectionMode;
import com.contrastsecurity.agent.messages.app.settings.protect.ProtectionModeDTM;
import java.util.Objects;

public final class ProtectRuleConfigurationDTM {
    private boolean blockAtEntry;
    private String id;
    private ProtectionModeDTM mode;
    private CommonConfigProtectionMode protectionMode;

    public ProtectRuleConfigurationDTM(boolean bl2, String string, ProtectionModeDTM protectionModeDTM) {
        p.a(string != null && string.length() > 0, "id");
        Objects.requireNonNull(protectionModeDTM, () -> "mode parameter cannot be null");
        this.blockAtEntry = bl2;
        this.id = string;
        this.mode = protectionModeDTM;
        this.protectionMode = this.generateMode();
    }

    private ProtectRuleConfigurationDTM() {
    }

    public boolean isBlockAtEntry() {
        return this.blockAtEntry;
    }

    public String getId() {
        return this.id;
    }

    public ProtectionModeDTM getMode() {
        return this.mode;
    }

    public CommonConfigProtectionMode getProtectionMode() {
        if (this.protectionMode == null) {
            this.protectionMode = this.generateMode();
        }
        return this.protectionMode;
    }

    private CommonConfigProtectionMode generateMode() {
        return this.isBlockAtEntry() ? CommonConfigProtectionMode.BLOCK_AT_PERIMETER : CommonConfigProtectionMode.fromString(this.mode.toString());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProtectRuleConfigurationDTM protectRuleConfigurationDTM = (ProtectRuleConfigurationDTM)object;
        if (this.blockAtEntry != protectRuleConfigurationDTM.blockAtEntry) {
            return false;
        }
        if (this.id != null ? !this.id.equals(protectRuleConfigurationDTM.id) : protectRuleConfigurationDTM.id != null) {
            return false;
        }
        return this.mode == protectRuleConfigurationDTM.mode;
    }

    public int hashCode() {
        int n2 = this.blockAtEntry ? 1 : 0;
        n2 = 31 * n2 + (this.id != null ? this.id.hashCode() : 0);
        n2 = 31 * n2 + (this.mode != null ? this.mode.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "ProtectRuleConfigurationDTM{blockAtEntry=" + this.blockAtEntry + ", id='" + this.id + '\'' + ", mode=" + (Object)((Object)this.mode) + ", protectionMode=" + (Object)((Object)this.protectionMode) + '}';
    }
}

