/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.http4k;

import com.contrastsecurity.agent.C;
import com.contrastsecurity.agent.Contrast;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.info.HTTPRoute;
import com.contrastsecurity.agent.plugins.route.d;
import com.contrastsecurity.agent.plugins.security.F;
import com.contrastsecurity.agent.t.b;
import com.contrastsecurity.agent.t.c;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Singleton
@DontObfuscate
public final class ContrastHttp4kRouteDispatcherImpl
implements ContrastHttp4kRouteDispatcher {
    private final ApplicationManager applicationManager;
    private final HttpManager httpManager;
    private final F routeObservationListener;
    private final Supplier<Contrast.a> contrastStatus;
    private static final Pattern TEMPLATE = Pattern.compile("template == '(.*)'");
    private static final Pattern METHOD = Pattern.compile("method == (.*)");
    private static final Logger logger = LoggerFactory.getLogger(ContrastHttp4kRouteDispatcherImpl.class);

    @Inject
    public ContrastHttp4kRouteDispatcherImpl(ApplicationManager applicationManager, HttpManager httpManager, F f2, Supplier<Contrast.a> supplier) {
        this.applicationManager = applicationManager;
        this.httpManager = httpManager;
        this.routeObservationListener = f2;
        this.contrastStatus = supplier;
    }

    public void onRoutingHandlerCreated(Object object) {
        if (object == null) {
            logger.error("Http4k router was null");
            return;
        }
        Application application = this.applicationManager.current();
        if (application == null) {
            return;
        }
        try {
            Method method = com.contrastsecurity.agent.t.d.a(object.getClass(), "getDescription", new Class[0]);
            if (method == null) {
                logger.error("Unable to find getDescription on Http4k router");
                return;
            }
            Object object2 = method.invoke(object, new Object[0]);
            a a2 = a.a(object2);
            if (a2 == null) {
                return;
            }
            HashSet<HTTPRoute> hashSet = new HashSet<HTTPRoute>();
            this.findRoutes(a2, hashSet, object2);
            application.addDiscoveredRoutes(Collections.unmodifiableSet(hashSet));
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            logger.error("Reflection error", reflectiveOperationException);
        }
    }

    public void onRoutedRequest(Object object, Object object2) {
        HttpRequest httpRequest = d.a(this.contrastStatus, this.applicationManager, this.httpManager);
        if (httpRequest == null) {
            return;
        }
        try {
            b b2 = b.a(object);
            Object object3 = b2.a("getMethod").b();
            if (object3 == null) {
                return;
            }
            Object object4 = b2.a("getUri").b();
            if (object4 == null) {
                return;
            }
            this.routeObservationListener.onRouteObserved(HTTPRoute.of(object3.toString(), object4.toString(), object2.toString()), httpRequest);
        }
        catch (c c2) {
            logger.debug("Error retrieving route observed", c2);
        }
    }

    private void findRoutes(a a2, Collection<HTTPRoute> collection, Object object) throws IllegalAccessException {
        List<?> list = a2.c(object);
        if (list.size() < 1) {
            logger.debug("Expected more than 1 child on parent node");
            return;
        }
        String string = a2.b(list.get(0));
        if (string == null) {
            logger.debug("Unable to find description on parent node");
            return;
        }
        Matcher matcher = METHOD.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            this.findUris(a2, collection, list, string2);
        } else {
            for (Object obj : list) {
                this.findRoutes(a2, collection, obj);
            }
        }
    }

    private void findUris(a a2, Collection<HTTPRoute> collection, Collection<?> collection2, String string) throws IllegalAccessException {
        for (Object obj : collection2) {
            Matcher matcher;
            String string2 = a2.b(obj);
            if (string2 != null && (matcher = TEMPLATE.matcher(string2)).find()) {
                String string3 = matcher.group(1);
                collection.add(HTTPRoute.of(string, string3, string3));
            }
            this.findUris(a2, collection, a2.c(obj), string);
        }
    }

    @C
    static final class a {
        private final Field a;
        private final Field b;

        private a(Field field, Field field2) {
            this.a = field;
            this.b = field2;
        }

        public static a a(Object object) {
            if (object == null) {
                return null;
            }
            Field field = com.contrastsecurity.agent.t.d.a(object.getClass(), "description");
            Field field2 = com.contrastsecurity.agent.t.d.a(object.getClass(), "children");
            if (field == null) {
                logger.error("Missing expected field \"description\", unable to parse routes for Http4k");
                return null;
            }
            if (field2 == null) {
                logger.error("Missing expected field \"children\", unable to parse routes for Http4k");
                return null;
            }
            return new a(field, field2);
        }

        public String b(Object object) throws IllegalAccessException {
            Object object2 = this.a.get(object);
            return object2 instanceof String ? (String)object2 : null;
        }

        public List<?> c(Object object) throws IllegalAccessException {
            Object object2 = this.b.get(object);
            return object2 instanceof List ? (List)object2 : Collections.emptyList();
        }
    }
}

