/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.java.nio;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.plugins.frameworks.antlr.k;
import com.contrastsecurity.agent.plugins.frameworks.java.nio.a;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.b.a;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.controller.propagate.h;
import com.contrastsecurity.agent.plugins.security.model.PropagationEvent;
import com.contrastsecurity.agent.plugins.security.model.g;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.c;
import com.contrastsecurity.agent.plugins.security.policy.m;
import com.contrastsecurity.agent.plugins.security.policy.propagators.Propagator;
import com.contrastsecurity.agent.scope.GlobalScopeProvider;
import com.contrastsecurity.agent.scope.ScopeAggregator;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.TagRange;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.e;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

@Singleton
@DontObfuscate
public final class ContrastNioDispatcherImpl
implements ContrastNioDispatcher {
    private final AssessmentManager assessmentManager;
    private final com.contrastsecurity.agent.plugins.security.model.c codeEventFactory;
    private final EventContext eventContext;
    private final e traceFactory;
    private final Propagator bogusPropagator;
    private final a debugStringFactory;
    private final com.contrastsecurity.agent.w.k stackCaptureFactory;
    private static final Logger logger = LoggerFactory.getLogger(ContrastNioDispatcherImpl.class);

    @Inject
    public ContrastNioDispatcherImpl(com.contrastsecurity.agent.plugins.security.model.c c2, AssessmentManager assessmentManager, c c3, EventContext eventContext, e e2, com.contrastsecurity.agent.w.k k2, a a2) {
        this.codeEventFactory = c2;
        this.assessmentManager = assessmentManager;
        this.eventContext = eventContext;
        this.traceFactory = e2;
        this.debugStringFactory = a2;
        this.stackCaptureFactory = k2;
        ContrastPolicy contrastPolicy = c3.e();
        Propagator propagator = new Propagator(contrastPolicy.getId(), contrastPolicy.getLocation(), "zzz-bytebuffer-propagator", m.q, m.n, null, null, null, null, false, false, new k());
        c3.a(propagator);
        this.bogusPropagator = propagator;
    }

    @ScopedSensor
    public void onByteBufferPut(ByteBuffer byteBuffer, byte[] byArray, int n2, int n3) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        ContrastNioDispatcherImpl contrastNioDispatcherImpl = this;
        ByteBuffer byteBuffer2 = byteBuffer;
        byte[] byArray2 = byArray;
        int n4 = n2;
        int n5 = n3;
        try {
            contrastNioDispatcherImpl.propagateGetAndPut(byteBuffer2, byArray2, byteBuffer2.array(), new Object[]{byArray2, n4, n5}, n4, n5, byteBuffer2.position() - n5, a.b.a);
            contrastNioDispatcherImpl = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (contrastNioDispatcherImpl != null) {
            throw contrastNioDispatcherImpl;
        }
    }

    @ScopedSensor
    public void onByteBufferGet(ByteBuffer byteBuffer, byte[] byArray, int n2, int n3) {
        ScopeAggregator scopeAggregator = null;
        scopeAggregator = GlobalScopeProvider.enterScope();
        ContrastNioDispatcherImpl contrastNioDispatcherImpl = this;
        ByteBuffer byteBuffer2 = byteBuffer;
        byte[] byArray2 = byArray;
        int n4 = n2;
        int n5 = n3;
        try {
            contrastNioDispatcherImpl.propagateGetAndPut(byteBuffer2, byteBuffer2.array(), byArray2, new Object[]{byArray2, n4, n5}, n4, n5, n4, a.b.b);
            contrastNioDispatcherImpl = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        scopeAggregator.leaveScope();
        if (contrastNioDispatcherImpl != null) {
            throw contrastNioDispatcherImpl;
        }
    }

    private void propagateGetAndPut(ByteBuffer byteBuffer, byte[] byArray, byte[] byArray2, Object[] objectArray, int n2, int n3, int n4, a.b b2) {
        Object object;
        ArrayList<TagRange> arrayList;
        if (n3 <= 0) {
            return;
        }
        Map<Object, Trace> map = this.eventContext.getTraceMap();
        Trace trace = map.get(byArray2);
        Trace trace2 = map.get(byArray);
        if (trace == null && trace2 == null && !map.containsKey(byteBuffer)) {
            return;
        }
        trace = trace != null ? trace : this.traceFactory.a();
        TagRanges tagRanges = b2.a(trace2, n2, n3, n4);
        TagRanges tagRanges2 = trace.getTagRanges().copy().clear(n4, n4 + n3);
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        CodeEvent codeEvent = trace.getLastEvent();
        if (codeEvent != null) {
            arrayList2.add(codeEvent.getId());
        }
        if (trace2 == null) {
            if (tagRanges2.isEmpty()) {
                logger.debug("The dst is no longer tainted and has been removed");
                map.remove(byArray2);
                if (b2.b()) {
                    map.remove(byteBuffer);
                }
                return;
            }
            if (trace.getTagRanges().size() == tagRanges2.size() && new HashSet<TagRange>(trace.getTagRanges().getTagRanges()).containsAll(tagRanges2.getTagRanges())) {
                return;
            }
            arrayList = new ArrayList<TagRange>(tagRanges2.getTagRanges());
        } else {
            object = new ArrayList<TagRange>(tagRanges.getTagRanges());
            object.addAll(tagRanges2.getTagRanges());
            arrayList = object;
            arrayList2.add(trace2.getLastEvent().getId());
            trace.copyEvents(trace2);
        }
        object = (g)((g)((g)((g)((g)((g)((g)((g)this.codeEventFactory.b(this.bogusPropagator).b(trace.getId())).a(b2.a())).a(byteBuffer)).b(byteBuffer)).a(new TagRanges(arrayList))).a(arrayList2)).a(this.stackCaptureFactory.a())).a(objectArray);
        PropagationEvent propagationEvent = ((g)object).g();
        trace.addEvent(propagationEvent);
        map.put(byArray2, trace);
        if (b2.b()) {
            map.put(byteBuffer, trace);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.debugStringFactory.a(propagationEvent, "TRACE "));
        }
        AssessmentContext assessmentContext = this.assessmentManager.currentContext();
        if (trace2 != null && assessmentContext != null && assessmentContext.isIdentityTaggingEnabled()) {
            h.a(byArray, trace, trace2, assessmentContext);
        }
    }
}

