/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.jersey;

import com.contrastsecurity.agent.Contrast;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.k;
import com.contrastsecurity.agent.commons.r;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.info.HTTPRoute;
import com.contrastsecurity.agent.plugins.c.g;
import com.contrastsecurity.agent.plugins.route.d;
import com.contrastsecurity.agent.plugins.security.F;
import com.contrastsecurity.agent.x;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

@Singleton
@DontObfuscate
final class ContrastJerseyRouteDispatcherImpl
implements ContrastJerseyRouteDispatcher {
    private final ApplicationManager applicationManager;
    private final HttpManager httpManager;
    private final F routeObservationListener;
    private final Supplier<Contrast.a> contrastStatus;
    public static final Set<String> GLASSFISH_ADMIN_METHODS = r.b("org.glassfish.admin.rest.resources.admin.CommandResource", "org.glassfish.jersey.server.wadl.processor.OptionsMethodProcessor$GenericOptionsInflector", "org.glassfish.jersey.server.wadl.processor.OptionsMethodProcessor$PlainTextOptionsInflector");
    private static final Map<String, Set<String>> JERSEY_CLASS_DENYLIST = k.a().a("//{command:.*}/", GLASSFISH_ADMIN_METHODS).a("//{command:.*}/manpage", GLASSFISH_ADMIN_METHODS).a();
    private static final Set<String> JERSEY_CONTEXT_PATH_DENYLIST = r.b("/lifecycle", "/tenant-monitoring", "/elasticity-monitoring", "/weblogic", "/wls");
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static final Logger logger = LoggerFactory.getLogger(ContrastJerseyRouteDispatcherImpl.class);

    @Inject
    public ContrastJerseyRouteDispatcherImpl(ApplicationManager applicationManager, HttpManager httpManager, F f2, Supplier<Contrast.a> supplier) {
        this.applicationManager = applicationManager;
        this.httpManager = httpManager;
        this.routeObservationListener = f2;
        this.contrastStatus = supplier;
    }

    public void onRoutesDiscovered(Object object) {
        Class<?> clazz;
        Object object2;
        if (object == null) {
            logger.debug("Jersey route discovery unavailable, ApplicationHandler was null");
            return;
        }
        a a2 = ContrastJerseyRouteDispatcherImpl.getInjectionManager(object);
        if (a2 == null) {
            return;
        }
        Object object3 = null;
        try {
            object3 = a2.getInstance(x.a("javax.servlet.ServletContext", false, object.getClass().getClassLoader()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        String string = null;
        if (object3 != null) {
            object2 = com.contrastsecurity.agent.t.d.b(object3.getClass(), "getContextPath", new Class[0]);
            if (object2 == null) {
                logger.debug("ServletContext#getContextPath() not found");
            } else {
                string = (String)com.contrastsecurity.agent.t.d.a((Method)object2, object3, new Object[0]);
            }
        }
        if (string == null) {
            logger.debug("ServletContext not found, using ApplicationManager#current()");
            object2 = this.applicationManager.current();
        } else {
            object2 = this.applicationManager.findByKey(string);
        }
        if (object2 == null) {
            logger.debug("Jersey route discovery unavailable, no application was found to which attach routes");
            return;
        }
        try {
            clazz = x.a("org.glassfish.jersey.server.internal.JerseyResourceContext", false, object.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.debug("Jersey route coverage unavailable, JerseyResourceContext class not found");
            return;
        }
        Object object4 = a2.getInstance(clazz);
        if (object4 == null) {
            logger.debug("Jersey route coverage unavailable, JerseyResourceContext was null");
            return;
        }
        Method method = com.contrastsecurity.agent.t.d.b(clazz, "getResourceModel", new Class[0]);
        if (method == null) {
            logger.debug("Jersey route coverage unavailable, getResourceModel method not found on: {}", (Object)clazz);
            return;
        }
        Object object5 = com.contrastsecurity.agent.t.d.a(method, object4, new Object[0]);
        if (object5 == null) {
            logger.debug("Jersey route coverage unavailable, resourceModel was null");
            return;
        }
        Method method2 = com.contrastsecurity.agent.t.d.b(object5.getClass(), "getResources", new Class[0]);
        if (method2 == null) {
            logger.debug("Jersey route coverage unavailable, could not find method getResources on {}", object5);
            return;
        }
        Object object6 = com.contrastsecurity.agent.t.d.a(method2, object5, new Object[0]);
        if (!(object6 instanceof List)) {
            logger.debug("Jersey route coverage unavailable, resources were not of type List");
            return;
        }
        HashSet<HTTPRoute> hashSet = new HashSet<HTTPRoute>();
        for (Object e2 : (List)object6) {
            hashSet.addAll(ContrastJerseyRouteDispatcherImpl.processResource(e2, ""));
        }
        ((Application)object2).addDiscoveredRoutes(Collections.unmodifiableCollection(hashSet));
    }

    public void onRouteObserved(Object object, Object object2) {
        HttpRequest httpRequest = d.a(this.contrastStatus, this.applicationManager, this.httpManager);
        if (httpRequest == null) {
            return;
        }
        try {
            if (object2 == null) {
                com.contrastsecurity.agent.logging.a.a("JERSEY_ROUTE_OBSERVATION_INVALID_PARAMS", logger, "Cannot observe route since the Jersey ResourceMethod is null.");
                return;
            }
            Method method = com.contrastsecurity.agent.t.d.b(object.getClass(), "getPath", new Class[0]);
            if (method == null) {
                logger.warn("Could not find method [getPath] on object [{}]. ", object);
                return;
            }
            Object object3 = method.invoke(object, new Object[0]);
            if (!(object3 instanceof String)) {
                logger.warn("getPath did not return a String");
                return;
            }
            HTTPRoute hTTPRoute = ContrastJerseyRouteDispatcherImpl.getHTTPRouteFromResourceMethod(ContrastJerseyRouteDispatcherImpl.normalizePath((String)object3), object2);
            if (hTTPRoute == null) {
                return;
            }
            this.routeObservationListener.onRouteObserved(hTTPRoute, httpRequest);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            logger.debug("Error occurred during route observation ", reflectiveOperationException);
        }
    }

    static String normalizePath(String string) {
        return string != null ? (string.startsWith("/") ? string : "/" + string) : null;
    }

    static HTTPRoute getHTTPRouteFromResourceMethod(String string, Object object) {
        if (object == null) {
            logger.trace("ResourceMethod was null");
            return null;
        }
        Method method = com.contrastsecurity.agent.t.d.b(object.getClass(), "getHttpMethod", new Class[0]);
        if (method == null) {
            logger.debug("Could not find method [getHttpMethod] on object [{}]. ", object);
            return null;
        }
        Object object2 = com.contrastsecurity.agent.t.d.a(method, object, new Object[0]);
        if (!(object2 instanceof String)) {
            logger.trace("getHttpMethod did not return a String");
            return null;
        }
        String string2 = (String)object2;
        Method method2 = com.contrastsecurity.agent.t.d.b(object.getClass(), "getInvocable", new Class[0]);
        if (method2 == null) {
            logger.debug("Could not find method [getInvocable] on object [{}]. ", object);
            return null;
        }
        Object object3 = com.contrastsecurity.agent.t.d.a(method2, object, new Object[0]);
        if (object3 == null) {
            logger.debug("Invocable was null");
            return null;
        }
        Method method3 = com.contrastsecurity.agent.t.d.b(object3.getClass(), "getHandlingMethod", new Class[0]);
        if (method3 == null) {
            logger.debug("Could not find method [getHandlingMethod] on object [{}]. ", object3);
            return null;
        }
        Object object4 = com.contrastsecurity.agent.t.d.a(method3, object3, new Object[0]);
        if (!(object4 instanceof Method)) {
            logger.trace("getHandlingMethod did not return a Method");
            return null;
        }
        Method method4 = (Method)object4;
        Set<String> set = JERSEY_CLASS_DENYLIST.get(string);
        if (set == null) {
            return HTTPRoute.of(string2, string, g.a(method4, g::a));
        }
        if (set.contains(method4.getDeclaringClass().getName())) {
            logger.trace("Ignoring route {} since it is in the denylist", (Object)string);
            return null;
        }
        return HTTPRoute.of(string2, string, g.a(method4, g::a));
    }

    private static a getInjectionManager(Object object) {
        Method method = com.contrastsecurity.agent.t.d.b(object.getClass(), "getServiceLocator", new Class[0]);
        if (method != null) {
            Object object2 = com.contrastsecurity.agent.t.d.a(method, object, new Object[0]);
            if (object2 == null) {
                logger.debug("Jersey route discovery unavailable, ServiceLocator was null");
                return null;
            }
            Method method2 = com.contrastsecurity.agent.t.d.b(object2.getClass(), "getService", Class.class, Annotation[].class);
            if (method2 == null) {
                logger.debug("Jersey route discovery unavailable, could not find getService method on {}", (Object)object2.getClass());
                return null;
            }
            return clazz -> {
                Object object2 = com.contrastsecurity.agent.t.d.a(method2, object2, clazz, EMPTY_ANNOTATION_ARRAY);
                if (!clazz.isInstance(object2)) {
                    logger.debug("JerseyInjectionManager could not find an object of type: {}", (Object)clazz);
                    return null;
                }
                return object2;
            };
        }
        Method method3 = com.contrastsecurity.agent.t.d.b(object.getClass(), "getInjectionManager", new Class[0]);
        if (method3 == null) {
            logger.debug("Jersey route discovery unavailable, could not find an InjectionManager in class: {}", (Object)object.getClass());
            return null;
        }
        Object object3 = com.contrastsecurity.agent.t.d.a(method3, object, new Object[0]);
        if (object3 == null) {
            logger.debug("Jersey route discovery unavailable, InjectionManager was null");
            return null;
        }
        Method method4 = com.contrastsecurity.agent.t.d.b(object3.getClass(), "getInstance", Class.class);
        if (method4 == null) {
            logger.debug("Jersey route discovery unavailable, could not find getInstance method on {}", (Object)object3.getClass());
            return null;
        }
        return clazz -> {
            Object object2 = com.contrastsecurity.agent.t.d.a(method4, object3, clazz);
            if (!clazz.isInstance(object2)) {
                logger.debug("JerseyInjectionManager could not find an object of type: {}", (Object)clazz);
                return null;
            }
            return object2;
        };
    }

    private static Collection<HTTPRoute> processResource(Object object, String string) {
        Object object2;
        Object object3;
        String string2;
        if (object == null) {
            return Collections.emptySet();
        }
        Class<?> clazz = object.getClass();
        Method method = com.contrastsecurity.agent.t.d.b(clazz, "getPath", new Class[0]);
        if (method == null) {
            logger.warn("Could not find method [getPath] on object [{}]. ", object);
            return Collections.emptySet();
        }
        Object object4 = com.contrastsecurity.agent.t.d.a(method, object, new Object[0]);
        if (!(object4 instanceof String)) {
            logger.warn("getPath did not return a String");
            return Collections.emptySet();
        }
        int n2 = (string = ContrastJerseyRouteDispatcherImpl.normalizePath(string + object4)).indexOf("/", 1);
        String string3 = string2 = n2 != -1 ? string.substring(0, n2) : string;
        if (JERSEY_CONTEXT_PATH_DENYLIST.contains(string2)) {
            return Collections.emptySet();
        }
        Method method2 = com.contrastsecurity.agent.t.d.b(clazz, "getResourceMethods", new Class[0]);
        if (method2 == null) {
            logger.warn("Could not find method [getResourceMethods] on object [{}]. ", object);
            return Collections.emptySet();
        }
        HashSet<HTTPRoute> hashSet = new HashSet<HTTPRoute>();
        Object object5 = com.contrastsecurity.agent.t.d.a(method2, object, new Object[0]);
        if (object5 instanceof List) {
            object3 = ((List)object5).iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                HTTPRoute hTTPRoute = ContrastJerseyRouteDispatcherImpl.getHTTPRouteFromResourceMethod(string, object2);
                if (hTTPRoute == null) continue;
                hashSet.add(hTTPRoute);
            }
        }
        if ((object3 = com.contrastsecurity.agent.t.d.b(clazz, "getChildResources", new Class[0])) == null) {
            return Collections.unmodifiableSet(hashSet);
        }
        object2 = com.contrastsecurity.agent.t.d.a((Method)object3, object, new Object[0]);
        if (!(object2 instanceof List)) {
            return Collections.unmodifiableSet(hashSet);
        }
        for (Object e2 : (List)object2) {
            hashSet.addAll(ContrastJerseyRouteDispatcherImpl.processResource(e2, string));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static interface a {
        public Object getInstance(Class<?> var1);
    }
}

