/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.resteasy;

import com.contrastsecurity.agent.Contrast;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.j;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.info.HTTPRoute;
import com.contrastsecurity.agent.plugins.frameworks.y.o;
import com.contrastsecurity.agent.plugins.route.d;
import com.contrastsecurity.agent.plugins.security.F;
import com.contrastsecurity.agent.t.b;
import com.contrastsecurity.agent.t.c;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@Singleton
@DontObfuscate
final class ContrastRESTEasyRouteDispatcherImpl
implements ContrastRESTEasyRouteDispatcher {
    private final ApplicationManager applicationManager;
    private final HttpManager httpManager;
    private final F routeObservationListener;
    private final Supplier<Contrast.a> contrastStatus;
    private static final Logger logger = LoggerFactory.getLogger(ContrastRESTEasyRouteDispatcherImpl.class);

    @Inject
    public ContrastRESTEasyRouteDispatcherImpl(ApplicationManager applicationManager, HttpManager httpManager, F f2, Supplier<Contrast.a> supplier) {
        this.applicationManager = applicationManager;
        this.httpManager = httpManager;
        this.routeObservationListener = f2;
        this.contrastStatus = supplier;
    }

    public void onRoutesDiscovered(Object object2) {
        Application application = this.applicationManager.current();
        if (application == null) {
            logger.error("We discovered a route but the application is not created yet. Discarding route.");
            return;
        }
        try {
            if ("org.jboss.resteasy.spi.metadata.DefaultResourceLocator".equals(object2.getClass().getName())) {
                logger.debug("Object is a resource locator, not a resource method. Not an exercisable route. Discarding.");
                return;
            }
            b b2 = b.a(object2);
            String string = b2.c("fullpath").a();
            Method method = b2.b("getMethod").a(Method.class);
            Set set = b2.a("getHttpMethods").a(Set.class);
            if (set != null && method != null) {
                set.forEach(object -> application.addDiscoveredRoutes(j.a(HTTPRoute.of((String)object, "/" + string, method))));
            }
        }
        catch (c c2) {
            logger.debug("Failed to reflect routes out of RESTEasy", c2);
        }
    }

    public void onRoutesInvoked(Object object, Object object2) {
        HttpRequest httpRequest = d.a(this.contrastStatus, this.applicationManager, this.httpManager);
        if (httpRequest == null) {
            return;
        }
        try {
            b b2 = b.a(object2);
            String string = b2.a("getHttpMethod").a();
            if (string == null) {
                return;
            }
            Optional<String> optional = this.findURI(b2);
            if (!optional.isPresent()) {
                return;
            }
            Optional<Method> optional2 = this.findMethod(object);
            if (!optional2.isPresent()) {
                return;
            }
            this.routeObservationListener.onRouteObserved(HTTPRoute.of(string, optional.get(), optional2.get()), httpRequest);
        }
        catch (c c2) {
            logger.debug("Error retrieving route observed", c2);
        }
    }

    public void onRequestMapped(Object object) {
        HttpRequest httpRequest = d.a(this.contrastStatus, this.applicationManager, this.httpManager);
        if (httpRequest == null) {
            return;
        }
        try {
            Object object2 = b.a(object).c("value").b();
            if (object2 == null) {
                return;
            }
            if (!object2.getClass().getName().equals("org.jboss.resteasy.reactive.server.mapping.RuntimeResource")) {
                return;
            }
            HTTPRoute hTTPRoute = o.a(b.a(object2), b.a(httpRequest));
            if (hTTPRoute == null) {
                return;
            }
            this.routeObservationListener.onRouteObserved(hTTPRoute, httpRequest);
        }
        catch (c | IllegalAccessException | InvocationTargetException exception) {
            logger.debug("Error retrieving route observed", exception);
        }
    }

    private Optional<String> findURI(b b2) {
        String string;
        try {
            Object object = b2.a("getUri").b();
            string = b.a(object).a("getPath").a();
        }
        catch (c c2) {
            logger.debug("Could not find URI on object {}", (Object)b2);
            return Optional.empty();
        }
        return Optional.ofNullable(string);
    }

    private Optional<Method> findMethod(Object object) {
        try {
            b b2 = b.a(object);
            Method method = b2.a("getMethod").a(Method.class);
            return Optional.ofNullable(method);
        }
        catch (c c2) {
            logger.debug("Could not find signature on object {}", object);
            return Optional.empty();
        }
    }
}

